/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.classfile;

import com.sun.tools.classfile.Attribute;
import com.sun.tools.classfile.Attributes;
import com.sun.tools.classfile.ClassFile;
import com.sun.tools.classfile.ConstantPool;
import com.sun.tools.classfile.Field;
import com.sun.tools.classfile.Method;
import java.util.Map;

public class ClassTranslator
implements ConstantPool.Visitor<ConstantPool.CPInfo, Map<Object, Object>> {
    public ClassFile translate(ClassFile cf, Map<Object, Object> translations) {
        ClassFile cf2 = (ClassFile)translations.get(cf);
        if (cf2 == null) {
            ConstantPool constant_pool2 = this.translate(cf.constant_pool, translations);
            Field[] fields2 = this.translate(cf.fields, cf.constant_pool, translations);
            Method[] methods2 = this.translateMethods(cf.methods, cf.constant_pool, translations);
            Attributes attributes2 = this.translateAttributes(cf.attributes, cf.constant_pool, translations);
            cf2 = constant_pool2 == cf.constant_pool && fields2 == cf.fields && methods2 == cf.methods && attributes2 == cf.attributes ? cf : new ClassFile(cf.magic, cf.minor_version, cf.major_version, constant_pool2, cf.access_flags, cf.this_class, cf.super_class, cf.interfaces, fields2, methods2, attributes2);
            translations.put(cf, cf2);
        }
        return cf2;
    }

    ConstantPool translate(ConstantPool cp, Map<Object, Object> translations) {
        ConstantPool cp2 = (ConstantPool)translations.get(cp);
        if (cp2 == null) {
            ConstantPool.CPInfo cpInfo;
            ConstantPool.CPInfo[] pool2 = new ConstantPool.CPInfo[cp.size()];
            boolean eq = true;
            for (int i = 0; i < cp.size(); i += cpInfo.size()) {
                try {
                    cpInfo = cp.get(i);
                }
                catch (ConstantPool.InvalidIndex e) {
                    throw new IllegalStateException(e);
                }
                ConstantPool.CPInfo cpInfo2 = this.translate(cpInfo, translations);
                eq &= cpInfo == cpInfo2;
                pool2[i] = cpInfo2;
                if (cpInfo.getTag() == cpInfo2.getTag()) continue;
                throw new IllegalStateException();
            }
            cp2 = eq ? cp : new ConstantPool(pool2);
            translations.put(cp, cp2);
        }
        return cp2;
    }

    ConstantPool.CPInfo translate(ConstantPool.CPInfo cpInfo, Map<Object, Object> translations) {
        ConstantPool.CPInfo cpInfo2 = (ConstantPool.CPInfo)translations.get(cpInfo);
        if (cpInfo2 == null) {
            cpInfo2 = cpInfo.accept(this, translations);
            translations.put(cpInfo, cpInfo2);
        }
        return cpInfo2;
    }

    Field[] translate(Field[] fields, ConstantPool constant_pool, Map<Object, Object> translations) {
        Field[] fields2 = (Field[])translations.get(fields);
        if (fields2 == null) {
            fields2 = new Field[fields.length];
            for (int i = 0; i < fields.length; ++i) {
                fields2[i] = this.translate(fields[i], constant_pool, translations);
            }
            if (ClassTranslator.equal(fields, fields2)) {
                fields2 = fields;
            }
            translations.put(fields, fields2);
        }
        return fields2;
    }

    Field translate(Field field, ConstantPool constant_pool, Map<Object, Object> translations) {
        Field field2 = (Field)translations.get(field);
        if (field2 == null) {
            Attributes attributes2 = this.translateAttributes(field.attributes, constant_pool, translations);
            field2 = attributes2 == field.attributes ? field : new Field(field.access_flags, field.name_index, field.descriptor, attributes2);
            translations.put(field, field2);
        }
        return field2;
    }

    Method[] translateMethods(Method[] methods, ConstantPool constant_pool, Map<Object, Object> translations) {
        Method[] methods2 = (Method[])translations.get(methods);
        if (methods2 == null) {
            methods2 = new Method[methods.length];
            for (int i = 0; i < methods.length; ++i) {
                methods2[i] = this.translate(methods[i], constant_pool, translations);
            }
            if (ClassTranslator.equal(methods, methods2)) {
                methods2 = methods;
            }
            translations.put(methods, methods2);
        }
        return methods2;
    }

    Method translate(Method method, ConstantPool constant_pool, Map<Object, Object> translations) {
        Method method2 = (Method)translations.get(method);
        if (method2 == null) {
            Attributes attributes2 = this.translateAttributes(method.attributes, constant_pool, translations);
            method2 = attributes2 == method.attributes ? method : new Method(method.access_flags, method.name_index, method.descriptor, attributes2);
            translations.put(method, method2);
        }
        return method2;
    }

    Attributes translateAttributes(Attributes attributes, ConstantPool constant_pool, Map<Object, Object> translations) {
        Attributes attributes2 = (Attributes)translations.get(attributes);
        if (attributes2 == null) {
            Attribute[] attrArray2 = new Attribute[attributes.size()];
            ConstantPool constant_pool2 = this.translate(constant_pool, translations);
            boolean attrsEqual = true;
            for (int i = 0; i < attributes.size(); ++i) {
                Attribute attr = attributes.get(i);
                Attribute attr2 = this.translate(attr, translations);
                if (attr2 != attr) {
                    attrsEqual = false;
                }
                attrArray2[i] = attr2;
            }
            attributes2 = constant_pool2 == constant_pool && attrsEqual ? attributes : new Attributes(constant_pool2, attrArray2);
            translations.put(attributes, attributes2);
        }
        return attributes2;
    }

    Attribute translate(Attribute attribute, Map<Object, Object> translations) {
        Attribute attribute2 = (Attribute)translations.get(attribute);
        if (attribute2 == null) {
            attribute2 = attribute;
            translations.put(attribute, attribute2);
        }
        return attribute2;
    }

    private static <T> boolean equal(T[] a1, T[] a2) {
        if (a1 == null || a2 == null) {
            return a1 == a2;
        }
        if (a1.length != a2.length) {
            return false;
        }
        for (int i = 0; i < a1.length; ++i) {
            if (a1[i] == a2[i]) continue;
            return false;
        }
        return true;
    }

    @Override
    public ConstantPool.CPInfo visitClass(ConstantPool.CONSTANT_Class_info info, Map<Object, Object> translations) {
        ConstantPool.CONSTANT_Class_info info2 = (ConstantPool.CONSTANT_Class_info)translations.get(info);
        if (info2 == null) {
            ConstantPool cp2 = this.translate(info.cp, translations);
            info2 = cp2 == info.cp ? info : new ConstantPool.CONSTANT_Class_info(cp2, info.name_index);
            translations.put(info, info2);
        }
        return info;
    }

    @Override
    public ConstantPool.CPInfo visitDouble(ConstantPool.CONSTANT_Double_info info, Map<Object, Object> translations) {
        ConstantPool.CONSTANT_Double_info info2 = (ConstantPool.CONSTANT_Double_info)translations.get(info);
        if (info2 == null) {
            info2 = info;
            translations.put(info, info2);
        }
        return info;
    }

    @Override
    public ConstantPool.CPInfo visitFieldref(ConstantPool.CONSTANT_Fieldref_info info, Map<Object, Object> translations) {
        ConstantPool.CONSTANT_Fieldref_info info2 = (ConstantPool.CONSTANT_Fieldref_info)translations.get(info);
        if (info2 == null) {
            ConstantPool cp2 = this.translate(info.cp, translations);
            info2 = cp2 == info.cp ? info : new ConstantPool.CONSTANT_Fieldref_info(cp2, info.class_index, info.name_and_type_index);
            translations.put(info, info2);
        }
        return info;
    }

    @Override
    public ConstantPool.CPInfo visitFloat(ConstantPool.CONSTANT_Float_info info, Map<Object, Object> translations) {
        ConstantPool.CONSTANT_Float_info info2 = (ConstantPool.CONSTANT_Float_info)translations.get(info);
        if (info2 == null) {
            info2 = info;
            translations.put(info, info2);
        }
        return info;
    }

    @Override
    public ConstantPool.CPInfo visitInteger(ConstantPool.CONSTANT_Integer_info info, Map<Object, Object> translations) {
        ConstantPool.CONSTANT_Integer_info info2 = (ConstantPool.CONSTANT_Integer_info)translations.get(info);
        if (info2 == null) {
            info2 = info;
            translations.put(info, info2);
        }
        return info;
    }

    @Override
    public ConstantPool.CPInfo visitInterfaceMethodref(ConstantPool.CONSTANT_InterfaceMethodref_info info, Map<Object, Object> translations) {
        ConstantPool.CONSTANT_InterfaceMethodref_info info2 = (ConstantPool.CONSTANT_InterfaceMethodref_info)translations.get(info);
        if (info2 == null) {
            ConstantPool cp2 = this.translate(info.cp, translations);
            info2 = cp2 == info.cp ? info : new ConstantPool.CONSTANT_InterfaceMethodref_info(cp2, info.class_index, info.name_and_type_index);
            translations.put(info, info2);
        }
        return info;
    }

    @Override
    public ConstantPool.CPInfo visitInvokeDynamic(ConstantPool.CONSTANT_InvokeDynamic_info info, Map<Object, Object> translations) {
        ConstantPool.CONSTANT_InvokeDynamic_info info2 = (ConstantPool.CONSTANT_InvokeDynamic_info)translations.get(info);
        if (info2 == null) {
            ConstantPool cp2 = this.translate(info.cp, translations);
            info2 = cp2 == info.cp ? info : new ConstantPool.CONSTANT_InvokeDynamic_info(cp2, info.bootstrap_method_attr_index, info.name_and_type_index);
            translations.put(info, info2);
        }
        return info;
    }

    @Override
    public ConstantPool.CPInfo visitLong(ConstantPool.CONSTANT_Long_info info, Map<Object, Object> translations) {
        ConstantPool.CONSTANT_Long_info info2 = (ConstantPool.CONSTANT_Long_info)translations.get(info);
        if (info2 == null) {
            info2 = info;
            translations.put(info, info2);
        }
        return info;
    }

    @Override
    public ConstantPool.CPInfo visitNameAndType(ConstantPool.CONSTANT_NameAndType_info info, Map<Object, Object> translations) {
        ConstantPool.CONSTANT_NameAndType_info info2 = (ConstantPool.CONSTANT_NameAndType_info)translations.get(info);
        if (info2 == null) {
            ConstantPool cp2 = this.translate(info.cp, translations);
            info2 = cp2 == info.cp ? info : new ConstantPool.CONSTANT_NameAndType_info(cp2, info.name_index, info.type_index);
            translations.put(info, info2);
        }
        return info;
    }

    @Override
    public ConstantPool.CPInfo visitMethodref(ConstantPool.CONSTANT_Methodref_info info, Map<Object, Object> translations) {
        ConstantPool.CONSTANT_Methodref_info info2 = (ConstantPool.CONSTANT_Methodref_info)translations.get(info);
        if (info2 == null) {
            ConstantPool cp2 = this.translate(info.cp, translations);
            info2 = cp2 == info.cp ? info : new ConstantPool.CONSTANT_Methodref_info(cp2, info.class_index, info.name_and_type_index);
            translations.put(info, info2);
        }
        return info;
    }

    @Override
    public ConstantPool.CPInfo visitMethodHandle(ConstantPool.CONSTANT_MethodHandle_info info, Map<Object, Object> translations) {
        ConstantPool.CONSTANT_MethodHandle_info info2 = (ConstantPool.CONSTANT_MethodHandle_info)translations.get(info);
        if (info2 == null) {
            ConstantPool cp2 = this.translate(info.cp, translations);
            info2 = cp2 == info.cp ? info : new ConstantPool.CONSTANT_MethodHandle_info(cp2, info.reference_kind, info.reference_index);
            translations.put(info, info2);
        }
        return info;
    }

    @Override
    public ConstantPool.CPInfo visitMethodType(ConstantPool.CONSTANT_MethodType_info info, Map<Object, Object> translations) {
        ConstantPool.CONSTANT_MethodType_info info2 = (ConstantPool.CONSTANT_MethodType_info)translations.get(info);
        if (info2 == null) {
            ConstantPool cp2 = this.translate(info.cp, translations);
            info2 = cp2 == info.cp ? info : new ConstantPool.CONSTANT_MethodType_info(cp2, info.descriptor_index);
            translations.put(info, info2);
        }
        return info;
    }

    @Override
    public ConstantPool.CPInfo visitString(ConstantPool.CONSTANT_String_info info, Map<Object, Object> translations) {
        ConstantPool.CONSTANT_String_info info2 = (ConstantPool.CONSTANT_String_info)translations.get(info);
        if (info2 == null) {
            ConstantPool cp2 = this.translate(info.cp, translations);
            info2 = cp2 == info.cp ? info : new ConstantPool.CONSTANT_String_info(cp2, info.string_index);
            translations.put(info, info2);
        }
        return info;
    }

    @Override
    public ConstantPool.CPInfo visitUtf8(ConstantPool.CONSTANT_Utf8_info info, Map<Object, Object> translations) {
        ConstantPool.CONSTANT_Utf8_info info2 = (ConstantPool.CONSTANT_Utf8_info)translations.get(info);
        if (info2 == null) {
            info2 = info;
            translations.put(info, info2);
        }
        return info;
    }
}

