/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.dlight.sendto.output;

import java.awt.Toolkit;
import java.io.FileNotFoundException;
import java.text.ParseException;
import java.util.List;
import org.netbeans.modules.dlight.sendto.output.OutputPattern;
import org.netbeans.modules.dlight.sendto.output.OutputPatterns;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.cookies.EditCookie;
import org.openide.cookies.SaveCookie;
import org.openide.filesystems.FileChangeAdapter;
import org.openide.filesystems.FileChangeListener;
import org.openide.filesystems.FileEvent;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.util.Exceptions;

public final class OutputPatternsEditSupport {
    private static DataObject cfgFile = null;
    private static final ChangeListener fileChangeListener = new ChangeListener();

    public static void openEditor() {
        if (cfgFile == null) {
            cfgFile = OutputPatternsEditSupport.createFile("SendTo-Output-Parsers");
        }
        if (cfgFile == null) {
            Toolkit.getDefaultToolkit().beep();
            return;
        }
        EditCookie cookie = (EditCookie)cfgFile.getLookup().lookup(EditCookie.class);
        if (cookie != null) {
            cookie.edit();
        }
    }

    private static DataObject createFile(String name) {
        try {
            FileSystem tfs = FileUtil.createMemoryFileSystem();
            FileObject mroot = tfs.getRoot();
            FileObject afile = mroot.createData(name);
            afile.addFileChangeListener((FileChangeListener)fileChangeListener);
            List<OutputPattern> patterns = OutputPatterns.getPatterns();
            OutputPatterns.storeToFile(afile, patterns);
            DataObject dob = DataObject.find((FileObject)afile);
            SaveCookie saveCookie = (SaveCookie)dob.getLookup().lookup(SaveCookie.class);
            if (saveCookie != null) {
                saveCookie.save();
            }
            return dob;
        }
        catch (Exception ex) {
            Exceptions.printStackTrace((Throwable)ex);
            return null;
        }
    }

    private static class ChangeListener
    extends FileChangeAdapter {
        private ChangeListener() {
        }

        public void fileChanged(FileEvent fe) {
            try {
                OutputPatterns.setPatterns(OutputPatterns.loadFromStream(fe.getFile().getInputStream()));
            }
            catch (FileNotFoundException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
            catch (ParseException ex) {
                DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)("Syntax error in line " + ex.getMessage()), 0));
            }
        }
    }
}

