/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.apt.impl.support.clank;

import java.io.IOException;
import java.io.PrintWriter;
import java.util.AbstractList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.clang.tools.services.ClankCompilationDataBase;
import org.clang.tools.services.ClankPreprocessorServices;
import org.clang.tools.services.ClankRunPreprocessorSettings;
import org.clang.tools.services.support.PrintWriter_ostream;
import org.llvm.support.MemoryBuffer;
import org.llvm.support.llvm;
import org.llvm.support.raw_ostream;
import org.netbeans.modules.cnd.antlr.TokenStream;
import org.netbeans.modules.cnd.apt.debug.APTTraceFlags;
import org.netbeans.modules.cnd.apt.impl.support.clank.APTToClankCompilationDB;
import org.netbeans.modules.cnd.apt.impl.support.clank.ClankIncludeHandlerImpl;
import org.netbeans.modules.cnd.apt.impl.support.clank.ClankMemoryBufferImpl;
import org.netbeans.modules.cnd.apt.impl.support.clank.ClankPPCallback;
import org.netbeans.modules.cnd.apt.support.APTFileBuffer;
import org.netbeans.modules.cnd.apt.support.APTToken;
import org.netbeans.modules.cnd.apt.support.APTTokenStream;
import org.netbeans.modules.cnd.apt.support.ClankDriver;
import org.netbeans.modules.cnd.apt.support.api.PreprocHandler;
import org.netbeans.modules.cnd.apt.support.spi.APTBufferProvider;
import org.netbeans.modules.cnd.apt.utils.APTUtils;
import org.netbeans.modules.cnd.spi.utils.CndFileSystemProvider;
import org.netbeans.modules.cnd.support.Interrupter;
import org.netbeans.modules.cnd.utils.CndUtils;
import org.openide.filesystems.FileSystem;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;

public class ClankDriverImpl {
    static final boolean TRACE = false;

    public static void invalidateImpl(FileSystem fs, CharSequence absPath) {
        if (APTTraceFlags.USE_CLANK) {
            ClankPreprocessorServices.invalidate((CharSequence)CndFileSystemProvider.toUrl((FileSystem)fs, (CharSequence)absPath));
        }
    }

    public static void invalidateImpl(APTFileBuffer buffer) {
        if (APTTraceFlags.USE_CLANK) {
            ClankDriverImpl.invalidateImpl(buffer.getFileSystem(), buffer.getAbsolutePath());
        }
    }

    public static void invalidateAllImpl() {
        if (APTTraceFlags.USE_CLANK) {
            ClankPreprocessorServices.invalidateAll();
        }
    }

    public static boolean preprocessImpl(APTFileBuffer buffer, PreprocHandler ppHandler, ClankDriver.ClankPreprocessorCallback callback, Interrupter interrupter) {
        if (APTTraceFlags.TRACE_PREPROC || APTTraceFlags.TRACE_PREPROC_STACKS) {
            String text = "Preprocessing " + buffer;
            if (APTTraceFlags.TRACE_PREPROC_STACKS) {
                new Exception(text).printStackTrace(System.err);
            } else {
                System.err.println(text);
            }
        }
        try {
            String path = CndFileSystemProvider.toUrl((FileSystem)buffer.getFileSystem(), (CharSequence)buffer.getAbsolutePath()).toString();
            ClankRunPreprocessorSettings settings = new ClankRunPreprocessorSettings();
            settings.WorkName = path;
            boolean fortranFlavor = APTToClankCompilationDB.isFortran(ppHandler);
            settings.GenerateDiagnostics = true;
            if (CndUtils.isUnitTestMode() && !fortranFlavor) {
                settings.PrettyPrintDiagnostics = true;
                PrintWriter printWriter = new PrintWriter(System.err);
                settings.PrintDiagnosticsOS = new PrintWriter_ostream(printWriter);
            } else {
                settings.PrettyPrintDiagnostics = false;
                settings.PrintDiagnosticsOS = llvm.nulls();
            }
            settings.TraceClankStatistics = false;
            ClankPPCallback.CancellableInterrupter canceller = new ClankPPCallback.CancellableInterrupter(interrupter);
            settings.cancelled = canceller;
            raw_ostream traceOS = CndUtils.isUnitTestMode() ? llvm.nulls() : llvm.errs();
            ClankPPCallback fileTokensCallback = new ClankPPCallback(ppHandler, traceOS, callback, canceller);
            settings.IncludeInfoCallbacks = fileTokensCallback;
            ClankCompilationDataBase db = APTToClankCompilationDB.convertPPHandler(ppHandler, path);
            Map<String, MemoryBuffer> remappedBuffers = ClankDriverImpl.getRemappedBuffers();
            if (!remappedBuffers.containsKey(path)) {
                char[] chars = fortranFlavor ? ClankDriverImpl.fixFortranTokens(buffer) : buffer.getCharBuffer();
                ClankMemoryBufferImpl fileContent = ClankMemoryBufferImpl.create(path, chars);
                remappedBuffers = new HashMap<String, MemoryBuffer>(remappedBuffers);
                remappedBuffers.put(path, fileContent);
            }
            ClankPreprocessorServices.preprocess(Collections.singleton(db), (ClankRunPreprocessorSettings)settings, remappedBuffers);
            return true;
        }
        catch (IOException ex) {
            Exceptions.printStackTrace((Throwable)ex);
            return false;
        }
    }

    private static char[] fixFortranTokens(APTFileBuffer buffer) throws IOException {
        char[] chars = buffer.getCharBuffer();
        for (int i = 0; i < chars.length - 1; ++i) {
            if (i < chars.length - 1 && chars[i] == '/' && chars[i + 1] == '/') {
                chars[i] = 126;
                chars[i + 1] = 126;
            }
            if (chars[i] != '.') continue;
            if (i < chars.length - 3) {
                if (!(chars[i + 1] != 'n' && chars[i + 1] != 'N' || chars[i + 2] != 'e' && chars[i + 2] != 'E' || chars[i + 3] != '.')) {
                    chars[i] = 32;
                    chars[i + 1] = 47;
                    chars[i + 2] = 61;
                    chars[i + 3] = 32;
                } else if (!(chars[i + 1] != 'e' && chars[i + 1] != 'E' || chars[i + 2] != 'q' && chars[i + 2] != 'Q' || chars[i + 3] != '.')) {
                    chars[i] = 32;
                    chars[i + 1] = 61;
                    chars[i + 2] = 61;
                    chars[i + 3] = 32;
                } else if (!(chars[i + 1] != 'g' && chars[i + 1] != 'G' || chars[i + 2] != 't' && chars[i + 2] != 'T' || chars[i + 3] != '.')) {
                    chars[i] = 32;
                    chars[i + 1] = 62;
                    chars[i + 2] = 32;
                    chars[i + 3] = 32;
                } else if (!(chars[i + 1] != 'g' && chars[i + 1] != 'G' || chars[i + 2] != 'e' && chars[i + 2] != 'E' || chars[i + 3] != '.')) {
                    chars[i] = 32;
                    chars[i + 1] = 62;
                    chars[i + 2] = 61;
                    chars[i + 3] = 32;
                } else if (!(chars[i + 1] != 'l' && chars[i + 1] != 'L' || chars[i + 2] != 't' && chars[i + 2] != 'T' || chars[i + 3] != '.')) {
                    chars[i] = 32;
                    chars[i + 1] = 60;
                    chars[i + 2] = 32;
                    chars[i + 3] = 32;
                } else if (!(chars[i + 1] != 'l' && chars[i + 1] != 'L' || chars[i + 2] != 'e' && chars[i + 2] != 'E' || chars[i + 3] != '.')) {
                    chars[i] = 32;
                    chars[i + 1] = 60;
                    chars[i + 2] = 61;
                    chars[i + 3] = 32;
                } else if (!(chars[i + 1] != 'o' && chars[i + 1] != 'O' || chars[i + 2] != 'r' && chars[i + 2] != 'R' || chars[i + 3] != '.')) {
                    chars[i] = 32;
                    chars[i + 1] = 124;
                    chars[i + 2] = 124;
                    chars[i + 3] = 32;
                }
            }
            if (i < chars.length - 4) {
                if (!(chars[i + 1] != 'a' && chars[i + 1] != 'A' || chars[i + 2] != 'n' && chars[i + 2] != 'N' || chars[i + 3] != 'd' && chars[i + 3] != 'D' || chars[i + 4] != '.')) {
                    chars[i] = 32;
                    chars[i + 1] = 38;
                    chars[i + 2] = 38;
                    chars[i + 3] = 32;
                    chars[i + 4] = 32;
                } else if (!(chars[i + 1] != 'e' && chars[i + 1] != 'E' || chars[i + 2] != 'q' && chars[i + 2] != 'Q' || chars[i + 3] != 'v' && chars[i + 3] != 'V' || chars[i + 4] != '.')) {
                    chars[i] = 32;
                    chars[i + 1] = 61;
                    chars[i + 2] = 61;
                    chars[i + 3] = 32;
                    chars[i + 4] = 32;
                } else if (!(chars[i + 1] != 'n' && chars[i + 1] != 'N' || chars[i + 2] != 'o' && chars[i + 2] != 'O' || chars[i + 3] != 't' && chars[i + 3] != 'T' || chars[i + 4] != '.')) {
                    chars[i] = 32;
                    chars[i + 1] = 94;
                    chars[i + 2] = 32;
                    chars[i + 3] = 32;
                    chars[i + 4] = 32;
                }
            }
            if (i >= chars.length - 5 || chars[i + 1] != 'n' && chars[i + 1] != 'N' || chars[i + 2] != 'e' && chars[i + 2] != 'E' || chars[i + 3] != 'q' && chars[i + 3] != 'Q' || chars[i + 4] != 'v' && chars[i + 3] != 'V' || chars[i + 5] != '.') continue;
            chars[i] = 32;
            chars[i + 1] = 60;
            chars[i + 2] = 62;
            chars[i + 3] = 32;
            chars[i + 4] = 32;
            chars[i + 5] = 32;
        }
        return chars;
    }

    private static Map<String, MemoryBuffer> getRemappedBuffers() {
        Collection<APTFileBuffer> buffers;
        Map<String, MemoryBuffer> result = Collections.emptyMap();
        APTBufferProvider provider = (APTBufferProvider)Lookup.getDefault().lookup(APTBufferProvider.class);
        if (provider != null && (buffers = provider.getUnsavedBuffers()) != null && !buffers.isEmpty()) {
            result = new HashMap<String, MemoryBuffer>();
            for (APTFileBuffer buf : buffers) {
                String pathAsUrl = CndFileSystemProvider.toUrl((FileSystem)buf.getFileSystem(), (CharSequence)buf.getAbsolutePath()).toString();
                try {
                    ClankMemoryBufferImpl mb = ClankMemoryBufferImpl.create(pathAsUrl, buf.getCharBuffer());
                    result.put(pathAsUrl, mb);
                }
                catch (IOException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
            }
        }
        return result;
    }

    public static ClankPreprocessorOutputImplementation extractPreprocessorOutputImplementation(ClankDriver.ClankFileInfo file) {
        if (file instanceof ClankPreprocessorOutputImplementation) {
            return (ClankPreprocessorOutputImplementation)((Object)file);
        }
        return null;
    }

    public static ClankPreprocessorOutputImplementation extractPreprocessorOutputImplementation(PreprocHandler ppHandler) {
        ClankIncludeHandlerImpl includeHandler = (ClankIncludeHandlerImpl)ppHandler.getIncludeHandler();
        ClankPreprocessorOutputImplementation cached = includeHandler.getPreprocessorOutputImplementation();
        return cached;
    }

    public static int extractFileIndex(PreprocHandler ppHandler) {
        ClankIncludeHandlerImpl includeHandler = (ClankIncludeHandlerImpl)ppHandler.getIncludeHandler();
        return includeHandler.getInclStackIndex();
    }

    public static final class ArrayBasedAPTTokenStream
    extends AbstractList<APTToken>
    implements APTTokenStream,
    TokenStream {
        private int index;
        private final int lastIndex;
        private final APTToken[] tokens;

        public ArrayBasedAPTTokenStream(APTToken[] tokens) {
            this.tokens = tokens;
            this.lastIndex = tokens.length;
            this.index = 0;
        }

        @Override
        public APTToken nextToken() {
            if (this.index < this.lastIndex) {
                return this.tokens[this.index++];
            }
            return APTUtils.EOF_TOKEN;
        }

        @Override
        public APTToken get(int index) {
            return this.tokens[index];
        }

        public List<APTToken> toList() {
            return this;
        }

        @Override
        public int size() {
            if (this.tokens.length == 0) {
                return 0;
            }
            if (this.tokens[this.tokens.length - 1] == APTUtils.EOF_TOKEN) {
                return this.tokens.length - 1;
            }
            return this.tokens.length;
        }

        @Override
        public String toString() {
            return APTUtils.debugString(new ArrayBasedAPTTokenStream(this.tokens)).toString();
        }
    }

    public static interface ClankPreprocessorOutputImplementation
    extends ClankDriver.ClankPreprocessorOutput {
        public ClankPreprocessorOutputImplementation prepareCachesIfPossible();
    }
}

