/*
 * Decompiled with CFR 0.152.
 */
package org.clang.basic.impl;

import org.clang.basic.vfs.FileSystem;
import org.clang.basic.vfs.OverlayFileSystem;
import org.clang.basic.vfs.Status;
import org.clang.basic.vfs.detail.DirIterImpl;
import org.clang.basic.vfs.directory_iterator;
import org.clank.java.std;
import org.clank.java.std_errors;
import org.clank.support.Destructors;
import org.llvm.adt.ADTAliases;
import org.llvm.adt.IntrusiveRefCntPtr;
import org.llvm.adt.StringRef;
import org.llvm.adt.StringSet;
import org.llvm.adt.Twine;
import org.llvm.support.sys.path;

public class OverlayFSDirIterImpl
extends DirIterImpl
implements Destructors.ClassWithDestructor {
    private OverlayFileSystem Overlays;
    private std.string Path;
    private std.reverse_iterator<IntrusiveRefCntPtr<? extends FileSystem>> CurrentFS;
    private directory_iterator CurrentDirIter;
    private StringSet SeenNames;

    private std_errors.error_code incrementFS() {
        assert (ADTAliases.$noteq_reverse_iterator$C(this.CurrentFS, this.Overlays.overlays_end())) : "incrementing past end";
        this.CurrentFS.$preInc();
        std.reverse_iterator<IntrusiveRefCntPtr<? extends FileSystem>> E = this.Overlays.overlays_end();
        while (ADTAliases.$noteq_reverse_iterator$C(this.CurrentFS, E)) {
            std_errors.error_code EC = new std_errors.error_code();
            this.CurrentDirIter.$assignMove(((FileSystem)((Object)((IntrusiveRefCntPtr)this.CurrentFS.$star()).$arrow())).dir_begin(new Twine(this.Path), EC));
            if (EC.$bool() && std.$noteq_error_code((std_errors.error_code)EC, (std_errors.error_code)new std_errors.error_code(std_errors.errc.no_such_file_or_directory))) {
                return EC;
            }
            if (this.CurrentDirIter.$noteq(new directory_iterator())) break;
            this.CurrentFS.$preInc();
        }
        return new std_errors.error_code();
    }

    private std_errors.error_code incrementDirIter(boolean IsFirstTime) {
        assert (IsFirstTime || this.CurrentDirIter.$noteq(new directory_iterator())) : "incrementing past end";
        std_errors.error_code EC = new std_errors.error_code();
        if (!IsFirstTime) {
            this.CurrentDirIter.increment(EC);
        }
        if (!EC.$bool() && this.CurrentDirIter.$eq(new directory_iterator())) {
            EC.$assignMove(this.incrementFS());
        }
        return EC;
    }

    private std_errors.error_code incrementImpl(boolean IsFirstTime) {
        std_errors.error_code EC;
        StringRef Name;
        do {
            if ((EC = this.incrementDirIter(IsFirstTime)).$bool() || this.CurrentDirIter.$eq(new directory_iterator())) {
                this.CurrentEntry.$assignMove(new Status());
                return EC;
            }
            this.CurrentEntry.$assign(this.CurrentDirIter.$star());
            Name = path.filename((StringRef)this.CurrentEntry.getName());
        } while (!this.SeenNames.insert((StringRef)Name).second);
        return EC;
    }

    public OverlayFSDirIterImpl(Twine Path, OverlayFileSystem FS, std_errors.error_code EC) {
        this.Overlays = FS;
        this.Path = Path.str();
        this.CurrentFS = this.Overlays.overlays_begin();
        this.CurrentDirIter = new directory_iterator();
        this.SeenNames = new StringSet();
        this.CurrentDirIter.$assignMove(((FileSystem)((Object)((IntrusiveRefCntPtr)this.CurrentFS.$star()).$arrow())).dir_begin(Path, EC));
        EC.$assignMove(this.incrementImpl(true));
    }

    @Override
    public std_errors.error_code increment() {
        return this.incrementImpl(false);
    }

    @Override
    public void $destroy() {
        this.SeenNames.$destroy();
        this.CurrentDirIter.$destroy();
        this.Path.$destroy();
        super.$destroy();
    }

    @Override
    public String toString() {
        return "Overlays=" + (Object)((Object)this.Overlays) + ", Path=" + this.Path + ", CurrentFS=" + this.CurrentFS + ", CurrentDirIter=" + this.CurrentDirIter + ", SeenNames=" + this.SeenNames + super.toString();
    }
}

