/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.utils.filters;

import java.io.File;
import org.netbeans.modules.cnd.utils.FileAndFileObjectFilter;
import org.netbeans.modules.cnd.utils.MIMEExtensions;
import org.netbeans.modules.cnd.utils.MIMESupport;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.NbBundle;

public class HeaderSourceFileFilter
extends FileAndFileObjectFilter {
    private static HeaderSourceFileFilter instance = null;
    private String[] suffixList = null;

    public static HeaderSourceFileFilter getInstance() {
        if (instance == null) {
            instance = new HeaderSourceFileFilter();
        }
        return instance;
    }

    @Override
    protected boolean mimeAccept(File f) {
        if (FileUtil.getExtension((String)f.getName()).length() == 0) {
            return "text/x-h".equals(MIMESupport.getSourceFileMIMEType(f));
        }
        return super.mimeAccept(f);
    }

    @Override
    protected boolean mimeAccept(FileObject f) {
        if (f.getExt().isEmpty()) {
            "text/x-h".equals(MIMESupport.getSourceFileMIMEType(f));
        }
        return super.mimeAccept(f);
    }

    @Override
    public String getDescription() {
        return NbBundle.getMessage(HeaderSourceFileFilter.class, (String)"FILECHOOSER_HEADER_SOURCES_FILEFILTER", (Object)this.getSuffixesAsString());
    }

    @Override
    public String[] getSuffixes() {
        if (this.suffixList == null) {
            this.suffixList = MIMEExtensions.get("text/x-h").getValues().toArray(new String[0]);
        }
        return this.suffixList;
    }
}

