/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javascript2.jade.editor;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import org.netbeans.api.lexer.Token;
import org.netbeans.api.lexer.TokenHierarchy;
import org.netbeans.api.lexer.TokenId;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.editor.BaseDocument;
import org.netbeans.modules.csl.api.CodeCompletionContext;
import org.netbeans.modules.csl.api.CodeCompletionHandler;
import org.netbeans.modules.csl.api.CodeCompletionHandler2;
import org.netbeans.modules.csl.api.CodeCompletionResult;
import org.netbeans.modules.csl.api.CompletionProposal;
import org.netbeans.modules.csl.api.Documentation;
import org.netbeans.modules.csl.api.ElementHandle;
import org.netbeans.modules.csl.api.ParameterInfo;
import org.netbeans.modules.csl.spi.DefaultCompletionResult;
import org.netbeans.modules.csl.spi.ParserResult;
import org.netbeans.modules.css.indexing.api.CssIndex;
import org.netbeans.modules.html.editor.lib.api.HtmlVersion;
import org.netbeans.modules.html.editor.lib.api.model.HtmlModel;
import org.netbeans.modules.html.editor.lib.api.model.HtmlModelFactory;
import org.netbeans.modules.html.editor.lib.api.model.HtmlTag;
import org.netbeans.modules.html.editor.lib.api.model.HtmlTagAttribute;
import org.netbeans.modules.html.editor.lib.api.model.HtmlTagType;
import org.netbeans.modules.javascript2.jade.editor.JadeCompletionContext;
import org.netbeans.modules.javascript2.jade.editor.JadeCompletionItem;
import org.netbeans.modules.javascript2.jade.editor.lexer.JadeTokenId;
import org.netbeans.modules.web.common.api.LexerUtils;
import org.openide.filesystems.FileObject;
import org.openide.util.Exceptions;

public class JadeCodeCompletion
implements CodeCompletionHandler2 {
    private static final Logger LOGGER = Logger.getLogger(JadeCodeCompletion.class.getName());
    private boolean caseSensitive;
    protected static final String CSS_ID_PREFIX = "#";
    protected static final String CSS_CLASS_PREFIX = ".";

    public CodeCompletionResult complete(CodeCompletionContext context) {
        ParserResult info = context.getParserResult();
        int carretOffset = context.getParserResult().getSnapshot().getEmbeddedOffset(context.getCaretOffset());
        String prefix = context.getPrefix();
        this.caseSensitive = context.isCaseSensitive();
        JadeCompletionContext jadeContext = JadeCompletionContext.findCompletionContext(info, carretOffset);
        ArrayList<CompletionProposal> resultList = new ArrayList<CompletionProposal>();
        JadeCompletionItem.CompletionRequest request = new JadeCompletionItem.CompletionRequest(info, prefix == null ? carretOffset : carretOffset - prefix.length(), prefix);
        LOGGER.log(Level.FINEST, "Jade Completion Context {0}, prefix: {1}, anchorOffset: {2}", new Object[]{jadeContext, request.prefix, request.anchor});
        switch (jadeContext) {
            case TAG_AND_KEYWORD: {
                this.completeKewords(request, resultList);
            }
            case TAG: {
                this.completeTags(request, resultList);
                break;
            }
            case ATTRIBUTE: {
                this.completeAttributes(request, resultList);
                break;
            }
            case CSS_ID: {
                this.completeTagIds(request, resultList);
                break;
            }
            case CSS_CLASS: {
                this.completeCSSClasses(request, resultList);
            }
        }
        if (!resultList.isEmpty()) {
            return new DefaultCompletionResult(resultList, false);
        }
        return CodeCompletionResult.NONE;
    }

    public String document(ParserResult info, ElementHandle element) {
        return null;
    }

    public ElementHandle resolveLink(String link, ElementHandle originalHandle) {
        return null;
    }

    public String getPrefix(ParserResult info, int caretOffset, boolean upToOffset) {
        Token token;
        String prefix = null;
        BaseDocument doc = (BaseDocument)info.getSnapshot().getSource().getDocument(false);
        if (doc == null) {
            return null;
        }
        TokenSequence ts = info.getSnapshot().getTokenHierarchy().tokenSequence(JadeTokenId.jadeLanguage());
        if (ts == null) {
            return null;
        }
        int offset = info.getSnapshot().getEmbeddedOffset(caretOffset);
        ts.move(offset);
        if (!ts.moveNext() && !ts.movePrevious()) {
            return null;
        }
        if (ts.offset() == offset) {
            ts.movePrevious();
        }
        if ((token = ts.token()).id() == JadeTokenId.TAG || ((JadeTokenId)token.id()).isKeyword()) {
            prefix = token.text().toString();
            if (upToOffset && offset - ts.offset() >= 0) {
                prefix = prefix.substring(0, offset - ts.offset());
            }
        }
        return prefix;
    }

    public CodeCompletionHandler.QueryType getAutoQuery(JTextComponent component, String typedText) {
        return CodeCompletionHandler.QueryType.NONE;
    }

    public String resolveTemplateVariable(String variable, ParserResult info, int caretOffset, String name, Map parameters) {
        return null;
    }

    public Set<String> getApplicableTemplates(Document doc, int selectionBegin, int selectionEnd) {
        return null;
    }

    public ParameterInfo parameters(ParserResult info, int caretOffset, CompletionProposal proposal) {
        return ParameterInfo.NONE;
    }

    public Documentation documentElement(ParserResult info, ElementHandle element, Callable<Boolean> cancel) {
        if (element != null && element instanceof JadeCompletionItem.SimpleElement) {
            return ((JadeCompletionItem.SimpleElement)element).getDocumentation();
        }
        return null;
    }

    private void completeKewords(JadeCompletionItem.CompletionRequest request, List<CompletionProposal> resultList) {
        for (JadeTokenId id : JadeTokenId.values()) {
            if (!id.isKeyword() || !this.startsWith(id.getText(), request.prefix)) continue;
            resultList.add(new JadeCompletionItem.KeywordItem(id.getText(), request));
        }
    }

    private void completeTags(JadeCompletionItem.CompletionRequest request, List<CompletionProposal> resultList) {
        ArrayList<HtmlTag> result;
        HtmlModel htmlModel = HtmlModelFactory.getModel((HtmlVersion)HtmlVersion.HTML5);
        ArrayList<HtmlTag> allTags = htmlModel.getAllTags();
        if (request.prefix == null || request.prefix.isEmpty()) {
            result = allTags;
        } else {
            result = new ArrayList<HtmlTag>();
            for (HtmlTag htmlTag : allTags) {
                if (!this.startsWith(htmlTag.getName(), request.prefix)) continue;
                result.add(htmlTag);
            }
        }
        if (!result.isEmpty()) {
            for (HtmlTag tag : result) {
                resultList.add(JadeCompletionItem.create(request, tag));
            }
        }
    }

    private void completeAttributes(JadeCompletionItem.CompletionRequest request, List<CompletionProposal> resultList) {
        Collection<HtmlTagAttribute> resultAttrs;
        HtmlTag htmlTag;
        HtmlModel htmlModel = HtmlModelFactory.getModel((HtmlVersion)HtmlVersion.HTML5);
        String tagName = this.findTag(request);
        String prefix = request.prefix == null ? "" : request.prefix;
        HtmlTag htmlTag2 = htmlTag = tagName == null ? null : htmlModel.getTag(tagName);
        if (tagName != null && !tagName.isEmpty() && htmlTag != null) {
            if (prefix.isEmpty()) {
                resultAttrs = tagName.isEmpty() ? this.getAllAttributes(htmlModel, prefix) : htmlTag.getAttributes();
            } else {
                Collection<HtmlTagAttribute> attributes = htmlTag.getAttributes();
                if (tagName.isEmpty() || htmlTag.getTagClass() == HtmlTagType.UNKNOWN) {
                    attributes = this.getAllAttributes(htmlModel, prefix);
                }
                resultAttrs = new ArrayList<HtmlTagAttribute>();
                for (HtmlTagAttribute htmlTagAttribute : attributes) {
                    if (!htmlTagAttribute.getName().startsWith(prefix)) continue;
                    resultAttrs.add(htmlTagAttribute);
                }
            }
        } else {
            resultAttrs = this.getAllAttributes(htmlModel, prefix);
        }
        for (HtmlTagAttribute attribute : resultAttrs) {
            resultList.add(JadeCompletionItem.create(request, attribute));
        }
    }

    private void completeTagIds(JadeCompletionItem.CompletionRequest request, List<CompletionProposal> resultList) {
        FileObject fo = request.parserResult.getSnapshot().getSource().getFileObject();
        if (fo == null) {
            return;
        }
        Project project = FileOwnerQuery.getOwner((FileObject)fo);
        HashSet<String> unique = new HashSet<String>();
        String prefix = request.prefix == null ? "" : request.prefix;
        try {
            CssIndex cssIndex = CssIndex.create((Project)project);
            Map findIdsByPrefix = cssIndex.findIdsByPrefix(prefix);
            for (Collection ids : findIdsByPrefix.values()) {
                for (String id : ids) {
                    unique.add(id);
                }
            }
        }
        catch (IOException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        for (String className : unique) {
            resultList.add(JadeCompletionItem.createCssItem(request, className, CSS_ID_PREFIX));
        }
    }

    private void completeCSSClasses(JadeCompletionItem.CompletionRequest request, List<CompletionProposal> resultList) {
        FileObject fo = request.parserResult.getSnapshot().getSource().getFileObject();
        if (fo == null) {
            return;
        }
        Project project = FileOwnerQuery.getOwner((FileObject)fo);
        HashSet<String> unique = new HashSet<String>();
        String prefix = request.prefix == null ? "" : request.prefix;
        try {
            CssIndex cssIndex = CssIndex.create((Project)project);
            Map findIdsByPrefix = cssIndex.findClassesByPrefix(prefix);
            for (Collection ids : findIdsByPrefix.values()) {
                for (String id : ids) {
                    unique.add(id);
                }
            }
        }
        catch (IOException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        for (String className : unique) {
            resultList.add(JadeCompletionItem.createCssItem(request, className, CSS_CLASS_PREFIX));
        }
    }

    private boolean startsWith(String theString, String prefix) {
        if (prefix == null || prefix.length() == 0) {
            return true;
        }
        return this.caseSensitive ? theString.startsWith(prefix) : theString.toLowerCase().startsWith(prefix.toLowerCase());
    }

    private String findTag(JadeCompletionItem.CompletionRequest request) {
        TokenHierarchy th = request.parserResult.getSnapshot().getTokenHierarchy();
        if (th == null) {
            return null;
        }
        TokenSequence ts = th.tokenSequence(JadeTokenId.jadeLanguage());
        if (ts == null) {
            return null;
        }
        ts.move(request.anchor);
        if (!ts.movePrevious()) {
            return null;
        }
        Token token = LexerUtils.followsToken((TokenSequence)ts, (TokenId)JadeTokenId.TAG, (boolean)true, (boolean)false, (TokenId[])new TokenId[0]);
        if (token == null) {
            return null;
        }
        JadeTokenId id = (JadeTokenId)token.id();
        String tagName = null;
        if (id == JadeTokenId.TAG) {
            tagName = token.text().toString();
        }
        return tagName;
    }

    private Collection<HtmlTagAttribute> getAllAttributes(HtmlModel htmlModel, String prefix) {
        HashMap<String, HtmlTagAttribute> result = new HashMap<String, HtmlTagAttribute>();
        for (HtmlTag htmlTag : htmlModel.getAllTags()) {
            for (HtmlTagAttribute htmlTagAttribute : htmlTag.getAttributes()) {
                if (result.containsKey(htmlTagAttribute.getName()) || !htmlTagAttribute.getName().startsWith(prefix)) continue;
                result.put(htmlTagAttribute.getName(), htmlTagAttribute);
            }
        }
        return result.values();
    }
}

