/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.toolchain.execution;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Stack;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.netbeans.api.project.Project;
import org.netbeans.modules.cnd.api.toolchain.CompilerFlavor;
import org.netbeans.modules.cnd.api.toolchain.ToolchainManager;
import org.netbeans.modules.cnd.spi.toolchain.ErrorParserProvider;
import org.netbeans.modules.cnd.toolchain.execution.ErrorParser;
import org.netbeans.modules.cnd.utils.CndPathUtilities;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironment;
import org.openide.filesystems.FileObject;
import org.openide.util.NbBundle;

public final class GCCErrorParser
extends ErrorParser {
    private final List<Pattern> GCC_ERROR_SCANNER = new ArrayList<Pattern>();
    private final List<Pattern> patterns = new ArrayList<Pattern>();
    private Pattern GCC_DIRECTORY_ENTER;
    private Pattern GCC_DIRECTORY_LEAVE;
    private Pattern GCC_DIRECTORY_CD;
    private Pattern GCC_DIRECTORY_MAKE_ALL;
    private List<Pattern> GCC_STACK_HEADER = new ArrayList<Pattern>();
    private List<Pattern> GCC_STACK_NEXT = new ArrayList<Pattern>();
    private Stack<FileObject> relativesTo = new Stack();
    private Stack<Integer> relativesLevel = new Stack();
    private ArrayList<StackIncludeItem> errorInludes = new ArrayList();
    private boolean isEntered;
    private ErrorParserProvider.OutputListenerRegistry listenerRegistry;

    public GCCErrorParser(Project project, CompilerFlavor flavor, ExecutionEnvironment execEnv, FileObject relativeTo) {
        super(project, execEnv, relativeTo);
        this.relativesTo.push(relativeTo);
        this.relativesLevel.push(0);
        this.isEntered = false;
        this.init(flavor);
    }

    private void init(CompilerFlavor flavor) {
        ToolchainManager.ScannerDescriptor scanner = flavor.getToolchainDescriptor().getScanner();
        if (scanner.getEnterDirectoryPattern() != null) {
            this.GCC_DIRECTORY_ENTER = Pattern.compile(scanner.getEnterDirectoryPattern());
            this.patterns.add(this.GCC_DIRECTORY_ENTER);
        }
        if (scanner.getLeaveDirectoryPattern() != null) {
            this.GCC_DIRECTORY_LEAVE = Pattern.compile(scanner.getLeaveDirectoryPattern());
            this.patterns.add(this.GCC_DIRECTORY_LEAVE);
        }
        if (scanner.getChangeDirectoryPattern() != null) {
            this.GCC_DIRECTORY_CD = Pattern.compile(scanner.getChangeDirectoryPattern());
            this.patterns.add(this.GCC_DIRECTORY_CD);
        }
        if (scanner.getChangeDirectoryPattern() != null) {
            this.GCC_DIRECTORY_MAKE_ALL = Pattern.compile(scanner.getMakeAllInDirectoryPattern());
            this.patterns.add(this.GCC_DIRECTORY_MAKE_ALL);
        }
        if (scanner.getStackHeaderPattern().size() > 0 && scanner.getStackNextPattern().size() > 0) {
            for (String pattern : scanner.getStackHeaderPattern()) {
                this.GCC_STACK_HEADER.add(Pattern.compile(pattern));
            }
            this.patterns.addAll(this.GCC_STACK_HEADER);
            for (String pattern : scanner.getStackNextPattern()) {
                this.GCC_STACK_NEXT.add(Pattern.compile(pattern));
            }
            this.patterns.addAll(this.GCC_STACK_NEXT);
        }
        for (ToolchainManager.ScannerPattern s : scanner.getPatterns()) {
            Pattern pattern = Pattern.compile(s.getPattern());
            this.GCC_ERROR_SCANNER.add(pattern);
            this.patterns.add(pattern);
        }
    }

    @Override
    public void setOutputListenerRegistry(ErrorParserProvider.OutputListenerRegistry regestry) {
        this.listenerRegistry = regestry;
    }

    private void popPath() {
        if (this.relativesTo.size() > 1) {
            this.relativesTo.pop();
        }
    }

    private void popLevel() {
        if (this.relativesLevel.size() > 1) {
            this.relativesLevel.pop();
        }
    }

    private String getNoEscapeLine(String line) {
        int startEscape = line.indexOf("\u001b[");
        if (startEscape >= 0) {
            StringBuilder buf = new StringBuilder();
            int i = 0;
            block0: while (i < line.length()) {
                char c = line.charAt(i);
                if (c == '\u001b' && i + 1 < line.length() && line.charAt(i + 1) == '[') {
                    i += 2;
                    while (i < line.length()) {
                        char t = line.charAt(i);
                        if (t == ';' || t >= '0' && t <= '9') {
                            ++i;
                            continue;
                        }
                        ++i;
                        continue block0;
                    }
                }
                ++i;
                buf.append(c);
            }
            line = buf.toString();
        }
        return line;
    }

    @Override
    public ErrorParserProvider.Result handleLine(String line) {
        String noEscape = this.getNoEscapeLine(line);
        for (Pattern p : this.patterns) {
            Matcher m = p.matcher(noEscape);
            boolean found = m.find();
            if (!found || m.start() != 0) continue;
            return this.handleLine(line, m);
        }
        if (!this.errorInludes.isEmpty()) {
            ErrorParserProvider.Results res = new ErrorParserProvider.Results();
            for (StackIncludeItem item : this.errorInludes) {
                if (item.fo != null) {
                    res.add(item.line, this.listenerRegistry.register(item.fo, item.lineNumber, false, item.getMessage()));
                    continue;
                }
                res.add(item.line, null);
            }
            this.errorInludes.clear();
            res.add(line, null);
            return res;
        }
        return null;
    }

    private ErrorParserProvider.Result handleLine(String line, Matcher m) {
        if (m.pattern() == this.GCC_DIRECTORY_ENTER || m.pattern() == this.GCC_DIRECTORY_LEAVE) {
            String levelString = m.group(1);
            int level = levelString == null ? 0 : Integer.parseInt(levelString);
            int baseLavel = this.relativesLevel.peek();
            String directory = m.group(2);
            if (level > baseLavel) {
                this.isEntered = true;
                this.relativesLevel.push(level);
                this.isEntered = true;
            } else if (level == baseLavel) {
                this.isEntered = !this.isEntered;
            } else {
                this.isEntered = false;
                this.popLevel();
            }
            if (this.isEntered) {
                FileObject relativeDir;
                if (!CndPathUtilities.isAbsolute((CharSequence)directory) && this.relativeTo != null && this.relativeTo.isFolder()) {
                    directory = this.relativeTo.toURL().getPath() + File.separator + directory;
                }
                if ((relativeDir = this.resolveFile(directory)) != null && relativeDir.isValid()) {
                    this.relativesTo.push(relativeDir);
                }
                return ErrorParserProvider.NO_RESULT;
            }
            this.popPath();
            return ErrorParserProvider.NO_RESULT;
        }
        if (m.pattern() == this.GCC_DIRECTORY_CD) {
            FileObject relativeDir;
            String directory = this.trimQuotes(m.group(1));
            if (!CndPathUtilities.isAbsolute((CharSequence)directory) && this.relativeTo != null && this.relativeTo.isFolder()) {
                directory = this.relativeTo.toURL().getPath() + File.separator + directory;
            }
            if ((relativeDir = this.resolveFile(directory)) != null && relativeDir.isValid()) {
                this.relativesTo.push(relativeDir);
            }
            return ErrorParserProvider.NO_RESULT;
        }
        if (m.pattern() == this.GCC_DIRECTORY_MAKE_ALL) {
            FileObject relativeDir = this.relativesTo.peek();
            String directory = m.group(1);
            if (!CndPathUtilities.isAbsolute((CharSequence)directory) && relativeDir != null && relativeDir.isFolder()) {
                directory = relativeDir.toURL().getPath() + File.separator + directory;
            }
            if ((relativeDir = this.resolveFile(directory)) != null && relativeDir.isValid()) {
                this.relativesTo.push(relativeDir);
            }
            return ErrorParserProvider.NO_RESULT;
        }
        if (this.GCC_STACK_NEXT.contains(m.pattern()) || this.GCC_STACK_HEADER.contains(m.pattern())) {
            try {
                String file = m.group(1);
                if (m.groupCount() >= 2) {
                    FileObject fo;
                    Integer lineNumber = Integer.valueOf(m.group(2));
                    FileObject relativeDir = this.relativesTo.peek();
                    if (relativeDir != null && (fo = this.resolveRelativePath(relativeDir, file)) != null && fo.isValid()) {
                        this.errorInludes.add(new StackIncludeItem(fo, line, lineNumber - 1));
                        return new ErrorParserProvider.Results();
                    }
                }
            }
            catch (NumberFormatException file) {
                // empty catch block
            }
            this.errorInludes.add(new StackIncludeItem(null, line, 0));
            return new ErrorParserProvider.Results();
        }
        if (this.GCC_ERROR_SCANNER.contains(m.pattern())) {
            ErrorParserProvider.Results res = new ErrorParserProvider.Results();
            try {
                FileObject relativeDir;
                Integer lineNumber;
                String file = null;
                if (m.groupCount() == 5) {
                    file = m.group(4);
                }
                String description = null;
                if (file == null || !file.matches(".*\\.pc")) {
                    file = m.group(1);
                    lineNumber = Integer.valueOf(m.group(2));
                    if (m.groupCount() >= 4) {
                        description = m.group(4);
                    }
                } else {
                    lineNumber = Integer.valueOf(m.group(2));
                    description = m.group(1);
                }
                if ((relativeDir = this.relativesTo.peek()) != null) {
                    FileObject fo = this.resolveRelativePath(relativeDir, file);
                    boolean important = false;
                    if (m.groupCount() > 2) {
                        if (this.isNumber(m.group(3))) {
                            if (description != null) {
                                important = description.trim().toLowerCase().indexOf("error:") == 0;
                            }
                        } else {
                            boolean bl = important = m.group(3).toLowerCase().indexOf("error") != -1;
                        }
                    }
                    if (fo != null && fo.isValid()) {
                        for (StackIncludeItem item : this.errorInludes) {
                            if (item.fo != null) {
                                res.add(item.line, this.listenerRegistry.register(item.fo, item.lineNumber, important, item.getMessage()));
                                continue;
                            }
                            res.add(item.line, null);
                        }
                        this.errorInludes.clear();
                        res.add(line, this.listenerRegistry.register(fo, lineNumber - 1, important, description));
                        return res;
                    }
                }
            }
            catch (NumberFormatException file) {
                // empty catch block
            }
            for (StackIncludeItem item : this.errorInludes) {
                res.add(item.line, null);
            }
            this.errorInludes.clear();
            res.add(line, null);
            return res;
        }
        throw new IllegalArgumentException("Unknown pattern: " + m.pattern().pattern());
    }

    private boolean isNumber(String s) {
        boolean res = false;
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (c < '0' || c > '9') {
                return false;
            }
            res = true;
        }
        return res;
    }

    private String trimQuotes(String s) {
        if (s.length() > 2) {
            if (s.startsWith("\"") && s.endsWith("\"")) {
                return s.substring(1, s.length() - 1);
            }
            if (s.startsWith("'") && s.endsWith("'")) {
                return s.substring(1, s.length() - 1);
            }
        }
        return s;
    }

    private static class StackIncludeItem {
        private final FileObject fo;
        private final String line;
        private final int lineNumber;

        private StackIncludeItem(FileObject fo, String line, int lineNumber) {
            this.fo = fo;
            this.line = line;
            this.lineNumber = lineNumber;
        }

        private String getMessage() {
            if (this.line.indexOf("instantiation of") >= 0 || this.line.indexOf("instantiated from") >= 0) {
                return NbBundle.getMessage(GCCErrorParser.class, (String)"HINT_InstantiatedFrom");
            }
            return NbBundle.getMessage(GCCErrorParser.class, (String)"HINT_IncludedFrom");
        }
    }
}

