/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.modelimpl.csm;

import java.io.IOException;
import java.util.ArrayList;
import org.netbeans.modules.cnd.antlr.collections.AST;
import org.netbeans.modules.cnd.api.model.CsmClass;
import org.netbeans.modules.cnd.api.model.CsmDeclaration;
import org.netbeans.modules.cnd.api.model.CsmFile;
import org.netbeans.modules.cnd.api.model.CsmNamespace;
import org.netbeans.modules.cnd.api.model.CsmProject;
import org.netbeans.modules.cnd.api.model.CsmQualifiedNamedElement;
import org.netbeans.modules.cnd.api.model.CsmScope;
import org.netbeans.modules.cnd.api.model.CsmType;
import org.netbeans.modules.cnd.api.model.CsmUID;
import org.netbeans.modules.cnd.api.model.CsmVariable;
import org.netbeans.modules.cnd.api.model.CsmVariableDefinition;
import org.netbeans.modules.cnd.api.model.deep.CsmExpression;
import org.netbeans.modules.cnd.api.model.deep.CsmStatement;
import org.netbeans.modules.cnd.modelimpl.csm.CsmObjectBuilder;
import org.netbeans.modules.cnd.modelimpl.csm.MutableDeclarationsContainer;
import org.netbeans.modules.cnd.modelimpl.csm.NameHolder;
import org.netbeans.modules.cnd.modelimpl.csm.TypeImpl;
import org.netbeans.modules.cnd.modelimpl.csm.core.AstRenderer;
import org.netbeans.modules.cnd.modelimpl.csm.core.AstUtil;
import org.netbeans.modules.cnd.modelimpl.csm.core.CsmIdentifiable;
import org.netbeans.modules.cnd.modelimpl.csm.core.Disposable;
import org.netbeans.modules.cnd.modelimpl.csm.core.OffsetableDeclarationBase;
import org.netbeans.modules.cnd.modelimpl.csm.core.ProjectBase;
import org.netbeans.modules.cnd.modelimpl.csm.core.Utils;
import org.netbeans.modules.cnd.modelimpl.csm.deep.ExpressionBase;
import org.netbeans.modules.cnd.modelimpl.csm.deep.ExpressionsFactory;
import org.netbeans.modules.cnd.modelimpl.parser.CsmAST;
import org.netbeans.modules.cnd.modelimpl.parser.FakeAST;
import org.netbeans.modules.cnd.modelimpl.parser.OffsetableAST;
import org.netbeans.modules.cnd.modelimpl.repository.PersistentUtils;
import org.netbeans.modules.cnd.modelimpl.textcache.NameCache;
import org.netbeans.modules.cnd.modelimpl.uid.UIDCsmConverter;
import org.netbeans.modules.cnd.modelimpl.uid.UIDObjectFactory;
import org.netbeans.modules.cnd.repository.spi.RepositoryDataInput;
import org.netbeans.modules.cnd.repository.spi.RepositoryDataOutput;
import org.netbeans.modules.cnd.utils.cache.CharSequenceUtils;
import org.openide.util.CharSequences;

public class VariableImpl<T>
extends OffsetableDeclarationBase<T>
implements CsmVariable,
Disposable {
    private final CharSequence name;
    private final CsmType type;
    private final boolean _static;
    private CsmScope scopeRef;
    private CsmUID<CsmScope> scopeUID;
    private final boolean _extern;
    private ExpressionBase initExpr;

    public static <T> VariableImpl<T> create(CsmFile file, int startOffset, int endOffset, CsmType type, CharSequence name, CsmScope scope, boolean _static, boolean _extern, boolean registerInProject) {
        VariableImpl<T> variableImpl = new VariableImpl<T>(file, startOffset, endOffset, type, name, scope, _static, _extern);
        VariableImpl.postObjectCreateRegistration(registerInProject, variableImpl);
        return variableImpl;
    }

    protected VariableImpl(AST ast, CsmFile file, CsmType type, NameHolder name, CsmScope scope, boolean _static, boolean _extern) {
        super(file, VariableImpl.getStartOffset(ast), VariableImpl.getEndOffset(ast));
        this.initInitialValue(ast, scope);
        this._static = _static;
        this._extern = _extern;
        this.name = NameCache.getManager().getString(name.getName());
        this.type = type;
        this._setScope(scope);
    }

    protected VariableImpl(CsmType type, CharSequence name, CsmScope scope, boolean _static, boolean _extern, ExpressionBase initExpr, CsmFile file, int startOffset, int endOffset) {
        super(file, startOffset, endOffset);
        this.initExpr = initExpr;
        this._static = _static;
        this._extern = _extern;
        this.name = name;
        this.type = type;
        this._setScope(scope);
    }

    public static <T> VariableImpl<T> create(AST ast, CsmFile file, CsmType type, NameHolder name, CsmScope scope, boolean _static, boolean _extern, boolean global) {
        VariableImpl<T> variableImpl = new VariableImpl<T>(ast, file, type, name, scope, _static, _extern);
        VariableImpl.postObjectCreateRegistration(global, variableImpl);
        return variableImpl;
    }

    protected VariableImpl(CsmFile file, int startOffset, int endOffset, CsmType type, CharSequence name, CsmScope scope, boolean _static, boolean _extern) {
        super(file, startOffset, endOffset);
        this._static = _static;
        this._extern = _extern;
        this.name = NameCache.getManager().getString(name);
        this.type = type;
        this._setScope(scope);
    }

    public static int getStartOffset(AST node) {
        OffsetableAST csmAst;
        if (node != null && (csmAst = AstUtil.getFirstOffsetableAST(node)) != null) {
            return csmAst.getOffset();
        }
        return 0;
    }

    public static int getEndOffset(AST node) {
        int endOffset = 0;
        if (node != null) {
            AST next;
            AST lastChild = AstUtil.getLastChildRecursively(node);
            if (lastChild instanceof CsmAST) {
                endOffset = ((CsmAST)lastChild).getEndOffset();
            }
            if ((node.getType() == 608 || node.getType() == 607) && (next = node.getNextSibling()) != null && next.getType() == 6) {
                int curlyLevel = 0;
                int templateLevel = 0;
                int parenLevel = 0;
                while (next != null && (curlyLevel != 0 || next.getType() != 8) && next.getType() != 10) {
                    if (next.getType() != 16) {
                        ++curlyLevel;
                    }
                    if (next.getType() != 17) {
                        --curlyLevel;
                    }
                    if (next.getType() != 21) {
                        ++templateLevel;
                    }
                    if (next.getType() != 23) {
                        --templateLevel;
                    }
                    if (next.getType() != 12) {
                        ++parenLevel;
                    }
                    if (next.getType() != 13) {
                        --parenLevel;
                    }
                    if ((lastChild = AstUtil.getLastChildRecursively(next)) instanceof CsmAST) {
                        endOffset = ((CsmAST)lastChild).getEndOffset();
                    }
                    next = next.getNextSibling();
                }
            }
        }
        return endOffset;
    }

    @Override
    protected boolean registerInProject() {
        CsmProject project = this.getContainingFile().getProject();
        if (project instanceof ProjectBase) {
            return ((ProjectBase)project).registerDeclaration(this);
        }
        return false;
    }

    protected boolean unregisterInProject() {
        CsmProject project = this.getContainingFile().getProject();
        if (project instanceof ProjectBase) {
            ((ProjectBase)project).unregisterDeclaration(this);
            this.cleanUID();
            return true;
        }
        return false;
    }

    public CharSequence getName() {
        return this.name;
    }

    public CharSequence getQualifiedName() {
        CsmScope scope = this.getScope();
        if (scope instanceof CsmNamespace || scope instanceof CsmClass) {
            return CharSequences.create((CharSequence)CharSequenceUtils.concatenate((CharSequence)((CsmQualifiedNamedElement)scope).getQualifiedName(), (CharSequence)"::", (CharSequence)this.getQualifiedNamePostfix()));
        }
        return this.getName();
    }

    @Override
    public CharSequence getUniqueNameWithoutPrefix() {
        if (this.isExtern()) {
            return this.getQualifiedName() + " (EXTERN)";
        }
        return this.getQualifiedName();
    }

    public CsmType getType() {
        return this.type;
    }

    private void initInitialValue(AST node, CsmScope scope) {
        if (node != null) {
            AST lastChild;
            AST next;
            OffsetableAST startAST = null;
            AST tok = AstUtil.findChildOfType(node, 6);
            if (tok == null && (node.getType() == 608 || node.getType() == 607) && (next = node.getNextSibling()) != null && next.getType() == 6) {
                tok = next;
            }
            if (tok != null) {
                tok = tok.getNextSibling();
            }
            if (tok != null) {
                startAST = AstUtil.getFirstOffsetableAST(tok);
            }
            AST lastInitAst = tok;
            int curlyLevel = 0;
            int templateLevel = 0;
            int parenLevel = 0;
            int squaresLevel = 0;
            ArrayList<CsmStatement> lambdas = new ArrayList<CsmStatement>();
            while (tok != null && (curlyLevel != 0 || templateLevel != 0 || parenLevel != 0 || squaresLevel != 0 || tok.getType() != 8) && tok.getType() != 10) {
                if (tok.getType() != 16) {
                    ++curlyLevel;
                }
                if (tok.getType() != 17) {
                    --curlyLevel;
                }
                if (tok.getType() != 21) {
                    ++templateLevel;
                }
                if (tok.getType() != 23) {
                    --templateLevel;
                }
                if (tok.getType() != 12) {
                    ++parenLevel;
                }
                if (tok.getType() != 13) {
                    --parenLevel;
                }
                if (tok.getType() != 14) {
                    ++squaresLevel;
                }
                if (tok.getType() != 15) {
                    --squaresLevel;
                }
                lastInitAst = tok;
                if (tok.getType() == 580) {
                    lambdas.add(AstRenderer.renderStatement(tok, this.getContainingFile(), scope));
                }
                tok = tok.getNextSibling();
            }
            if (lastInitAst != null && (lastChild = AstUtil.getLastChildRecursively(lastInitAst)) != null && lastChild instanceof CsmAST) {
                FakeAST exprAST = new FakeAST();
                exprAST.setType(599);
                exprAST.addChild(AstUtil.cloneAST(startAST, lastInitAst));
                this.initExpr = ExpressionsFactory.create((AST)exprAST, this.getContainingFile(), this._getScope());
                if (!lambdas.isEmpty()) {
                    this.initExpr.setLambdas(lambdas);
                }
            }
        }
    }

    public CsmExpression getInitialValue() {
        return this.initExpr;
    }

    public CsmDeclaration.Kind getKind() {
        return CsmDeclaration.Kind.VARIABLE;
    }

    public String getDeclarationText() {
        return "";
    }

    public boolean isAuto() {
        return true;
    }

    public boolean isRegister() {
        return false;
    }

    public boolean isStatic() {
        return this._static;
    }

    public boolean isExtern() {
        return this._extern;
    }

    public boolean isConst() {
        CsmType _type = this.getType();
        if (_type != null) {
            return _type.isConst();
        }
        return false;
    }

    public boolean isMutable() {
        return false;
    }

    public void setScope(CsmScope scope) {
        this.unregisterInProject();
        this._setScope(scope);
        this.registerInProject();
    }

    public synchronized CsmScope getScope() {
        return this._getScope();
    }

    @Override
    public void dispose() {
        super.dispose();
        this.onDispose();
        if (this.type != null && this.type instanceof Disposable) {
            ((Disposable)this.type).dispose();
        }
        if (this._getScope() instanceof MutableDeclarationsContainer) {
            ((MutableDeclarationsContainer)this._getScope()).removeDeclaration(this);
        }
        this.unregisterInProject();
    }

    private synchronized void onDispose() {
        if (this.scopeRef == null) {
            this.scopeRef = UIDCsmConverter.UIDtoScope(this.scopeUID);
            assert (this.scopeRef != null || this.scopeUID == null) : "empty scope for UID " + this.scopeUID;
        }
    }

    public CsmVariableDefinition getDefinition() {
        if (!this.isValid()) {
            return null;
        }
        String uname = "" + Utils.getCsmDeclarationKindkey(CsmDeclaration.Kind.VARIABLE_DEFINITION) + ':' + this.getQualifiedName();
        CsmDeclaration def = this.getContainingFile().getProject().findDeclaration((CharSequence)uname);
        return def == null ? null : (CsmVariableDefinition)def;
    }

    private synchronized CsmScope _getScope() {
        CsmScope scope = this.scopeRef;
        if (scope == null) {
            scope = UIDCsmConverter.UIDtoScope(this.scopeUID);
        }
        return scope;
    }

    private void _setScope(CsmScope scope) {
        if (this.isScopePersistent()) {
            if (scope instanceof CsmIdentifiable) {
                this.scopeUID = UIDCsmConverter.scopeToUID(scope);
                assert (this.scopeUID != null);
            } else {
                this.scopeRef = scope;
            }
        } else {
            this.scopeUID = null;
            this.scopeRef = scope;
        }
    }

    public CharSequence getDisplayText() {
        CsmType _type = this.getType();
        if (_type instanceof TypeImpl) {
            return ((TypeImpl)_type).getText(false, this.getName());
        }
        if (_type != null) {
            StringBuilder sb = new StringBuilder();
            sb.append(_type.getText());
            CharSequence _name = this.getName();
            if (_name != null && _name.length() > 0) {
                sb.append(' ');
                sb.append(_name);
            }
            return sb;
        }
        return CharSequences.empty();
    }

    @Override
    public CharSequence getText() {
        return this.getDisplayText();
    }

    @Override
    public void write(RepositoryDataOutput output) throws IOException {
        super.write(output);
        assert (this.name != null);
        PersistentUtils.writeUTF(this.name, output);
        byte pack = (byte)((this._static ? 1 : 0) | (this._extern ? 2 : 0));
        output.writeByte((int)pack);
        PersistentUtils.writeExpression(this.initExpr, output);
        PersistentUtils.writeType(this.type, output);
        if (this.isScopePersistent()) {
            UIDObjectFactory.getDefaultFactory().writeUID(this.scopeUID, output);
        }
    }

    protected boolean isScopePersistent() {
        return true;
    }

    public VariableImpl(RepositoryDataInput input) throws IOException {
        this(input, null);
        this.scopeUID = UIDObjectFactory.getDefaultFactory().readUID(input);
        this.scopeRef = null;
    }

    protected VariableImpl(RepositoryDataInput input, CsmScope scope) throws IOException {
        super(input);
        this.name = PersistentUtils.readUTF(input, NameCache.getManager());
        assert (this.name != null);
        byte pack = input.readByte();
        this._static = (pack & 1) == 1;
        this._extern = (pack & 2) == 2;
        this.initExpr = (ExpressionBase)PersistentUtils.readExpression(input);
        this.type = PersistentUtils.readType(input);
        this.scopeUID = null;
        this.scopeRef = scope;
    }

    @Override
    public String toString() {
        return (this.isExtern() ? "EXTERN " : "") + super.toString();
    }

    public static class VariableBuilder
    extends OffsetableDeclarationBase.SimpleDeclarationBuilder
    implements CsmObjectBuilder {
        public VariableBuilder(OffsetableDeclarationBase.SimpleDeclarationBuilder builder) {
            super(builder);
        }

        public VariableImpl create() {
            VariableImpl var = null;
            CsmScope s = this.getScope();
            if (s != null && this.getName() != null && this.getScope() != null) {
                var = new VariableImpl(this.getType(), this.getName(), this.getScope(), this.isStatic(), this.isExtern(), null, this.getFile(), this.getStartOffset(), this.getEndOffset());
                VariableImpl.postObjectCreateRegistration(this.isGlobal(), var);
                this.addDeclaration(var);
            }
            return var;
        }
    }
}

