/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.git.ui.history;

import java.awt.EventQueue;
import java.io.File;
import java.util.List;
import org.netbeans.libs.git.GitBranch;
import org.netbeans.modules.git.ui.actions.MultipleRepositoryAction;
import org.netbeans.modules.git.ui.history.DiffResultsView;
import org.netbeans.modules.git.ui.history.DiffResultsViewForLine;
import org.netbeans.modules.git.ui.history.RepositoryRevision;
import org.netbeans.modules.git.ui.history.SearchHistoryPanel;
import org.netbeans.modules.git.ui.history.SearchHistoryTopComponent;
import org.netbeans.modules.git.ui.repository.RepositoryInfo;
import org.netbeans.modules.versioning.spi.VCSContext;
import org.netbeans.modules.versioning.util.Utils;
import org.openide.util.Mutex;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

public class SearchHistoryAction
extends MultipleRepositoryAction {
    private static final String ICON_RESOURCE = "org/netbeans/modules/git/resources/icons/search_history.png";

    public SearchHistoryAction() {
        super(ICON_RESOURCE);
    }

    protected String iconResource() {
        return ICON_RESOURCE;
    }

    @Override
    protected RequestProcessor.Task performAction(File repository, File[] roots, VCSContext context) {
        SearchHistoryAction.openSearch(repository, roots, Utils.getContextDisplayName((VCSContext)context));
        return null;
    }

    public static void openSearch(File repository, File[] roots, String contextName) {
        SearchHistoryAction.openSearch(repository, roots, SearchHistoryAction.getActiveBranchName(repository), contextName);
    }

    public static void openSearch(File repository, File[] roots, String branchName, String contextName) {
        SearchHistoryAction.openSearch(repository, roots, branchName, contextName, roots != null && (roots.length == 1 && roots[0].isFile() || roots.length > 1 && Utils.shareCommonDataObject((File[])roots)));
    }

    public static void openSearch(final File repository, final File[] roots, final String branchName, String contextName, final boolean invokeSearch) {
        final String title = NbBundle.getMessage(SearchHistoryTopComponent.class, (String)"LBL_SearchHistoryTopComponent.title", (Object)contextName);
        final RepositoryInfo info = RepositoryInfo.getInstance(repository);
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                SearchHistoryTopComponent tc = new SearchHistoryTopComponent(repository, info, roots);
                tc.setBranch(branchName);
                tc.setDisplayName(title);
                tc.open();
                tc.requestActive();
                if (invokeSearch) {
                    tc.search(false);
                }
            }
        });
    }

    public static void openSearch(final File repository, final File root, String contextName, final String commitIdFrom, final String commitIdTo) {
        final String title = NbBundle.getMessage(SearchHistoryTopComponent.class, (String)"LBL_SearchHistoryTopComponent.title", (Object)contextName);
        final RepositoryInfo info = RepositoryInfo.getInstance(repository);
        Mutex.EVENT.readAccess(new Runnable(){

            @Override
            public void run() {
                SearchHistoryTopComponent tc = new SearchHistoryTopComponent(repository, info, new File[]{root});
                tc.setDisplayName(title);
                tc.open();
                tc.requestActive();
                tc.setSearchCommitFrom(commitIdFrom);
                tc.setSearchCommitTo(commitIdTo);
                tc.search(true);
            }
        });
    }

    public static void openSearch(final File repository, final File root, String contextName, final int lineNumber) {
        final String title = NbBundle.getMessage(SearchHistoryTopComponent.class, (String)"LBL_SearchHistoryTopComponent.title", (Object)contextName);
        final RepositoryInfo info = RepositoryInfo.getInstance(repository);
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                SearchHistoryTopComponent tc = new SearchHistoryTopComponent(repository, info, root, new SearchHistoryTopComponent.DiffResultsViewFactory(){

                    @Override
                    DiffResultsView createDiffResultsView(SearchHistoryPanel panel, List<RepositoryRevision> results) {
                        return new DiffResultsViewForLine(panel, results, lineNumber);
                    }
                });
                tc.setDisplayName(title);
                tc.open();
                tc.requestActive();
                tc.search(true);
                tc.activateDiffView(true);
            }
        });
    }

    private static String getActiveBranchName(File repository) {
        GitBranch activeBranch = RepositoryInfo.getInstance(repository).getActiveBranch();
        String branchName = null;
        if (activeBranch != GitBranch.NO_BRANCH_INSTANCE) {
            branchName = activeBranch.getName() == "(no branch)" ? "HEAD" : activeBranch.getName();
        }
        return branchName;
    }
}

