/*
 * Decompiled with CFR 0.152.
 */
package org.clang.driver.tools.impl;

import org.clang.driver.Action;
import org.clang.driver.Command;
import org.clang.driver.Compilation;
import org.clang.driver.Driver;
import org.clang.driver.JobAction;
import org.clang.driver.Tool;
import org.clang.driver.ToolChain;
import org.clang.driver.impl.InputInfo;
import org.clang.driver.impl.ToolsStatics;
import org.clang.driver.options;
import org.clang.driver.tools.impl.GnuTool;
import org.clang.driver.tools.impl.MipsStatics;
import org.clank.java.std;
import org.clank.java.std_ptr;
import org.clank.support.Destructors;
import org.clank.support.JavaCleaner;
import org.clank.support.Native;
import org.clank.support.NativePointer;
import org.clank.support.aliases.char;
import org.llvm.adt.StringRef;
import org.llvm.adt.Triple;
import org.llvm.adt.Twine;
import org.llvm.adt.aliases.ArrayRef;
import org.llvm.adt.aliases.SmallVector;
import org.llvm.option.ArgList;
import org.llvm.option.ArgStringList;
import org.llvm.option.OptSpecifier;
import org.llvm.support.llvm;

public final class OpenbsdStatics {

    public static class Linker
    extends GnuTool
    implements Destructors.ClassWithDestructor {
        public Linker(ToolChain TC) {
            super(NativePointer.$((String)"openbsd::Linker"), NativePointer.$((String)"linker"), TC);
        }

        @Override
        public boolean hasIntegratedCPP() {
            return false;
        }

        @Override
        public boolean isLinkJob() {
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void ConstructJob(Compilation C, JobAction JA, InputInfo Output, SmallVector<InputInfo> Inputs, ArgList Args, char.ptr LinkingOutput) {
            JavaCleaner $c$ = Native.$createJavaCleaner();
            try {
                std.string Triple2;
                Driver D = this.getToolChain().getDriver();
                ArgStringList CmdArgs = new ArgStringList();
                Args.ClaimAllArgs(new OptSpecifier(options.ID.OPT_g_Group.getValue()));
                Args.ClaimAllArgs(new OptSpecifier(options.ID.OPT_emit_llvm.getValue()));
                Args.ClaimAllArgs(new OptSpecifier(options.ID.OPT_w.getValue()));
                if (this.getToolChain().getArch() == Triple.ArchType.mips64) {
                    CmdArgs.push_back((Object)NativePointer.$((String)"-EB"));
                } else if (this.getToolChain().getArch() == Triple.ArchType.mips64el) {
                    CmdArgs.push_back((Object)NativePointer.$((String)"-EL"));
                }
                if (!Args.hasArg(new OptSpecifier(options.ID.OPT_nostdlib.getValue()), new OptSpecifier(options.ID.OPT_shared.getValue()))) {
                    CmdArgs.push_back((Object)NativePointer.$((String)"-e"));
                    CmdArgs.push_back((Object)NativePointer.$((String)"__start"));
                }
                if (Args.hasArg(new OptSpecifier(options.ID.OPT_static.getValue()))) {
                    CmdArgs.push_back((Object)NativePointer.$((String)"-Bstatic"));
                } else {
                    if (Args.hasArg(new OptSpecifier(options.ID.OPT_rdynamic.getValue()))) {
                        CmdArgs.push_back((Object)NativePointer.$((String)"-export-dynamic"));
                    }
                    CmdArgs.push_back((Object)NativePointer.$((String)"--eh-frame-hdr"));
                    CmdArgs.push_back((Object)NativePointer.$((String)"-Bdynamic"));
                    if (Args.hasArg(new OptSpecifier(options.ID.OPT_shared.getValue()))) {
                        CmdArgs.push_back((Object)NativePointer.$((String)"-shared"));
                    } else {
                        CmdArgs.push_back((Object)NativePointer.$((String)"-dynamic-linker"));
                        CmdArgs.push_back((Object)NativePointer.$((String)"/usr/libexec/ld.so"));
                    }
                }
                if (Args.hasArg(new OptSpecifier(options.ID.OPT_nopie.getValue()))) {
                    CmdArgs.push_back((Object)NativePointer.$((String)"-nopie"));
                }
                if (Output.isFilename()) {
                    CmdArgs.push_back((Object)NativePointer.$((String)"-o"));
                    CmdArgs.push_back((Object)Output.getFilename());
                } else assert (Output.isNothing()) : "Invalid output.";
                if (!Args.hasArg(new OptSpecifier(options.ID.OPT_nostdlib.getValue()), new OptSpecifier(options.ID.OPT_nostartfiles.getValue()))) {
                    if (!Args.hasArg(new OptSpecifier(options.ID.OPT_shared.getValue()))) {
                        if (Args.hasArg(new OptSpecifier(options.ID.OPT_pg.getValue()))) {
                            CmdArgs.push_back((Object)Args.MakeArgString(new Twine(this.getToolChain().GetFilePath(NativePointer.$((String)"gcrt0.o")))));
                        } else {
                            CmdArgs.push_back((Object)Args.MakeArgString(new Twine(this.getToolChain().GetFilePath(NativePointer.$((String)"crt0.o")))));
                        }
                        CmdArgs.push_back((Object)Args.MakeArgString(new Twine(this.getToolChain().GetFilePath(NativePointer.$((String)"crtbegin.o")))));
                    } else {
                        CmdArgs.push_back((Object)Args.MakeArgString(new Twine(this.getToolChain().GetFilePath(NativePointer.$((String)"crtbeginS.o")))));
                    }
                }
                if (std.$eq_str$C_T((std.string)(Triple2 = this.getToolChain().getTripleString()).substr(0, 6), (String)"x86_64")) {
                    Triple2.replace(0, 6, NativePointer.$((String)"amd64"));
                }
                CmdArgs.push_back((Object)Args.MakeArgString(new Twine(std.$add_str_T((std.string)std.$add_T_str$C((String)"-L/usr/lib/gcc-lib/", (std.string)Triple2), (String)"/4.2.1"))));
                Args.AddAllArgs(CmdArgs, new ArrayRef((Object[])new OptSpecifier[]{new OptSpecifier(options.ID.OPT_L.getValue()), new OptSpecifier(options.ID.OPT_T_Group.getValue()), new OptSpecifier(options.ID.OPT_e.getValue()), new OptSpecifier(options.ID.OPT_s.getValue()), new OptSpecifier(options.ID.OPT_t.getValue()), new OptSpecifier(options.ID.OPT_Z_Flag.getValue()), new OptSpecifier(options.ID.OPT_r.getValue())}));
                ToolsStatics.AddLinkerInputs(this.getToolChain(), Inputs, Args, CmdArgs);
                if (!Args.hasArg(new OptSpecifier(options.ID.OPT_nostdlib.getValue()), new OptSpecifier(options.ID.OPT_nodefaultlibs.getValue()))) {
                    if (D.CCCIsCXX()) {
                        this.getToolChain().AddCXXStdlibLibArgs(Args, CmdArgs);
                        if (Args.hasArg(new OptSpecifier(options.ID.OPT_pg.getValue()))) {
                            CmdArgs.push_back((Object)NativePointer.$((String)"-lm_p"));
                        } else {
                            CmdArgs.push_back((Object)NativePointer.$((String)"-lm"));
                        }
                    }
                    CmdArgs.push_back((Object)NativePointer.$((String)"-lgcc"));
                    if (Args.hasArg(new OptSpecifier(options.ID.OPT_pthread.getValue()))) {
                        if (!Args.hasArg(new OptSpecifier(options.ID.OPT_shared.getValue())) && Args.hasArg(new OptSpecifier(options.ID.OPT_pg.getValue()))) {
                            CmdArgs.push_back((Object)NativePointer.$((String)"-lpthread_p"));
                        } else {
                            CmdArgs.push_back((Object)NativePointer.$((String)"-lpthread"));
                        }
                    }
                    if (!Args.hasArg(new OptSpecifier(options.ID.OPT_shared.getValue()))) {
                        if (Args.hasArg(new OptSpecifier(options.ID.OPT_pg.getValue()))) {
                            CmdArgs.push_back((Object)NativePointer.$((String)"-lc_p"));
                        } else {
                            CmdArgs.push_back((Object)NativePointer.$((String)"-lc"));
                        }
                    }
                    CmdArgs.push_back((Object)NativePointer.$((String)"-lgcc"));
                }
                if (!Args.hasArg(new OptSpecifier(options.ID.OPT_nostdlib.getValue()), new OptSpecifier(options.ID.OPT_nostartfiles.getValue()))) {
                    if (!Args.hasArg(new OptSpecifier(options.ID.OPT_shared.getValue()))) {
                        CmdArgs.push_back((Object)Args.MakeArgString(new Twine(this.getToolChain().GetFilePath(NativePointer.$((String)"crtend.o")))));
                    } else {
                        CmdArgs.push_back((Object)Args.MakeArgString(new Twine(this.getToolChain().GetFilePath(NativePointer.$((String)"crtendS.o")))));
                    }
                }
                char.ptr Exec = Native.$tryClone((char.ptr)Args.MakeArgString(new Twine(this.getToolChain().GetLinkerPath())));
                C.addCommand((std_ptr.unique_ptr<Command>)$c$.track(llvm.make_unique((Object)new Command((Action)JA, (Tool)this, Exec, CmdArgs, Inputs))));
                $c$.clean();
            }
            finally {
                $c$.$destroy();
            }
        }

        @Override
        public void $destroy() {
            super.$destroy();
        }

        @Override
        public String toString() {
            return "" + super.toString();
        }
    }

    public static class Assembler
    extends GnuTool
    implements Destructors.ClassWithDestructor {
        public Assembler(ToolChain TC) {
            super(NativePointer.$((String)"openbsd::Assembler"), NativePointer.$((String)"assembler"), TC);
        }

        @Override
        public boolean hasIntegratedCPP() {
            return false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void ConstructJob(Compilation C, JobAction JA, InputInfo Output, SmallVector<InputInfo> Inputs, ArgList Args, char.ptr LinkingOutput) {
            JavaCleaner $c$ = Native.$createJavaCleaner();
            try {
                ToolsStatics.claimNoWarnArgs(Args);
                ArgStringList CmdArgs = new ArgStringList();
                switch (this.getToolChain().getArch()) {
                    case x86: {
                        CmdArgs.push_back((Object)NativePointer.$((String)"--32"));
                        break;
                    }
                    case ppc: {
                        CmdArgs.push_back((Object)NativePointer.$((String)"-mppc"));
                        CmdArgs.push_back((Object)NativePointer.$((String)"-many"));
                        break;
                    }
                    case sparc: 
                    case sparcel: {
                        CmdArgs.push_back((Object)NativePointer.$((String)"-32"));
                        std.string CPU = ToolsStatics.getCPUName(Args, this.getToolChain().getTriple());
                        CmdArgs.push_back((Object)ToolsStatics.getSparcAsmModeForCPU(new StringRef(CPU), this.getToolChain().getTriple()));
                        ToolsStatics.AddAssemblerKPIC(this.getToolChain(), Args, CmdArgs);
                        break;
                    }
                    case sparcv9: {
                        CmdArgs.push_back((Object)NativePointer.$((String)"-64"));
                        std.string CPU = ToolsStatics.getCPUName(Args, this.getToolChain().getTriple());
                        CmdArgs.push_back((Object)ToolsStatics.getSparcAsmModeForCPU(new StringRef(CPU), this.getToolChain().getTriple()));
                        ToolsStatics.AddAssemblerKPIC(this.getToolChain(), Args, CmdArgs);
                        break;
                    }
                    case mips64: 
                    case mips64el: {
                        StringRef CPUName = new StringRef();
                        StringRef ABIName = new StringRef();
                        MipsStatics.getMipsCPUAndABI(Args, this.getToolChain().getTriple(), CPUName, ABIName);
                        CmdArgs.push_back((Object)NativePointer.$((String)"-mabi"));
                        CmdArgs.push_back((Object)ToolsStatics.getGnuCompatibleMipsABIName(ABIName).data());
                        if (this.getToolChain().getArch() == Triple.ArchType.mips64) {
                            CmdArgs.push_back((Object)NativePointer.$((String)"-EB"));
                        } else {
                            CmdArgs.push_back((Object)NativePointer.$((String)"-EL"));
                        }
                        ToolsStatics.AddAssemblerKPIC(this.getToolChain(), Args, CmdArgs);
                        break;
                    }
                }
                Args.AddAllArgValues(CmdArgs, new OptSpecifier(options.ID.OPT_Wa_COMMA.getValue()), new OptSpecifier(options.ID.OPT_Xassembler.getValue()));
                CmdArgs.push_back((Object)NativePointer.$((String)"-o"));
                CmdArgs.push_back((Object)Output.getFilename());
                for (InputInfo II : Inputs) {
                    CmdArgs.push_back((Object)II.getFilename());
                }
                char.ptr Exec = Native.$tryClone((char.ptr)Args.MakeArgString(new Twine(this.getToolChain().GetProgramPath(NativePointer.$((String)"as")))));
                C.addCommand((std_ptr.unique_ptr<Command>)$c$.track(llvm.make_unique((Object)new Command((Action)JA, (Tool)this, Exec, CmdArgs, Inputs))));
                $c$.clean();
            }
            finally {
                $c$.$destroy();
            }
        }

        @Override
        public void $destroy() {
            super.$destroy();
        }

        @Override
        public String toString() {
            return "" + super.toString();
        }
    }
}

