/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.mobility.end2end.ui.wizard;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import javax.swing.ListCellRenderer;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.api.project.Sources;
import org.netbeans.spi.java.project.support.ui.PackageView;
import org.openide.awt.Mnemonics;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.util.NbBundle;

public class ClientOptionsPanelGUI
extends JPanel
implements DocumentListener,
ActionListener {
    private static Project clientProject;
    private String expectedExtension;
    private final List<ChangeListener> listeners = new ArrayList<ChangeListener>();
    private static final ListCellRenderer CELL_RENDERER;
    private SourceGroup preselectedGroup;
    private JLabel clientNameLabel;
    private JTextField clientNameTextField;
    private JCheckBox createDataBindingCheckBox;
    private JLabel createdFileLabel;
    private JTextField createdFileTextField;
    private JCheckBox floatingPointCheckBox;
    private JCheckBox generateStubsCheckBox;
    private JPanel jPanel1;
    private JSeparator jSeparator1;
    private JSeparator jSeparator2;
    private JComboBox packageComboBox;
    private JLabel packageLabel;
    private JLabel projectLabel;
    private JTextField projectTextField;

    public ClientOptionsPanelGUI() {
        this.initComponents();
        this.packageComboBox.setRenderer(CELL_RENDERER);
        this.initAccessibility();
    }

    private void initAccessibility() {
        this.getAccessibleContext().setAccessibleName(NbBundle.getMessage(ClientOptionsPanelGUI.class, (String)"ACSN_Client_Options_Panel"));
        this.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ClientOptionsPanelGUI.class, (String)"ACSD_Client_Options_Panel"));
        this.clientNameTextField.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ClientOptionsPanelGUI.class, (String)"ACSD_Client_Name"));
        this.projectTextField.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ClientOptionsPanelGUI.class, (String)"ACSD_Client_Project"));
        this.packageComboBox.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ClientOptionsPanelGUI.class, (String)"ACSD_Client_Package"));
        this.createdFileTextField.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ClientOptionsPanelGUI.class, (String)"ACSD_Client_Created_File"));
        this.generateStubsCheckBox.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ClientOptionsPanelGUI.class, (String)"ACSD_Generate_Stubs"));
        this.floatingPointCheckBox.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ClientOptionsPanelGUI.class, (String)"ACSD_Floating_point"));
        this.createDataBindingCheckBox.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ClientOptionsPanelGUI.class, (String)"ACSD_Sample_MIDlet"));
    }

    public void setValues(Project project, String clientName, FileObject preselectedFolder) {
        clientProject = project;
        this.clientNameTextField.setText(clientName);
        String ext = "java";
        this.expectedExtension = "java".length() == 0 ? "" : ".java";
        Sources sources = ProjectUtils.getSources((Project)project);
        SourceGroup[] groups = sources.getSourceGroups("java");
        if (this.preselectedGroup == null) {
            this.preselectedGroup = this.getPreselectedGroup(groups, preselectedFolder);
            if (this.preselectedGroup != null) {
                ModelItem groupItem = new ModelItem(this.preselectedGroup);
                ModelItem[] nodes = groupItem.getChildren();
                this.packageComboBox.setModel(new DefaultComboBoxModel<ModelItem>(nodes));
                ModelItem folderItem = this.getPreselectedPackage(groupItem, preselectedFolder);
                if (folderItem != null) {
                    this.packageComboBox.setSelectedItem(folderItem);
                }
            } else {
                this.packageComboBox.setModel(new DefaultComboBoxModel());
            }
        }
        this.projectTextField.setText(ProjectUtils.getInformation((Project)project).getDisplayName());
        Component packageEditor = this.packageComboBox.getEditor().getEditorComponent();
        ((JTextField)packageEditor).getDocument().addDocumentListener(this);
        this.clientNameTextField.getDocument().addDocumentListener(this);
        this.updateText();
    }

    @Override
    public void insertUpdate(DocumentEvent e) {
        this.changedUpdate(e);
    }

    @Override
    public void removeUpdate(DocumentEvent e) {
        this.changedUpdate(e);
    }

    @Override
    public void changedUpdate(DocumentEvent e) {
        this.updateText();
        this.fireChange();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (this.packageComboBox == e.getSource()) {
            this.updateText();
        }
    }

    public String getProjectName() {
        return this.projectTextField.getText();
    }

    public String getTargetName() {
        return this.clientNameTextField.getText().trim();
    }

    public boolean isGenerateStubs() {
        return this.generateStubsCheckBox.isSelected();
    }

    public boolean isFloatingPointUsed() {
        return this.floatingPointCheckBox.isSelected();
    }

    public boolean isDataBinded() {
        return this.createDataBindingCheckBox.isSelected();
    }

    public String getCreatedFile() {
        return this.createdFileTextField.getText();
    }

    final FileObject getRootFolder() {
        return this.preselectedGroup.getRootFolder();
    }

    final SourceGroup getSourceGroup() {
        return this.preselectedGroup;
    }

    private void updateText() {
        File projdirFile = FileUtil.toFile((FileObject)clientProject.getProjectDirectory());
        if (projdirFile != null) {
            String documentName = this.clientNameTextField.getText().trim();
            if (documentName.length() == 0) {
                this.createdFileTextField.setText("");
            } else {
                File folder = this.getFolder();
                if (folder != null) {
                    File newFile = new File(folder, documentName + this.expectedExtension);
                    this.createdFileTextField.setText(newFile.getAbsolutePath());
                } else {
                    this.createdFileTextField.setText("");
                }
            }
        } else {
            this.createdFileTextField.setText("");
        }
    }

    public void addChangeListener(ChangeListener l) {
        this.listeners.add(l);
    }

    public void removeChangeListener(ChangeListener l) {
        this.listeners.remove(l);
    }

    private void fireChange() {
        ChangeEvent e = new ChangeEvent(this);
        for (ChangeListener cl : this.listeners) {
            cl.stateChanged(e);
        }
    }

    private void initComponents() {
        this.clientNameLabel = new JLabel();
        this.clientNameTextField = new JTextField();
        this.projectLabel = new JLabel();
        this.projectTextField = new JTextField();
        this.packageLabel = new JLabel();
        this.packageComboBox = new JComboBox();
        this.createdFileLabel = new JLabel();
        this.createdFileTextField = new JTextField();
        this.jSeparator1 = new JSeparator();
        this.generateStubsCheckBox = new JCheckBox();
        this.floatingPointCheckBox = new JCheckBox();
        this.jSeparator2 = new JSeparator();
        this.createDataBindingCheckBox = new JCheckBox();
        this.jPanel1 = new JPanel();
        this.setPreferredSize(new Dimension(560, 350));
        this.setLayout(new GridBagLayout());
        this.clientNameLabel.setLabelFor(this.clientNameTextField);
        Mnemonics.setLocalizedText((JLabel)this.clientNameLabel, (String)NbBundle.getMessage(ClientOptionsPanelGUI.class, (String)"LBL_ClientName"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 0, 0, 0);
        this.add((Component)this.clientNameLabel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.ipadx = 65;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 0, 0);
        this.add((Component)this.clientNameTextField, gridBagConstraints);
        this.projectLabel.setLabelFor(this.projectTextField);
        Mnemonics.setLocalizedText((JLabel)this.projectLabel, (String)NbBundle.getMessage(ClientOptionsPanelGUI.class, (String)"LBL_Client_Project"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 0, 0, 0);
        this.add((Component)this.projectLabel, gridBagConstraints);
        this.projectTextField.setEditable(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.ipadx = 65;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 0, 0);
        this.add((Component)this.projectTextField, gridBagConstraints);
        this.packageLabel.setLabelFor(this.packageComboBox);
        Mnemonics.setLocalizedText((JLabel)this.packageLabel, (String)NbBundle.getMessage(ClientOptionsPanelGUI.class, (String)"LBL_Client_Package"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 0, 0, 0);
        this.add((Component)this.packageLabel, gridBagConstraints);
        this.packageComboBox.setEditable(true);
        this.packageComboBox.setModel(new DefaultComboBoxModel<String>(new String[]{"Item 1", "Item 2", "Item 3", "Item 4"}));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 0, 0);
        this.add((Component)this.packageComboBox, gridBagConstraints);
        this.createdFileLabel.setLabelFor(this.createdFileTextField);
        Mnemonics.setLocalizedText((JLabel)this.createdFileLabel, (String)NbBundle.getMessage(ClientOptionsPanelGUI.class, (String)"LBL_Client_Created_File"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 0, 0, 0);
        this.add((Component)this.createdFileLabel, gridBagConstraints);
        this.createdFileTextField.setEditable(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.ipadx = 65;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 0, 0);
        this.add((Component)this.createdFileTextField, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.ipady = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 0, 0, 0);
        this.add((Component)this.jSeparator1, gridBagConstraints);
        this.generateStubsCheckBox.setSelected(true);
        Mnemonics.setLocalizedText((AbstractButton)this.generateStubsCheckBox, (String)NbBundle.getBundle(ClientOptionsPanelGUI.class).getString("LBL_Generate_Stubs"));
        this.generateStubsCheckBox.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.generateStubsCheckBox.setMargin(new Insets(0, 0, 0, 0));
        this.generateStubsCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ClientOptionsPanelGUI.this.generateStubsCheckBoxActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 0, 0);
        this.add((Component)this.generateStubsCheckBox, gridBagConstraints);
        this.floatingPointCheckBox.setSelected(true);
        Mnemonics.setLocalizedText((AbstractButton)this.floatingPointCheckBox, (String)NbBundle.getMessage(ClientOptionsPanelGUI.class, (String)"LBL_Floating_Point"));
        this.floatingPointCheckBox.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.floatingPointCheckBox.setMargin(new Insets(0, 0, 0, 0));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 0, 0);
        this.add((Component)this.floatingPointCheckBox, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 8;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.ipady = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 0, 0, 0);
        this.add((Component)this.jSeparator2, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)this.createDataBindingCheckBox, (String)NbBundle.getMessage(ClientOptionsPanelGUI.class, (String)"LBL_Create_Sample_MIDlet"));
        this.createDataBindingCheckBox.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.createDataBindingCheckBox.setMargin(new Insets(0, 0, 0, 0));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(5, 5, 0, 0);
        this.add((Component)this.createDataBindingCheckBox, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 9;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this.jPanel1, gridBagConstraints);
    }

    private void generateStubsCheckBoxActionPerformed(ActionEvent evt) {
        this.fireChange();
    }

    private SourceGroup getPreselectedGroup(SourceGroup[] groups, FileObject preselectedFolder) {
        if (preselectedFolder != null) {
            for (int i = 0; i < groups.length; ++i) {
                if (!groups[i].getRootFolder().equals(preselectedFolder) && !FileUtil.isParentOf((FileObject)groups[i].getRootFolder(), (FileObject)preselectedFolder)) continue;
                return groups[i];
            }
        }
        return groups.length > 0 ? groups[0] : null;
    }

    private ModelItem getPreselectedPackage(ModelItem groupItem, FileObject preselectedFolder) {
        if (preselectedFolder == null) {
            return null;
        }
        ModelItem[] ch = groupItem.getChildren();
        FileObject root = groupItem.group.getRootFolder();
        String relPath = FileUtil.getRelativePath((FileObject)root, (FileObject)preselectedFolder);
        relPath = relPath == null ? "" : relPath.replace('/', '.');
        for (int i = 0; i < ch.length; ++i) {
            if (!ch[i].toString().equals(relPath)) continue;
            return ch[i];
        }
        return null;
    }

    public File getFolder() {
        FileObject root = this.getRootFolder();
        File rootFile = FileUtil.toFile((FileObject)root);
        if (rootFile == null) {
            return null;
        }
        return new File(rootFile, this.getPackageFileName());
    }

    public String getPackageFileName() {
        String packageName = this.packageComboBox.getEditor().getItem().toString();
        if (ModelItem.DEFAULT_PACKAGE_DISPLAY_NAME.equals(packageName)) {
            packageName = "";
        }
        return packageName.replace('.', '/');
    }

    static {
        CELL_RENDERER = new NodeCellRenderer();
    }

    private static class NodeCellRenderer
    extends JLabel
    implements ListCellRenderer {
        public NodeCellRenderer() {
            this.setOpaque(true);
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            if (value instanceof ModelItem) {
                ModelItem item = (ModelItem)value;
                this.setText(item.getDisplayName());
                this.setIcon(item.getIcon());
            } else {
                this.setText(value.toString());
                this.setIcon(null);
            }
            if (isSelected) {
                this.setBackground(list.getSelectionBackground());
                this.setForeground(list.getSelectionForeground());
            } else {
                this.setBackground(list.getBackground());
                this.setForeground(list.getForeground());
            }
            return this;
        }
    }

    private static class ModelItem {
        public static final String DEFAULT_PACKAGE_DISPLAY_NAME = NbBundle.getMessage(ClientOptionsPanelGUI.class, (String)"LBL_MIDPTargetChooserPanelGUI_DefaultPackage");
        private Node node;
        protected SourceGroup group;
        private final Icon icon;
        private ModelItem[] children;

        public ModelItem(SourceGroup group) {
            this.group = group;
            this.icon = group.getIcon(false);
        }

        public ModelItem(Node node) {
            this.node = node;
            this.icon = new ImageIcon(node.getIcon(1));
        }

        public String getDisplayName() {
            if (this.group != null) {
                return this.group.getDisplayName();
            }
            String nodeName = this.node.getName();
            return nodeName.length() == 0 ? DEFAULT_PACKAGE_DISPLAY_NAME : nodeName;
        }

        public Icon getIcon() {
            return this.icon;
        }

        public String toString() {
            if (this.group != null) {
                return this.getDisplayName();
            }
            return this.node.getName();
        }

        public ModelItem[] getChildren() {
            if (this.group == null) {
                return null;
            }
            if (this.children == null) {
                Node n = PackageView.createPackageView((SourceGroup)this.group);
                if (n == null) {
                    return null;
                }
                Children ch = n.getChildren();
                if (ch == null) {
                    return null;
                }
                Node[] nodes = ch.getNodes(true);
                this.children = new ModelItem[nodes.length];
                for (int i = 0; i < nodes.length; ++i) {
                    this.children[i] = new ModelItem(nodes[i]);
                }
            }
            return this.children;
        }
    }
}

