/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.discovery.api;

import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.netbeans.api.project.Project;
import org.netbeans.modules.cnd.api.project.IncludePath;
import org.netbeans.modules.cnd.api.project.NativeFileItem;
import org.netbeans.modules.cnd.discovery.api.DiscoveryUtils;
import org.netbeans.modules.cnd.discovery.api.FolderImpl;
import org.netbeans.modules.cnd.discovery.api.FolderProperties;
import org.netbeans.modules.cnd.discovery.api.ItemProperties;
import org.netbeans.modules.cnd.discovery.api.ProjectProperties;
import org.netbeans.modules.cnd.discovery.api.ProjectProxy;
import org.netbeans.modules.cnd.discovery.api.SourceFileProperties;
import org.netbeans.modules.cnd.discovery.wizard.api.support.ProjectBridge;
import org.netbeans.modules.cnd.makeproject.api.configurations.BooleanConfiguration;
import org.netbeans.modules.cnd.makeproject.api.configurations.Configuration;
import org.netbeans.modules.cnd.makeproject.api.configurations.ConfigurationDescriptorProvider;
import org.netbeans.modules.cnd.makeproject.api.configurations.Item;
import org.netbeans.modules.cnd.makeproject.api.configurations.ItemConfiguration;
import org.netbeans.modules.cnd.makeproject.api.configurations.MakeConfiguration;
import org.netbeans.modules.cnd.makeproject.api.configurations.MakeConfigurationDescriptor;
import org.netbeans.modules.cnd.utils.FSPath;
import org.netbeans.modules.cnd.utils.cache.CndFileUtils;
import org.openide.util.Utilities;

public final class ProjectImpl
implements ProjectProperties {
    private static final boolean gatherFolders = true;
    private final ItemProperties.LanguageKind language;
    private final Set<String> userIncludes = new LinkedHashSet<String>();
    private final Set<String> userFiles = new HashSet<String>();
    private final Set<String> systemIncludes = new LinkedHashSet<String>();
    private final Map<String, String> userMacros = new HashMap<String, String>();
    private final Set<String> undefinedMacros = new LinkedHashSet<String>();
    private final Map<String, FolderProperties> folders = new HashMap<String, FolderProperties>();

    public ProjectImpl(ItemProperties.LanguageKind language) {
        this.language = language;
    }

    public void update(SourceFileProperties source) {
        this.userIncludes.addAll(source.getUserInludePaths());
        for (String path : source.getUserInludePaths()) {
            this.userIncludes.add(DiscoveryUtils.convertRelativePathToAbsolute(source, path));
        }
        this.userFiles.addAll(source.getUserInludeFiles());
        this.userMacros.putAll(source.getUserMacros());
        this.undefinedMacros.addAll(source.getUndefinedMacros());
        this.updateFolder(source);
    }

    /*
     * WARNING - void declaration
     */
    public static List<ProjectProperties> divideByLanguage(List<SourceFileProperties> sources, ProjectProxy project) {
        ProjectImpl cProp = null;
        ProjectImpl cppProp = null;
        ProjectImpl fortranProp = null;
        if (sources.size() > 0 && project != null && project.mergeProjectProperties()) {
            sources = ProjectImpl.mergeLists(sources, project);
        }
        for (SourceFileProperties source : sources) {
            void var8_8;
            ProjectImpl current;
            ItemProperties.LanguageKind lang = source.getLanguageKind();
            if (lang == ItemProperties.LanguageKind.C) {
                if (cProp == null) {
                    cProp = new ProjectImpl(lang);
                }
                current = cProp;
            } else if (lang == ItemProperties.LanguageKind.CPP) {
                if (cppProp == null) {
                    cppProp = new ProjectImpl(lang);
                }
                current = cppProp;
            } else {
                if (lang != ItemProperties.LanguageKind.Fortran) continue;
                if (fortranProp == null) {
                    fortranProp = new ProjectImpl(lang);
                }
                current = fortranProp;
            }
            var8_8.update(source);
        }
        ArrayList<ProjectProperties> languages = new ArrayList<ProjectProperties>();
        if (cProp != null) {
            languages.add(cProp);
        }
        if (cppProp != null) {
            languages.add(cppProp);
        }
        if (fortranProp != null) {
            languages.add(fortranProp);
        }
        return languages;
    }

    private static List<SourceFileProperties> mergeLists(List<SourceFileProperties> discovered, ProjectProxy project) {
        ProjectBridge bridge = new ProjectBridge(project.getProject());
        HashMap<String, SourceFileProperties> map = new HashMap<String, SourceFileProperties>();
        ArrayList<SourceFileProperties> res = new ArrayList<SourceFileProperties>(discovered);
        for (SourceFileProperties source : discovered) {
            map.put(source.getItemPath(), source);
        }
        int equalsSources = 0;
        for (SourceFileProperties source : ProjectImpl.getExistingProjectItems(project)) {
            if (!map.containsKey(source.getItemPath())) {
                res.add(source);
                continue;
            }
            if (!ProjectImpl.isSourcesEquals((SourceFileProperties)map.get(source.getItemPath()), source, bridge)) continue;
            ++equalsSources;
        }
        if (equalsSources == discovered.size()) {
            return Collections.emptyList();
        }
        return res;
    }

    private static boolean isSourcesEquals(SourceFileProperties newSource, SourceFileProperties oldSource, ProjectBridge bridge) {
        HashSet<String> set1 = new HashSet<String>();
        bridge.convertIncludePaths(set1, newSource.getUserInludePaths(), newSource.getCompilePath(), newSource.getItemPath());
        HashSet<String> set2 = new HashSet<String>();
        for (String s : oldSource.getUserInludePaths()) {
            set2.add(bridge.getRelativepath(s));
        }
        if (!set1.equals(set2)) {
            return false;
        }
        set1 = new HashSet();
        bridge.convertIncludeFiles(set1, newSource.getUserInludeFiles(), newSource.getCompilePath(), newSource.getUserInludePaths());
        set2 = new HashSet();
        for (String s : oldSource.getUserInludeFiles()) {
            set2.add(bridge.getRelativepath(s));
        }
        if (!set1.equals(set2)) {
            return false;
        }
        Map<String, String> m1 = newSource.getUserMacros();
        Map<String, String> m2 = oldSource.getUserMacros();
        if (m1.size() != m2.size()) {
            return false;
        }
        if (!new HashMap<String, String>(m1).equals(m2)) {
            return false;
        }
        HashSet<String> u1 = new HashSet<String>(newSource.getUndefinedMacros());
        HashSet<String> u2 = new HashSet<String>(oldSource.getUndefinedMacros());
        if (u1.size() != u2.size()) {
            return false;
        }
        return u1.equals(u2);
    }

    private static List<SourceFileProperties> getExistingProjectItems(ProjectProxy project) {
        ArrayList<SourceFileProperties> res = new ArrayList<SourceFileProperties>();
        Project makeProject = project.getProject();
        ConfigurationDescriptorProvider pdp = (ConfigurationDescriptorProvider)makeProject.getLookup().lookup(ConfigurationDescriptorProvider.class);
        MakeConfigurationDescriptor makeConfigurationDescriptor = pdp.getConfigurationDescriptor();
        if (makeConfigurationDescriptor != null) {
            Item[] items = makeConfigurationDescriptor.getProjectItems();
            for (int i = 0; i < items.length; ++i) {
                NativeFileItem.Language lang;
                Item item = items[i];
                if (ProjectImpl.isExcluded(item) || (lang = item.getLanguage()) != NativeFileItem.Language.C && lang != NativeFileItem.Language.CPP) continue;
                res.add(new ItemWrapper(item));
            }
        }
        return res;
    }

    private static boolean isExcluded(Item item) {
        MakeConfiguration makeConfiguration = item.getFolder().getConfigurationDescriptor().getActiveConfiguration();
        ItemConfiguration itemConfiguration = item.getItemConfiguration((Configuration)makeConfiguration);
        if (itemConfiguration == null) {
            return true;
        }
        BooleanConfiguration excl = itemConfiguration.getExcluded();
        return excl.getValue();
    }

    private void updateFolder(SourceFileProperties source) {
        File file = new File(source.getItemPath());
        File parent = file.getParentFile();
        if (parent != null) {
            FolderProperties folder;
            String path = CndFileUtils.normalizeFile((File)parent).getAbsolutePath();
            if (Utilities.isWindows()) {
                path = path.replace('\\', '/');
            }
            if ((folder = this.folders.get(path)) == null) {
                this.folders.put(path, new FolderImpl(path, source));
            } else {
                ((FolderImpl)folder).update(source);
            }
        }
    }

    @Override
    public List<FolderProperties> getConfiguredFolders() {
        return new ArrayList<FolderProperties>(this.folders.values());
    }

    @Override
    public String getMakePath() {
        return null;
    }

    @Override
    public String getBinaryPath() {
        return null;
    }

    @Override
    public ProjectProperties.BinaryKind getBinaryKind() {
        return null;
    }

    @Override
    public List<String> getUserInludePaths() {
        return new ArrayList<String>(this.userIncludes);
    }

    @Override
    public List<String> getUserInludeFiles() {
        return new ArrayList<String>(this.userFiles);
    }

    @Override
    public List<String> getSystemInludePaths() {
        return new ArrayList<String>(this.systemIncludes);
    }

    @Override
    public Map<String, String> getUserMacros() {
        return this.userMacros;
    }

    @Override
    public List<String> getUndefinedMacros() {
        return new ArrayList<String>(this.undefinedMacros);
    }

    @Override
    public Map<String, String> getSystemMacros() {
        return null;
    }

    @Override
    public ItemProperties.LanguageKind getLanguageKind() {
        return this.language;
    }

    @Override
    public String getCompilerName() {
        return "";
    }

    @Override
    public ItemProperties.LanguageStandard getLanguageStandard() {
        return ItemProperties.LanguageStandard.Unknown;
    }

    private static final class ItemWrapper
    implements SourceFileProperties {
        private final Item item;
        private final List<String> userIncludePaths;
        private final List<String> userIncludeFiles;
        private final Map<String, String> userMacroDefinitions;
        private final List<String> userUndefinesMacros;
        private final String importantFlags;

        private ItemWrapper(Item item) {
            this.item = item;
            this.userIncludePaths = IncludePath.toStringList((List)item.getUserIncludePaths());
            this.userIncludeFiles = this.convertFSPaths(item.getIncludeFiles());
            this.userMacroDefinitions = this.convertToMap(item.getUserMacroDefinitions());
            this.userUndefinesMacros = new ArrayList<String>(item.getUndefinedMacros());
            this.importantFlags = item.getImportantFlags();
        }

        private List<String> convertFSPaths(List<FSPath> list) {
            ArrayList<String> res = new ArrayList<String>(list.size());
            for (FSPath p : list) {
                res.add(p.getPath());
            }
            return res;
        }

        private Map<String, String> convertToMap(List<String> list) {
            HashMap<String, String> res = new HashMap<String, String>();
            for (String macro : list) {
                int i = macro.indexOf(61);
                if (i > 0) {
                    res.put(macro.substring(0, i).trim(), macro.substring(i + 1).trim());
                    continue;
                }
                res.put(macro, null);
            }
            return res;
        }

        @Override
        public String getCompilePath() {
            return this.item.getFileObject().getParent().getPath();
        }

        @Override
        public String getItemPath() {
            return this.item.getFileObject().getPath();
        }

        @Override
        public String getCompileLine() {
            return null;
        }

        @Override
        public String getImportantFlags() {
            return this.importantFlags;
        }

        @Override
        public String getItemName() {
            return this.item.getFileObject().getNameExt();
        }

        @Override
        public List<String> getUserInludePaths() {
            return this.userIncludePaths;
        }

        @Override
        public List<String> getUserInludeFiles() {
            return this.userIncludeFiles;
        }

        @Override
        public List<String> getSystemInludePaths() {
            return IncludePath.toStringList((List)this.item.getSystemIncludePaths());
        }

        @Override
        public Map<String, String> getUserMacros() {
            return this.userMacroDefinitions;
        }

        @Override
        public List<String> getUndefinedMacros() {
            return this.userUndefinesMacros;
        }

        @Override
        public Map<String, String> getSystemMacros() {
            return this.convertToMap(this.item.getSystemMacroDefinitions());
        }

        @Override
        public ItemProperties.LanguageKind getLanguageKind() {
            switch (this.item.getLanguage()) {
                case C: {
                    return ItemProperties.LanguageKind.C;
                }
                case CPP: {
                    return ItemProperties.LanguageKind.CPP;
                }
                case FORTRAN: {
                    return ItemProperties.LanguageKind.Fortran;
                }
            }
            return ItemProperties.LanguageKind.Unknown;
        }

        @Override
        public ItemProperties.LanguageStandard getLanguageStandard() {
            switch (this.item.getLanguageFlavor()) {
                case C: {
                    return ItemProperties.LanguageStandard.C;
                }
                case C89: {
                    return ItemProperties.LanguageStandard.C89;
                }
                case C99: {
                    return ItemProperties.LanguageStandard.C99;
                }
                case C11: {
                    return ItemProperties.LanguageStandard.C11;
                }
                case CPP: {
                    return ItemProperties.LanguageStandard.CPP;
                }
                case CPP11: {
                    return ItemProperties.LanguageStandard.CPP11;
                }
                case CPP14: {
                    return ItemProperties.LanguageStandard.CPP14;
                }
                case F77: {
                    return ItemProperties.LanguageStandard.F77;
                }
                case F90: {
                    return ItemProperties.LanguageStandard.F90;
                }
                case F95: {
                    return ItemProperties.LanguageStandard.F95;
                }
                case DEFAULT: {
                    return ItemProperties.LanguageStandard.Default;
                }
            }
            return ItemProperties.LanguageStandard.Unknown;
        }

        @Override
        public String getCompilerName() {
            switch (this.item.getLanguage()) {
                case C: {
                    return "cc";
                }
                case CPP: {
                    return "CC";
                }
                case FORTRAN: {
                    return "f95";
                }
            }
            return "";
        }
    }
}

