/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.jpda.expr;

import java.util.HashMap;
import java.util.Map;
import org.netbeans.api.debugger.jpda.InvalidExpressionException;
import org.netbeans.spi.debugger.jpda.Evaluator;

public class EvaluatorExpression {
    private String expression;
    private Map<Evaluator, AssociatedExpression<?>> associatedExpressions = new HashMap();

    public EvaluatorExpression(String expression) {
        this.expression = expression;
    }

    public String getExpression() {
        return this.expression;
    }

    public Evaluator.Result evaluate(Evaluator<?> e, Evaluator.Context context) throws InvalidExpressionException {
        AssociatedExpression<?> ae = this.associatedExpressions.get(e);
        if (ae == null) {
            ae = new AssociatedExpression(e, this.expression);
            this.associatedExpressions.put(e, ae);
        }
        return ae.evaluate(context);
    }

    private static class AssociatedExpression<PI> {
        private Evaluator<PI> e;
        private Evaluator.Expression<PI> expr;

        AssociatedExpression(Evaluator<PI> e, String expression) {
            this.e = e;
            this.expr = new Evaluator.Expression(expression);
        }

        Evaluator<PI> getEvaluator() {
            return this.e;
        }

        public Evaluator.Result evaluate(Evaluator.Context context) throws InvalidExpressionException {
            return this.e.evaluate(this.expr, context);
        }
    }
}

