/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.transport.tcp.server.tomcat.grizzly10;

import com.sun.enterprise.web.connector.grizzly.ByteBufferInputStream;
import com.sun.enterprise.web.portunif.ProtocolHandler;
import com.sun.enterprise.web.portunif.util.ProtocolInfo;
import com.sun.xml.ws.transport.tcp.server.tomcat.grizzly10.HttpRedirector;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.SelectionKey;

public class HttpRedirectorProtocolHandler
implements ProtocolHandler {
    private static final int DEFAULT_HTTP_HEADER_BUFFER_SIZE = 49152;
    protected String[] protocols = new String[]{"redirect-https", "redirect-http"};
    private HttpRedirector redirector;
    private int redirectPort;

    public HttpRedirectorProtocolHandler(int redirectPort) {
        this.redirectPort = redirectPort;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handle(ProtocolInfo protocolInfo) throws IOException {
        if (this.redirector == null) {
            this.redirector = new HttpRedirector(this.redirectPort);
        }
        if (protocolInfo.protocol.equalsIgnoreCase("https")) {
            this.redirector.redirectSSL(protocolInfo);
        } else {
            this.redirector.redirect(protocolInfo);
        }
        protocolInfo.keepAlive = false;
        ByteBuffer tmpBuffer = protocolInfo.byteBuffer;
        tmpBuffer.clear();
        ByteBufferInputStream is = new ByteBufferInputStream(tmpBuffer);
        try {
            int readBytes;
            is.setReadTimeout(2);
            is.setSelectionKey(protocolInfo.key);
            for (int count = 0; tmpBuffer.hasRemaining() && count < 49152; count += readBytes) {
                tmpBuffer.position(tmpBuffer.limit());
                readBytes = is.read();
                if (readBytes != -1) continue;
                break;
            }
        }
        catch (IOException e) {
        }
        finally {
            is.close();
        }
    }

    public String[] getProtocols() {
        return this.protocols;
    }

    public boolean expireKey(SelectionKey key) {
        return true;
    }
}

