/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.profiler.ui.cpu;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ItemEvent;
import java.text.MessageFormat;
import java.util.Collection;
import java.util.HashSet;
import java.util.ResourceBundle;
import java.util.Set;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JToolBar;
import javax.swing.RowFilter;
import javax.swing.SortOrder;
import javax.swing.ToolTipManager;
import javax.swing.table.AbstractTableModel;
import org.netbeans.lib.profiler.results.cpu.CPUResultsSnapshot;
import org.netbeans.lib.profiler.ui.UIUtils;
import org.netbeans.lib.profiler.ui.swing.FilteringToolbar;
import org.netbeans.lib.profiler.ui.swing.PopupButton;
import org.netbeans.lib.profiler.ui.swing.ProfilerPopupFactory;
import org.netbeans.lib.profiler.ui.swing.ProfilerTable;
import org.netbeans.lib.profiler.ui.swing.ProfilerTableContainer;
import org.netbeans.lib.profiler.ui.swing.renderer.CheckBoxRenderer;
import org.netbeans.lib.profiler.ui.swing.renderer.LabelRenderer;
import org.netbeans.modules.profiler.api.icons.Icons;

public abstract class ThreadsSelector
extends PopupButton {
    private static final ResourceBundle messages = ResourceBundle.getBundle("org.netbeans.lib.profiler.ui.cpu.Bundle");
    private static final String SELECT_THREADS = messages.getString("ThreadsSelector_SelectThreads");
    private static final String SELECTED_THREADS = messages.getString("ThreadsSelector_SelectedThreads");
    private static final String SELECTED_THREADS_ALL = messages.getString("ThreadsSelector_SelectedThreadsAll");
    private static final String NO_THREADS = messages.getString("ThreadsSelector_NoThreads");
    private static final String ALL_THREADS = messages.getString("ThreadsSelector_AllThreads");
    private static final String FILTER_THREADS = messages.getString("ThreadsSelector_FilterThreads");
    private static final String MERGE_THREADS = messages.getString("ThreadsSelector_MergeThreads");
    private static final String ALL_THREADS_TOOLTIP = messages.getString("ThreadsSelector_AllThreadsToolTip");
    private static final String MERGE_THREADS_TOOLTIP = messages.getString("ThreadsSelector_MergeThreadsToolTip");
    private static final String MERGE_THREADS_TOOLTIP_DISABLED = messages.getString("ThreadsSelector_MergeThreadsToolTipDisabled");
    private static final String COLUMN_SELECTED = messages.getString("ThreadsSelector_ColumnSelected");
    private static final String COLUMN_THREAD = messages.getString("ThreadsSelector_ColumnThread");
    private static final String COLUMN_SELECTED_TOOLTIP = messages.getString("ThreadsSelector_ColumnSelectedToolTip");
    private static final String COLUMN_THREAD_TOOLTIP = messages.getString("ThreadsSelector_ColumnThreadToolTip");
    private final Set<Integer> selection = new HashSet<Integer>();
    private boolean displayAllThreads = true;
    private boolean mergeSelectedThreads = false;
    private Runnable allThreadsResetter;

    public ThreadsSelector() {
        super(Icons.getIcon((String)"ProfilerIcons.AllThreads"));
        ToolTipManager.sharedInstance().registerComponent(this);
    }

    protected abstract CPUResultsSnapshot getSnapshot();

    protected abstract void selectionChanged(Collection<Integer> var1, boolean var2);

    void reset() {
        UIUtils.runInEventDispatchThread(new Runnable(){

            @Override
            public void run() {
                ThreadsSelector.this.displayAllThreads = true;
                ThreadsSelector.this.mergeSelectedThreads = false;
                ThreadsSelector.this.selection.clear();
            }
        });
    }

    @Override
    public String getToolTipText() {
        return this.displayAllThreads ? SELECTED_THREADS_ALL : MessageFormat.format(SELECTED_THREADS, this.selection.size());
    }

    @Override
    protected void displayPopup() {
        CPUResultsSnapshot snapshot = this.getSnapshot();
        int[] threadIDs = snapshot == null ? null : snapshot.getThreadIds();
        JPanel content = new JPanel(new BorderLayout());
        content.setBorder(BorderFactory.createEmptyBorder(8, 8, 8, 8));
        if (threadIDs == null || threadIDs.length == 0) {
            JLabel noThreads = new JLabel(NO_THREADS);
            noThreads.setOpaque(false);
            content.add((Component)noThreads, "Center");
        } else {
            JLabel hint = new JLabel(SELECT_THREADS, 10);
            hint.setBorder(BorderFactory.createEmptyBorder(0, 0, 4, 0));
            content.add((Component)hint, "North");
            final SelectedThreadsModel threadsModel = new SelectedThreadsModel();
            final ProfilerTable threadsTable = new ProfilerTable(threadsModel, true, false, null);
            threadsTable.setColumnToolTips(new String[]{COLUMN_SELECTED_TOOLTIP, COLUMN_THREAD_TOOLTIP});
            threadsTable.setMainColumn(1);
            threadsTable.setFitWidthColumn(1);
            threadsTable.setDefaultSortOrder(1, SortOrder.ASCENDING);
            threadsTable.setSortColumn(1);
            threadsTable.setColumnRenderer(0, new CheckBoxRenderer());
            LabelRenderer threadsRenderer = new LabelRenderer();
            threadsRenderer.setIcon(Icons.getIcon((String)"ProfilerIcons.Thread"));
            threadsRenderer.setFont(threadsRenderer.getFont().deriveFont(1));
            threadsTable.setColumnRenderer(1, threadsRenderer);
            int w = new JLabel((String)threadsTable.getColumnName((int)0)).getPreferredSize().width;
            threadsTable.setDefaultColumnWidth(0, w + 15);
            int h = threadsTable.getRowHeight() * 8;
            threadsRenderer.setValue("Inactive RequestProcessor thread [Was:Just template/AWT-EventQueue-0]", -1);
            Dimension prefSize = new Dimension(threadsRenderer.getPreferredSize().width, h += threadsTable.getTableHeader().getPreferredSize().height);
            threadsTable.setPreferredScrollableViewportSize(prefSize);
            ProfilerTableContainer tableContainer = new ProfilerTableContainer(threadsTable, true, null);
            content.add((Component)tableContainer, "Center");
            FilteringToolbar controls = new FilteringToolbar(FILTER_THREADS){

                @Override
                protected void filterChanged(final String filter) {
                    if (filter == null) {
                        threadsTable.setRowFilter(null);
                    } else {
                        threadsTable.setRowFilter(new RowFilter(){

                            public boolean include(RowFilter.Entry entry) {
                                return entry.getStringValue(1).contains(filter);
                            }
                        });
                    }
                }
            };
            controls.add(Box.createHorizontalStrut(2));
            ((JToolBar)controls).addSeparator();
            controls.add(Box.createHorizontalStrut(3));
            final JCheckBox mergeThreads = new JCheckBox(MERGE_THREADS, this.mergeSelectedThreads){

                @Override
                protected void fireItemStateChanged(ItemEvent e) {
                    ThreadsSelector.this.mergeSelectedThreads = this.isSelected() && !ThreadsSelector.this.displayAllThreads;
                    ThreadsSelector.this.fireSelectionChanged();
                }

                @Override
                public String getToolTipText() {
                    return this.isEnabled() ? super.getToolTipText() : MERGE_THREADS_TOOLTIP_DISABLED;
                }
            };
            mergeThreads.setToolTipText(MERGE_THREADS_TOOLTIP);
            final boolean[] resetterEvent = new boolean[1];
            final JCheckBox allThreads = new JCheckBox(ALL_THREADS, this.displayAllThreads){

                @Override
                protected void fireItemStateChanged(ItemEvent e) {
                    if (resetterEvent[0]) {
                        return;
                    }
                    ThreadsSelector.this.displayAllThreads = this.isSelected();
                    CPUResultsSnapshot snapshot = ThreadsSelector.this.getSnapshot();
                    if (snapshot != null && ThreadsSelector.this.displayAllThreads) {
                        for (int i = 0; i < snapshot.getNThreads(); ++i) {
                            ThreadsSelector.this.selection.add(snapshot.getThreadIds()[i]);
                        }
                    } else {
                        ThreadsSelector.this.selection.clear();
                    }
                    mergeThreads.setEnabled(!ThreadsSelector.this.displayAllThreads);
                    if (ThreadsSelector.this.displayAllThreads) {
                        mergeThreads.setSelected(false);
                        ThreadsSelector.this.mergeSelectedThreads = false;
                    }
                    threadsModel.fireTableDataChanged();
                    ThreadsSelector.this.fireSelectionChanged();
                }
            };
            allThreads.setToolTipText(ALL_THREADS_TOOLTIP);
            this.allThreadsResetter = new Runnable(){

                @Override
                public void run() {
                    resetterEvent[0] = true;
                    allThreads.setSelected(false);
                    mergeThreads.setEnabled(true);
                    resetterEvent[0] = false;
                }
            };
            controls.add(allThreads);
            controls.add(Box.createHorizontalStrut(7));
            controls.add(mergeThreads);
            controls.add(Box.createHorizontalStrut(20));
            content.add((Component)controls, "South");
        }
        ProfilerPopupFactory.Listener listener = new ProfilerPopupFactory.Listener(){

            @Override
            protected void popupHidden() {
                if (!ThreadsSelector.this.displayAllThreads && ThreadsSelector.this.selection.isEmpty()) {
                    ThreadsSelector.this.displayAllThreads = true;
                    ThreadsSelector.this.mergeSelectedThreads = false;
                    ThreadsSelector.this.fireSelectionChanged();
                }
                ThreadsSelector.this.allThreadsResetter = null;
            }
        };
        ProfilerPopupFactory.getPopup(this, content, -5, this.getHeight() - 1, listener).show();
    }

    private void fireSelectionChanged() {
        HashSet<Integer> selected = this.displayAllThreads ? null : new HashSet<Integer>(this.selection);
        this.selectionChanged(selected, this.mergeSelectedThreads);
    }

    private class SelectedThreadsModel
    extends AbstractTableModel {
        private SelectedThreadsModel() {
        }

        @Override
        public String getColumnName(int columnIndex) {
            if (columnIndex == 0) {
                return COLUMN_SELECTED;
            }
            if (columnIndex == 1) {
                return COLUMN_THREAD;
            }
            return null;
        }

        @Override
        public Class<?> getColumnClass(int columnIndex) {
            if (columnIndex == 0) {
                return Boolean.class;
            }
            if (columnIndex == 1) {
                return String.class;
            }
            return null;
        }

        @Override
        public int getRowCount() {
            CPUResultsSnapshot snapshot = ThreadsSelector.this.getSnapshot();
            return snapshot == null ? 0 : snapshot.getNThreads();
        }

        @Override
        public int getColumnCount() {
            return 2;
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            if (columnIndex == 0) {
                return ThreadsSelector.this.selection.contains(ThreadsSelector.this.getSnapshot().getThreadIds()[rowIndex]);
            }
            if (columnIndex == 1) {
                return ThreadsSelector.this.getSnapshot().getThreadNames()[rowIndex];
            }
            return null;
        }

        @Override
        public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
            if (columnIndex == 0) {
                int threadId = ThreadsSelector.this.getSnapshot().getThreadIds()[rowIndex];
                if (Boolean.TRUE.equals(aValue)) {
                    ThreadsSelector.this.selection.add(threadId);
                } else {
                    ThreadsSelector.this.selection.remove(threadId);
                }
                if (ThreadsSelector.this.allThreadsResetter != null) {
                    ThreadsSelector.this.allThreadsResetter.run();
                }
                ThreadsSelector.this.displayAllThreads = false;
                ThreadsSelector.this.fireSelectionChanged();
            }
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return columnIndex == 0;
        }
    }
}

