/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.jellytools.modules.j2ee.nodes;

import java.lang.reflect.Method;
import javax.swing.tree.TreePath;
import org.netbeans.jellytools.Bundle;
import org.netbeans.jellytools.NbDialogOperator;
import org.netbeans.jellytools.RuntimeTabOperator;
import org.netbeans.jellytools.modules.j2ee.nodes.J2eeServerNode;
import org.netbeans.jemmy.JemmyException;
import org.netbeans.jemmy.TimeoutExpiredException;
import org.netbeans.jemmy.Waitable;
import org.netbeans.jemmy.Waiter;
import org.netbeans.jemmy.operators.ContainerOperator;
import org.netbeans.jemmy.operators.JButtonOperator;
import org.netbeans.jemmy.operators.JListOperator;
import org.netbeans.jemmy.operators.JPopupMenuOperator;
import org.netbeans.jemmy.operators.JTextFieldOperator;
import org.netbeans.jemmy.operators.JTreeOperator;
import org.openide.nodes.Node;

public class GlassFishV3ServerNode
extends J2eeServerNode {
    public static final int STATE_WAITING = 0;
    public static final int STATE_WAITING_2 = 4;
    public static final int STATE_STOPPED = 5;
    public static final int STATE_RUNNING = 1;
    public static final int STATE_DEBUGGING = 2;
    public static final int STATE_SUSPENDED = 6;
    public static final int STATE_PROFILING = 3;
    public static final int STATE_PROFILER_BLOCKING = 7;
    public static final int STATE_PROFILER_STARTING = 8;

    public GlassFishV3ServerNode() {
        super(Bundle.getString((String)"org.netbeans.modules.glassfish.common.Bundle", (String)"STR_V3_SERVER_NAME"));
    }

    public static GlassFishV3ServerNode invoke() {
        RuntimeTabOperator.invoke();
        return new GlassFishV3ServerNode();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static GlassFishV3ServerNode checkServerShown() {
        JTreeOperator tree = new RuntimeTabOperator().getRootNode().tree();
        long oldValue = tree.getTimeouts().getTimeout("JTreeOperator.WaitNextNodeTimeout");
        tree.getTimeouts().setTimeout("JTreeOperator.WaitNextNodeTimeout", 1L);
        GlassFishV3ServerNode result = null;
        try {
            result = GlassFishV3ServerNode.invoke();
        }
        catch (TimeoutExpiredException timeoutExpiredException) {
        }
        finally {
            tree.getTimeouts().setTimeout("JTreeOperator.WaitNextNodeTimeout", oldValue);
        }
        return result;
    }

    public static GlassFishV3ServerNode getGlassFishV3Node(String appServerPath) {
        GlassFishV3ServerNode result = GlassFishV3ServerNode.checkServerShown();
        if (result != null) {
            return result;
        }
        if (appServerPath == null) {
            throw new Error("Can't add application server. org.glassfish.v3ee6.installRoot property is not set.");
        }
        String addServerMenuItem = Bundle.getStringTrimmed((String)"org.netbeans.modules.j2ee.deployment.impl.ui.actions.Bundle", (String)"LBL_Add_Server_Instance");
        String addServerInstanceDialogTitle = Bundle.getStringTrimmed((String)"org.netbeans.modules.j2ee.deployment.impl.ui.wizard.Bundle", (String)"LBL_ASIW_Title");
        String glassFishV3ListItem = Bundle.getStringTrimmed((String)"org.netbeans.modules.glassfish.common.wizards.Bundle", (String)"V3_EE6_NAME");
        String nextButtonCaption = Bundle.getStringTrimmed((String)"org.openide.Bundle", (String)"CTL_NEXT");
        String finishButtonCaption = Bundle.getStringTrimmed((String)"org.openide.Bundle", (String)"CTL_FINISH");
        RuntimeTabOperator rto = RuntimeTabOperator.invoke();
        JTreeOperator runtimeTree = rto.tree();
        long oldTimeout = runtimeTree.getTimeouts().getTimeout("JTreeOperator.WaitNextNodeTimeout");
        runtimeTree.getTimeouts().setTimeout("JTreeOperator.WaitNextNodeTimeout", 6000L);
        TreePath path = runtimeTree.findPath("Servers");
        runtimeTree.selectPath(path);
        try {
            runtimeTree.findPath("Servers|GlassFish v3");
        }
        catch (TimeoutExpiredException tee) {
            new JPopupMenuOperator(runtimeTree.callPopupOnPath(path)).pushMenuNoBlock(addServerMenuItem);
            NbDialogOperator addServerInstanceDialog = new NbDialogOperator(addServerInstanceDialogTitle);
            new JListOperator((ContainerOperator)addServerInstanceDialog, 1).selectItem(glassFishV3ListItem);
            new JButtonOperator((ContainerOperator)addServerInstanceDialog, nextButtonCaption).push();
            new JTextFieldOperator((ContainerOperator)addServerInstanceDialog).enterText(appServerPath);
            new JButtonOperator((ContainerOperator)addServerInstanceDialog, finishButtonCaption).push();
        }
        runtimeTree.getTimeouts().setTimeout("JTreeOperator.WaitNextNodeTimeout", oldTimeout);
        return GlassFishV3ServerNode.invoke();
    }

    @Override
    public void properties() {
        this.waitNotWaiting();
        customizerAction.perform(this);
    }

    @Override
    public void debug() {
        this.waitNotWaiting();
        startDebugAction.perform(this);
        this.waitDebugging();
    }

    @Override
    public void refresh() {
        this.waitNotWaiting();
        refreshAction.perform(this);
        this.waitNotWaiting();
    }

    @Override
    public void remove() {
        this.waitNotWaiting();
        removeInstanceAction.perform(this);
    }

    @Override
    public void restart() {
        this.waitNotWaiting();
        restartAction.perform(this);
    }

    @Override
    public void start() {
        this.waitNotWaiting();
        startAction.perform(this);
        this.waitRunning();
    }

    @Override
    public void stop() {
        this.waitNotWaiting();
        stopAction.perform(this);
        this.waitStopped();
    }

    @Override
    public void waitFinished() {
        this.waitNotWaiting();
    }

    static Class<?> classGlassfishInstance() {
        try {
            ClassLoader loader = Thread.currentThread().getContextClassLoader();
            Class<?> general = Class.forName("org.netbeans.modules.glassfish.common.GlassfishInstance", false, loader);
            return general;
        }
        catch (ClassNotFoundException ex) {
            return Class.class;
        }
    }

    private void waitDebugging() {
        this.waitServerState(2);
    }

    private void waitRunning() {
        this.waitServerState(1);
    }

    private void waitStopped() {
        this.waitServerState(5);
    }

    @Override
    public int getServerState() {
        Node ideNode = (Node)this.getOpenideNode();
        return GlassFishV3ServerNode.getServerState(ideNode);
    }

    private static int getServerState(Node n) {
        try {
            Object server = n.getLookup().lookup(GlassFishV3ServerNode.classGlassfishInstance());
            Method m = GlassFishV3ServerNode.classGlassfishInstance().getMethod("getServerState", new Class[0]);
            return ((Enum)m.invoke(server, new Object[0])).ordinal();
        }
        catch (Exception ex) {
            return 5;
        }
    }

    private void waitServerState(int state) {
        final Node ideNode = (Node)this.getOpenideNode();
        final int targetState = state;
        GlassFishV3ServerNode.waitFor(new Waitable(){

            public Object actionProduced(Object obj) {
                if (GlassFishV3ServerNode.getServerState(ideNode) == targetState) {
                    return "Server state: " + this.getStateName() + " reached.";
                }
                return null;
            }

            public String getDescription() {
                return "Wait for server state: " + this.getStateName();
            }

            private String getStateName() {
                switch (targetState) {
                    case 2: {
                        return "DEBUGGING";
                    }
                    case 1: {
                        return "RUNNING";
                    }
                    case 5: {
                        return "STOPPED";
                    }
                    case 6: {
                        return "SUSPENDED";
                    }
                    case 0: {
                        return "WAITING (Starting)";
                    }
                    case 4: {
                        return "WAITING_2 (Stopping)";
                    }
                }
                return "UNKNOWN STATE";
            }
        });
    }

    private void waitNotWaiting() {
        final Node ideNode = (Node)this.getOpenideNode();
        GlassFishV3ServerNode.waitFor(new Waitable(){

            public Object actionProduced(Object obj) {
                if (GlassFishV3ServerNode.getServerState(ideNode) != 0) {
                    return "Server leaves WAITING state.";
                }
                return null;
            }

            public String getDescription() {
                return "Wait till server leaves state WAITING.";
            }
        });
    }

    private static Object waitFor(Waitable action) {
        Waiter waiter = new Waiter(action);
        waiter.getTimeouts().setTimeout("Waiter.WaitingTime", 120000L);
        try {
            return waiter.waitAction(null);
        }
        catch (InterruptedException ex) {
            throw new JemmyException(action.getDescription() + " has been " + "interrupted.", (Throwable)ex);
        }
    }
}

