/*
 * Decompiled with CFR 0.152.
 */
package org.clang.tools.services.support;

import java.util.Collection;
import java.util.Collections;
import org.clang.basic.vfs.FileSystem;
import org.clang.frontend.InputKind;
import org.clang.frontend.LangStandard;
import org.clang.tools.services.ClankCompilationDataBase;
import org.llvm.adt.IntrusiveRefCntPtr;

public final class DataBaseEntry
implements ClankCompilationDataBase.Entry {
    private final Collection<CharSequence> mainFile;
    private final CharSequence cwd;
    private final CharSequence sysRoot;
    private final InputKind lang;
    private final LangStandard.Kind langStd;
    private final Collection<CharSequence> incFiles;
    private final Collection<ClankCompilationDataBase.IncludePath> userIncludePaths;
    private final Collection<String> userMacroDefs;
    private final Collection<String> userMacroUndefs;
    private final Collection<ClankCompilationDataBase.IncludePath> predefinedIncludePaths;
    private final Collection<String> predefinedMacroDefs;
    private final IntrusiveRefCntPtr<FileSystem> fileSystem;
    private final CharSequence absPathLookupPrefix;

    DataBaseEntry(CharSequence mainFile, CharSequence cwd, CharSequence sysRoot, Collection<CharSequence> incFiles, Collection<ClankCompilationDataBase.IncludePath> userIncludePaths, Collection<String> userMacroDefs, Collection<String> userMacroUndefs, Collection<ClankCompilationDataBase.IncludePath> predefinedIncludePaths, Collection<String> predefinedMacroDefs, InputKind lang, LangStandard.Kind langStd, IntrusiveRefCntPtr<FileSystem> fileSystem, CharSequence absPathLookupPrefix) {
        this.mainFile = Collections.singletonList(mainFile);
        this.cwd = cwd;
        this.sysRoot = sysRoot;
        this.incFiles = incFiles;
        this.userIncludePaths = userIncludePaths;
        this.userMacroDefs = userMacroDefs;
        this.userMacroUndefs = userMacroUndefs;
        this.predefinedIncludePaths = predefinedIncludePaths;
        this.predefinedMacroDefs = predefinedMacroDefs;
        this.lang = lang;
        this.langStd = langStd;
        this.fileSystem = fileSystem;
        this.absPathLookupPrefix = absPathLookupPrefix;
    }

    @Override
    public Collection<CharSequence> getCompiledFiles() {
        return this.mainFile;
    }

    @Override
    public CharSequence getCompileWorkingDir() {
        return this.cwd;
    }

    @Override
    public CharSequence getSysRoot() {
        return this.sysRoot;
    }

    @Override
    public IntrusiveRefCntPtr<FileSystem> getFileSystem() {
        return this.fileSystem;
    }

    @Override
    public CharSequence getAbsPathLookupPrefix() {
        return this.absPathLookupPrefix;
    }

    @Override
    public Collection<CharSequence> getIncludeFiles() {
        return this.incFiles;
    }

    @Override
    public Collection<ClankCompilationDataBase.IncludePath> getUserIncludePaths() {
        return this.userIncludePaths;
    }

    @Override
    public Collection<String> getUserMacroDefines() {
        return this.userMacroDefs;
    }

    @Override
    public Collection<String> getUserMacroUndefines() {
        return this.userMacroUndefs;
    }

    @Override
    public Collection<ClankCompilationDataBase.IncludePath> getPredefinedSystemIncludePaths() {
        return this.predefinedIncludePaths;
    }

    @Override
    public Collection<String> getSystemMacroDefines() {
        return this.predefinedMacroDefs;
    }

    @Override
    public InputKind getLanguage() {
        return this.lang;
    }

    @Override
    public LangStandard.Kind getLangStandard() {
        return this.langStd;
    }

    public String toString() {
        return "EntryImpl{files=" + this.toString(this.mainFile) + "\n cwd=" + this.cwd + "\n lang=" + this.lang + ", langStd=" + this.langStd + "\n incFiles=" + this.toString(this.incFiles) + "\n userIncludePaths=" + this.toStringIncludePaths(this.userIncludePaths) + "\n userMacroDefs=" + this.toString(this.userMacroDefs) + "\n userMacroUndefs=" + this.toString(this.userMacroUndefs) + "\n predefinedIncludePaths=" + this.toStringIncludePaths(this.predefinedIncludePaths) + "\n predefinedMacroDefs=" + this.toString(this.predefinedMacroDefs) + "\n}";
    }

    private CharSequence toString(Collection<? extends CharSequence> cs) {
        StringBuilder builder = new StringBuilder();
        for (CharSequence charSequence : cs) {
            builder.append("\n").append(charSequence);
        }
        return builder;
    }

    private CharSequence toStringIncludePaths(Collection<? extends ClankCompilationDataBase.IncludePath> cs) {
        StringBuilder builder = new StringBuilder();
        for (ClankCompilationDataBase.IncludePath includePath : cs) {
            builder.append("\n").append(includePath.getPath()).append(";Framework=").append(includePath.isFramework()).append(";IgnoreSysRoot=").append(includePath.ignoreSysRoot());
        }
        return builder;
    }
}

