/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.groovy.grailsproject;

import java.awt.Image;
import java.beans.PropertyChangeListener;
import java.util.logging.Logger;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.java.classpath.GlobalPathRegistry;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectInformation;
import org.netbeans.modules.groovy.grails.api.GrailsProjectConfig;
import org.netbeans.modules.groovy.grailsproject.GrailsActionProvider;
import org.netbeans.modules.groovy.grailsproject.GrailsProjectOperations;
import org.netbeans.modules.groovy.grailsproject.GrailsServerState;
import org.netbeans.modules.groovy.grailsproject.GrailsSources;
import org.netbeans.modules.groovy.grailsproject.classpath.ClassPathProviderImpl;
import org.netbeans.modules.groovy.grailsproject.classpath.SourceRoots;
import org.netbeans.modules.groovy.grailsproject.commands.GrailsCommandSupport;
import org.netbeans.modules.groovy.grailsproject.completion.ControllerCompletionProvider;
import org.netbeans.modules.groovy.grailsproject.completion.DomainCompletionProvider;
import org.netbeans.modules.groovy.grailsproject.config.BuildConfig;
import org.netbeans.modules.groovy.grailsproject.debug.GrailsDebugger;
import org.netbeans.modules.groovy.grailsproject.queries.GrailsProjectEncodingQueryImpl;
import org.netbeans.modules.groovy.grailsproject.ui.GrailsLogicalViewProvider;
import org.netbeans.modules.groovy.grailsproject.ui.customizer.GrailsProjectCustomizerProvider;
import org.netbeans.modules.groovy.support.spi.GroovyExtenderImplementation;
import org.netbeans.spi.project.AuxiliaryConfiguration;
import org.netbeans.spi.project.ProjectState;
import org.netbeans.spi.project.ui.LogicalViewProvider;
import org.netbeans.spi.project.ui.PrivilegedTemplates;
import org.netbeans.spi.project.ui.ProjectOpenedHook;
import org.netbeans.spi.project.ui.RecommendedTemplates;
import org.openide.filesystems.FileObject;
import org.openide.util.ImageUtilities;
import org.openide.util.Lookup;
import org.openide.util.lookup.Lookups;
import org.w3c.dom.Element;

public final class GrailsProject
implements Project {
    private static final Logger LOG = Logger.getLogger(GrailsProject.class.getName());
    private final FileObject projectDir;
    private final ProjectState projectState;
    private final LogicalViewProvider logicalView;
    private final ClassPathProviderImpl cpProvider;
    private final GrailsCommandSupport commandSupport;
    private final BuildConfig buildConfig;
    private SourceRoots sourceRoots;
    private SourceRoots testRoots;
    private Lookup lookup;

    public GrailsProject(FileObject projectDir, ProjectState projectState) {
        this.projectDir = projectDir;
        this.projectState = projectState;
        this.logicalView = new GrailsLogicalViewProvider(this);
        this.cpProvider = new ClassPathProviderImpl(this.getSourceRoots(), this.getTestSourceRoots(), this);
        this.commandSupport = new GrailsCommandSupport(this);
        this.buildConfig = new BuildConfig(this);
    }

    public FileObject getProjectDirectory() {
        return this.projectDir;
    }

    public ProjectState getProjectState() {
        return this.projectState;
    }

    public GrailsCommandSupport getCommandSupport() {
        return this.commandSupport;
    }

    public BuildConfig getBuildConfig() {
        return this.buildConfig;
    }

    public Lookup getLookup() {
        if (this.lookup == null) {
            GrailsProjectConfig config = new GrailsProjectConfig((Project)this);
            config.initListeners();
            this.lookup = Lookups.fixed((Object[])new Object[]{this, this.projectState, new Info(), new GrailsActionProvider(this), GrailsSources.create(this), new GrailsServerState(this), new GrailsProjectCustomizerProvider(this), new GrailsProjectOperations(this), new GrailsProjectEncodingQueryImpl(), new OpenHook(), new AuxiliaryConfigurationImpl(), new RecommendedTemplatesImpl(), new GroovyExtenderImpl(), new ControllerCompletionProvider(), new DomainCompletionProvider(), this.logicalView, this.cpProvider, config, new GrailsDebugger(this)});
        }
        return this.lookup;
    }

    public synchronized SourceRoots getSourceRoots() {
        if (this.sourceRoots == null) {
            this.sourceRoots = new SourceRoots(this, this.projectDir);
        }
        return this.sourceRoots;
    }

    public synchronized SourceRoots getTestSourceRoots() {
        if (this.testRoots == null) {
            this.testRoots = new SourceRoots(this, this.projectDir);
        }
        return this.testRoots;
    }

    private static final class GroovyExtenderImpl
    implements GroovyExtenderImplementation {
        private GroovyExtenderImpl() {
        }

        public boolean isActive() {
            return true;
        }

        public boolean activate() {
            return true;
        }

        public boolean deactivate() {
            return true;
        }
    }

    private static final class RecommendedTemplatesImpl
    implements RecommendedTemplates,
    PrivilegedTemplates {
        private static final String[] RECOMMENDED_TYPES = new String[]{"groovy", "java-classes", "XML", "simple-files"};
        private static final String[] PRIVILEGED_NAMES = new String[]{"Templates/Groovy/DomainClass", "Templates/Groovy/Controller", "Templates/Groovy/IntegrationTest", "Templates/Groovy/GantScript", "Templates/Groovy/Service", "Templates/Groovy/TagLib", "Templates/Groovy/UnitTest", "Templates/Other/Folder", "Templates/Other/properties.properties", "simple-files"};

        private RecommendedTemplatesImpl() {
        }

        public String[] getRecommendedTypes() {
            return RECOMMENDED_TYPES;
        }

        public String[] getPrivilegedTemplates() {
            return PRIVILEGED_NAMES;
        }
    }

    private static class AuxiliaryConfigurationImpl
    implements AuxiliaryConfiguration {
        private AuxiliaryConfigurationImpl() {
        }

        public Element getConfigurationFragment(String elementName, String namespace, boolean shared) {
            return null;
        }

        public void putConfigurationFragment(Element fragment, boolean shared) throws IllegalArgumentException {
        }

        public boolean removeConfigurationFragment(String elementName, String namespace, boolean shared) throws IllegalArgumentException {
            return false;
        }
    }

    private class OpenHook
    extends ProjectOpenedHook {
        private OpenHook() {
        }

        protected void projectOpened() {
            ClassPath[] sourceClasspaths = GrailsProject.this.cpProvider.getProjectClassPaths("classpath/source");
            GlobalPathRegistry.getDefault().register("classpath/boot", GrailsProject.this.cpProvider.getProjectClassPaths("classpath/boot"));
            GlobalPathRegistry.getDefault().register("classpath/compile", GrailsProject.this.cpProvider.getProjectClassPaths("classpath/compile"));
            GlobalPathRegistry.getDefault().register("classpath/source", sourceClasspaths);
        }

        protected void projectClosed() {
            GlobalPathRegistry.getDefault().unregister("classpath/boot", GrailsProject.this.cpProvider.getProjectClassPaths("classpath/boot"));
            GlobalPathRegistry.getDefault().unregister("classpath/compile", GrailsProject.this.cpProvider.getProjectClassPaths("classpath/compile"));
            GlobalPathRegistry.getDefault().unregister("classpath/source", GrailsProject.this.cpProvider.getProjectClassPaths("classpath/source"));
        }
    }

    private final class Info
    implements ProjectInformation {
        private Info() {
        }

        public Icon getIcon() {
            Image image = ImageUtilities.loadImage((String)"org/netbeans/modules/groovy/grails/resources/GrailsIcon16x16.png");
            return image == null ? null : new ImageIcon(image);
        }

        public String getName() {
            return GrailsProject.this.getProjectDirectory().getName();
        }

        public String getDisplayName() {
            return this.getName();
        }

        public void addPropertyChangeListener(PropertyChangeListener pcl) {
        }

        public void removePropertyChangeListener(PropertyChangeListener pcl) {
        }

        public Project getProject() {
            return GrailsProject.this;
        }
    }
}

