/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.weblogic9;

import java.util.Collection;
import java.util.TreeSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.enterprise.deploy.spi.exceptions.DeploymentManagerCreationException;
import org.netbeans.modules.j2ee.deployment.common.api.Version;
import org.netbeans.modules.j2ee.deployment.devmodules.api.Deployment;
import org.netbeans.modules.j2ee.deployment.devmodules.api.InstanceRemovedException;
import org.netbeans.modules.j2ee.deployment.devmodules.api.ServerInstance;
import org.netbeans.modules.j2ee.weblogic9.WLDeploymentFactory;
import org.netbeans.modules.j2ee.weblogic9.deploy.WLDeploymentManager;

public final class DomainSupport {
    private static final Logger LOGGER = Logger.getLogger(DomainSupport.class.getName());

    private DomainSupport() {
    }

    public static Collection<WLDomain> getUsableDomainInstances(Version minimalWeblogicVersion) {
        TreeSet<WLDomain> domains = new TreeSet<WLDomain>();
        for (String url : Deployment.getDefault().getInstancesOfServer("WebLogic9")) {
            try {
                WLDeploymentManager dm = (WLDeploymentManager)WLDeploymentFactory.getInstance().getDisconnectedDeploymentManager(url);
                if (minimalWeblogicVersion != null && !minimalWeblogicVersion.isBelowOrEqual(dm.getDomainVersion())) continue;
                ServerInstance inst = Deployment.getDefault().getServerInstance(url);
                domains.add(new WLDomain(inst.getDisplayName(), url, dm.getDomainVersion()));
            }
            catch (DeploymentManagerCreationException ex) {
                LOGGER.log(Level.FINE, null, ex);
            }
            catch (InstanceRemovedException ex) {
                LOGGER.log(Level.FINE, null, ex);
            }
        }
        return domains;
    }

    public static class WLDomain
    implements Comparable<WLDomain> {
        private final String name;
        private final String url;
        private final Version version;

        private WLDomain(String name, String url, Version version) {
            this.name = name;
            this.url = url;
            this.version = version;
        }

        public String getName() {
            return this.name;
        }

        public String getUrl() {
            return this.url;
        }

        public String toString() {
            return this.name;
        }

        @Override
        public int compareTo(WLDomain o) {
            if (this.version == o.version) {
                return 0;
            }
            if (this.version == null && o.version != null) {
                return 1;
            }
            if (this.version != null && o.version == null) {
                return -1;
            }
            if (this.version.equals((Object)o.version)) {
                return 0;
            }
            if (this.version.isBelowOrEqual(o.version)) {
                return 1;
            }
            return -1;
        }
    }
}

