/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.classview.model;

import java.util.ArrayList;
import java.util.Collection;
import javax.swing.Action;
import javax.swing.event.ChangeListener;
import org.netbeans.modules.cnd.api.model.CsmFile;
import org.netbeans.modules.cnd.api.model.CsmFriend;
import org.netbeans.modules.cnd.api.model.CsmFunction;
import org.netbeans.modules.cnd.api.model.CsmFunctionDefinition;
import org.netbeans.modules.cnd.api.model.CsmObject;
import org.netbeans.modules.cnd.api.model.CsmOffsetable;
import org.netbeans.modules.cnd.api.model.CsmOffsetableDeclaration;
import org.netbeans.modules.cnd.api.model.CsmProject;
import org.netbeans.modules.cnd.api.model.services.CsmFriendResolver;
import org.netbeans.modules.cnd.api.model.util.CsmKindUtilities;
import org.netbeans.modules.cnd.classview.PersistentKey;
import org.netbeans.modules.cnd.classview.actions.GoToDeclarationAction;
import org.netbeans.modules.cnd.classview.actions.MoreDeclarations;
import org.netbeans.modules.cnd.classview.model.BaseNode;
import org.netbeans.modules.cnd.refactoring.api.ui.CsmRefactoringActionsFactory;
import org.netbeans.modules.refactoring.api.ui.RefactoringActionsFactory;
import org.openide.nodes.Children;

public abstract class ObjectNode
extends BaseNode
implements ChangeListener {
    private PersistentKey key;

    public ObjectNode(CsmOffsetableDeclaration declaration) {
        this(declaration, Children.LEAF);
    }

    public ObjectNode(CsmOffsetableDeclaration declaration, Children children) {
        super(children);
        this.setObject(declaration);
    }

    public final CsmObject getCsmObject() {
        return this.getObject();
    }

    public final CsmOffsetableDeclaration getObject() {
        return (CsmOffsetableDeclaration)this.key.getObject();
    }

    protected final void setObject(CsmOffsetableDeclaration declaration) {
        this.key = PersistentKey.createKey(declaration);
    }

    public Action getPreferredAction() {
        return this.createOpenAction();
    }

    private Action createOpenAction() {
        CsmOffsetableDeclaration decl = this.getObject();
        if (decl != null) {
            return new GoToDeclarationAction((CsmOffsetable)decl);
        }
        return null;
    }

    public Action[] getActions(boolean context) {
        ArrayList<Action> res = new ArrayList<Action>();
        Action action = this.createOpenAction();
        if (action != null) {
            res.add(action);
            CsmOffsetableDeclaration decl = this.getObject();
            CharSequence name = decl.getUniqueName();
            CsmFile file = decl.getContainingFile();
            CsmProject project = file.getProject();
            if (project != null) {
                CsmFunctionDefinition def;
                Collection arr = project.findDeclarations(name);
                for (CsmFriend friend : CsmFriendResolver.getDefault().findFriends(decl)) {
                    if (!CsmKindUtilities.isFriendMethod((CsmObject)friend)) continue;
                    arr.add(friend);
                }
                if (CsmKindUtilities.isFunctionDeclaration((CsmObject)decl) && (def = ((CsmFunction)decl).getDefinition()) != null && def != decl) {
                    arr.addAll(project.findDeclarations(def.getUniqueName()));
                }
                if (arr.size() > 1) {
                    MoreDeclarations more = new MoreDeclarations(arr);
                    res.add(more);
                }
            }
            if (CsmRefactoringActionsFactory.supportRefactoring((CsmFile)file)) {
                res.add((Action)RefactoringActionsFactory.renameAction());
                res.add((Action)RefactoringActionsFactory.whereUsedAction());
                if (CsmKindUtilities.isField((CsmObject)decl) || CsmKindUtilities.isClass((CsmObject)decl)) {
                    res.add((Action)CsmRefactoringActionsFactory.encapsulateFieldsAction());
                } else if (CsmKindUtilities.isFunction((CsmObject)decl) && !CsmKindUtilities.isDestructor((CsmObject)decl)) {
                    res.add((Action)CsmRefactoringActionsFactory.changeParametersAction());
                }
            }
        }
        return res.toArray(new Action[res.size()]);
    }
}

