/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.apisupport.project.universe;

import java.io.DataInput;
import java.io.DataInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.modules.apisupport.project.ApisupportAntUtils;
import org.netbeans.modules.apisupport.project.api.ManifestManager;
import org.netbeans.modules.apisupport.project.api.Util;
import org.netbeans.modules.apisupport.project.universe.LocalizedBundleInfo;
import org.netbeans.modules.apisupport.project.universe.ModuleEntry;
import org.netbeans.modules.apisupport.project.universe.NbPlatform;
import org.netbeans.spi.project.support.ant.PropertyUtils;

abstract class AbstractEntry
implements ModuleEntry {
    private String localizedName;
    private Set<String> publicClassNames;

    AbstractEntry() {
    }

    protected abstract LocalizedBundleInfo getBundleInfo();

    @Override
    public String getLocalizedName() {
        if (this.localizedName == null) {
            this.localizedName = this.getBundleInfo().getDisplayName();
            if (this.localizedName == null) {
                this.localizedName = this.getCodeNameBase();
            }
        }
        return this.localizedName;
    }

    @Override
    public String getCategory() {
        return this.getBundleInfo().getCategory();
    }

    @Override
    public String getShortDescription() {
        return this.getBundleInfo().getShortDescription();
    }

    @Override
    public String getLongDescription() {
        return this.getBundleInfo().getLongDescription();
    }

    @Override
    public int compareTo(ModuleEntry o) {
        int retval = this.getLocalizedName().compareTo(o.getLocalizedName());
        return retval != 0 ? retval : this.getCodeNameBase().compareTo(o.getCodeNameBase());
    }

    @Override
    public synchronized Set<String> getPublicClassNames() {
        if (this.publicClassNames == null) {
            try {
                this.publicClassNames = this.computePublicClassNamesInMainModule();
                String[] cpext = PropertyUtils.tokenizePath((String)this.getClassPathExtensions());
                for (int i = 0; i < cpext.length; ++i) {
                    File ext = new File(cpext[i]);
                    if (!ext.isFile()) {
                        Logger.getLogger(AbstractEntry.class.getName()).log(Level.FINE, "Could not find Class-Path extension {0} of {1}", new Object[]{ext, this});
                        continue;
                    }
                    this.scanJarForPublicClassNames(this.publicClassNames, ext);
                }
            }
            catch (IOException e) {
                this.publicClassNames = Collections.emptySet();
                Util.err.annotate((Throwable)e, 0, "While scanning for public classes in " + this, null, null, null);
                Util.err.notify(1, (Throwable)e);
            }
        }
        return this.publicClassNames;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void scanJarForPublicClassNames(Set<String> result, File jar) throws IOException {
        HashSet<String> publicPackagesSlashNonRec = new HashSet<String>();
        ArrayList<String> publicPackagesSlashRec = new ArrayList<String>();
        for (ManifestManager.PackageExport pkg : this.getPublicPackages()) {
            String name = pkg.getPackage().replace('.', '/') + '/';
            if (pkg.isRecursive()) {
                publicPackagesSlashRec.add(name);
                continue;
            }
            publicPackagesSlashNonRec.add(name);
        }
        JarFile jf = new JarFile(jar);
        try {
            Enumeration<JarEntry> entries = jf.entries();
            block4: while (entries.hasMoreElements()) {
                int slash;
                JarEntry entry = entries.nextElement();
                String path = entry.getName();
                if (!path.endsWith(".class") || (slash = path.lastIndexOf(47)) == -1) continue;
                String pkg = path.substring(0, slash + 1);
                if (!publicPackagesSlashNonRec.contains(pkg)) {
                    boolean pub = false;
                    Iterator it = publicPackagesSlashRec.iterator();
                    while (it.hasNext()) {
                        if (!pkg.startsWith((String)it.next())) continue;
                        pub = true;
                        break;
                    }
                    if (!pub) continue;
                }
                StringTokenizer tok = new StringTokenizer(path, "$");
                while (tok.hasMoreTokens()) {
                    String component = tok.nextToken();
                    char c = component.charAt(0);
                    if (c < '0' || c > '9') continue;
                    continue block4;
                }
                if (!AbstractEntry.isPublic(jf, entry)) continue;
                result.add(path.substring(0, path.length() - 6).replace('/', '.'));
            }
        }
        finally {
            jf.close();
        }
    }

    protected abstract Set<String> computePublicClassNamesInMainModule() throws IOException;

    protected static boolean isDeclaredAsFriend(String[] friends, String cnb) {
        return friends == null ? true : Arrays.binarySearch(friends, cnb) >= 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean isPublic(JarFile jf, JarEntry entry) throws IOException {
        InputStream is;
        try {
            is = jf.getInputStream(entry);
        }
        catch (SecurityException x) {
            throw new IOException(x);
        }
        try {
            DataInputStream input = new DataInputStream(is);
            AbstractEntry.skip(input, 8);
            int size = input.readUnsignedShort() - 1;
            block11: for (int i = 0; i < size; ++i) {
                byte tag = input.readByte();
                switch (tag) {
                    case 1: {
                        input.readUTF();
                        continue block11;
                    }
                    case 3: 
                    case 4: 
                    case 9: 
                    case 10: 
                    case 11: 
                    case 12: {
                        AbstractEntry.skip(input, 4);
                        continue block11;
                    }
                    case 7: 
                    case 8: {
                        AbstractEntry.skip(input, 2);
                        continue block11;
                    }
                    case 5: 
                    case 6: {
                        AbstractEntry.skip(input, 8);
                        ++i;
                        continue block11;
                    }
                    default: {
                        throw new IOException("Unrecognized constant pool tag " + tag + " at index " + i);
                    }
                }
            }
            int accessFlags = input.readUnsignedShort();
            boolean bl = (accessFlags & 1) > 0;
            return bl;
        }
        finally {
            is.close();
        }
    }

    private static void skip(DataInput input, int bytes) throws IOException {
        int skipped = input.skipBytes(bytes);
        if (skipped != bytes) {
            throw new IOException();
        }
    }

    @Override
    public URL getJavadoc(NbPlatform platform) {
        if (platform == null) {
            return null;
        }
        String cnbdashes = this.getCodeNameBase().replace('.', '-');
        URL[] roots = platform.getJavadocRoots();
        return roots == null ? null : ApisupportAntUtils.findJavadocURL(cnbdashes, roots);
    }
}

