/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler.snaptracer.impl.timeline;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Stroke;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import javax.swing.SwingUtilities;
import org.netbeans.lib.profiler.charts.ChartConfigurationListener;
import org.netbeans.lib.profiler.charts.ChartContext;
import org.netbeans.lib.profiler.charts.ChartItem;
import org.netbeans.lib.profiler.charts.ChartOverlay;
import org.netbeans.lib.profiler.charts.ChartSelectionListener;
import org.netbeans.lib.profiler.charts.ItemSelection;
import org.netbeans.lib.profiler.charts.swing.Utils;
import org.netbeans.lib.profiler.charts.xy.XYItem;
import org.netbeans.lib.profiler.charts.xy.XYItemSelection;
import org.netbeans.lib.profiler.charts.xy.synchronous.SynchronousXYItemsModel;
import org.netbeans.modules.profiler.snaptracer.impl.timeline.TimelineChart;
import org.netbeans.modules.profiler.snaptracer.impl.timeline.TimelineSupport;
import org.netbeans.modules.profiler.snaptracer.impl.timeline.TimelineXYPainter;

final class TimelineSelectionOverlay
extends ChartOverlay {
    private TimelineChart chart;
    private TimelineSupport support;
    private int selectionExtent;
    private ConfigurationListener configurationListener;
    private SelectionListener selectionListener;
    private TimeSelectionListener timeSelectionListener;
    private final Set<Point> highlightedValues;
    private final Set<Point> selectedValues;
    private Paint sMarkPaint;
    private Paint sOddPerfPaint;
    private Paint sEvenPerfPaint;
    private Paint hMarkPaint;
    private Paint hOddPerfPaint;
    private Paint hEvenPerfPaint;
    private Stroke markStroke;
    private Stroke oddPerfStroke;
    private Stroke evenPerfStroke;
    private final Set<Integer> paintedLines = new HashSet<Integer>();

    TimelineSelectionOverlay() {
        this.configurationListener = new ConfigurationListener();
        this.selectionListener = new SelectionListener();
        this.timeSelectionListener = new TimeSelectionListener();
        this.highlightedValues = new HashSet<Point>();
        this.selectedValues = new HashSet<Point>();
        this.initDefaultValues();
    }

    final void registerChart(TimelineSupport support) {
        this.unregisterListener();
        this.support = support;
        this.chart = support.getChart();
        this.registerListener();
    }

    final void unregisterChart(TimelineSupport support) {
        this.unregisterListener();
        this.support = null;
        this.chart = null;
    }

    private void registerListener() {
        if (this.support == null || this.chart == null) {
            return;
        }
        this.chart.addConfigurationListener((ChartConfigurationListener)this.configurationListener);
        this.chart.addRowListener(this.configurationListener);
        this.chart.getSelectionModel().addSelectionListener((ChartSelectionListener)this.selectionListener);
        this.support.addSelectionListener(this.timeSelectionListener);
    }

    private void unregisterListener() {
        if (this.support == null || this.chart == null) {
            return;
        }
        this.chart.removeConfigurationListener((ChartConfigurationListener)this.configurationListener);
        this.chart.removeRowListener(this.configurationListener);
        this.chart.getSelectionModel().removeSelectionListener((ChartSelectionListener)this.selectionListener);
        this.support.removeSelectionListener(this.timeSelectionListener);
    }

    private void initDefaultValues() {
        this.sMarkPaint = new Color(120, 120, 120);
        this.sOddPerfPaint = new Color(120, 120, 120);
        this.sEvenPerfPaint = Color.WHITE;
        this.hMarkPaint = new Color(80, 80, 80);
        this.hOddPerfPaint = Color.BLACK;
        this.hEvenPerfPaint = Color.WHITE;
        this.markStroke = new BasicStroke(2.8f, 1, 1);
        this.oddPerfStroke = new BasicStroke(1.0f, 2, 2, 0.0f, new float[]{1.0f, 3.0f}, 0.0f);
        this.evenPerfStroke = new BasicStroke(1.0f, 2, 2, 0.0f, new float[]{1.0f, 3.0f}, 2.0f);
        this.selectionExtent = 3;
    }

    public void paint(Graphics g) {
        int y;
        int x;
        Point p;
        if (this.highlightedValues.isEmpty() && this.selectedValues.isEmpty()) {
            return;
        }
        Graphics2D g2 = (Graphics2D)g;
        g2.setRenderingHints(this.chart.getRenderingHints());
        Iterator<Point> it = this.selectedValues.iterator();
        this.paintedLines.clear();
        int height = this.getHeight();
        int extentP = 1 - this.selectionExtent;
        int extentD = this.selectionExtent * 2 - 1;
        while (it.hasNext()) {
            p = it.next();
            x = p.x;
            y = p.y;
            if (y == -1) continue;
            if (!this.paintedLines.contains(x)) {
                g2.setPaint(this.sEvenPerfPaint);
                g2.setStroke(this.evenPerfStroke);
                g2.drawLine(x, 0, x, height);
                g2.setPaint(this.sOddPerfPaint);
                g2.setStroke(this.oddPerfStroke);
                g2.drawLine(x, 0, x, height);
                g2.setPaint(this.sMarkPaint);
                g2.setStroke(this.markStroke);
                this.paintedLines.add(x);
            }
            if (y - this.selectionExtent < 0 || y + this.selectionExtent > height) continue;
            g2.fillOval(x + extentP, y + extentP, extentD, extentD);
        }
        it = this.highlightedValues.iterator();
        this.paintedLines.clear();
        while (it.hasNext()) {
            p = it.next();
            x = p.x;
            y = p.y;
            if (y == -1) continue;
            if (!this.paintedLines.contains(x)) {
                g2.setPaint(this.hEvenPerfPaint);
                g2.setStroke(this.evenPerfStroke);
                g2.drawLine(x, 0, x, height);
                g2.setPaint(this.hOddPerfPaint);
                g2.setStroke(this.oddPerfStroke);
                g2.drawLine(x, 0, x, height);
                g2.setPaint(this.hMarkPaint);
                g2.setStroke(this.markStroke);
                this.paintedLines.add(x);
            }
            if (y - this.selectionExtent < 0 || y + this.selectionExtent > height) continue;
            g2.fillOval(x + extentP, y + extentP, extentD, extentD);
        }
    }

    private void vLineBoundsChanged(Set<Point> oldSelection, Set<Point> newSelection) {
        TreeSet<Integer> selectionBounds = new TreeSet<Integer>();
        for (Point point : oldSelection) {
            selectionBounds.add(point.x);
        }
        int selections = selectionBounds.size();
        if (selections == 1) {
            this.repaint((Integer)selectionBounds.first() - this.selectionExtent, 0, this.selectionExtent * 2, this.getHeight());
            selectionBounds.clear();
        }
        for (Point p : newSelection) {
            selectionBounds.add(p.x);
        }
        selections = selectionBounds.size();
        if (selections == 1) {
            this.repaint((Integer)selectionBounds.first() - this.selectionExtent, 0, this.selectionExtent * 2, this.getHeight());
        } else if (selections > 1) {
            int n = (Integer)selectionBounds.first() - this.selectionExtent;
            int lastX = (Integer)selectionBounds.last() + this.selectionExtent;
            this.repaint(n, 0, lastX - n, this.getHeight());
        }
    }

    private List<ItemSelection> getSelections() {
        ArrayList<ItemSelection> items = new ArrayList<ItemSelection>();
        Set<Integer> timestamps = this.support.getSelectedTimestamps();
        SynchronousXYItemsModel model = (SynchronousXYItemsModel)this.chart.getItemsModel();
        int itemsCount = model.getItemsCount();
        for (int itemIndex = 0; itemIndex < itemsCount; ++itemIndex) {
            for (int timestamp : timestamps) {
                items.add((ItemSelection)new XYItemSelection.Default((XYItem)model.getItem(itemIndex), timestamp, Integer.MAX_VALUE));
            }
        }
        return items;
    }

    private static void updateValues(Set<Point> values, List<ItemSelection> selectedItems, TimelineChart chart) {
        values.clear();
        for (ItemSelection sel : selectedItems) {
            XYItemSelection xySel = (XYItemSelection)sel;
            XYItem item = xySel.getItem();
            TimelineXYPainter painter = (TimelineXYPainter)chart.getPaintersModel().getPainter((ChartItem)item);
            ChartContext context = chart.getChartContext((ChartItem)item);
            long xValue = item.getXValue(xySel.getValueIndex());
            long yValue = item.getYValue(xySel.getValueIndex());
            int xPos = Utils.checkedInt((double)Math.ceil(context.getViewX((double)xValue)));
            int yPos = Utils.checkedInt((double)Math.ceil(painter.getItemView(yValue, item, context)));
            if (xPos < 0 || xPos > chart.getWidth()) continue;
            values.add(new Point(xPos, yPos));
        }
    }

    private class TimeSelectionListener
    implements TimelineSupport.SelectionListener {
        private TimeSelectionListener() {
        }

        @Override
        public void intervalsSelectionChanged() {
        }

        @Override
        public void indexSelectionChanged() {
        }

        @Override
        public void timeSelectionChanged(boolean timestampsSelected, boolean justHovering) {
            HashSet oldSelectedValues = new HashSet(TimelineSelectionOverlay.this.selectedValues);
            TimelineSelectionOverlay.updateValues(TimelineSelectionOverlay.this.selectedValues, TimelineSelectionOverlay.this.getSelections(), TimelineSelectionOverlay.this.chart);
            TimelineSelectionOverlay.this.vLineBoundsChanged(oldSelectedValues, TimelineSelectionOverlay.this.selectedValues);
        }
    }

    private class SelectionListener
    implements ChartSelectionListener {
        private SelectionListener() {
        }

        public void selectionModeChanged(int newMode, int oldMode) {
        }

        public void selectionBoundsChanged(Rectangle newBounds, Rectangle oldBounds) {
        }

        public void selectedItemsChanged(List<ItemSelection> currentItems, List<ItemSelection> addedItems, List<ItemSelection> removedItems) {
        }

        public void highlightedItemsChanged(List<ItemSelection> currentItems, List<ItemSelection> addedItems, List<ItemSelection> removedItems) {
            HashSet oldHighlightedValues = new HashSet(TimelineSelectionOverlay.this.highlightedValues);
            TimelineSelectionOverlay.updateValues(TimelineSelectionOverlay.this.highlightedValues, currentItems, TimelineSelectionOverlay.this.chart);
            TimelineSelectionOverlay.this.vLineBoundsChanged(oldHighlightedValues, TimelineSelectionOverlay.this.highlightedValues);
        }
    }

    private class ConfigurationListener
    extends ChartConfigurationListener.Adapter
    implements TimelineChart.RowListener {
        private final Runnable selectionUpdater = new Runnable(){

            @Override
            public void run() {
                HashSet oldSelectedValues = new HashSet(TimelineSelectionOverlay.this.selectedValues);
                TimelineSelectionOverlay.updateValues(TimelineSelectionOverlay.this.selectedValues, TimelineSelectionOverlay.this.getSelections(), TimelineSelectionOverlay.this.chart);
                TimelineSelectionOverlay.this.vLineBoundsChanged(oldSelectedValues, TimelineSelectionOverlay.this.selectedValues);
                HashSet oldValues = new HashSet(TimelineSelectionOverlay.this.highlightedValues);
                TimelineSelectionOverlay.updateValues(TimelineSelectionOverlay.this.highlightedValues, TimelineSelectionOverlay.this.chart.getSelectionModel().getHighlightedItems(), TimelineSelectionOverlay.this.chart);
                TimelineSelectionOverlay.this.vLineBoundsChanged(oldValues, TimelineSelectionOverlay.this.highlightedValues);
            }
        };

        private ConfigurationListener() {
        }

        public void contentsUpdated(long offsetX, long offsetY, double scaleX, double scaleY, long lastOffsetX, long lastOffsetY, double lastScaleX, double lastScaleY, int shiftX, int shiftY) {
            if (TimelineSelectionOverlay.this.highlightedValues.isEmpty() && !TimelineSelectionOverlay.this.support.isTimestampSelection(true)) {
                return;
            }
            if (lastOffsetX != offsetX || lastOffsetY != offsetY || scaleX != lastScaleX || scaleY != lastScaleY) {
                SwingUtilities.invokeLater(this.selectionUpdater);
            }
        }

        @Override
        public void rowsAdded(List<TimelineChart.Row> rows) {
            this.selectionUpdater.run();
        }

        @Override
        public void rowsRemoved(List<TimelineChart.Row> rows) {
            this.selectionUpdater.run();
        }

        @Override
        public void rowsResized(List<TimelineChart.Row> rows) {
            this.selectionUpdater.run();
        }
    }
}

