/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.db.explorer.action;

import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.api.db.explorer.node.BaseNode;
import org.netbeans.lib.ddl.impl.Specification;
import org.netbeans.modules.db.explorer.DatabaseConnection;
import org.netbeans.modules.db.explorer.DbUtilities;
import org.netbeans.modules.db.explorer.action.BaseAction;
import org.netbeans.modules.db.explorer.action.RefreshAction;
import org.netbeans.modules.db.explorer.dlg.AddViewDialog;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.util.actions.SystemAction;

public class CreateViewAction
extends BaseAction {
    protected boolean enable(Node[] activatedNodes) {
        if (activatedNodes == null || activatedNodes.length != 1) {
            return false;
        }
        boolean enabled = false;
        DatabaseConnection dbconn = (DatabaseConnection)activatedNodes[0].getLookup().lookup(DatabaseConnection.class);
        if (dbconn != null) {
            enabled = dbconn.isVitalConnection();
        }
        return enabled;
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx(CreateViewAction.class);
    }

    public void performAction(Node[] activatedNodes) {
        final BaseNode node = (BaseNode)((Object)activatedNodes[0].getLookup().lookup(BaseNode.class));
        RequestProcessor.getDefault().post(new Runnable(){

            @Override
            public void run() {
                CreateViewAction.this.perform(node);
            }
        });
    }

    private void perform(BaseNode node) {
        DatabaseConnection connection = (DatabaseConnection)node.getLookup().lookup(DatabaseConnection.class);
        String schemaName = CreateViewAction.findSchemaWorkingName(node.getLookup());
        try {
            boolean viewsSupported = connection.getConnector().getDriverSpecification(schemaName).areViewsSupported();
            if (!viewsSupported) {
                String message = NbBundle.getMessage(CreateViewAction.class, (String)"MSG_ViewsAreNotSupported", (Object)connection.getJDBCConnection().getMetaData().getDatabaseProductName().trim());
                DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)message, 1));
                return;
            }
            Specification spec = connection.getConnector().getDatabaseSpecification();
            boolean viewAdded = AddViewDialog.showDialogAndCreate(spec, schemaName);
            if (viewAdded) {
                ((RefreshAction)SystemAction.get(RefreshAction.class)).performAction(new Node[]{node});
            }
        }
        catch (Exception exc) {
            Logger.getLogger(CreateViewAction.class.getName()).log(Level.INFO, exc.getLocalizedMessage(), exc);
            DbUtilities.reportError(NbBundle.getMessage(CreateViewAction.class, (String)"ERR_UnableToCreateView"), exc.getMessage());
        }
    }

    public String getName() {
        return NbBundle.getMessage(CreateViewAction.class, (String)"AddView");
    }
}

