/* $Id$
 * ===========================================================================
 *
 *                            PUBLIC DOMAIN NOTICE
 *               National Center for Biotechnology Information
 *
 *  This software/database is a "United States Government Work" under the
 *  terms of the United States Copyright Act.  It was written as part of
 *  the author's official duties as a United States Government employee and
 *  thus cannot be copyrighted.  This software/database is freely available
 *  to the public for use. The National Library of Medicine and the U.S.
 *  Government have not placed any restriction on its use or reproduction.
 *
 *  Although all reasonable efforts have been taken to ensure the accuracy
 *  and reliability of the software and data, the NLM and the U.S.
 *  Government do not and cannot warrant the performance or results that
 *  may be obtained by using this software or data. The NLM and the U.S.
 *  Government disclaim all warranties, express or implied, including
 *  warranties of performance, merchantability or fitness for any particular
 *  purpose.
 *
 *  Please cite the author in any work or product based on this material.
 *
 * ===========================================================================
 *
 */

/// @file SupplMeshList_.hpp
/// Data storage class.
///
/// This file was generated by application DATATOOL
/// using the following specifications:
/// 'efetch.xsd'.
///
/// ATTENTION:
///   Don't edit or commit this file into CVS as this file will
///   be overridden (by DATATOOL) without warning!

#ifndef eutils__OBJTOOLS_EUTILS_EFETCH_SUPPLMESHLIST_BASE_HPP
#define eutils__OBJTOOLS_EUTILS_EFETCH_SUPPLMESHLIST_BASE_HPP

// standard includes
#include <serial/serialbase.hpp>

// generated includes
#include <list>

#ifndef BEGIN_eutils_SCOPE
#  define BEGIN_eutils_SCOPE BEGIN_SCOPE(eutils)
#  define END_eutils_SCOPE END_SCOPE(eutils)
#endif
BEGIN_eutils_SCOPE // namespace eutils::


// forward declarations
class CSupplMeshName;


// generated classes

/////////////////////////////////////////////////////////////////////////////
class CSupplMeshList_Base : public NCBI_NS_NCBI::CSerialObject
{
    typedef NCBI_NS_NCBI::CSerialObject Tparent;
public:
    // constructor
    CSupplMeshList_Base(void);
    // destructor
    virtual ~CSupplMeshList_Base(void);

    // type info
    DECLARE_INTERNAL_TYPE_INFO();

    // types
    typedef CSupplMeshName C_E;
    typedef NCBI_NS_STD::list< NCBI_NS_NCBI::CRef< CSupplMeshName > > TSupplMeshName;

    // member index
    enum class E_memberIndex {
        e__allMandatory = 0,
        e_SupplMeshName
    };
    typedef Tparent::CMemberIndex<E_memberIndex, 2> TmemberIndex;

    // getters
    // setters

    /// mandatory
    /// typedef NCBI_NS_STD::list< NCBI_NS_NCBI::CRef< CSupplMeshName > > TSupplMeshName
    ///  Check whether the SupplMeshName data member has been assigned a value.
    bool IsSetSupplMeshName(void) const;
    /// Check whether it is safe or not to call GetSupplMeshName method.
    bool CanGetSupplMeshName(void) const;
    void ResetSupplMeshName(void);
    const TSupplMeshName& GetSupplMeshName(void) const;
    TSupplMeshName& SetSupplMeshName(void);

    /// Reset the whole object
    virtual void Reset(void);


private:
    // Prohibit copy constructor and assignment operator
    CSupplMeshList_Base(const CSupplMeshList_Base&);
    CSupplMeshList_Base& operator=(const CSupplMeshList_Base&);

    // data
    Uint4 m_set_State[1];
    NCBI_NS_STD::list< NCBI_NS_NCBI::CRef< CSupplMeshName > > m_SupplMeshName;
};






///////////////////////////////////////////////////////////
///////////////////// inline methods //////////////////////
///////////////////////////////////////////////////////////
inline
bool CSupplMeshList_Base::IsSetSupplMeshName(void) const
{
    return ((m_set_State[0] & 0x3) != 0);
}

inline
bool CSupplMeshList_Base::CanGetSupplMeshName(void) const
{
    return true;
}

inline
const CSupplMeshList_Base::TSupplMeshName& CSupplMeshList_Base::GetSupplMeshName(void) const
{
    return m_SupplMeshName;
}

inline
CSupplMeshList_Base::TSupplMeshName& CSupplMeshList_Base::SetSupplMeshName(void)
{
    m_set_State[0] |= 0x1;
    return m_SupplMeshName;
}

///////////////////////////////////////////////////////////
////////////////// end of inline methods //////////////////
///////////////////////////////////////////////////////////





END_eutils_SCOPE // namespace eutils::


#endif // eutils__OBJTOOLS_EUTILS_EFETCH_SUPPLMESHLIST_BASE_HPP
