/* $Id$
 * ===========================================================================
 *
 *                            PUBLIC DOMAIN NOTICE
 *               National Center for Biotechnology Information
 *
 *  This software/database is a "United States Government Work" under the
 *  terms of the United States Copyright Act.  It was written as part of
 *  the author's official duties as a United States Government employee and
 *  thus cannot be copyrighted.  This software/database is freely available
 *  to the public for use. The National Library of Medicine and the U.S.
 *  Government have not placed any restriction on its use or reproduction.
 *
 *  Although all reasonable efforts have been taken to ensure the accuracy
 *  and reliability of the software and data, the NLM and the U.S.
 *  Government do not and cannot warrant the performance or results that
 *  may be obtained by using this software or data. The NLM and the U.S.
 *  Government disclaim all warranties, express or implied, including
 *  warranties of performance, merchantability or fitness for any particular
 *  purpose.
 *
 *  Please cite the author in any work or product based on this material.
 *
 * ===========================================================================
 *
 */

/// @file Semantics_.hpp
/// Data storage class.
///
/// This file was generated by application DATATOOL
/// using the following specifications:
/// 'efetch.xsd'.
///
/// ATTENTION:
///   Don't edit or commit this file into CVS as this file will
///   be overridden (by DATATOOL) without warning!

#ifndef eutils__OBJTOOLS_EUTILS_EFETCH_SEMANTICS_BASE_HPP
#define eutils__OBJTOOLS_EUTILS_EFETCH_SEMANTICS_BASE_HPP

// standard includes
#include <serial/serialbase.hpp>

// generated includes
#include <list>
#include <string>
#include <objtools/eutils/efetch/MathExpression.hpp>

#ifndef BEGIN_eutils_SCOPE
#  define BEGIN_eutils_SCOPE BEGIN_SCOPE(eutils)
#  define END_eutils_SCOPE END_SCOPE(eutils)
#endif
BEGIN_eutils_SCOPE // namespace eutils::


// forward declarations
class CAnnotation;
class CAnnotation_xml;


// generated classes

/////////////////////////////////////////////////////////////////////////////
class CSemantics_Base : public NCBI_NS_NCBI::CSerialObject
{
    typedef NCBI_NS_NCBI::CSerialObject Tparent;
public:
    // constructor
    CSemantics_Base(void);
    // destructor
    virtual ~CSemantics_Base(void);

    // type info
    DECLARE_INTERNAL_TYPE_INFO();

    /////////////////////////////////////////////////////////////////////////////
    class C_Attlist : public NCBI_NS_NCBI::CSerialObject
    {
        typedef NCBI_NS_NCBI::CSerialObject Tparent;
    public:
        // constructor
        C_Attlist(void);
        // destructor
        ~C_Attlist(void);
    
        // type info
        DECLARE_INTERNAL_TYPE_INFO();
    
        // types
        typedef NCBI_NS_STD::string TId;
        typedef NCBI_NS_STD::string TXref;
        typedef NCBI_NS_STD::string TClass;
        typedef NCBI_NS_STD::string TStyle;
        typedef NCBI_NS_STD::string THref;
        typedef NCBI_NS_STD::string TEncoding;
        typedef NCBI_NS_STD::string TDefinitionURL;
        typedef NCBI_NS_STD::string TCd;
        typedef NCBI_NS_STD::string TName;
    
        // member index
        enum class E_memberIndex {
            e__allMandatory = 0,
            e_id,
            e_xref,
            e_class,
            e_style,
            e_href,
            e_encoding,
            e_definitionURL,
            e_cd,
            e_name
        };
        typedef Tparent::CMemberIndex<E_memberIndex, 10> TmemberIndex;
    
        // getters
        // setters
    
        /// optional
        /// typedef NCBI_NS_STD::string TId
        ///  Check whether the Id data member has been assigned a value.
        bool IsSetId(void) const;
        /// Check whether it is safe or not to call GetId method.
        bool CanGetId(void) const;
        void ResetId(void);
        const TId& GetId(void) const;
        void SetId(const TId& value);
        void SetId(TId&& value);
        TId& SetId(void);
    
        /// optional
        /// typedef NCBI_NS_STD::string TXref
        ///  Check whether the Xref data member has been assigned a value.
        bool IsSetXref(void) const;
        /// Check whether it is safe or not to call GetXref method.
        bool CanGetXref(void) const;
        void ResetXref(void);
        const TXref& GetXref(void) const;
        void SetXref(const TXref& value);
        void SetXref(TXref&& value);
        TXref& SetXref(void);
    
        /// optional
        /// typedef NCBI_NS_STD::string TClass
        ///  Check whether the Class data member has been assigned a value.
        bool IsSetClass(void) const;
        /// Check whether it is safe or not to call GetClass method.
        bool CanGetClass(void) const;
        void ResetClass(void);
        const TClass& GetClass(void) const;
        void SetClass(const TClass& value);
        void SetClass(TClass&& value);
        TClass& SetClass(void);
    
        /// optional
        /// typedef NCBI_NS_STD::string TStyle
        ///  Check whether the Style data member has been assigned a value.
        bool IsSetStyle(void) const;
        /// Check whether it is safe or not to call GetStyle method.
        bool CanGetStyle(void) const;
        void ResetStyle(void);
        const TStyle& GetStyle(void) const;
        void SetStyle(const TStyle& value);
        void SetStyle(TStyle&& value);
        TStyle& SetStyle(void);
    
        /// optional
        /// typedef NCBI_NS_STD::string THref
        ///  Check whether the Href data member has been assigned a value.
        bool IsSetHref(void) const;
        /// Check whether it is safe or not to call GetHref method.
        bool CanGetHref(void) const;
        void ResetHref(void);
        const THref& GetHref(void) const;
        void SetHref(const THref& value);
        void SetHref(THref&& value);
        THref& SetHref(void);
    
        /// optional
        /// typedef NCBI_NS_STD::string TEncoding
        ///  Check whether the Encoding data member has been assigned a value.
        bool IsSetEncoding(void) const;
        /// Check whether it is safe or not to call GetEncoding method.
        bool CanGetEncoding(void) const;
        void ResetEncoding(void);
        const TEncoding& GetEncoding(void) const;
        void SetEncoding(const TEncoding& value);
        void SetEncoding(TEncoding&& value);
        TEncoding& SetEncoding(void);
    
        /// optional
        /// typedef NCBI_NS_STD::string TDefinitionURL
        ///  Check whether the DefinitionURL data member has been assigned a value.
        bool IsSetDefinitionURL(void) const;
        /// Check whether it is safe or not to call GetDefinitionURL method.
        bool CanGetDefinitionURL(void) const;
        void ResetDefinitionURL(void);
        const TDefinitionURL& GetDefinitionURL(void) const;
        void SetDefinitionURL(const TDefinitionURL& value);
        void SetDefinitionURL(TDefinitionURL&& value);
        TDefinitionURL& SetDefinitionURL(void);
    
        /// optional
        /// typedef NCBI_NS_STD::string TCd
        ///  Check whether the Cd data member has been assigned a value.
        bool IsSetCd(void) const;
        /// Check whether it is safe or not to call GetCd method.
        bool CanGetCd(void) const;
        void ResetCd(void);
        const TCd& GetCd(void) const;
        void SetCd(const TCd& value);
        void SetCd(TCd&& value);
        TCd& SetCd(void);
    
        /// optional
        /// typedef NCBI_NS_STD::string TName
        ///  Check whether the Name data member has been assigned a value.
        bool IsSetName(void) const;
        /// Check whether it is safe or not to call GetName method.
        bool CanGetName(void) const;
        void ResetName(void);
        const TName& GetName(void) const;
        void SetName(const TName& value);
        void SetName(TName&& value);
        TName& SetName(void);
    
        /// Reset the whole object
        void Reset(void);
    
    
    private:
        // Prohibit copy constructor and assignment operator
        C_Attlist(const C_Attlist&);
        C_Attlist& operator=(const C_Attlist&);
    
        // data
        Uint4 m_set_State[1];
        NCBI_NS_STD::string m_Id;
        NCBI_NS_STD::string m_Xref;
        NCBI_NS_STD::string m_Class;
        NCBI_NS_STD::string m_Style;
        NCBI_NS_STD::string m_Href;
        NCBI_NS_STD::string m_Encoding;
        NCBI_NS_STD::string m_DefinitionURL;
        NCBI_NS_STD::string m_Cd;
        NCBI_NS_STD::string m_Name;
    };
    typedef CMathExpression C_MathExpression;
    /////////////////////////////////////////////////////////////////////////////
    class C_AA : public NCBI_NS_NCBI::CSerialObject
    {
        typedef NCBI_NS_NCBI::CSerialObject Tparent;
    public:
        // constructor
        C_AA(void);
        // destructor
        ~C_AA(void);
    
        // type info
        DECLARE_INTERNAL_TYPE_INFO();
    
        /////////////////////////////////////////////////////////////////////////////
        class C_E_AA : public NCBI_NS_NCBI::CSerialObject
        {
            typedef NCBI_NS_NCBI::CSerialObject Tparent;
        public:
            // constructor
            C_E_AA(void);
            // destructor
            ~C_E_AA(void);
        
            // type info
            DECLARE_INTERNAL_TYPE_INFO();
        
        
            /// Choice variants.
            enum E_Choice {
                e_not_set = 0,     ///< No variant selected
                e_Annotation,
                e_Annotation_xml
            };
            /// Maximum+1 value of the choice variant enumerator.
            enum E_ChoiceStopper {
                e_MaxChoice = 3 ///< == e_Annotation_xml+1
            };
        
            /// Reset the whole object
            void Reset(void);
        
            /// Reset the selection (set it to e_not_set).
            void ResetSelection(void);
        
            /// Which variant is currently selected.
            E_Choice Which(void) const;
        
            /// Verify selection, throw exception if it differs from the expected.
            void CheckSelected(E_Choice index) const;
        
            /// Throw 'InvalidSelection' exception.
            NCBI_NORETURN void ThrowInvalidSelection(E_Choice index) const;
        
            /// Retrieve selection name (for diagnostic purposes).
            static NCBI_NS_STD::string SelectionName(E_Choice index);
        
            /// Select the requested variant if needed.
            void Select(E_Choice index, NCBI_NS_NCBI::EResetVariant reset = NCBI_NS_NCBI::eDoResetVariant);
            /// Select the requested variant if needed,
            /// allocating CObject variants from memory pool.
            void Select(E_Choice index,
                        NCBI_NS_NCBI::EResetVariant reset,
                        NCBI_NS_NCBI::CObjectMemoryPool* pool);
        
            // types
            typedef CAnnotation TAnnotation;
            typedef CAnnotation_xml TAnnotation_xml;
        
            // getters
            // setters
        
            // typedef CAnnotation TAnnotation
            bool IsAnnotation(void) const;
            const TAnnotation& GetAnnotation(void) const;
            TAnnotation& SetAnnotation(void);
            void SetAnnotation(TAnnotation& value);
        
            // typedef CAnnotation_xml TAnnotation_xml
            bool IsAnnotation_xml(void) const;
            const TAnnotation_xml& GetAnnotation_xml(void) const;
            TAnnotation_xml& SetAnnotation_xml(void);
            void SetAnnotation_xml(TAnnotation_xml& value);
        
        
        private:
            // copy constructor and assignment operator
            C_E_AA(const C_E_AA& );
            C_E_AA& operator=(const C_E_AA& );
            // choice state
            E_Choice m_choice;
            // helper methods
            void DoSelect(E_Choice index, NCBI_NS_NCBI::CObjectMemoryPool* pool = 0);
        
            static const char* const sm_SelectionNames[];
            // data
            NCBI_NS_NCBI::CSerialObject *m_object;
        };
        // types
        typedef C_E_AA C_E;
        typedef NCBI_NS_STD::list< NCBI_NS_NCBI::CRef< C_E_AA > > TAA;
    
        // member index
        enum class E_memberIndex {
            e__allMandatory = 0,
            e_AA
        };
        typedef Tparent::CMemberIndex<E_memberIndex, 2> TmemberIndex;
    
        // getters
        // setters
    
        /// optional
        /// typedef NCBI_NS_STD::list< NCBI_NS_NCBI::CRef< C_E_AA > > TAA
        ///  Check whether the AA data member has been assigned a value.
        bool IsSetAA(void) const;
        /// Check whether it is safe or not to call GetAA method.
        bool CanGetAA(void) const;
        void ResetAA(void);
        const TAA& GetAA(void) const;
        TAA& SetAA(void);
    
        /// Reset the whole object
        void Reset(void);
    
    
    private:
        // Prohibit copy constructor and assignment operator
        C_AA(const C_AA&);
        C_AA& operator=(const C_AA&);
    
        // data
        Uint4 m_set_State[1];
        NCBI_NS_STD::list< NCBI_NS_NCBI::CRef< C_E_AA > > m_AA;
    };
    // types
    typedef C_Attlist TAttlist;
    typedef C_MathExpression TMathExpression;
    typedef C_AA TAA;

    // member index
    enum class E_memberIndex {
        e__allMandatory = 0,
        e_Attlist,
        e_MathExpression,
        e_AA
    };
    typedef Tparent::CMemberIndex<E_memberIndex, 4> TmemberIndex;

    // getters
    // setters

    /// mandatory
    /// typedef C_Attlist TAttlist
    ///  Check whether the Attlist data member has been assigned a value.
    bool IsSetAttlist(void) const;
    /// Check whether it is safe or not to call GetAttlist method.
    bool CanGetAttlist(void) const;
    void ResetAttlist(void);
    const TAttlist& GetAttlist(void) const;
    void SetAttlist(TAttlist& value);
    TAttlist& SetAttlist(void);

    /// mandatory
    /// typedef C_MathExpression TMathExpression
    ///  Check whether the MathExpression data member has been assigned a value.
    bool IsSetMathExpression(void) const;
    /// Check whether it is safe or not to call GetMathExpression method.
    bool CanGetMathExpression(void) const;
    void ResetMathExpression(void);
    const TMathExpression& GetMathExpression(void) const;
    void SetMathExpression(TMathExpression& value);
    TMathExpression& SetMathExpression(void);

    /// optional
    /// typedef C_AA TAA
    ///  Check whether the AA data member has been assigned a value.
    bool IsSetAA(void) const;
    /// Check whether it is safe or not to call GetAA method.
    bool CanGetAA(void) const;
    void ResetAA(void);
    const TAA& GetAA(void) const;
    void SetAA(TAA& value);
    TAA& SetAA(void);

    /// Reset the whole object
    virtual void Reset(void);


private:
    // Prohibit copy constructor and assignment operator
    CSemantics_Base(const CSemantics_Base&);
    CSemantics_Base& operator=(const CSemantics_Base&);

    // data
    Uint4 m_set_State[1];
    NCBI_NS_NCBI::CRef< TAttlist > m_Attlist;
    NCBI_NS_NCBI::CRef< TMathExpression > m_MathExpression;
    NCBI_NS_NCBI::CRef< TAA > m_AA;
};






///////////////////////////////////////////////////////////
///////////////////// inline methods //////////////////////
///////////////////////////////////////////////////////////
inline
bool CSemantics_Base::C_Attlist::IsSetId(void) const
{
    return ((m_set_State[0] & 0x3) != 0);
}

inline
bool CSemantics_Base::C_Attlist::CanGetId(void) const
{
    return IsSetId();
}

inline
const CSemantics_Base::C_Attlist::TId& CSemantics_Base::C_Attlist::GetId(void) const
{
    if (!CanGetId()) {
        ThrowUnassigned(0);
    }
    return m_Id;
}

inline
void CSemantics_Base::C_Attlist::SetId(const CSemantics_Base::C_Attlist::TId& value)
{
    m_Id = value;
    m_set_State[0] |= 0x3;
}

inline
void CSemantics_Base::C_Attlist::SetId(CSemantics_Base::C_Attlist::TId&& value)
{
    m_Id = std::forward<CSemantics_Base::C_Attlist::TId>(value);
    m_set_State[0] |= 0x3;
}

inline
CSemantics_Base::C_Attlist::TId& CSemantics_Base::C_Attlist::SetId(void)
{
#ifdef _DEBUG
    if (!IsSetId()) {
        m_Id = UnassignedString();
    }
#endif
    m_set_State[0] |= 0x1;
    return m_Id;
}

inline
bool CSemantics_Base::C_Attlist::IsSetXref(void) const
{
    return ((m_set_State[0] & 0xc) != 0);
}

inline
bool CSemantics_Base::C_Attlist::CanGetXref(void) const
{
    return IsSetXref();
}

inline
const CSemantics_Base::C_Attlist::TXref& CSemantics_Base::C_Attlist::GetXref(void) const
{
    if (!CanGetXref()) {
        ThrowUnassigned(1);
    }
    return m_Xref;
}

inline
void CSemantics_Base::C_Attlist::SetXref(const CSemantics_Base::C_Attlist::TXref& value)
{
    m_Xref = value;
    m_set_State[0] |= 0xc;
}

inline
void CSemantics_Base::C_Attlist::SetXref(CSemantics_Base::C_Attlist::TXref&& value)
{
    m_Xref = std::forward<CSemantics_Base::C_Attlist::TXref>(value);
    m_set_State[0] |= 0xc;
}

inline
CSemantics_Base::C_Attlist::TXref& CSemantics_Base::C_Attlist::SetXref(void)
{
#ifdef _DEBUG
    if (!IsSetXref()) {
        m_Xref = UnassignedString();
    }
#endif
    m_set_State[0] |= 0x4;
    return m_Xref;
}

inline
bool CSemantics_Base::C_Attlist::IsSetClass(void) const
{
    return ((m_set_State[0] & 0x30) != 0);
}

inline
bool CSemantics_Base::C_Attlist::CanGetClass(void) const
{
    return IsSetClass();
}

inline
const CSemantics_Base::C_Attlist::TClass& CSemantics_Base::C_Attlist::GetClass(void) const
{
    if (!CanGetClass()) {
        ThrowUnassigned(2);
    }
    return m_Class;
}

inline
void CSemantics_Base::C_Attlist::SetClass(const CSemantics_Base::C_Attlist::TClass& value)
{
    m_Class = value;
    m_set_State[0] |= 0x30;
}

inline
void CSemantics_Base::C_Attlist::SetClass(CSemantics_Base::C_Attlist::TClass&& value)
{
    m_Class = std::forward<CSemantics_Base::C_Attlist::TClass>(value);
    m_set_State[0] |= 0x30;
}

inline
CSemantics_Base::C_Attlist::TClass& CSemantics_Base::C_Attlist::SetClass(void)
{
#ifdef _DEBUG
    if (!IsSetClass()) {
        m_Class = UnassignedString();
    }
#endif
    m_set_State[0] |= 0x10;
    return m_Class;
}

inline
bool CSemantics_Base::C_Attlist::IsSetStyle(void) const
{
    return ((m_set_State[0] & 0xc0) != 0);
}

inline
bool CSemantics_Base::C_Attlist::CanGetStyle(void) const
{
    return IsSetStyle();
}

inline
const CSemantics_Base::C_Attlist::TStyle& CSemantics_Base::C_Attlist::GetStyle(void) const
{
    if (!CanGetStyle()) {
        ThrowUnassigned(3);
    }
    return m_Style;
}

inline
void CSemantics_Base::C_Attlist::SetStyle(const CSemantics_Base::C_Attlist::TStyle& value)
{
    m_Style = value;
    m_set_State[0] |= 0xc0;
}

inline
void CSemantics_Base::C_Attlist::SetStyle(CSemantics_Base::C_Attlist::TStyle&& value)
{
    m_Style = std::forward<CSemantics_Base::C_Attlist::TStyle>(value);
    m_set_State[0] |= 0xc0;
}

inline
CSemantics_Base::C_Attlist::TStyle& CSemantics_Base::C_Attlist::SetStyle(void)
{
#ifdef _DEBUG
    if (!IsSetStyle()) {
        m_Style = UnassignedString();
    }
#endif
    m_set_State[0] |= 0x40;
    return m_Style;
}

inline
bool CSemantics_Base::C_Attlist::IsSetHref(void) const
{
    return ((m_set_State[0] & 0x300) != 0);
}

inline
bool CSemantics_Base::C_Attlist::CanGetHref(void) const
{
    return IsSetHref();
}

inline
const CSemantics_Base::C_Attlist::THref& CSemantics_Base::C_Attlist::GetHref(void) const
{
    if (!CanGetHref()) {
        ThrowUnassigned(4);
    }
    return m_Href;
}

inline
void CSemantics_Base::C_Attlist::SetHref(const CSemantics_Base::C_Attlist::THref& value)
{
    m_Href = value;
    m_set_State[0] |= 0x300;
}

inline
void CSemantics_Base::C_Attlist::SetHref(CSemantics_Base::C_Attlist::THref&& value)
{
    m_Href = std::forward<CSemantics_Base::C_Attlist::THref>(value);
    m_set_State[0] |= 0x300;
}

inline
CSemantics_Base::C_Attlist::THref& CSemantics_Base::C_Attlist::SetHref(void)
{
#ifdef _DEBUG
    if (!IsSetHref()) {
        m_Href = UnassignedString();
    }
#endif
    m_set_State[0] |= 0x100;
    return m_Href;
}

inline
bool CSemantics_Base::C_Attlist::IsSetEncoding(void) const
{
    return ((m_set_State[0] & 0xc00) != 0);
}

inline
bool CSemantics_Base::C_Attlist::CanGetEncoding(void) const
{
    return IsSetEncoding();
}

inline
const CSemantics_Base::C_Attlist::TEncoding& CSemantics_Base::C_Attlist::GetEncoding(void) const
{
    if (!CanGetEncoding()) {
        ThrowUnassigned(5);
    }
    return m_Encoding;
}

inline
void CSemantics_Base::C_Attlist::SetEncoding(const CSemantics_Base::C_Attlist::TEncoding& value)
{
    m_Encoding = value;
    m_set_State[0] |= 0xc00;
}

inline
void CSemantics_Base::C_Attlist::SetEncoding(CSemantics_Base::C_Attlist::TEncoding&& value)
{
    m_Encoding = std::forward<CSemantics_Base::C_Attlist::TEncoding>(value);
    m_set_State[0] |= 0xc00;
}

inline
CSemantics_Base::C_Attlist::TEncoding& CSemantics_Base::C_Attlist::SetEncoding(void)
{
#ifdef _DEBUG
    if (!IsSetEncoding()) {
        m_Encoding = UnassignedString();
    }
#endif
    m_set_State[0] |= 0x400;
    return m_Encoding;
}

inline
bool CSemantics_Base::C_Attlist::IsSetDefinitionURL(void) const
{
    return ((m_set_State[0] & 0x3000) != 0);
}

inline
bool CSemantics_Base::C_Attlist::CanGetDefinitionURL(void) const
{
    return IsSetDefinitionURL();
}

inline
const CSemantics_Base::C_Attlist::TDefinitionURL& CSemantics_Base::C_Attlist::GetDefinitionURL(void) const
{
    if (!CanGetDefinitionURL()) {
        ThrowUnassigned(6);
    }
    return m_DefinitionURL;
}

inline
void CSemantics_Base::C_Attlist::SetDefinitionURL(const CSemantics_Base::C_Attlist::TDefinitionURL& value)
{
    m_DefinitionURL = value;
    m_set_State[0] |= 0x3000;
}

inline
void CSemantics_Base::C_Attlist::SetDefinitionURL(CSemantics_Base::C_Attlist::TDefinitionURL&& value)
{
    m_DefinitionURL = std::forward<CSemantics_Base::C_Attlist::TDefinitionURL>(value);
    m_set_State[0] |= 0x3000;
}

inline
CSemantics_Base::C_Attlist::TDefinitionURL& CSemantics_Base::C_Attlist::SetDefinitionURL(void)
{
#ifdef _DEBUG
    if (!IsSetDefinitionURL()) {
        m_DefinitionURL = UnassignedString();
    }
#endif
    m_set_State[0] |= 0x1000;
    return m_DefinitionURL;
}

inline
bool CSemantics_Base::C_Attlist::IsSetCd(void) const
{
    return ((m_set_State[0] & 0xc000) != 0);
}

inline
bool CSemantics_Base::C_Attlist::CanGetCd(void) const
{
    return IsSetCd();
}

inline
const CSemantics_Base::C_Attlist::TCd& CSemantics_Base::C_Attlist::GetCd(void) const
{
    if (!CanGetCd()) {
        ThrowUnassigned(7);
    }
    return m_Cd;
}

inline
void CSemantics_Base::C_Attlist::SetCd(const CSemantics_Base::C_Attlist::TCd& value)
{
    m_Cd = value;
    m_set_State[0] |= 0xc000;
}

inline
void CSemantics_Base::C_Attlist::SetCd(CSemantics_Base::C_Attlist::TCd&& value)
{
    m_Cd = std::forward<CSemantics_Base::C_Attlist::TCd>(value);
    m_set_State[0] |= 0xc000;
}

inline
CSemantics_Base::C_Attlist::TCd& CSemantics_Base::C_Attlist::SetCd(void)
{
#ifdef _DEBUG
    if (!IsSetCd()) {
        m_Cd = UnassignedString();
    }
#endif
    m_set_State[0] |= 0x4000;
    return m_Cd;
}

inline
bool CSemantics_Base::C_Attlist::IsSetName(void) const
{
    return ((m_set_State[0] & 0x30000) != 0);
}

inline
bool CSemantics_Base::C_Attlist::CanGetName(void) const
{
    return IsSetName();
}

inline
const CSemantics_Base::C_Attlist::TName& CSemantics_Base::C_Attlist::GetName(void) const
{
    if (!CanGetName()) {
        ThrowUnassigned(8);
    }
    return m_Name;
}

inline
void CSemantics_Base::C_Attlist::SetName(const CSemantics_Base::C_Attlist::TName& value)
{
    m_Name = value;
    m_set_State[0] |= 0x30000;
}

inline
void CSemantics_Base::C_Attlist::SetName(CSemantics_Base::C_Attlist::TName&& value)
{
    m_Name = std::forward<CSemantics_Base::C_Attlist::TName>(value);
    m_set_State[0] |= 0x30000;
}

inline
CSemantics_Base::C_Attlist::TName& CSemantics_Base::C_Attlist::SetName(void)
{
#ifdef _DEBUG
    if (!IsSetName()) {
        m_Name = UnassignedString();
    }
#endif
    m_set_State[0] |= 0x10000;
    return m_Name;
}

inline
CSemantics_Base::C_AA::C_E_AA::E_Choice CSemantics_Base::C_AA::C_E_AA::Which(void) const
{
    return m_choice;
}

inline
void CSemantics_Base::C_AA::C_E_AA::CheckSelected(E_Choice index) const
{
    if ( m_choice != index )
        ThrowInvalidSelection(index);
}

inline
void CSemantics_Base::C_AA::C_E_AA::Select(E_Choice index, NCBI_NS_NCBI::EResetVariant reset, NCBI_NS_NCBI::CObjectMemoryPool* pool)
{
    if ( reset == NCBI_NS_NCBI::eDoResetVariant || m_choice != index ) {
        if ( m_choice != e_not_set )
            ResetSelection();
        DoSelect(index, pool);
    }
}

inline
void CSemantics_Base::C_AA::C_E_AA::Select(E_Choice index, NCBI_NS_NCBI::EResetVariant reset)
{
    Select(index, reset, 0);
}

inline
bool CSemantics_Base::C_AA::C_E_AA::IsAnnotation(void) const
{
    return m_choice == e_Annotation;
}

inline
bool CSemantics_Base::C_AA::C_E_AA::IsAnnotation_xml(void) const
{
    return m_choice == e_Annotation_xml;
}

inline
bool CSemantics_Base::C_AA::IsSetAA(void) const
{
    return ((m_set_State[0] & 0x3) != 0);
}

inline
bool CSemantics_Base::C_AA::CanGetAA(void) const
{
    return true;
}

inline
const CSemantics_Base::C_AA::TAA& CSemantics_Base::C_AA::GetAA(void) const
{
    return m_AA;
}

inline
CSemantics_Base::C_AA::TAA& CSemantics_Base::C_AA::SetAA(void)
{
    m_set_State[0] |= 0x1;
    return m_AA;
}

inline
bool CSemantics_Base::IsSetAttlist(void) const
{
    return m_Attlist.NotEmpty();
}

inline
bool CSemantics_Base::CanGetAttlist(void) const
{
    return true;
}

inline
const CSemantics_Base::TAttlist& CSemantics_Base::GetAttlist(void) const
{
    if ( !m_Attlist ) {
        const_cast<CSemantics_Base*>(this)->ResetAttlist();
    }
    return (*m_Attlist);
}

inline
CSemantics_Base::TAttlist& CSemantics_Base::SetAttlist(void)
{
    if ( !m_Attlist ) {
        ResetAttlist();
    }
    return (*m_Attlist);
}

inline
bool CSemantics_Base::IsSetMathExpression(void) const
{
    return m_MathExpression.NotEmpty();
}

inline
bool CSemantics_Base::CanGetMathExpression(void) const
{
    return true;
}

inline
const CSemantics_Base::TMathExpression& CSemantics_Base::GetMathExpression(void) const
{
    if ( !m_MathExpression ) {
        const_cast<CSemantics_Base*>(this)->ResetMathExpression();
    }
    return (*m_MathExpression);
}

inline
CSemantics_Base::TMathExpression& CSemantics_Base::SetMathExpression(void)
{
    if ( !m_MathExpression ) {
        ResetMathExpression();
    }
    return (*m_MathExpression);
}

inline
bool CSemantics_Base::IsSetAA(void) const
{
    return m_AA.NotEmpty();
}

inline
bool CSemantics_Base::CanGetAA(void) const
{
    return IsSetAA();
}

inline
const CSemantics_Base::TAA& CSemantics_Base::GetAA(void) const
{
    if (!CanGetAA()) {
        ThrowUnassigned(2);
    }
    return (*m_AA);
}

///////////////////////////////////////////////////////////
////////////////// end of inline methods //////////////////
///////////////////////////////////////////////////////////





END_eutils_SCOPE // namespace eutils::


#endif // eutils__OBJTOOLS_EUTILS_EFETCH_SEMANTICS_BASE_HPP
