/* $Id$
 * ===========================================================================
 *
 *                            PUBLIC DOMAIN NOTICE
 *               National Center for Biotechnology Information
 *
 *  This software/database is a "United States Government Work" under the
 *  terms of the United States Copyright Act.  It was written as part of
 *  the author's official duties as a United States Government employee and
 *  thus cannot be copyrighted.  This software/database is freely available
 *  to the public for use. The National Library of Medicine and the U.S.
 *  Government have not placed any restriction on its use or reproduction.
 *
 *  Although all reasonable efforts have been taken to ensure the accuracy
 *  and reliability of the software and data, the NLM and the U.S.
 *  Government do not and cannot warrant the performance or results that
 *  may be obtained by using this software or data. The NLM and the U.S.
 *  Government disclaim all warranties, express or implied, including
 *  warranties of performance, merchantability or fitness for any particular
 *  purpose.
 *
 *  Please cite the author in any work or product based on this material.
 *
 * ===========================================================================
 *
 */

/// @file QualifierName.hpp
/// User-defined methods of the data storage class.
///
/// This file was originally generated by application DATATOOL
/// using the following specifications:
/// 'efetch.xsd'.
///
/// New methods or data members can be added to it if needed.
/// See also: QualifierName_.hpp


#ifndef eutils__OBJTOOLS_EUTILS_EFETCH_QUALIFIERNAME_HPP
#define eutils__OBJTOOLS_EUTILS_EFETCH_QUALIFIERNAME_HPP


// generated includes
#include <objtools/eutils/efetch/QualifierName_.hpp>

// generated classes

BEGIN_eutils_SCOPE // namespace eutils::

/////////////////////////////////////////////////////////////////////////////
class CQualifierName : public CQualifierName_Base
{
    typedef CQualifierName_Base Tparent;
public:
    // constructor
    CQualifierName(void);
    CQualifierName(const std::string& value);
    // destructor
    ~CQualifierName(void);

    // typedef std::string TQualifierName;

    /// Conversion operator to 'TQualifierName' type.
    operator const TQualifierName&(void) const;
    /// Assignment operator.
    CQualifierName& operator=(const TQualifierName& value);

private:
    // Prohibit copy constructor and assignment operator
    CQualifierName(const CQualifierName& value);
    CQualifierName& operator=(const CQualifierName& value);

};

/////////////////// CQualifierName inline methods

// constructor
inline
CQualifierName::CQualifierName(void)
{
}

inline
CQualifierName::CQualifierName(const std::string& value)
{
    SetQualifierName(value);
}

inline
CQualifierName::operator const CQualifierName::TQualifierName&(void) const
{
    return GetQualifierName();
}

inline
CQualifierName& CQualifierName::operator=(const TQualifierName& value)
{
    SetQualifierName(value);
    return *this;
}


/////////////////// end of CQualifierName inline methods


END_eutils_SCOPE // namespace eutils::


#endif // eutils__OBJTOOLS_EUTILS_EFETCH_QUALIFIERNAME_HPP
/* Original file checksum: lines: 109, chars: 3078, CRC32: df56926c */
