/* $Id$
 * ===========================================================================
 *
 *                            PUBLIC DOMAIN NOTICE
 *               National Center for Biotechnology Information
 *
 *  This software/database is a "United States Government Work" under the
 *  terms of the United States Copyright Act.  It was written as part of
 *  the author's official duties as a United States Government employee and
 *  thus cannot be copyrighted.  This software/database is freely available
 *  to the public for use. The National Library of Medicine and the U.S.
 *  Government have not placed any restriction on its use or reproduction.
 *
 *  Although all reasonable efforts have been taken to ensure the accuracy
 *  and reliability of the software and data, the NLM and the U.S.
 *  Government do not and cannot warrant the performance or results that
 *  may be obtained by using this software or data. The NLM and the U.S.
 *  Government disclaim all warranties, express or implied, including
 *  warranties of performance, merchantability or fitness for any particular
 *  purpose.
 *
 *  Please cite the author in any work or product based on this material.
 *
 * ===========================================================================
 *
 */

/// @file Mscarry_.hpp
/// Data storage class.
///
/// This file was generated by application DATATOOL
/// using the following specifications:
/// 'efetch.xsd'.
///
/// ATTENTION:
///   Don't edit or commit this file into CVS as this file will
///   be overridden (by DATATOOL) without warning!

#ifndef eutils__OBJTOOLS_EUTILS_EFETCH_MSCARRY_BASE_HPP
#define eutils__OBJTOOLS_EUTILS_EFETCH_MSCARRY_BASE_HPP

// standard includes
#include <serial/serialbase.hpp>

// generated includes
#include <list>
#include <string>
#include <objtools/eutils/efetch/MsrowExpression.hpp>

#ifndef BEGIN_eutils_SCOPE
#  define BEGIN_eutils_SCOPE BEGIN_SCOPE(eutils)
#  define END_eutils_SCOPE END_SCOPE(eutils)
#endif
BEGIN_eutils_SCOPE // namespace eutils::


// generated classes

/////////////////////////////////////////////////////////////////////////////
class CMscarry_Base : public NCBI_NS_NCBI::CSerialObject
{
    typedef NCBI_NS_NCBI::CSerialObject Tparent;
public:
    // constructor
    CMscarry_Base(void);
    // destructor
    virtual ~CMscarry_Base(void);

    // type info
    DECLARE_INTERNAL_TYPE_INFO();

    /////////////////////////////////////////////////////////////////////////////
    class C_Attlist : public NCBI_NS_NCBI::CSerialObject
    {
        typedef NCBI_NS_NCBI::CSerialObject Tparent;
    public:
        // constructor
        C_Attlist(void);
        // destructor
        ~C_Attlist(void);
    
        // type info
        DECLARE_INTERNAL_TYPE_INFO();
    
        enum EAttlist_location {
            eAttlist_location_w  = 1,
            eAttlist_location_nw = 2,
            eAttlist_location_n  = 3,
            eAttlist_location_ne = 4,
            eAttlist_location_e  = 5,
            eAttlist_location_se = 6,
            eAttlist_location_s  = 7,
            eAttlist_location_sw = 8
        };
        
        /// Access to EAttlist_location's attributes (values, names) as defined in spec
        static const NCBI_NS_NCBI::CEnumeratedTypeValues* ENUM_METHOD_NAME(EAttlist_location)(void);
        
        // types
        typedef NCBI_NS_STD::string TId;
        typedef NCBI_NS_STD::string TXref;
        typedef NCBI_NS_STD::string TClass;
        typedef NCBI_NS_STD::string TStyle;
        typedef NCBI_NS_STD::string THref;
        typedef NCBI_NS_STD::string TMathcolor;
        typedef NCBI_NS_STD::string TMathbackground;
        typedef EAttlist_location TLocation;
        typedef NCBI_NS_STD::string TCrossout;
    
        // member index
        enum class E_memberIndex {
            e__allMandatory = 0,
            e_id,
            e_xref,
            e_class,
            e_style,
            e_href,
            e_mathcolor,
            e_mathbackground,
            e_location,
            e_crossout
        };
        typedef Tparent::CMemberIndex<E_memberIndex, 10> TmemberIndex;
    
        // getters
        // setters
    
        /// optional
        /// typedef NCBI_NS_STD::string TId
        ///  Check whether the Id data member has been assigned a value.
        bool IsSetId(void) const;
        /// Check whether it is safe or not to call GetId method.
        bool CanGetId(void) const;
        void ResetId(void);
        const TId& GetId(void) const;
        void SetId(const TId& value);
        void SetId(TId&& value);
        TId& SetId(void);
    
        /// optional
        /// typedef NCBI_NS_STD::string TXref
        ///  Check whether the Xref data member has been assigned a value.
        bool IsSetXref(void) const;
        /// Check whether it is safe or not to call GetXref method.
        bool CanGetXref(void) const;
        void ResetXref(void);
        const TXref& GetXref(void) const;
        void SetXref(const TXref& value);
        void SetXref(TXref&& value);
        TXref& SetXref(void);
    
        /// optional
        /// typedef NCBI_NS_STD::string TClass
        ///  Check whether the Class data member has been assigned a value.
        bool IsSetClass(void) const;
        /// Check whether it is safe or not to call GetClass method.
        bool CanGetClass(void) const;
        void ResetClass(void);
        const TClass& GetClass(void) const;
        void SetClass(const TClass& value);
        void SetClass(TClass&& value);
        TClass& SetClass(void);
    
        /// optional
        /// typedef NCBI_NS_STD::string TStyle
        ///  Check whether the Style data member has been assigned a value.
        bool IsSetStyle(void) const;
        /// Check whether it is safe or not to call GetStyle method.
        bool CanGetStyle(void) const;
        void ResetStyle(void);
        const TStyle& GetStyle(void) const;
        void SetStyle(const TStyle& value);
        void SetStyle(TStyle&& value);
        TStyle& SetStyle(void);
    
        /// optional
        /// typedef NCBI_NS_STD::string THref
        ///  Check whether the Href data member has been assigned a value.
        bool IsSetHref(void) const;
        /// Check whether it is safe or not to call GetHref method.
        bool CanGetHref(void) const;
        void ResetHref(void);
        const THref& GetHref(void) const;
        void SetHref(const THref& value);
        void SetHref(THref&& value);
        THref& SetHref(void);
    
        /// optional
        /// typedef NCBI_NS_STD::string TMathcolor
        ///  Check whether the Mathcolor data member has been assigned a value.
        bool IsSetMathcolor(void) const;
        /// Check whether it is safe or not to call GetMathcolor method.
        bool CanGetMathcolor(void) const;
        void ResetMathcolor(void);
        const TMathcolor& GetMathcolor(void) const;
        void SetMathcolor(const TMathcolor& value);
        void SetMathcolor(TMathcolor&& value);
        TMathcolor& SetMathcolor(void);
    
        /// optional
        /// typedef NCBI_NS_STD::string TMathbackground
        ///  Check whether the Mathbackground data member has been assigned a value.
        bool IsSetMathbackground(void) const;
        /// Check whether it is safe or not to call GetMathbackground method.
        bool CanGetMathbackground(void) const;
        void ResetMathbackground(void);
        const TMathbackground& GetMathbackground(void) const;
        void SetMathbackground(const TMathbackground& value);
        void SetMathbackground(TMathbackground&& value);
        TMathbackground& SetMathbackground(void);
    
        /// optional
        /// typedef EAttlist_location TLocation
        ///  Check whether the Location data member has been assigned a value.
        bool IsSetLocation(void) const;
        /// Check whether it is safe or not to call GetLocation method.
        bool CanGetLocation(void) const;
        void ResetLocation(void);
        TLocation GetLocation(void) const;
        void SetLocation(TLocation value);
        TLocation& SetLocation(void);
    
        /// optional
        /// typedef NCBI_NS_STD::string TCrossout
        ///  Check whether the Crossout data member has been assigned a value.
        bool IsSetCrossout(void) const;
        /// Check whether it is safe or not to call GetCrossout method.
        bool CanGetCrossout(void) const;
        void ResetCrossout(void);
        const TCrossout& GetCrossout(void) const;
        void SetCrossout(const TCrossout& value);
        void SetCrossout(TCrossout&& value);
        TCrossout& SetCrossout(void);
    
        /// Reset the whole object
        void Reset(void);
    
    
    private:
        // Prohibit copy constructor and assignment operator
        C_Attlist(const C_Attlist&);
        C_Attlist& operator=(const C_Attlist&);
    
        // data
        Uint4 m_set_State[1];
        NCBI_NS_STD::string m_Id;
        NCBI_NS_STD::string m_Xref;
        NCBI_NS_STD::string m_Class;
        NCBI_NS_STD::string m_Style;
        NCBI_NS_STD::string m_Href;
        NCBI_NS_STD::string m_Mathcolor;
        NCBI_NS_STD::string m_Mathbackground;
        EAttlist_location m_Location;
        NCBI_NS_STD::string m_Crossout;
    };
    /////////////////////////////////////////////////////////////////////////////
    class C_E_MsrowExpression : public CMsrowExpression
    {
        typedef CMsrowExpression Tparent;
    public:
        C_E_MsrowExpression(void);
    
        // type info
        DECLARE_INTERNAL_TYPE_INFO();
    
    };
    // types
    typedef C_Attlist TAttlist;
    typedef NCBI_NS_STD::list< NCBI_NS_NCBI::CRef< C_E_MsrowExpression > > TMsrowExpression;

    // member index
    enum class E_memberIndex {
        e__allMandatory = 0,
        e_Attlist,
        e_MsrowExpression
    };
    typedef Tparent::CMemberIndex<E_memberIndex, 3> TmemberIndex;

    // getters
    // setters

    /// mandatory
    /// typedef C_Attlist TAttlist
    ///  Check whether the Attlist data member has been assigned a value.
    bool IsSetAttlist(void) const;
    /// Check whether it is safe or not to call GetAttlist method.
    bool CanGetAttlist(void) const;
    void ResetAttlist(void);
    const TAttlist& GetAttlist(void) const;
    void SetAttlist(TAttlist& value);
    TAttlist& SetAttlist(void);

    /// optional
    /// typedef NCBI_NS_STD::list< NCBI_NS_NCBI::CRef< C_E_MsrowExpression > > TMsrowExpression
    ///  Check whether the MsrowExpression data member has been assigned a value.
    bool IsSetMsrowExpression(void) const;
    /// Check whether it is safe or not to call GetMsrowExpression method.
    bool CanGetMsrowExpression(void) const;
    void ResetMsrowExpression(void);
    const TMsrowExpression& GetMsrowExpression(void) const;
    TMsrowExpression& SetMsrowExpression(void);

    /// Reset the whole object
    virtual void Reset(void);


private:
    // Prohibit copy constructor and assignment operator
    CMscarry_Base(const CMscarry_Base&);
    CMscarry_Base& operator=(const CMscarry_Base&);

    // data
    Uint4 m_set_State[1];
    NCBI_NS_NCBI::CRef< TAttlist > m_Attlist;
    NCBI_NS_STD::list< NCBI_NS_NCBI::CRef< C_E_MsrowExpression > > m_MsrowExpression;
};






///////////////////////////////////////////////////////////
///////////////////// inline methods //////////////////////
///////////////////////////////////////////////////////////
inline
bool CMscarry_Base::C_Attlist::IsSetId(void) const
{
    return ((m_set_State[0] & 0x3) != 0);
}

inline
bool CMscarry_Base::C_Attlist::CanGetId(void) const
{
    return IsSetId();
}

inline
const CMscarry_Base::C_Attlist::TId& CMscarry_Base::C_Attlist::GetId(void) const
{
    if (!CanGetId()) {
        ThrowUnassigned(0);
    }
    return m_Id;
}

inline
void CMscarry_Base::C_Attlist::SetId(const CMscarry_Base::C_Attlist::TId& value)
{
    m_Id = value;
    m_set_State[0] |= 0x3;
}

inline
void CMscarry_Base::C_Attlist::SetId(CMscarry_Base::C_Attlist::TId&& value)
{
    m_Id = std::forward<CMscarry_Base::C_Attlist::TId>(value);
    m_set_State[0] |= 0x3;
}

inline
CMscarry_Base::C_Attlist::TId& CMscarry_Base::C_Attlist::SetId(void)
{
#ifdef _DEBUG
    if (!IsSetId()) {
        m_Id = UnassignedString();
    }
#endif
    m_set_State[0] |= 0x1;
    return m_Id;
}

inline
bool CMscarry_Base::C_Attlist::IsSetXref(void) const
{
    return ((m_set_State[0] & 0xc) != 0);
}

inline
bool CMscarry_Base::C_Attlist::CanGetXref(void) const
{
    return IsSetXref();
}

inline
const CMscarry_Base::C_Attlist::TXref& CMscarry_Base::C_Attlist::GetXref(void) const
{
    if (!CanGetXref()) {
        ThrowUnassigned(1);
    }
    return m_Xref;
}

inline
void CMscarry_Base::C_Attlist::SetXref(const CMscarry_Base::C_Attlist::TXref& value)
{
    m_Xref = value;
    m_set_State[0] |= 0xc;
}

inline
void CMscarry_Base::C_Attlist::SetXref(CMscarry_Base::C_Attlist::TXref&& value)
{
    m_Xref = std::forward<CMscarry_Base::C_Attlist::TXref>(value);
    m_set_State[0] |= 0xc;
}

inline
CMscarry_Base::C_Attlist::TXref& CMscarry_Base::C_Attlist::SetXref(void)
{
#ifdef _DEBUG
    if (!IsSetXref()) {
        m_Xref = UnassignedString();
    }
#endif
    m_set_State[0] |= 0x4;
    return m_Xref;
}

inline
bool CMscarry_Base::C_Attlist::IsSetClass(void) const
{
    return ((m_set_State[0] & 0x30) != 0);
}

inline
bool CMscarry_Base::C_Attlist::CanGetClass(void) const
{
    return IsSetClass();
}

inline
const CMscarry_Base::C_Attlist::TClass& CMscarry_Base::C_Attlist::GetClass(void) const
{
    if (!CanGetClass()) {
        ThrowUnassigned(2);
    }
    return m_Class;
}

inline
void CMscarry_Base::C_Attlist::SetClass(const CMscarry_Base::C_Attlist::TClass& value)
{
    m_Class = value;
    m_set_State[0] |= 0x30;
}

inline
void CMscarry_Base::C_Attlist::SetClass(CMscarry_Base::C_Attlist::TClass&& value)
{
    m_Class = std::forward<CMscarry_Base::C_Attlist::TClass>(value);
    m_set_State[0] |= 0x30;
}

inline
CMscarry_Base::C_Attlist::TClass& CMscarry_Base::C_Attlist::SetClass(void)
{
#ifdef _DEBUG
    if (!IsSetClass()) {
        m_Class = UnassignedString();
    }
#endif
    m_set_State[0] |= 0x10;
    return m_Class;
}

inline
bool CMscarry_Base::C_Attlist::IsSetStyle(void) const
{
    return ((m_set_State[0] & 0xc0) != 0);
}

inline
bool CMscarry_Base::C_Attlist::CanGetStyle(void) const
{
    return IsSetStyle();
}

inline
const CMscarry_Base::C_Attlist::TStyle& CMscarry_Base::C_Attlist::GetStyle(void) const
{
    if (!CanGetStyle()) {
        ThrowUnassigned(3);
    }
    return m_Style;
}

inline
void CMscarry_Base::C_Attlist::SetStyle(const CMscarry_Base::C_Attlist::TStyle& value)
{
    m_Style = value;
    m_set_State[0] |= 0xc0;
}

inline
void CMscarry_Base::C_Attlist::SetStyle(CMscarry_Base::C_Attlist::TStyle&& value)
{
    m_Style = std::forward<CMscarry_Base::C_Attlist::TStyle>(value);
    m_set_State[0] |= 0xc0;
}

inline
CMscarry_Base::C_Attlist::TStyle& CMscarry_Base::C_Attlist::SetStyle(void)
{
#ifdef _DEBUG
    if (!IsSetStyle()) {
        m_Style = UnassignedString();
    }
#endif
    m_set_State[0] |= 0x40;
    return m_Style;
}

inline
bool CMscarry_Base::C_Attlist::IsSetHref(void) const
{
    return ((m_set_State[0] & 0x300) != 0);
}

inline
bool CMscarry_Base::C_Attlist::CanGetHref(void) const
{
    return IsSetHref();
}

inline
const CMscarry_Base::C_Attlist::THref& CMscarry_Base::C_Attlist::GetHref(void) const
{
    if (!CanGetHref()) {
        ThrowUnassigned(4);
    }
    return m_Href;
}

inline
void CMscarry_Base::C_Attlist::SetHref(const CMscarry_Base::C_Attlist::THref& value)
{
    m_Href = value;
    m_set_State[0] |= 0x300;
}

inline
void CMscarry_Base::C_Attlist::SetHref(CMscarry_Base::C_Attlist::THref&& value)
{
    m_Href = std::forward<CMscarry_Base::C_Attlist::THref>(value);
    m_set_State[0] |= 0x300;
}

inline
CMscarry_Base::C_Attlist::THref& CMscarry_Base::C_Attlist::SetHref(void)
{
#ifdef _DEBUG
    if (!IsSetHref()) {
        m_Href = UnassignedString();
    }
#endif
    m_set_State[0] |= 0x100;
    return m_Href;
}

inline
bool CMscarry_Base::C_Attlist::IsSetMathcolor(void) const
{
    return ((m_set_State[0] & 0xc00) != 0);
}

inline
bool CMscarry_Base::C_Attlist::CanGetMathcolor(void) const
{
    return IsSetMathcolor();
}

inline
const CMscarry_Base::C_Attlist::TMathcolor& CMscarry_Base::C_Attlist::GetMathcolor(void) const
{
    if (!CanGetMathcolor()) {
        ThrowUnassigned(5);
    }
    return m_Mathcolor;
}

inline
void CMscarry_Base::C_Attlist::SetMathcolor(const CMscarry_Base::C_Attlist::TMathcolor& value)
{
    m_Mathcolor = value;
    m_set_State[0] |= 0xc00;
}

inline
void CMscarry_Base::C_Attlist::SetMathcolor(CMscarry_Base::C_Attlist::TMathcolor&& value)
{
    m_Mathcolor = std::forward<CMscarry_Base::C_Attlist::TMathcolor>(value);
    m_set_State[0] |= 0xc00;
}

inline
CMscarry_Base::C_Attlist::TMathcolor& CMscarry_Base::C_Attlist::SetMathcolor(void)
{
#ifdef _DEBUG
    if (!IsSetMathcolor()) {
        m_Mathcolor = UnassignedString();
    }
#endif
    m_set_State[0] |= 0x400;
    return m_Mathcolor;
}

inline
bool CMscarry_Base::C_Attlist::IsSetMathbackground(void) const
{
    return ((m_set_State[0] & 0x3000) != 0);
}

inline
bool CMscarry_Base::C_Attlist::CanGetMathbackground(void) const
{
    return IsSetMathbackground();
}

inline
const CMscarry_Base::C_Attlist::TMathbackground& CMscarry_Base::C_Attlist::GetMathbackground(void) const
{
    if (!CanGetMathbackground()) {
        ThrowUnassigned(6);
    }
    return m_Mathbackground;
}

inline
void CMscarry_Base::C_Attlist::SetMathbackground(const CMscarry_Base::C_Attlist::TMathbackground& value)
{
    m_Mathbackground = value;
    m_set_State[0] |= 0x3000;
}

inline
void CMscarry_Base::C_Attlist::SetMathbackground(CMscarry_Base::C_Attlist::TMathbackground&& value)
{
    m_Mathbackground = std::forward<CMscarry_Base::C_Attlist::TMathbackground>(value);
    m_set_State[0] |= 0x3000;
}

inline
CMscarry_Base::C_Attlist::TMathbackground& CMscarry_Base::C_Attlist::SetMathbackground(void)
{
#ifdef _DEBUG
    if (!IsSetMathbackground()) {
        m_Mathbackground = UnassignedString();
    }
#endif
    m_set_State[0] |= 0x1000;
    return m_Mathbackground;
}

inline
bool CMscarry_Base::C_Attlist::IsSetLocation(void) const
{
    return ((m_set_State[0] & 0xc000) != 0);
}

inline
bool CMscarry_Base::C_Attlist::CanGetLocation(void) const
{
    return IsSetLocation();
}

inline
void CMscarry_Base::C_Attlist::ResetLocation(void)
{
    m_Location = (EAttlist_location)(0);
    m_set_State[0] &= ~0xc000;
}

inline
CMscarry_Base::C_Attlist::TLocation CMscarry_Base::C_Attlist::GetLocation(void) const
{
    if (!CanGetLocation()) {
        ThrowUnassigned(7);
    }
    return m_Location;
}

inline
void CMscarry_Base::C_Attlist::SetLocation(CMscarry_Base::C_Attlist::TLocation value)
{
    m_Location = value;
    m_set_State[0] |= 0xc000;
}

inline
CMscarry_Base::C_Attlist::TLocation& CMscarry_Base::C_Attlist::SetLocation(void)
{
#ifdef _DEBUG
    if (!IsSetLocation()) {
        memset(&m_Location,UnassignedByte(),sizeof(m_Location));
    }
#endif
    m_set_State[0] |= 0x4000;
    return m_Location;
}

inline
bool CMscarry_Base::C_Attlist::IsSetCrossout(void) const
{
    return ((m_set_State[0] & 0x30000) != 0);
}

inline
bool CMscarry_Base::C_Attlist::CanGetCrossout(void) const
{
    return IsSetCrossout();
}

inline
const CMscarry_Base::C_Attlist::TCrossout& CMscarry_Base::C_Attlist::GetCrossout(void) const
{
    if (!CanGetCrossout()) {
        ThrowUnassigned(8);
    }
    return m_Crossout;
}

inline
void CMscarry_Base::C_Attlist::SetCrossout(const CMscarry_Base::C_Attlist::TCrossout& value)
{
    m_Crossout = value;
    m_set_State[0] |= 0x30000;
}

inline
void CMscarry_Base::C_Attlist::SetCrossout(CMscarry_Base::C_Attlist::TCrossout&& value)
{
    m_Crossout = std::forward<CMscarry_Base::C_Attlist::TCrossout>(value);
    m_set_State[0] |= 0x30000;
}

inline
CMscarry_Base::C_Attlist::TCrossout& CMscarry_Base::C_Attlist::SetCrossout(void)
{
#ifdef _DEBUG
    if (!IsSetCrossout()) {
        m_Crossout = UnassignedString();
    }
#endif
    m_set_State[0] |= 0x10000;
    return m_Crossout;
}

inline
CMscarry_Base::C_E_MsrowExpression::C_E_MsrowExpression(void)
{
}

inline
bool CMscarry_Base::IsSetAttlist(void) const
{
    return m_Attlist.NotEmpty();
}

inline
bool CMscarry_Base::CanGetAttlist(void) const
{
    return true;
}

inline
const CMscarry_Base::TAttlist& CMscarry_Base::GetAttlist(void) const
{
    if ( !m_Attlist ) {
        const_cast<CMscarry_Base*>(this)->ResetAttlist();
    }
    return (*m_Attlist);
}

inline
CMscarry_Base::TAttlist& CMscarry_Base::SetAttlist(void)
{
    if ( !m_Attlist ) {
        ResetAttlist();
    }
    return (*m_Attlist);
}

inline
bool CMscarry_Base::IsSetMsrowExpression(void) const
{
    return ((m_set_State[0] & 0xc) != 0);
}

inline
bool CMscarry_Base::CanGetMsrowExpression(void) const
{
    return true;
}

inline
const CMscarry_Base::TMsrowExpression& CMscarry_Base::GetMsrowExpression(void) const
{
    return m_MsrowExpression;
}

inline
CMscarry_Base::TMsrowExpression& CMscarry_Base::SetMsrowExpression(void)
{
    m_set_State[0] |= 0x4;
    return m_MsrowExpression;
}

///////////////////////////////////////////////////////////
////////////////// end of inline methods //////////////////
///////////////////////////////////////////////////////////





END_eutils_SCOPE // namespace eutils::


#endif // eutils__OBJTOOLS_EUTILS_EFETCH_MSCARRY_BASE_HPP
