/* $Id$
 * ===========================================================================
 *
 *                            PUBLIC DOMAIN NOTICE
 *               National Center for Biotechnology Information
 *
 *  This software/database is a "United States Government Work" under the
 *  terms of the United States Copyright Act.  It was written as part of
 *  the author's official duties as a United States Government employee and
 *  thus cannot be copyrighted.  This software/database is freely available
 *  to the public for use. The National Library of Medicine and the U.S.
 *  Government have not placed any restriction on its use or reproduction.
 *
 *  Although all reasonable efforts have been taken to ensure the accuracy
 *  and reliability of the software and data, the NLM and the U.S.
 *  Government do not and cannot warrant the performance or results that
 *  may be obtained by using this software or data. The NLM and the U.S.
 *  Government disclaim all warranties, express or implied, including
 *  warranties of performance, merchantability or fitness for any particular
 *  purpose.
 *
 *  Please cite the author in any work or product based on this material.
 *
 * ===========================================================================
 *
 */

/// @file Ms_.hpp
/// Data storage class.
///
/// This file was generated by application DATATOOL
/// using the following specifications:
/// 'efetch.xsd'.
///
/// ATTENTION:
///   Don't edit or commit this file into CVS as this file will
///   be overridden (by DATATOOL) without warning!

#ifndef eutils__OBJTOOLS_EUTILS_EFETCH_MS_BASE_HPP
#define eutils__OBJTOOLS_EUTILS_EFETCH_MS_BASE_HPP

// standard includes
#include <serial/serialbase.hpp>

// generated includes
#include <list>
#include <string>
#include <objtools/eutils/efetch/Token_content.hpp>

#ifndef BEGIN_eutils_SCOPE
#  define BEGIN_eutils_SCOPE BEGIN_SCOPE(eutils)
#  define END_eutils_SCOPE END_SCOPE(eutils)
#endif
BEGIN_eutils_SCOPE // namespace eutils::


// generated classes

/////////////////////////////////////////////////////////////////////////////
class CMs_Base : public NCBI_NS_NCBI::CSerialObject
{
    typedef NCBI_NS_NCBI::CSerialObject Tparent;
public:
    // constructor
    CMs_Base(void);
    // destructor
    virtual ~CMs_Base(void);

    // type info
    DECLARE_INTERNAL_TYPE_INFO();

    /////////////////////////////////////////////////////////////////////////////
    class C_Attlist : public NCBI_NS_NCBI::CSerialObject
    {
        typedef NCBI_NS_NCBI::CSerialObject Tparent;
    public:
        // constructor
        C_Attlist(void);
        // destructor
        ~C_Attlist(void);
    
        // type info
        DECLARE_INTERNAL_TYPE_INFO();
    
        enum EAttlist_mathvariant {
            eAttlist_mathvariant_normal                 =  1,
            eAttlist_mathvariant_bold                   =  2,
            eAttlist_mathvariant_italic                 =  3,
            eAttlist_mathvariant_bold_italic            =  4,
            eAttlist_mathvariant_double_struck          =  5,
            eAttlist_mathvariant_bold_fraktur           =  6,
            eAttlist_mathvariant_script                 =  7,
            eAttlist_mathvariant_bold_script            =  8,
            eAttlist_mathvariant_fraktur                =  9,
            eAttlist_mathvariant_sans_serif             = 10,
            eAttlist_mathvariant_bold_sans_serif        = 11,
            eAttlist_mathvariant_sans_serif_italic      = 12,
            eAttlist_mathvariant_sans_serif_bold_italic = 13,
            eAttlist_mathvariant_monospace              = 14,
            eAttlist_mathvariant_initial                = 15,
            eAttlist_mathvariant_tailed                 = 16,
            eAttlist_mathvariant_looped                 = 17,
            eAttlist_mathvariant_stretched              = 18
        };
        
        /// Access to EAttlist_mathvariant's attributes (values, names) as defined in spec
        static const NCBI_NS_NCBI::CEnumeratedTypeValues* ENUM_METHOD_NAME(EAttlist_mathvariant)(void);
        
        enum EAttlist_dir {
            eAttlist_dir_ltr = 1,
            eAttlist_dir_rtl = 2
        };
        
        /// Access to EAttlist_dir's attributes (values, names) as defined in spec
        static const NCBI_NS_NCBI::CEnumeratedTypeValues* ENUM_METHOD_NAME(EAttlist_dir)(void);
        
        enum EAttlist_fontweight {
            eAttlist_fontweight_normal = 1,
            eAttlist_fontweight_bold   = 2
        };
        
        /// Access to EAttlist_fontweight's attributes (values, names) as defined in spec
        static const NCBI_NS_NCBI::CEnumeratedTypeValues* ENUM_METHOD_NAME(EAttlist_fontweight)(void);
        
        enum EAttlist_fontstyle {
            eAttlist_fontstyle_normal = 1,
            eAttlist_fontstyle_italic = 2
        };
        
        /// Access to EAttlist_fontstyle's attributes (values, names) as defined in spec
        static const NCBI_NS_NCBI::CEnumeratedTypeValues* ENUM_METHOD_NAME(EAttlist_fontstyle)(void);
        
        // types
        typedef NCBI_NS_STD::string TId;
        typedef NCBI_NS_STD::string TXref;
        typedef NCBI_NS_STD::string TClass;
        typedef NCBI_NS_STD::string TStyle;
        typedef NCBI_NS_STD::string THref;
        typedef NCBI_NS_STD::string TMathcolor;
        typedef NCBI_NS_STD::string TMathbackground;
        typedef EAttlist_mathvariant TMathvariant;
        typedef NCBI_NS_STD::string TMathsize;
        typedef EAttlist_dir TDir;
        typedef NCBI_NS_STD::string TFontfamily;
        typedef EAttlist_fontweight TFontweight;
        typedef EAttlist_fontstyle TFontstyle;
        typedef NCBI_NS_STD::string TFontsize;
        typedef NCBI_NS_STD::string TColor;
        typedef NCBI_NS_STD::string TBackground;
        typedef NCBI_NS_STD::string TLquote;
        typedef NCBI_NS_STD::string TRquote;
    
        // member index
        enum class E_memberIndex {
            e__allMandatory = 0,
            e_id,
            e_xref,
            e_class,
            e_style,
            e_href,
            e_mathcolor,
            e_mathbackground,
            e_mathvariant,
            e_mathsize,
            e_dir,
            e_fontfamily,
            e_fontweight,
            e_fontstyle,
            e_fontsize,
            e_color,
            e_background,
            e_lquote,
            e_rquote
        };
        typedef Tparent::CMemberIndex<E_memberIndex, 19> TmemberIndex;
    
        // getters
        // setters
    
        /// optional
        /// typedef NCBI_NS_STD::string TId
        ///  Check whether the Id data member has been assigned a value.
        bool IsSetId(void) const;
        /// Check whether it is safe or not to call GetId method.
        bool CanGetId(void) const;
        void ResetId(void);
        const TId& GetId(void) const;
        void SetId(const TId& value);
        void SetId(TId&& value);
        TId& SetId(void);
    
        /// optional
        /// typedef NCBI_NS_STD::string TXref
        ///  Check whether the Xref data member has been assigned a value.
        bool IsSetXref(void) const;
        /// Check whether it is safe or not to call GetXref method.
        bool CanGetXref(void) const;
        void ResetXref(void);
        const TXref& GetXref(void) const;
        void SetXref(const TXref& value);
        void SetXref(TXref&& value);
        TXref& SetXref(void);
    
        /// optional
        /// typedef NCBI_NS_STD::string TClass
        ///  Check whether the Class data member has been assigned a value.
        bool IsSetClass(void) const;
        /// Check whether it is safe or not to call GetClass method.
        bool CanGetClass(void) const;
        void ResetClass(void);
        const TClass& GetClass(void) const;
        void SetClass(const TClass& value);
        void SetClass(TClass&& value);
        TClass& SetClass(void);
    
        /// optional
        /// typedef NCBI_NS_STD::string TStyle
        ///  Check whether the Style data member has been assigned a value.
        bool IsSetStyle(void) const;
        /// Check whether it is safe or not to call GetStyle method.
        bool CanGetStyle(void) const;
        void ResetStyle(void);
        const TStyle& GetStyle(void) const;
        void SetStyle(const TStyle& value);
        void SetStyle(TStyle&& value);
        TStyle& SetStyle(void);
    
        /// optional
        /// typedef NCBI_NS_STD::string THref
        ///  Check whether the Href data member has been assigned a value.
        bool IsSetHref(void) const;
        /// Check whether it is safe or not to call GetHref method.
        bool CanGetHref(void) const;
        void ResetHref(void);
        const THref& GetHref(void) const;
        void SetHref(const THref& value);
        void SetHref(THref&& value);
        THref& SetHref(void);
    
        /// optional
        /// typedef NCBI_NS_STD::string TMathcolor
        ///  Check whether the Mathcolor data member has been assigned a value.
        bool IsSetMathcolor(void) const;
        /// Check whether it is safe or not to call GetMathcolor method.
        bool CanGetMathcolor(void) const;
        void ResetMathcolor(void);
        const TMathcolor& GetMathcolor(void) const;
        void SetMathcolor(const TMathcolor& value);
        void SetMathcolor(TMathcolor&& value);
        TMathcolor& SetMathcolor(void);
    
        /// optional
        /// typedef NCBI_NS_STD::string TMathbackground
        ///  Check whether the Mathbackground data member has been assigned a value.
        bool IsSetMathbackground(void) const;
        /// Check whether it is safe or not to call GetMathbackground method.
        bool CanGetMathbackground(void) const;
        void ResetMathbackground(void);
        const TMathbackground& GetMathbackground(void) const;
        void SetMathbackground(const TMathbackground& value);
        void SetMathbackground(TMathbackground&& value);
        TMathbackground& SetMathbackground(void);
    
        /// optional
        /// typedef EAttlist_mathvariant TMathvariant
        ///  Check whether the Mathvariant data member has been assigned a value.
        bool IsSetMathvariant(void) const;
        /// Check whether it is safe or not to call GetMathvariant method.
        bool CanGetMathvariant(void) const;
        void ResetMathvariant(void);
        TMathvariant GetMathvariant(void) const;
        void SetMathvariant(TMathvariant value);
        TMathvariant& SetMathvariant(void);
    
        /// optional
        /// typedef NCBI_NS_STD::string TMathsize
        ///  Check whether the Mathsize data member has been assigned a value.
        bool IsSetMathsize(void) const;
        /// Check whether it is safe or not to call GetMathsize method.
        bool CanGetMathsize(void) const;
        void ResetMathsize(void);
        const TMathsize& GetMathsize(void) const;
        void SetMathsize(const TMathsize& value);
        void SetMathsize(TMathsize&& value);
        TMathsize& SetMathsize(void);
    
        /// optional
        /// typedef EAttlist_dir TDir
        ///  Check whether the Dir data member has been assigned a value.
        bool IsSetDir(void) const;
        /// Check whether it is safe or not to call GetDir method.
        bool CanGetDir(void) const;
        void ResetDir(void);
        TDir GetDir(void) const;
        void SetDir(TDir value);
        TDir& SetDir(void);
    
        /// optional
        /// typedef NCBI_NS_STD::string TFontfamily
        ///  Check whether the Fontfamily data member has been assigned a value.
        bool IsSetFontfamily(void) const;
        /// Check whether it is safe or not to call GetFontfamily method.
        bool CanGetFontfamily(void) const;
        void ResetFontfamily(void);
        const TFontfamily& GetFontfamily(void) const;
        void SetFontfamily(const TFontfamily& value);
        void SetFontfamily(TFontfamily&& value);
        TFontfamily& SetFontfamily(void);
    
        /// optional
        /// typedef EAttlist_fontweight TFontweight
        ///  Check whether the Fontweight data member has been assigned a value.
        bool IsSetFontweight(void) const;
        /// Check whether it is safe or not to call GetFontweight method.
        bool CanGetFontweight(void) const;
        void ResetFontweight(void);
        TFontweight GetFontweight(void) const;
        void SetFontweight(TFontweight value);
        TFontweight& SetFontweight(void);
    
        /// optional
        /// typedef EAttlist_fontstyle TFontstyle
        ///  Check whether the Fontstyle data member has been assigned a value.
        bool IsSetFontstyle(void) const;
        /// Check whether it is safe or not to call GetFontstyle method.
        bool CanGetFontstyle(void) const;
        void ResetFontstyle(void);
        TFontstyle GetFontstyle(void) const;
        void SetFontstyle(TFontstyle value);
        TFontstyle& SetFontstyle(void);
    
        /// optional
        /// typedef NCBI_NS_STD::string TFontsize
        ///  Check whether the Fontsize data member has been assigned a value.
        bool IsSetFontsize(void) const;
        /// Check whether it is safe or not to call GetFontsize method.
        bool CanGetFontsize(void) const;
        void ResetFontsize(void);
        const TFontsize& GetFontsize(void) const;
        void SetFontsize(const TFontsize& value);
        void SetFontsize(TFontsize&& value);
        TFontsize& SetFontsize(void);
    
        /// optional
        /// typedef NCBI_NS_STD::string TColor
        ///  Check whether the Color data member has been assigned a value.
        bool IsSetColor(void) const;
        /// Check whether it is safe or not to call GetColor method.
        bool CanGetColor(void) const;
        void ResetColor(void);
        const TColor& GetColor(void) const;
        void SetColor(const TColor& value);
        void SetColor(TColor&& value);
        TColor& SetColor(void);
    
        /// optional
        /// typedef NCBI_NS_STD::string TBackground
        ///  Check whether the Background data member has been assigned a value.
        bool IsSetBackground(void) const;
        /// Check whether it is safe or not to call GetBackground method.
        bool CanGetBackground(void) const;
        void ResetBackground(void);
        const TBackground& GetBackground(void) const;
        void SetBackground(const TBackground& value);
        void SetBackground(TBackground&& value);
        TBackground& SetBackground(void);
    
        /// optional
        /// typedef NCBI_NS_STD::string TLquote
        ///  Check whether the Lquote data member has been assigned a value.
        bool IsSetLquote(void) const;
        /// Check whether it is safe or not to call GetLquote method.
        bool CanGetLquote(void) const;
        void ResetLquote(void);
        const TLquote& GetLquote(void) const;
        void SetLquote(const TLquote& value);
        void SetLquote(TLquote&& value);
        TLquote& SetLquote(void);
    
        /// optional
        /// typedef NCBI_NS_STD::string TRquote
        ///  Check whether the Rquote data member has been assigned a value.
        bool IsSetRquote(void) const;
        /// Check whether it is safe or not to call GetRquote method.
        bool CanGetRquote(void) const;
        void ResetRquote(void);
        const TRquote& GetRquote(void) const;
        void SetRquote(const TRquote& value);
        void SetRquote(TRquote&& value);
        TRquote& SetRquote(void);
    
        /// Reset the whole object
        void Reset(void);
    
    
    private:
        // Prohibit copy constructor and assignment operator
        C_Attlist(const C_Attlist&);
        C_Attlist& operator=(const C_Attlist&);
    
        // data
        Uint4 m_set_State[2];
        NCBI_NS_STD::string m_Id;
        NCBI_NS_STD::string m_Xref;
        NCBI_NS_STD::string m_Class;
        NCBI_NS_STD::string m_Style;
        NCBI_NS_STD::string m_Href;
        NCBI_NS_STD::string m_Mathcolor;
        NCBI_NS_STD::string m_Mathbackground;
        EAttlist_mathvariant m_Mathvariant;
        NCBI_NS_STD::string m_Mathsize;
        EAttlist_dir m_Dir;
        NCBI_NS_STD::string m_Fontfamily;
        EAttlist_fontweight m_Fontweight;
        EAttlist_fontstyle m_Fontstyle;
        NCBI_NS_STD::string m_Fontsize;
        NCBI_NS_STD::string m_Color;
        NCBI_NS_STD::string m_Background;
        NCBI_NS_STD::string m_Lquote;
        NCBI_NS_STD::string m_Rquote;
    };
    /////////////////////////////////////////////////////////////////////////////
    class C_E_Ms : public NCBI_NS_NCBI::CSerialObject
    {
        typedef NCBI_NS_NCBI::CSerialObject Tparent;
    public:
        // constructor
        C_E_Ms(void);
        // destructor
        ~C_E_Ms(void);
    
        // type info
        DECLARE_INTERNAL_TYPE_INFO();
    
        typedef CToken_content C_Token_content;
    
        /// Choice variants.
        enum E_Choice {
            e_not_set = 0,    ///< No variant selected
            e__CharData,
            e_Token_content
        };
        /// Maximum+1 value of the choice variant enumerator.
        enum E_ChoiceStopper {
            e_MaxChoice = 3 ///< == e_Token_content+1
        };
    
        /// Reset the whole object
        void Reset(void);
    
        /// Reset the selection (set it to e_not_set).
        void ResetSelection(void);
    
        /// Which variant is currently selected.
        E_Choice Which(void) const;
    
        /// Verify selection, throw exception if it differs from the expected.
        void CheckSelected(E_Choice index) const;
    
        /// Throw 'InvalidSelection' exception.
        NCBI_NORETURN void ThrowInvalidSelection(E_Choice index) const;
    
        /// Retrieve selection name (for diagnostic purposes).
        static NCBI_NS_STD::string SelectionName(E_Choice index);
    
        /// Select the requested variant if needed.
        void Select(E_Choice index, NCBI_NS_NCBI::EResetVariant reset = NCBI_NS_NCBI::eDoResetVariant);
        /// Select the requested variant if needed,
        /// allocating CObject variants from memory pool.
        void Select(E_Choice index,
                    NCBI_NS_NCBI::EResetVariant reset,
                    NCBI_NS_NCBI::CObjectMemoryPool* pool);
    
        // types
        typedef NCBI_NS_STD::string T_CharData;
        typedef C_Token_content TToken_content;
    
        // getters
        // setters
    
        // typedef NCBI_NS_STD::string T_CharData
        bool Is_CharData(void) const;
        const T_CharData& Get_CharData(void) const;
        T_CharData& Set_CharData(void);
        void Set_CharData(const T_CharData& value);
    
        // typedef C_Token_content TToken_content
        bool IsToken_content(void) const;
        const TToken_content& GetToken_content(void) const;
        TToken_content& SetToken_content(void);
        void SetToken_content(TToken_content& value);
    
    
    private:
        // copy constructor and assignment operator
        C_E_Ms(const C_E_Ms& );
        C_E_Ms& operator=(const C_E_Ms& );
        // choice state
        E_Choice m_choice;
        // helper methods
        void DoSelect(E_Choice index, NCBI_NS_NCBI::CObjectMemoryPool* pool = 0);
    
        static const char* const sm_SelectionNames[];
        // data
        union {
            NCBI_NS_NCBI::CUnionBuffer<NCBI_NS_STD::string> m_string;
            NCBI_NS_NCBI::CSerialObject *m_object;
        };
    };
    // types
    typedef C_Attlist TAttlist;
    typedef C_E_Ms C_E;
    typedef NCBI_NS_STD::list< NCBI_NS_NCBI::CRef< C_E_Ms > > TMs;

    // member index
    enum class E_memberIndex {
        e__allMandatory = 0,
        e_Attlist,
        e_ms
    };
    typedef Tparent::CMemberIndex<E_memberIndex, 3> TmemberIndex;

    // getters
    // setters

    /// mandatory
    /// typedef C_Attlist TAttlist
    ///  Check whether the Attlist data member has been assigned a value.
    bool IsSetAttlist(void) const;
    /// Check whether it is safe or not to call GetAttlist method.
    bool CanGetAttlist(void) const;
    void ResetAttlist(void);
    const TAttlist& GetAttlist(void) const;
    void SetAttlist(TAttlist& value);
    TAttlist& SetAttlist(void);

    /// optional
    /// typedef NCBI_NS_STD::list< NCBI_NS_NCBI::CRef< C_E_Ms > > TMs
    ///  Check whether the Ms data member has been assigned a value.
    bool IsSetMs(void) const;
    /// Check whether it is safe or not to call GetMs method.
    bool CanGetMs(void) const;
    void ResetMs(void);
    const TMs& GetMs(void) const;
    TMs& SetMs(void);

    /// Reset the whole object
    virtual void Reset(void);


private:
    // Prohibit copy constructor and assignment operator
    CMs_Base(const CMs_Base&);
    CMs_Base& operator=(const CMs_Base&);

    // data
    Uint4 m_set_State[1];
    NCBI_NS_NCBI::CRef< TAttlist > m_Attlist;
    NCBI_NS_STD::list< NCBI_NS_NCBI::CRef< C_E_Ms > > m_Ms;
};






///////////////////////////////////////////////////////////
///////////////////// inline methods //////////////////////
///////////////////////////////////////////////////////////
inline
bool CMs_Base::C_Attlist::IsSetId(void) const
{
    return ((m_set_State[0] & 0x3) != 0);
}

inline
bool CMs_Base::C_Attlist::CanGetId(void) const
{
    return IsSetId();
}

inline
const CMs_Base::C_Attlist::TId& CMs_Base::C_Attlist::GetId(void) const
{
    if (!CanGetId()) {
        ThrowUnassigned(0);
    }
    return m_Id;
}

inline
void CMs_Base::C_Attlist::SetId(const CMs_Base::C_Attlist::TId& value)
{
    m_Id = value;
    m_set_State[0] |= 0x3;
}

inline
void CMs_Base::C_Attlist::SetId(CMs_Base::C_Attlist::TId&& value)
{
    m_Id = std::forward<CMs_Base::C_Attlist::TId>(value);
    m_set_State[0] |= 0x3;
}

inline
CMs_Base::C_Attlist::TId& CMs_Base::C_Attlist::SetId(void)
{
#ifdef _DEBUG
    if (!IsSetId()) {
        m_Id = UnassignedString();
    }
#endif
    m_set_State[0] |= 0x1;
    return m_Id;
}

inline
bool CMs_Base::C_Attlist::IsSetXref(void) const
{
    return ((m_set_State[0] & 0xc) != 0);
}

inline
bool CMs_Base::C_Attlist::CanGetXref(void) const
{
    return IsSetXref();
}

inline
const CMs_Base::C_Attlist::TXref& CMs_Base::C_Attlist::GetXref(void) const
{
    if (!CanGetXref()) {
        ThrowUnassigned(1);
    }
    return m_Xref;
}

inline
void CMs_Base::C_Attlist::SetXref(const CMs_Base::C_Attlist::TXref& value)
{
    m_Xref = value;
    m_set_State[0] |= 0xc;
}

inline
void CMs_Base::C_Attlist::SetXref(CMs_Base::C_Attlist::TXref&& value)
{
    m_Xref = std::forward<CMs_Base::C_Attlist::TXref>(value);
    m_set_State[0] |= 0xc;
}

inline
CMs_Base::C_Attlist::TXref& CMs_Base::C_Attlist::SetXref(void)
{
#ifdef _DEBUG
    if (!IsSetXref()) {
        m_Xref = UnassignedString();
    }
#endif
    m_set_State[0] |= 0x4;
    return m_Xref;
}

inline
bool CMs_Base::C_Attlist::IsSetClass(void) const
{
    return ((m_set_State[0] & 0x30) != 0);
}

inline
bool CMs_Base::C_Attlist::CanGetClass(void) const
{
    return IsSetClass();
}

inline
const CMs_Base::C_Attlist::TClass& CMs_Base::C_Attlist::GetClass(void) const
{
    if (!CanGetClass()) {
        ThrowUnassigned(2);
    }
    return m_Class;
}

inline
void CMs_Base::C_Attlist::SetClass(const CMs_Base::C_Attlist::TClass& value)
{
    m_Class = value;
    m_set_State[0] |= 0x30;
}

inline
void CMs_Base::C_Attlist::SetClass(CMs_Base::C_Attlist::TClass&& value)
{
    m_Class = std::forward<CMs_Base::C_Attlist::TClass>(value);
    m_set_State[0] |= 0x30;
}

inline
CMs_Base::C_Attlist::TClass& CMs_Base::C_Attlist::SetClass(void)
{
#ifdef _DEBUG
    if (!IsSetClass()) {
        m_Class = UnassignedString();
    }
#endif
    m_set_State[0] |= 0x10;
    return m_Class;
}

inline
bool CMs_Base::C_Attlist::IsSetStyle(void) const
{
    return ((m_set_State[0] & 0xc0) != 0);
}

inline
bool CMs_Base::C_Attlist::CanGetStyle(void) const
{
    return IsSetStyle();
}

inline
const CMs_Base::C_Attlist::TStyle& CMs_Base::C_Attlist::GetStyle(void) const
{
    if (!CanGetStyle()) {
        ThrowUnassigned(3);
    }
    return m_Style;
}

inline
void CMs_Base::C_Attlist::SetStyle(const CMs_Base::C_Attlist::TStyle& value)
{
    m_Style = value;
    m_set_State[0] |= 0xc0;
}

inline
void CMs_Base::C_Attlist::SetStyle(CMs_Base::C_Attlist::TStyle&& value)
{
    m_Style = std::forward<CMs_Base::C_Attlist::TStyle>(value);
    m_set_State[0] |= 0xc0;
}

inline
CMs_Base::C_Attlist::TStyle& CMs_Base::C_Attlist::SetStyle(void)
{
#ifdef _DEBUG
    if (!IsSetStyle()) {
        m_Style = UnassignedString();
    }
#endif
    m_set_State[0] |= 0x40;
    return m_Style;
}

inline
bool CMs_Base::C_Attlist::IsSetHref(void) const
{
    return ((m_set_State[0] & 0x300) != 0);
}

inline
bool CMs_Base::C_Attlist::CanGetHref(void) const
{
    return IsSetHref();
}

inline
const CMs_Base::C_Attlist::THref& CMs_Base::C_Attlist::GetHref(void) const
{
    if (!CanGetHref()) {
        ThrowUnassigned(4);
    }
    return m_Href;
}

inline
void CMs_Base::C_Attlist::SetHref(const CMs_Base::C_Attlist::THref& value)
{
    m_Href = value;
    m_set_State[0] |= 0x300;
}

inline
void CMs_Base::C_Attlist::SetHref(CMs_Base::C_Attlist::THref&& value)
{
    m_Href = std::forward<CMs_Base::C_Attlist::THref>(value);
    m_set_State[0] |= 0x300;
}

inline
CMs_Base::C_Attlist::THref& CMs_Base::C_Attlist::SetHref(void)
{
#ifdef _DEBUG
    if (!IsSetHref()) {
        m_Href = UnassignedString();
    }
#endif
    m_set_State[0] |= 0x100;
    return m_Href;
}

inline
bool CMs_Base::C_Attlist::IsSetMathcolor(void) const
{
    return ((m_set_State[0] & 0xc00) != 0);
}

inline
bool CMs_Base::C_Attlist::CanGetMathcolor(void) const
{
    return IsSetMathcolor();
}

inline
const CMs_Base::C_Attlist::TMathcolor& CMs_Base::C_Attlist::GetMathcolor(void) const
{
    if (!CanGetMathcolor()) {
        ThrowUnassigned(5);
    }
    return m_Mathcolor;
}

inline
void CMs_Base::C_Attlist::SetMathcolor(const CMs_Base::C_Attlist::TMathcolor& value)
{
    m_Mathcolor = value;
    m_set_State[0] |= 0xc00;
}

inline
void CMs_Base::C_Attlist::SetMathcolor(CMs_Base::C_Attlist::TMathcolor&& value)
{
    m_Mathcolor = std::forward<CMs_Base::C_Attlist::TMathcolor>(value);
    m_set_State[0] |= 0xc00;
}

inline
CMs_Base::C_Attlist::TMathcolor& CMs_Base::C_Attlist::SetMathcolor(void)
{
#ifdef _DEBUG
    if (!IsSetMathcolor()) {
        m_Mathcolor = UnassignedString();
    }
#endif
    m_set_State[0] |= 0x400;
    return m_Mathcolor;
}

inline
bool CMs_Base::C_Attlist::IsSetMathbackground(void) const
{
    return ((m_set_State[0] & 0x3000) != 0);
}

inline
bool CMs_Base::C_Attlist::CanGetMathbackground(void) const
{
    return IsSetMathbackground();
}

inline
const CMs_Base::C_Attlist::TMathbackground& CMs_Base::C_Attlist::GetMathbackground(void) const
{
    if (!CanGetMathbackground()) {
        ThrowUnassigned(6);
    }
    return m_Mathbackground;
}

inline
void CMs_Base::C_Attlist::SetMathbackground(const CMs_Base::C_Attlist::TMathbackground& value)
{
    m_Mathbackground = value;
    m_set_State[0] |= 0x3000;
}

inline
void CMs_Base::C_Attlist::SetMathbackground(CMs_Base::C_Attlist::TMathbackground&& value)
{
    m_Mathbackground = std::forward<CMs_Base::C_Attlist::TMathbackground>(value);
    m_set_State[0] |= 0x3000;
}

inline
CMs_Base::C_Attlist::TMathbackground& CMs_Base::C_Attlist::SetMathbackground(void)
{
#ifdef _DEBUG
    if (!IsSetMathbackground()) {
        m_Mathbackground = UnassignedString();
    }
#endif
    m_set_State[0] |= 0x1000;
    return m_Mathbackground;
}

inline
bool CMs_Base::C_Attlist::IsSetMathvariant(void) const
{
    return ((m_set_State[0] & 0xc000) != 0);
}

inline
bool CMs_Base::C_Attlist::CanGetMathvariant(void) const
{
    return IsSetMathvariant();
}

inline
void CMs_Base::C_Attlist::ResetMathvariant(void)
{
    m_Mathvariant = (EAttlist_mathvariant)(0);
    m_set_State[0] &= ~0xc000;
}

inline
CMs_Base::C_Attlist::TMathvariant CMs_Base::C_Attlist::GetMathvariant(void) const
{
    if (!CanGetMathvariant()) {
        ThrowUnassigned(7);
    }
    return m_Mathvariant;
}

inline
void CMs_Base::C_Attlist::SetMathvariant(CMs_Base::C_Attlist::TMathvariant value)
{
    m_Mathvariant = value;
    m_set_State[0] |= 0xc000;
}

inline
CMs_Base::C_Attlist::TMathvariant& CMs_Base::C_Attlist::SetMathvariant(void)
{
#ifdef _DEBUG
    if (!IsSetMathvariant()) {
        memset(&m_Mathvariant,UnassignedByte(),sizeof(m_Mathvariant));
    }
#endif
    m_set_State[0] |= 0x4000;
    return m_Mathvariant;
}

inline
bool CMs_Base::C_Attlist::IsSetMathsize(void) const
{
    return ((m_set_State[0] & 0x30000) != 0);
}

inline
bool CMs_Base::C_Attlist::CanGetMathsize(void) const
{
    return IsSetMathsize();
}

inline
const CMs_Base::C_Attlist::TMathsize& CMs_Base::C_Attlist::GetMathsize(void) const
{
    if (!CanGetMathsize()) {
        ThrowUnassigned(8);
    }
    return m_Mathsize;
}

inline
void CMs_Base::C_Attlist::SetMathsize(const CMs_Base::C_Attlist::TMathsize& value)
{
    m_Mathsize = value;
    m_set_State[0] |= 0x30000;
}

inline
void CMs_Base::C_Attlist::SetMathsize(CMs_Base::C_Attlist::TMathsize&& value)
{
    m_Mathsize = std::forward<CMs_Base::C_Attlist::TMathsize>(value);
    m_set_State[0] |= 0x30000;
}

inline
CMs_Base::C_Attlist::TMathsize& CMs_Base::C_Attlist::SetMathsize(void)
{
#ifdef _DEBUG
    if (!IsSetMathsize()) {
        m_Mathsize = UnassignedString();
    }
#endif
    m_set_State[0] |= 0x10000;
    return m_Mathsize;
}

inline
bool CMs_Base::C_Attlist::IsSetDir(void) const
{
    return ((m_set_State[0] & 0xc0000) != 0);
}

inline
bool CMs_Base::C_Attlist::CanGetDir(void) const
{
    return IsSetDir();
}

inline
void CMs_Base::C_Attlist::ResetDir(void)
{
    m_Dir = (EAttlist_dir)(0);
    m_set_State[0] &= ~0xc0000;
}

inline
CMs_Base::C_Attlist::TDir CMs_Base::C_Attlist::GetDir(void) const
{
    if (!CanGetDir()) {
        ThrowUnassigned(9);
    }
    return m_Dir;
}

inline
void CMs_Base::C_Attlist::SetDir(CMs_Base::C_Attlist::TDir value)
{
    m_Dir = value;
    m_set_State[0] |= 0xc0000;
}

inline
CMs_Base::C_Attlist::TDir& CMs_Base::C_Attlist::SetDir(void)
{
#ifdef _DEBUG
    if (!IsSetDir()) {
        memset(&m_Dir,UnassignedByte(),sizeof(m_Dir));
    }
#endif
    m_set_State[0] |= 0x40000;
    return m_Dir;
}

inline
bool CMs_Base::C_Attlist::IsSetFontfamily(void) const
{
    return ((m_set_State[0] & 0x300000) != 0);
}

inline
bool CMs_Base::C_Attlist::CanGetFontfamily(void) const
{
    return IsSetFontfamily();
}

inline
const CMs_Base::C_Attlist::TFontfamily& CMs_Base::C_Attlist::GetFontfamily(void) const
{
    if (!CanGetFontfamily()) {
        ThrowUnassigned(10);
    }
    return m_Fontfamily;
}

inline
void CMs_Base::C_Attlist::SetFontfamily(const CMs_Base::C_Attlist::TFontfamily& value)
{
    m_Fontfamily = value;
    m_set_State[0] |= 0x300000;
}

inline
void CMs_Base::C_Attlist::SetFontfamily(CMs_Base::C_Attlist::TFontfamily&& value)
{
    m_Fontfamily = std::forward<CMs_Base::C_Attlist::TFontfamily>(value);
    m_set_State[0] |= 0x300000;
}

inline
CMs_Base::C_Attlist::TFontfamily& CMs_Base::C_Attlist::SetFontfamily(void)
{
#ifdef _DEBUG
    if (!IsSetFontfamily()) {
        m_Fontfamily = UnassignedString();
    }
#endif
    m_set_State[0] |= 0x100000;
    return m_Fontfamily;
}

inline
bool CMs_Base::C_Attlist::IsSetFontweight(void) const
{
    return ((m_set_State[0] & 0xc00000) != 0);
}

inline
bool CMs_Base::C_Attlist::CanGetFontweight(void) const
{
    return IsSetFontweight();
}

inline
void CMs_Base::C_Attlist::ResetFontweight(void)
{
    m_Fontweight = (EAttlist_fontweight)(0);
    m_set_State[0] &= ~0xc00000;
}

inline
CMs_Base::C_Attlist::TFontweight CMs_Base::C_Attlist::GetFontweight(void) const
{
    if (!CanGetFontweight()) {
        ThrowUnassigned(11);
    }
    return m_Fontweight;
}

inline
void CMs_Base::C_Attlist::SetFontweight(CMs_Base::C_Attlist::TFontweight value)
{
    m_Fontweight = value;
    m_set_State[0] |= 0xc00000;
}

inline
CMs_Base::C_Attlist::TFontweight& CMs_Base::C_Attlist::SetFontweight(void)
{
#ifdef _DEBUG
    if (!IsSetFontweight()) {
        memset(&m_Fontweight,UnassignedByte(),sizeof(m_Fontweight));
    }
#endif
    m_set_State[0] |= 0x400000;
    return m_Fontweight;
}

inline
bool CMs_Base::C_Attlist::IsSetFontstyle(void) const
{
    return ((m_set_State[0] & 0x3000000) != 0);
}

inline
bool CMs_Base::C_Attlist::CanGetFontstyle(void) const
{
    return IsSetFontstyle();
}

inline
void CMs_Base::C_Attlist::ResetFontstyle(void)
{
    m_Fontstyle = (EAttlist_fontstyle)(0);
    m_set_State[0] &= ~0x3000000;
}

inline
CMs_Base::C_Attlist::TFontstyle CMs_Base::C_Attlist::GetFontstyle(void) const
{
    if (!CanGetFontstyle()) {
        ThrowUnassigned(12);
    }
    return m_Fontstyle;
}

inline
void CMs_Base::C_Attlist::SetFontstyle(CMs_Base::C_Attlist::TFontstyle value)
{
    m_Fontstyle = value;
    m_set_State[0] |= 0x3000000;
}

inline
CMs_Base::C_Attlist::TFontstyle& CMs_Base::C_Attlist::SetFontstyle(void)
{
#ifdef _DEBUG
    if (!IsSetFontstyle()) {
        memset(&m_Fontstyle,UnassignedByte(),sizeof(m_Fontstyle));
    }
#endif
    m_set_State[0] |= 0x1000000;
    return m_Fontstyle;
}

inline
bool CMs_Base::C_Attlist::IsSetFontsize(void) const
{
    return ((m_set_State[0] & 0xc000000) != 0);
}

inline
bool CMs_Base::C_Attlist::CanGetFontsize(void) const
{
    return IsSetFontsize();
}

inline
const CMs_Base::C_Attlist::TFontsize& CMs_Base::C_Attlist::GetFontsize(void) const
{
    if (!CanGetFontsize()) {
        ThrowUnassigned(13);
    }
    return m_Fontsize;
}

inline
void CMs_Base::C_Attlist::SetFontsize(const CMs_Base::C_Attlist::TFontsize& value)
{
    m_Fontsize = value;
    m_set_State[0] |= 0xc000000;
}

inline
void CMs_Base::C_Attlist::SetFontsize(CMs_Base::C_Attlist::TFontsize&& value)
{
    m_Fontsize = std::forward<CMs_Base::C_Attlist::TFontsize>(value);
    m_set_State[0] |= 0xc000000;
}

inline
CMs_Base::C_Attlist::TFontsize& CMs_Base::C_Attlist::SetFontsize(void)
{
#ifdef _DEBUG
    if (!IsSetFontsize()) {
        m_Fontsize = UnassignedString();
    }
#endif
    m_set_State[0] |= 0x4000000;
    return m_Fontsize;
}

inline
bool CMs_Base::C_Attlist::IsSetColor(void) const
{
    return ((m_set_State[0] & 0x30000000) != 0);
}

inline
bool CMs_Base::C_Attlist::CanGetColor(void) const
{
    return IsSetColor();
}

inline
const CMs_Base::C_Attlist::TColor& CMs_Base::C_Attlist::GetColor(void) const
{
    if (!CanGetColor()) {
        ThrowUnassigned(14);
    }
    return m_Color;
}

inline
void CMs_Base::C_Attlist::SetColor(const CMs_Base::C_Attlist::TColor& value)
{
    m_Color = value;
    m_set_State[0] |= 0x30000000;
}

inline
void CMs_Base::C_Attlist::SetColor(CMs_Base::C_Attlist::TColor&& value)
{
    m_Color = std::forward<CMs_Base::C_Attlist::TColor>(value);
    m_set_State[0] |= 0x30000000;
}

inline
CMs_Base::C_Attlist::TColor& CMs_Base::C_Attlist::SetColor(void)
{
#ifdef _DEBUG
    if (!IsSetColor()) {
        m_Color = UnassignedString();
    }
#endif
    m_set_State[0] |= 0x10000000;
    return m_Color;
}

inline
bool CMs_Base::C_Attlist::IsSetBackground(void) const
{
    return ((m_set_State[0] & 0xc0000000) != 0);
}

inline
bool CMs_Base::C_Attlist::CanGetBackground(void) const
{
    return IsSetBackground();
}

inline
const CMs_Base::C_Attlist::TBackground& CMs_Base::C_Attlist::GetBackground(void) const
{
    if (!CanGetBackground()) {
        ThrowUnassigned(15);
    }
    return m_Background;
}

inline
void CMs_Base::C_Attlist::SetBackground(const CMs_Base::C_Attlist::TBackground& value)
{
    m_Background = value;
    m_set_State[0] |= 0xc0000000;
}

inline
void CMs_Base::C_Attlist::SetBackground(CMs_Base::C_Attlist::TBackground&& value)
{
    m_Background = std::forward<CMs_Base::C_Attlist::TBackground>(value);
    m_set_State[0] |= 0xc0000000;
}

inline
CMs_Base::C_Attlist::TBackground& CMs_Base::C_Attlist::SetBackground(void)
{
#ifdef _DEBUG
    if (!IsSetBackground()) {
        m_Background = UnassignedString();
    }
#endif
    m_set_State[0] |= 0x40000000;
    return m_Background;
}

inline
bool CMs_Base::C_Attlist::IsSetLquote(void) const
{
    return ((m_set_State[1] & 0x3) != 0);
}

inline
bool CMs_Base::C_Attlist::CanGetLquote(void) const
{
    return IsSetLquote();
}

inline
const CMs_Base::C_Attlist::TLquote& CMs_Base::C_Attlist::GetLquote(void) const
{
    if (!CanGetLquote()) {
        ThrowUnassigned(16);
    }
    return m_Lquote;
}

inline
void CMs_Base::C_Attlist::SetLquote(const CMs_Base::C_Attlist::TLquote& value)
{
    m_Lquote = value;
    m_set_State[1] |= 0x3;
}

inline
void CMs_Base::C_Attlist::SetLquote(CMs_Base::C_Attlist::TLquote&& value)
{
    m_Lquote = std::forward<CMs_Base::C_Attlist::TLquote>(value);
    m_set_State[1] |= 0x3;
}

inline
CMs_Base::C_Attlist::TLquote& CMs_Base::C_Attlist::SetLquote(void)
{
#ifdef _DEBUG
    if (!IsSetLquote()) {
        m_Lquote = UnassignedString();
    }
#endif
    m_set_State[1] |= 0x1;
    return m_Lquote;
}

inline
bool CMs_Base::C_Attlist::IsSetRquote(void) const
{
    return ((m_set_State[1] & 0xc) != 0);
}

inline
bool CMs_Base::C_Attlist::CanGetRquote(void) const
{
    return IsSetRquote();
}

inline
const CMs_Base::C_Attlist::TRquote& CMs_Base::C_Attlist::GetRquote(void) const
{
    if (!CanGetRquote()) {
        ThrowUnassigned(17);
    }
    return m_Rquote;
}

inline
void CMs_Base::C_Attlist::SetRquote(const CMs_Base::C_Attlist::TRquote& value)
{
    m_Rquote = value;
    m_set_State[1] |= 0xc;
}

inline
void CMs_Base::C_Attlist::SetRquote(CMs_Base::C_Attlist::TRquote&& value)
{
    m_Rquote = std::forward<CMs_Base::C_Attlist::TRquote>(value);
    m_set_State[1] |= 0xc;
}

inline
CMs_Base::C_Attlist::TRquote& CMs_Base::C_Attlist::SetRquote(void)
{
#ifdef _DEBUG
    if (!IsSetRquote()) {
        m_Rquote = UnassignedString();
    }
#endif
    m_set_State[1] |= 0x4;
    return m_Rquote;
}

inline
CMs_Base::C_E_Ms::E_Choice CMs_Base::C_E_Ms::Which(void) const
{
    return m_choice;
}

inline
void CMs_Base::C_E_Ms::CheckSelected(E_Choice index) const
{
    if ( m_choice != index )
        ThrowInvalidSelection(index);
}

inline
void CMs_Base::C_E_Ms::Select(E_Choice index, NCBI_NS_NCBI::EResetVariant reset, NCBI_NS_NCBI::CObjectMemoryPool* pool)
{
    if ( reset == NCBI_NS_NCBI::eDoResetVariant || m_choice != index ) {
        if ( m_choice != e_not_set )
            ResetSelection();
        DoSelect(index, pool);
    }
}

inline
void CMs_Base::C_E_Ms::Select(E_Choice index, NCBI_NS_NCBI::EResetVariant reset)
{
    Select(index, reset, 0);
}

inline
bool CMs_Base::C_E_Ms::Is_CharData(void) const
{
    return m_choice == e__CharData;
}

inline
const CMs_Base::C_E_Ms::T_CharData& CMs_Base::C_E_Ms::Get_CharData(void) const
{
    CheckSelected(e__CharData);
    return *m_string;
}

inline
CMs_Base::C_E_Ms::T_CharData& CMs_Base::C_E_Ms::Set_CharData(void)
{
    Select(e__CharData, NCBI_NS_NCBI::eDoNotResetVariant);
    return *m_string;
}

inline
bool CMs_Base::C_E_Ms::IsToken_content(void) const
{
    return m_choice == e_Token_content;
}

inline
bool CMs_Base::IsSetAttlist(void) const
{
    return m_Attlist.NotEmpty();
}

inline
bool CMs_Base::CanGetAttlist(void) const
{
    return true;
}

inline
const CMs_Base::TAttlist& CMs_Base::GetAttlist(void) const
{
    if ( !m_Attlist ) {
        const_cast<CMs_Base*>(this)->ResetAttlist();
    }
    return (*m_Attlist);
}

inline
CMs_Base::TAttlist& CMs_Base::SetAttlist(void)
{
    if ( !m_Attlist ) {
        ResetAttlist();
    }
    return (*m_Attlist);
}

inline
bool CMs_Base::IsSetMs(void) const
{
    return ((m_set_State[0] & 0xc) != 0);
}

inline
bool CMs_Base::CanGetMs(void) const
{
    return true;
}

inline
const CMs_Base::TMs& CMs_Base::GetMs(void) const
{
    return m_Ms;
}

inline
CMs_Base::TMs& CMs_Base::SetMs(void)
{
    m_set_State[0] |= 0x4;
    return m_Ms;
}

///////////////////////////////////////////////////////////
////////////////// end of inline methods //////////////////
///////////////////////////////////////////////////////////





END_eutils_SCOPE // namespace eutils::


#endif // eutils__OBJTOOLS_EUTILS_EFETCH_MS_BASE_HPP
