/* $Id$
 * ===========================================================================
 *
 *                            PUBLIC DOMAIN NOTICE
 *               National Center for Biotechnology Information
 *
 *  This software/database is a "United States Government Work" under the
 *  terms of the United States Copyright Act.  It was written as part of
 *  the author's official duties as a United States Government employee and
 *  thus cannot be copyrighted.  This software/database is freely available
 *  to the public for use. The National Library of Medicine and the U.S.
 *  Government have not placed any restriction on its use or reproduction.
 *
 *  Although all reasonable efforts have been taken to ensure the accuracy
 *  and reliability of the software and data, the NLM and the U.S.
 *  Government do not and cannot warrant the performance or results that
 *  may be obtained by using this software or data. The NLM and the U.S.
 *  Government disclaim all warranties, express or implied, including
 *  warranties of performance, merchantability or fitness for any particular
 *  purpose.
 *
 *  Please cite the author in any work or product based on this material.
 *
 * ===========================================================================
 *
 */

/// @file ItemList_.hpp
/// Data storage class.
///
/// This file was generated by application DATATOOL
/// using the following specifications:
/// 'efetch.xsd'.
///
/// ATTENTION:
///   Don't edit or commit this file into CVS as this file will
///   be overridden (by DATATOOL) without warning!

#ifndef eutils__OBJTOOLS_EUTILS_EFETCH_ITEMLIST_BASE_HPP
#define eutils__OBJTOOLS_EUTILS_EFETCH_ITEMLIST_BASE_HPP

// standard includes
#include <serial/serialbase.hpp>

// generated includes
#include <list>
#include <string>

#ifndef BEGIN_eutils_SCOPE
#  define BEGIN_eutils_SCOPE BEGIN_SCOPE(eutils)
#  define END_eutils_SCOPE END_SCOPE(eutils)
#endif
BEGIN_eutils_SCOPE // namespace eutils::


// forward declarations
class CItem;


// generated classes

/////////////////////////////////////////////////////////////////////////////
class CItemList_Base : public NCBI_NS_NCBI::CSerialObject
{
    typedef NCBI_NS_NCBI::CSerialObject Tparent;
public:
    // constructor
    CItemList_Base(void);
    // destructor
    virtual ~CItemList_Base(void);

    // type info
    DECLARE_INTERNAL_TYPE_INFO();

    /////////////////////////////////////////////////////////////////////////////
    class C_Attlist : public NCBI_NS_NCBI::CSerialObject
    {
        typedef NCBI_NS_NCBI::CSerialObject Tparent;
    public:
        // constructor
        C_Attlist(void);
        // destructor
        ~C_Attlist(void);
    
        // type info
        DECLARE_INTERNAL_TYPE_INFO();
    
        // types
        typedef NCBI_NS_STD::string TListType;
    
        // member index
        enum class E_memberIndex {
            e__allMandatory = 0,
            e_ListType
        };
        typedef Tparent::CMemberIndex<E_memberIndex, 2> TmemberIndex;
    
        // getters
        // setters
    
        /// mandatory
        /// typedef NCBI_NS_STD::string TListType
        ///  Check whether the ListType data member has been assigned a value.
        bool IsSetListType(void) const;
        /// Check whether it is safe or not to call GetListType method.
        bool CanGetListType(void) const;
        void ResetListType(void);
        const TListType& GetListType(void) const;
        void SetListType(const TListType& value);
        void SetListType(TListType&& value);
        TListType& SetListType(void);
    
        /// Reset the whole object
        void Reset(void);
    
    
    private:
        // Prohibit copy constructor and assignment operator
        C_Attlist(const C_Attlist&);
        C_Attlist& operator=(const C_Attlist&);
    
        // data
        Uint4 m_set_State[1];
        NCBI_NS_STD::string m_ListType;
    };
    // types
    typedef C_Attlist TAttlist;
    typedef NCBI_NS_STD::list< NCBI_NS_NCBI::CRef< CItem > > TItem;

    // member index
    enum class E_memberIndex {
        e__allMandatory = 0,
        e_Attlist,
        e_Item
    };
    typedef Tparent::CMemberIndex<E_memberIndex, 3> TmemberIndex;

    // getters
    // setters

    /// mandatory
    /// typedef C_Attlist TAttlist
    ///  Check whether the Attlist data member has been assigned a value.
    bool IsSetAttlist(void) const;
    /// Check whether it is safe or not to call GetAttlist method.
    bool CanGetAttlist(void) const;
    void ResetAttlist(void);
    const TAttlist& GetAttlist(void) const;
    void SetAttlist(TAttlist& value);
    TAttlist& SetAttlist(void);

    /// mandatory
    /// typedef NCBI_NS_STD::list< NCBI_NS_NCBI::CRef< CItem > > TItem
    ///  Check whether the Item data member has been assigned a value.
    bool IsSetItem(void) const;
    /// Check whether it is safe or not to call GetItem method.
    bool CanGetItem(void) const;
    void ResetItem(void);
    const TItem& GetItem(void) const;
    TItem& SetItem(void);

    /// Reset the whole object
    virtual void Reset(void);


private:
    // Prohibit copy constructor and assignment operator
    CItemList_Base(const CItemList_Base&);
    CItemList_Base& operator=(const CItemList_Base&);

    // data
    Uint4 m_set_State[1];
    NCBI_NS_NCBI::CRef< TAttlist > m_Attlist;
    NCBI_NS_STD::list< NCBI_NS_NCBI::CRef< CItem > > m_Item;
};






///////////////////////////////////////////////////////////
///////////////////// inline methods //////////////////////
///////////////////////////////////////////////////////////
inline
bool CItemList_Base::C_Attlist::IsSetListType(void) const
{
    return ((m_set_State[0] & 0x3) != 0);
}

inline
bool CItemList_Base::C_Attlist::CanGetListType(void) const
{
    return IsSetListType();
}

inline
const CItemList_Base::C_Attlist::TListType& CItemList_Base::C_Attlist::GetListType(void) const
{
    if (!CanGetListType()) {
        ThrowUnassigned(0);
    }
    return m_ListType;
}

inline
void CItemList_Base::C_Attlist::SetListType(const CItemList_Base::C_Attlist::TListType& value)
{
    m_ListType = value;
    m_set_State[0] |= 0x3;
}

inline
void CItemList_Base::C_Attlist::SetListType(CItemList_Base::C_Attlist::TListType&& value)
{
    m_ListType = std::forward<CItemList_Base::C_Attlist::TListType>(value);
    m_set_State[0] |= 0x3;
}

inline
CItemList_Base::C_Attlist::TListType& CItemList_Base::C_Attlist::SetListType(void)
{
#ifdef _DEBUG
    if (!IsSetListType()) {
        m_ListType = UnassignedString();
    }
#endif
    m_set_State[0] |= 0x1;
    return m_ListType;
}

inline
bool CItemList_Base::IsSetAttlist(void) const
{
    return m_Attlist.NotEmpty();
}

inline
bool CItemList_Base::CanGetAttlist(void) const
{
    return true;
}

inline
const CItemList_Base::TAttlist& CItemList_Base::GetAttlist(void) const
{
    if ( !m_Attlist ) {
        const_cast<CItemList_Base*>(this)->ResetAttlist();
    }
    return (*m_Attlist);
}

inline
CItemList_Base::TAttlist& CItemList_Base::SetAttlist(void)
{
    if ( !m_Attlist ) {
        ResetAttlist();
    }
    return (*m_Attlist);
}

inline
bool CItemList_Base::IsSetItem(void) const
{
    return ((m_set_State[0] & 0xc) != 0);
}

inline
bool CItemList_Base::CanGetItem(void) const
{
    return true;
}

inline
const CItemList_Base::TItem& CItemList_Base::GetItem(void) const
{
    return m_Item;
}

inline
CItemList_Base::TItem& CItemList_Base::SetItem(void)
{
    m_set_State[0] |= 0x4;
    return m_Item;
}

///////////////////////////////////////////////////////////
////////////////// end of inline methods //////////////////
///////////////////////////////////////////////////////////





END_eutils_SCOPE // namespace eutils::


#endif // eutils__OBJTOOLS_EUTILS_EFETCH_ITEMLIST_BASE_HPP
