/* $Id$
 * ===========================================================================
 *
 *                            PUBLIC DOMAIN NOTICE
 *               National Center for Biotechnology Information
 *
 *  This software/database is a "United States Government Work" under the
 *  terms of the United States Copyright Act.  It was written as part of
 *  the author's official duties as a United States Government employee and
 *  thus cannot be copyrighted.  This software/database is freely available
 *  to the public for use. The National Library of Medicine and the U.S.
 *  Government have not placed any restriction on its use or reproduction.
 *
 *  Although all reasonable efforts have been taken to ensure the accuracy
 *  and reliability of the software and data, the NLM and the U.S.
 *  Government do not and cannot warrant the performance or results that
 *  may be obtained by using this software or data. The NLM and the U.S.
 *  Government disclaim all warranties, express or implied, including
 *  warranties of performance, merchantability or fitness for any particular
 *  purpose.
 *
 *  Please cite the author in any work or product based on this material.
 *
 * ===========================================================================
 *
 */

/// @file DescriptorName_.hpp
/// Data storage class.
///
/// This file was generated by application DATATOOL
/// using the following specifications:
/// 'efetch.xsd'.
///
/// ATTENTION:
///   Don't edit or commit this file into CVS as this file will
///   be overridden (by DATATOOL) without warning!

#ifndef eutils__OBJTOOLS_EUTILS_EFETCH_DESCRIPTORNAME_BASE_HPP
#define eutils__OBJTOOLS_EUTILS_EFETCH_DESCRIPTORNAME_BASE_HPP

// standard includes
#include <serial/serialbase.hpp>

// generated includes
#include <string>

#ifndef BEGIN_eutils_SCOPE
#  define BEGIN_eutils_SCOPE BEGIN_SCOPE(eutils)
#  define END_eutils_SCOPE END_SCOPE(eutils)
#endif
BEGIN_eutils_SCOPE // namespace eutils::


// generated classes

/////////////////////////////////////////////////////////////////////////////
class CDescriptorName_Base : public NCBI_NS_NCBI::CSerialObject
{
    typedef NCBI_NS_NCBI::CSerialObject Tparent;
public:
    // constructor
    CDescriptorName_Base(void);
    // destructor
    virtual ~CDescriptorName_Base(void);

    // type info
    DECLARE_INTERNAL_TYPE_INFO();

    /////////////////////////////////////////////////////////////////////////////
    class C_Attlist : public NCBI_NS_NCBI::CSerialObject
    {
        typedef NCBI_NS_NCBI::CSerialObject Tparent;
    public:
        // constructor
        C_Attlist(void);
        // destructor
        ~C_Attlist(void);
    
        // type info
        DECLARE_INTERNAL_TYPE_INFO();
    
        enum EAttlist_MajorTopicYN {
            eAttlist_MajorTopicYN_Y = 1,
            eAttlist_MajorTopicYN_N = 2
        };
        
        /// Access to EAttlist_MajorTopicYN's attributes (values, names) as defined in spec
        static const NCBI_NS_NCBI::CEnumeratedTypeValues* ENUM_METHOD_NAME(EAttlist_MajorTopicYN)(void);
        
        enum EAttlist_Type {
            eAttlist_Type_Geographic = 1
        };
        
        /// Access to EAttlist_Type's attributes (values, names) as defined in spec
        static const NCBI_NS_NCBI::CEnumeratedTypeValues* ENUM_METHOD_NAME(EAttlist_Type)(void);
        
        // types
        typedef EAttlist_MajorTopicYN TMajorTopicYN;
        typedef EAttlist_Type TType;
        typedef NCBI_NS_STD::string TUI;
    
        // member index
        enum class E_memberIndex {
            e__allMandatory = 0,
            e_MajorTopicYN,
            e_Type,
            e_UI
        };
        typedef Tparent::CMemberIndex<E_memberIndex, 4> TmemberIndex;
    
        // getters
        // setters
    
        /// optional with default eAttlist_MajorTopicYN_N
        /// typedef EAttlist_MajorTopicYN TMajorTopicYN
        ///  Check whether the MajorTopicYN data member has been assigned a value.
        bool IsSetMajorTopicYN(void) const;
        /// Check whether it is safe or not to call GetMajorTopicYN method.
        bool CanGetMajorTopicYN(void) const;
        void ResetMajorTopicYN(void);
        void SetDefaultMajorTopicYN(void);
        TMajorTopicYN GetMajorTopicYN(void) const;
        void SetMajorTopicYN(TMajorTopicYN value);
        TMajorTopicYN& SetMajorTopicYN(void);
    
        /// optional
        /// typedef EAttlist_Type TType
        ///  Check whether the Type data member has been assigned a value.
        bool IsSetType(void) const;
        /// Check whether it is safe or not to call GetType method.
        bool CanGetType(void) const;
        void ResetType(void);
        TType GetType(void) const;
        void SetType(TType value);
        TType& SetType(void);
    
        /// mandatory
        /// typedef NCBI_NS_STD::string TUI
        ///  Check whether the UI data member has been assigned a value.
        bool IsSetUI(void) const;
        /// Check whether it is safe or not to call GetUI method.
        bool CanGetUI(void) const;
        void ResetUI(void);
        const TUI& GetUI(void) const;
        void SetUI(const TUI& value);
        void SetUI(TUI&& value);
        TUI& SetUI(void);
    
        /// Reset the whole object
        void Reset(void);
    
    
    private:
        // Prohibit copy constructor and assignment operator
        C_Attlist(const C_Attlist&);
        C_Attlist& operator=(const C_Attlist&);
    
        // data
        Uint4 m_set_State[1];
        EAttlist_MajorTopicYN m_MajorTopicYN;
        EAttlist_Type m_Type;
        NCBI_NS_STD::string m_UI;
    };
    // types
    typedef C_Attlist TAttlist;
    typedef NCBI_NS_STD::string TDescriptorName;

    // member index
    enum class E_memberIndex {
        e__allMandatory = 0,
        e_Attlist,
        e_DescriptorName
    };
    typedef Tparent::CMemberIndex<E_memberIndex, 3> TmemberIndex;

    // getters
    // setters

    /// mandatory
    /// typedef C_Attlist TAttlist
    ///  Check whether the Attlist data member has been assigned a value.
    bool IsSetAttlist(void) const;
    /// Check whether it is safe or not to call GetAttlist method.
    bool CanGetAttlist(void) const;
    void ResetAttlist(void);
    const TAttlist& GetAttlist(void) const;
    void SetAttlist(TAttlist& value);
    TAttlist& SetAttlist(void);

    /// mandatory
    /// typedef NCBI_NS_STD::string TDescriptorName
    ///  Check whether the DescriptorName data member has been assigned a value.
    bool IsSetDescriptorName(void) const;
    /// Check whether it is safe or not to call GetDescriptorName method.
    bool CanGetDescriptorName(void) const;
    void ResetDescriptorName(void);
    const TDescriptorName& GetDescriptorName(void) const;
    void SetDescriptorName(const TDescriptorName& value);
    void SetDescriptorName(TDescriptorName&& value);
    TDescriptorName& SetDescriptorName(void);

    /// Reset the whole object
    virtual void Reset(void);


private:
    // Prohibit copy constructor and assignment operator
    CDescriptorName_Base(const CDescriptorName_Base&);
    CDescriptorName_Base& operator=(const CDescriptorName_Base&);

    // data
    Uint4 m_set_State[1];
    NCBI_NS_NCBI::CRef< TAttlist > m_Attlist;
    NCBI_NS_STD::string m_DescriptorName;
};






///////////////////////////////////////////////////////////
///////////////////// inline methods //////////////////////
///////////////////////////////////////////////////////////
inline
bool CDescriptorName_Base::C_Attlist::IsSetMajorTopicYN(void) const
{
    return ((m_set_State[0] & 0x3) != 0);
}

inline
bool CDescriptorName_Base::C_Attlist::CanGetMajorTopicYN(void) const
{
    return true;
}

inline
void CDescriptorName_Base::C_Attlist::ResetMajorTopicYN(void)
{
    m_MajorTopicYN = eAttlist_MajorTopicYN_N;
    m_set_State[0] &= ~0x3;
}

inline
void CDescriptorName_Base::C_Attlist::SetDefaultMajorTopicYN(void)
{
    ResetMajorTopicYN();
    m_set_State[0] |= 0x1;
}

inline
CDescriptorName_Base::C_Attlist::TMajorTopicYN CDescriptorName_Base::C_Attlist::GetMajorTopicYN(void) const
{
    return m_MajorTopicYN;
}

inline
void CDescriptorName_Base::C_Attlist::SetMajorTopicYN(CDescriptorName_Base::C_Attlist::TMajorTopicYN value)
{
    m_MajorTopicYN = value;
    m_set_State[0] |= 0x3;
}

inline
CDescriptorName_Base::C_Attlist::TMajorTopicYN& CDescriptorName_Base::C_Attlist::SetMajorTopicYN(void)
{
#ifdef _DEBUG
    if (!IsSetMajorTopicYN()) {
        memset(&m_MajorTopicYN,UnassignedByte(),sizeof(m_MajorTopicYN));
    }
#endif
    m_set_State[0] |= 0x1;
    return m_MajorTopicYN;
}

inline
bool CDescriptorName_Base::C_Attlist::IsSetType(void) const
{
    return ((m_set_State[0] & 0xc) != 0);
}

inline
bool CDescriptorName_Base::C_Attlist::CanGetType(void) const
{
    return IsSetType();
}

inline
void CDescriptorName_Base::C_Attlist::ResetType(void)
{
    m_Type = (EAttlist_Type)(0);
    m_set_State[0] &= ~0xc;
}

inline
CDescriptorName_Base::C_Attlist::TType CDescriptorName_Base::C_Attlist::GetType(void) const
{
    if (!CanGetType()) {
        ThrowUnassigned(1);
    }
    return m_Type;
}

inline
void CDescriptorName_Base::C_Attlist::SetType(CDescriptorName_Base::C_Attlist::TType value)
{
    m_Type = value;
    m_set_State[0] |= 0xc;
}

inline
CDescriptorName_Base::C_Attlist::TType& CDescriptorName_Base::C_Attlist::SetType(void)
{
#ifdef _DEBUG
    if (!IsSetType()) {
        memset(&m_Type,UnassignedByte(),sizeof(m_Type));
    }
#endif
    m_set_State[0] |= 0x4;
    return m_Type;
}

inline
bool CDescriptorName_Base::C_Attlist::IsSetUI(void) const
{
    return ((m_set_State[0] & 0x30) != 0);
}

inline
bool CDescriptorName_Base::C_Attlist::CanGetUI(void) const
{
    return IsSetUI();
}

inline
const CDescriptorName_Base::C_Attlist::TUI& CDescriptorName_Base::C_Attlist::GetUI(void) const
{
    if (!CanGetUI()) {
        ThrowUnassigned(2);
    }
    return m_UI;
}

inline
void CDescriptorName_Base::C_Attlist::SetUI(const CDescriptorName_Base::C_Attlist::TUI& value)
{
    m_UI = value;
    m_set_State[0] |= 0x30;
}

inline
void CDescriptorName_Base::C_Attlist::SetUI(CDescriptorName_Base::C_Attlist::TUI&& value)
{
    m_UI = std::forward<CDescriptorName_Base::C_Attlist::TUI>(value);
    m_set_State[0] |= 0x30;
}

inline
CDescriptorName_Base::C_Attlist::TUI& CDescriptorName_Base::C_Attlist::SetUI(void)
{
#ifdef _DEBUG
    if (!IsSetUI()) {
        m_UI = UnassignedString();
    }
#endif
    m_set_State[0] |= 0x10;
    return m_UI;
}

inline
bool CDescriptorName_Base::IsSetAttlist(void) const
{
    return m_Attlist.NotEmpty();
}

inline
bool CDescriptorName_Base::CanGetAttlist(void) const
{
    return true;
}

inline
const CDescriptorName_Base::TAttlist& CDescriptorName_Base::GetAttlist(void) const
{
    if ( !m_Attlist ) {
        const_cast<CDescriptorName_Base*>(this)->ResetAttlist();
    }
    return (*m_Attlist);
}

inline
CDescriptorName_Base::TAttlist& CDescriptorName_Base::SetAttlist(void)
{
    if ( !m_Attlist ) {
        ResetAttlist();
    }
    return (*m_Attlist);
}

inline
bool CDescriptorName_Base::IsSetDescriptorName(void) const
{
    return ((m_set_State[0] & 0xc) != 0);
}

inline
bool CDescriptorName_Base::CanGetDescriptorName(void) const
{
    return IsSetDescriptorName();
}

inline
const CDescriptorName_Base::TDescriptorName& CDescriptorName_Base::GetDescriptorName(void) const
{
    if (!CanGetDescriptorName()) {
        ThrowUnassigned(1);
    }
    return m_DescriptorName;
}

inline
void CDescriptorName_Base::SetDescriptorName(const CDescriptorName_Base::TDescriptorName& value)
{
    m_DescriptorName = value;
    m_set_State[0] |= 0xc;
}

inline
void CDescriptorName_Base::SetDescriptorName(CDescriptorName_Base::TDescriptorName&& value)
{
    m_DescriptorName = std::forward<CDescriptorName_Base::TDescriptorName>(value);
    m_set_State[0] |= 0xc;
}

inline
CDescriptorName_Base::TDescriptorName& CDescriptorName_Base::SetDescriptorName(void)
{
#ifdef _DEBUG
    if (!IsSetDescriptorName()) {
        m_DescriptorName = UnassignedString();
    }
#endif
    m_set_State[0] |= 0x4;
    return m_DescriptorName;
}

///////////////////////////////////////////////////////////
////////////////// end of inline methods //////////////////
///////////////////////////////////////////////////////////





END_eutils_SCOPE // namespace eutils::


#endif // eutils__OBJTOOLS_EUTILS_EFETCH_DESCRIPTORNAME_BASE_HPP
