/* $Id$
 * ===========================================================================
 *
 *                            PUBLIC DOMAIN NOTICE
 *               National Center for Biotechnology Information
 *
 *  This software/database is a "United States Government Work" under the
 *  terms of the United States Copyright Act.  It was written as part of
 *  the author's official duties as a United States Government employee and
 *  thus cannot be copyrighted.  This software/database is freely available
 *  to the public for use. The National Library of Medicine and the U.S.
 *  Government have not placed any restriction on its use or reproduction.
 *
 *  Although all reasonable efforts have been taken to ensure the accuracy
 *  and reliability of the software and data, the NLM and the U.S.
 *  Government do not and cannot warrant the performance or results that
 *  may be obtained by using this software or data. The NLM and the U.S.
 *  Government disclaim all warranties, express or implied, including
 *  warranties of performance, merchantability or fitness for any particular
 *  purpose.
 *
 *  Please cite the author in any work or product based on this material.
 *
 * ===========================================================================
 *
 */

/// @file Author_.hpp
/// Data storage class.
///
/// This file was generated by application DATATOOL
/// using the following specifications:
/// 'efetch.xsd'.
///
/// ATTENTION:
///   Don't edit or commit this file into CVS as this file will
///   be overridden (by DATATOOL) without warning!

#ifndef eutils__OBJTOOLS_EUTILS_EFETCH_AUTHOR_BASE_HPP
#define eutils__OBJTOOLS_EUTILS_EFETCH_AUTHOR_BASE_HPP

// standard includes
#include <serial/serialbase.hpp>

// generated includes
#include <list>

#ifndef BEGIN_eutils_SCOPE
#  define BEGIN_eutils_SCOPE BEGIN_SCOPE(eutils)
#  define END_eutils_SCOPE END_SCOPE(eutils)
#endif
BEGIN_eutils_SCOPE // namespace eutils::


// forward declarations
class CAffiliationInfo;
class CCollectiveName;
class CForeName;
class CIdentifier;
class CInitials;
class CLastName;
class CSuffix;


// generated classes

/////////////////////////////////////////////////////////////////////////////
class CAuthor_Base : public NCBI_NS_NCBI::CSerialObject
{
    typedef NCBI_NS_NCBI::CSerialObject Tparent;
public:
    // constructor
    CAuthor_Base(void);
    // destructor
    virtual ~CAuthor_Base(void);

    // type info
    DECLARE_INTERNAL_TYPE_INFO();

    /////////////////////////////////////////////////////////////////////////////
    class C_Attlist : public NCBI_NS_NCBI::CSerialObject
    {
        typedef NCBI_NS_NCBI::CSerialObject Tparent;
    public:
        // constructor
        C_Attlist(void);
        // destructor
        ~C_Attlist(void);
    
        // type info
        DECLARE_INTERNAL_TYPE_INFO();
    
        enum EAttlist_ValidYN {
            eAttlist_ValidYN_Y = 1,
            eAttlist_ValidYN_N = 2
        };
        
        /// Access to EAttlist_ValidYN's attributes (values, names) as defined in spec
        static const NCBI_NS_NCBI::CEnumeratedTypeValues* ENUM_METHOD_NAME(EAttlist_ValidYN)(void);
        
        enum EAttlist_EqualContrib {
            eAttlist_EqualContrib_Y = 1,
            eAttlist_EqualContrib_N = 2
        };
        
        /// Access to EAttlist_EqualContrib's attributes (values, names) as defined in spec
        static const NCBI_NS_NCBI::CEnumeratedTypeValues* ENUM_METHOD_NAME(EAttlist_EqualContrib)(void);
        
        // types
        typedef EAttlist_ValidYN TValidYN;
        typedef EAttlist_EqualContrib TEqualContrib;
    
        // member index
        enum class E_memberIndex {
            e__allMandatory = 0,
            e_ValidYN,
            e_EqualContrib
        };
        typedef Tparent::CMemberIndex<E_memberIndex, 3> TmemberIndex;
    
        // getters
        // setters
    
        /// optional with default eAttlist_ValidYN_Y
        /// typedef EAttlist_ValidYN TValidYN
        ///  Check whether the ValidYN data member has been assigned a value.
        bool IsSetValidYN(void) const;
        /// Check whether it is safe or not to call GetValidYN method.
        bool CanGetValidYN(void) const;
        void ResetValidYN(void);
        void SetDefaultValidYN(void);
        TValidYN GetValidYN(void) const;
        void SetValidYN(TValidYN value);
        TValidYN& SetValidYN(void);
    
        /// optional
        /// typedef EAttlist_EqualContrib TEqualContrib
        ///  Check whether the EqualContrib data member has been assigned a value.
        bool IsSetEqualContrib(void) const;
        /// Check whether it is safe or not to call GetEqualContrib method.
        bool CanGetEqualContrib(void) const;
        void ResetEqualContrib(void);
        TEqualContrib GetEqualContrib(void) const;
        void SetEqualContrib(TEqualContrib value);
        TEqualContrib& SetEqualContrib(void);
    
        /// Reset the whole object
        void Reset(void);
    
    
    private:
        // Prohibit copy constructor and assignment operator
        C_Attlist(const C_Attlist&);
        C_Attlist& operator=(const C_Attlist&);
    
        // data
        Uint4 m_set_State[1];
        EAttlist_ValidYN m_ValidYN;
        EAttlist_EqualContrib m_EqualContrib;
    };
    /////////////////////////////////////////////////////////////////////////////
    class C_LC : public NCBI_NS_NCBI::CSerialObject
    {
        typedef NCBI_NS_NCBI::CSerialObject Tparent;
    public:
        // constructor
        C_LC(void);
        // destructor
        ~C_LC(void);
    
        // type info
        DECLARE_INTERNAL_TYPE_INFO();
    
        /////////////////////////////////////////////////////////////////////////////
        class C_LFIS : public NCBI_NS_NCBI::CSerialObject
        {
            typedef NCBI_NS_NCBI::CSerialObject Tparent;
        public:
            // constructor
            C_LFIS(void);
            // destructor
            ~C_LFIS(void);
        
            // type info
            DECLARE_INTERNAL_TYPE_INFO();
        
            // types
            typedef CLastName TLastName;
            typedef CForeName TForeName;
            typedef CInitials TInitials;
            typedef CSuffix TSuffix;
        
            // member index
            enum class E_memberIndex {
                e__allMandatory = 0,
                e_LastName,
                e_ForeName,
                e_Initials,
                e_Suffix
            };
            typedef Tparent::CMemberIndex<E_memberIndex, 5> TmemberIndex;
        
            // getters
            // setters
        
            /// mandatory
            /// typedef CLastName TLastName
            ///  Check whether the LastName data member has been assigned a value.
            bool IsSetLastName(void) const;
            /// Check whether it is safe or not to call GetLastName method.
            bool CanGetLastName(void) const;
            void ResetLastName(void);
            const TLastName& GetLastName(void) const;
            void SetLastName(TLastName& value);
            TLastName& SetLastName(void);
        
            /// optional
            /// typedef CForeName TForeName
            ///  Check whether the ForeName data member has been assigned a value.
            bool IsSetForeName(void) const;
            /// Check whether it is safe or not to call GetForeName method.
            bool CanGetForeName(void) const;
            void ResetForeName(void);
            const TForeName& GetForeName(void) const;
            void SetForeName(TForeName& value);
            TForeName& SetForeName(void);
        
            /// optional
            /// typedef CInitials TInitials
            ///  Check whether the Initials data member has been assigned a value.
            bool IsSetInitials(void) const;
            /// Check whether it is safe or not to call GetInitials method.
            bool CanGetInitials(void) const;
            void ResetInitials(void);
            const TInitials& GetInitials(void) const;
            void SetInitials(TInitials& value);
            TInitials& SetInitials(void);
        
            /// optional
            /// typedef CSuffix TSuffix
            ///  Check whether the Suffix data member has been assigned a value.
            bool IsSetSuffix(void) const;
            /// Check whether it is safe or not to call GetSuffix method.
            bool CanGetSuffix(void) const;
            void ResetSuffix(void);
            const TSuffix& GetSuffix(void) const;
            void SetSuffix(TSuffix& value);
            TSuffix& SetSuffix(void);
        
            /// Reset the whole object
            void Reset(void);
        
        
        private:
            // Prohibit copy constructor and assignment operator
            C_LFIS(const C_LFIS&);
            C_LFIS& operator=(const C_LFIS&);
        
            // data
            Uint4 m_set_State[1];
            NCBI_NS_NCBI::CRef< TLastName > m_LastName;
            NCBI_NS_NCBI::CRef< TForeName > m_ForeName;
            NCBI_NS_NCBI::CRef< TInitials > m_Initials;
            NCBI_NS_NCBI::CRef< TSuffix > m_Suffix;
        };
    
        /// Choice variants.
        enum E_Choice {
            e_not_set = 0,     ///< No variant selected
            e_LFIS,
            e_CollectiveName
        };
        /// Maximum+1 value of the choice variant enumerator.
        enum E_ChoiceStopper {
            e_MaxChoice = 3 ///< == e_CollectiveName+1
        };
    
        /// Reset the whole object
        void Reset(void);
    
        /// Reset the selection (set it to e_not_set).
        void ResetSelection(void);
    
        /// Which variant is currently selected.
        E_Choice Which(void) const;
    
        /// Verify selection, throw exception if it differs from the expected.
        void CheckSelected(E_Choice index) const;
    
        /// Throw 'InvalidSelection' exception.
        NCBI_NORETURN void ThrowInvalidSelection(E_Choice index) const;
    
        /// Retrieve selection name (for diagnostic purposes).
        static NCBI_NS_STD::string SelectionName(E_Choice index);
    
        /// Select the requested variant if needed.
        void Select(E_Choice index, NCBI_NS_NCBI::EResetVariant reset = NCBI_NS_NCBI::eDoResetVariant);
        /// Select the requested variant if needed,
        /// allocating CObject variants from memory pool.
        void Select(E_Choice index,
                    NCBI_NS_NCBI::EResetVariant reset,
                    NCBI_NS_NCBI::CObjectMemoryPool* pool);
    
        // types
        typedef C_LFIS TLFIS;
        typedef CCollectiveName TCollectiveName;
    
        // getters
        // setters
    
        // typedef C_LFIS TLFIS
        bool IsLFIS(void) const;
        const TLFIS& GetLFIS(void) const;
        TLFIS& SetLFIS(void);
        void SetLFIS(TLFIS& value);
    
        // typedef CCollectiveName TCollectiveName
        bool IsCollectiveName(void) const;
        const TCollectiveName& GetCollectiveName(void) const;
        TCollectiveName& SetCollectiveName(void);
        void SetCollectiveName(TCollectiveName& value);
    
    
    private:
        // copy constructor and assignment operator
        C_LC(const C_LC& );
        C_LC& operator=(const C_LC& );
        // choice state
        E_Choice m_choice;
        // helper methods
        void DoSelect(E_Choice index, NCBI_NS_NCBI::CObjectMemoryPool* pool = 0);
    
        static const char* const sm_SelectionNames[];
        // data
        NCBI_NS_NCBI::CSerialObject *m_object;
    };
    // types
    typedef C_Attlist TAttlist;
    typedef C_LC TLC;
    typedef NCBI_NS_STD::list< NCBI_NS_NCBI::CRef< CIdentifier > > TIdentifier;
    typedef NCBI_NS_STD::list< NCBI_NS_NCBI::CRef< CAffiliationInfo > > TAffiliationInfo;

    // member index
    enum class E_memberIndex {
        e__allMandatory = 0,
        e_Attlist,
        e_LC,
        e_Identifier,
        e_AffiliationInfo
    };
    typedef Tparent::CMemberIndex<E_memberIndex, 5> TmemberIndex;

    // getters
    // setters

    /// mandatory
    /// typedef C_Attlist TAttlist
    ///  Check whether the Attlist data member has been assigned a value.
    bool IsSetAttlist(void) const;
    /// Check whether it is safe or not to call GetAttlist method.
    bool CanGetAttlist(void) const;
    void ResetAttlist(void);
    const TAttlist& GetAttlist(void) const;
    void SetAttlist(TAttlist& value);
    TAttlist& SetAttlist(void);

    /// mandatory
    /// typedef C_LC TLC
    ///  Check whether the LC data member has been assigned a value.
    bool IsSetLC(void) const;
    /// Check whether it is safe or not to call GetLC method.
    bool CanGetLC(void) const;
    void ResetLC(void);
    const TLC& GetLC(void) const;
    void SetLC(TLC& value);
    TLC& SetLC(void);

    /// optional
    /// typedef NCBI_NS_STD::list< NCBI_NS_NCBI::CRef< CIdentifier > > TIdentifier
    ///  Check whether the Identifier data member has been assigned a value.
    bool IsSetIdentifier(void) const;
    /// Check whether it is safe or not to call GetIdentifier method.
    bool CanGetIdentifier(void) const;
    void ResetIdentifier(void);
    const TIdentifier& GetIdentifier(void) const;
    TIdentifier& SetIdentifier(void);

    /// optional
    /// typedef NCBI_NS_STD::list< NCBI_NS_NCBI::CRef< CAffiliationInfo > > TAffiliationInfo
    ///  Check whether the AffiliationInfo data member has been assigned a value.
    bool IsSetAffiliationInfo(void) const;
    /// Check whether it is safe or not to call GetAffiliationInfo method.
    bool CanGetAffiliationInfo(void) const;
    void ResetAffiliationInfo(void);
    const TAffiliationInfo& GetAffiliationInfo(void) const;
    TAffiliationInfo& SetAffiliationInfo(void);

    /// Reset the whole object
    virtual void Reset(void);


private:
    // Prohibit copy constructor and assignment operator
    CAuthor_Base(const CAuthor_Base&);
    CAuthor_Base& operator=(const CAuthor_Base&);

    // data
    Uint4 m_set_State[1];
    NCBI_NS_NCBI::CRef< TAttlist > m_Attlist;
    NCBI_NS_NCBI::CRef< TLC > m_LC;
    NCBI_NS_STD::list< NCBI_NS_NCBI::CRef< CIdentifier > > m_Identifier;
    NCBI_NS_STD::list< NCBI_NS_NCBI::CRef< CAffiliationInfo > > m_AffiliationInfo;
};






///////////////////////////////////////////////////////////
///////////////////// inline methods //////////////////////
///////////////////////////////////////////////////////////
inline
bool CAuthor_Base::C_Attlist::IsSetValidYN(void) const
{
    return ((m_set_State[0] & 0x3) != 0);
}

inline
bool CAuthor_Base::C_Attlist::CanGetValidYN(void) const
{
    return true;
}

inline
void CAuthor_Base::C_Attlist::ResetValidYN(void)
{
    m_ValidYN = eAttlist_ValidYN_Y;
    m_set_State[0] &= ~0x3;
}

inline
void CAuthor_Base::C_Attlist::SetDefaultValidYN(void)
{
    ResetValidYN();
    m_set_State[0] |= 0x1;
}

inline
CAuthor_Base::C_Attlist::TValidYN CAuthor_Base::C_Attlist::GetValidYN(void) const
{
    return m_ValidYN;
}

inline
void CAuthor_Base::C_Attlist::SetValidYN(CAuthor_Base::C_Attlist::TValidYN value)
{
    m_ValidYN = value;
    m_set_State[0] |= 0x3;
}

inline
CAuthor_Base::C_Attlist::TValidYN& CAuthor_Base::C_Attlist::SetValidYN(void)
{
#ifdef _DEBUG
    if (!IsSetValidYN()) {
        memset(&m_ValidYN,UnassignedByte(),sizeof(m_ValidYN));
    }
#endif
    m_set_State[0] |= 0x1;
    return m_ValidYN;
}

inline
bool CAuthor_Base::C_Attlist::IsSetEqualContrib(void) const
{
    return ((m_set_State[0] & 0xc) != 0);
}

inline
bool CAuthor_Base::C_Attlist::CanGetEqualContrib(void) const
{
    return IsSetEqualContrib();
}

inline
void CAuthor_Base::C_Attlist::ResetEqualContrib(void)
{
    m_EqualContrib = (EAttlist_EqualContrib)(0);
    m_set_State[0] &= ~0xc;
}

inline
CAuthor_Base::C_Attlist::TEqualContrib CAuthor_Base::C_Attlist::GetEqualContrib(void) const
{
    if (!CanGetEqualContrib()) {
        ThrowUnassigned(1);
    }
    return m_EqualContrib;
}

inline
void CAuthor_Base::C_Attlist::SetEqualContrib(CAuthor_Base::C_Attlist::TEqualContrib value)
{
    m_EqualContrib = value;
    m_set_State[0] |= 0xc;
}

inline
CAuthor_Base::C_Attlist::TEqualContrib& CAuthor_Base::C_Attlist::SetEqualContrib(void)
{
#ifdef _DEBUG
    if (!IsSetEqualContrib()) {
        memset(&m_EqualContrib,UnassignedByte(),sizeof(m_EqualContrib));
    }
#endif
    m_set_State[0] |= 0x4;
    return m_EqualContrib;
}

inline
bool CAuthor_Base::C_LC::C_LFIS::IsSetLastName(void) const
{
    return m_LastName.NotEmpty();
}

inline
bool CAuthor_Base::C_LC::C_LFIS::CanGetLastName(void) const
{
    return true;
}

inline
const CAuthor_Base::C_LC::C_LFIS::TLastName& CAuthor_Base::C_LC::C_LFIS::GetLastName(void) const
{
    if ( !m_LastName ) {
        const_cast<C_LFIS*>(this)->ResetLastName();
    }
    return (*m_LastName);
}

inline
CAuthor_Base::C_LC::C_LFIS::TLastName& CAuthor_Base::C_LC::C_LFIS::SetLastName(void)
{
    if ( !m_LastName ) {
        ResetLastName();
    }
    return (*m_LastName);
}

inline
bool CAuthor_Base::C_LC::C_LFIS::IsSetForeName(void) const
{
    return m_ForeName.NotEmpty();
}

inline
bool CAuthor_Base::C_LC::C_LFIS::CanGetForeName(void) const
{
    return IsSetForeName();
}

inline
const CAuthor_Base::C_LC::C_LFIS::TForeName& CAuthor_Base::C_LC::C_LFIS::GetForeName(void) const
{
    if (!CanGetForeName()) {
        ThrowUnassigned(1);
    }
    return (*m_ForeName);
}

inline
bool CAuthor_Base::C_LC::C_LFIS::IsSetInitials(void) const
{
    return m_Initials.NotEmpty();
}

inline
bool CAuthor_Base::C_LC::C_LFIS::CanGetInitials(void) const
{
    return IsSetInitials();
}

inline
const CAuthor_Base::C_LC::C_LFIS::TInitials& CAuthor_Base::C_LC::C_LFIS::GetInitials(void) const
{
    if (!CanGetInitials()) {
        ThrowUnassigned(2);
    }
    return (*m_Initials);
}

inline
bool CAuthor_Base::C_LC::C_LFIS::IsSetSuffix(void) const
{
    return m_Suffix.NotEmpty();
}

inline
bool CAuthor_Base::C_LC::C_LFIS::CanGetSuffix(void) const
{
    return IsSetSuffix();
}

inline
const CAuthor_Base::C_LC::C_LFIS::TSuffix& CAuthor_Base::C_LC::C_LFIS::GetSuffix(void) const
{
    if (!CanGetSuffix()) {
        ThrowUnassigned(3);
    }
    return (*m_Suffix);
}

inline
CAuthor_Base::C_LC::E_Choice CAuthor_Base::C_LC::Which(void) const
{
    return m_choice;
}

inline
void CAuthor_Base::C_LC::CheckSelected(E_Choice index) const
{
    if ( m_choice != index )
        ThrowInvalidSelection(index);
}

inline
void CAuthor_Base::C_LC::Select(E_Choice index, NCBI_NS_NCBI::EResetVariant reset, NCBI_NS_NCBI::CObjectMemoryPool* pool)
{
    if ( reset == NCBI_NS_NCBI::eDoResetVariant || m_choice != index ) {
        if ( m_choice != e_not_set )
            ResetSelection();
        DoSelect(index, pool);
    }
}

inline
void CAuthor_Base::C_LC::Select(E_Choice index, NCBI_NS_NCBI::EResetVariant reset)
{
    Select(index, reset, 0);
}

inline
bool CAuthor_Base::C_LC::IsLFIS(void) const
{
    return m_choice == e_LFIS;
}

inline
bool CAuthor_Base::C_LC::IsCollectiveName(void) const
{
    return m_choice == e_CollectiveName;
}

inline
bool CAuthor_Base::IsSetAttlist(void) const
{
    return m_Attlist.NotEmpty();
}

inline
bool CAuthor_Base::CanGetAttlist(void) const
{
    return true;
}

inline
const CAuthor_Base::TAttlist& CAuthor_Base::GetAttlist(void) const
{
    if ( !m_Attlist ) {
        const_cast<CAuthor_Base*>(this)->ResetAttlist();
    }
    return (*m_Attlist);
}

inline
CAuthor_Base::TAttlist& CAuthor_Base::SetAttlist(void)
{
    if ( !m_Attlist ) {
        ResetAttlist();
    }
    return (*m_Attlist);
}

inline
bool CAuthor_Base::IsSetLC(void) const
{
    return m_LC.NotEmpty();
}

inline
bool CAuthor_Base::CanGetLC(void) const
{
    return true;
}

inline
const CAuthor_Base::TLC& CAuthor_Base::GetLC(void) const
{
    if ( !m_LC ) {
        const_cast<CAuthor_Base*>(this)->ResetLC();
    }
    return (*m_LC);
}

inline
CAuthor_Base::TLC& CAuthor_Base::SetLC(void)
{
    if ( !m_LC ) {
        ResetLC();
    }
    return (*m_LC);
}

inline
bool CAuthor_Base::IsSetIdentifier(void) const
{
    return ((m_set_State[0] & 0x30) != 0);
}

inline
bool CAuthor_Base::CanGetIdentifier(void) const
{
    return true;
}

inline
const CAuthor_Base::TIdentifier& CAuthor_Base::GetIdentifier(void) const
{
    return m_Identifier;
}

inline
CAuthor_Base::TIdentifier& CAuthor_Base::SetIdentifier(void)
{
    m_set_State[0] |= 0x10;
    return m_Identifier;
}

inline
bool CAuthor_Base::IsSetAffiliationInfo(void) const
{
    return ((m_set_State[0] & 0xc0) != 0);
}

inline
bool CAuthor_Base::CanGetAffiliationInfo(void) const
{
    return true;
}

inline
const CAuthor_Base::TAffiliationInfo& CAuthor_Base::GetAffiliationInfo(void) const
{
    return m_AffiliationInfo;
}

inline
CAuthor_Base::TAffiliationInfo& CAuthor_Base::SetAffiliationInfo(void)
{
    m_set_State[0] |= 0x40;
    return m_AffiliationInfo;
}

///////////////////////////////////////////////////////////
////////////////// end of inline methods //////////////////
///////////////////////////////////////////////////////////





END_eutils_SCOPE // namespace eutils::


#endif // eutils__OBJTOOLS_EUTILS_EFETCH_AUTHOR_BASE_HPP
