/* $Id$
 * ===========================================================================
 *
 *                            PUBLIC DOMAIN NOTICE
 *               National Center for Biotechnology Information
 *
 *  This software/database is a "United States Government Work" under the
 *  terms of the United States Copyright Act.  It was written as part of
 *  the author's official duties as a United States Government employee and
 *  thus cannot be copyrighted.  This software/database is freely available
 *  to the public for use. The National Library of Medicine and the U.S.
 *  Government have not placed any restriction on its use or reproduction.
 *
 *  Although all reasonable efforts have been taken to ensure the accuracy
 *  and reliability of the software and data, the NLM and the U.S.
 *  Government do not and cannot warrant the performance or results that
 *  may be obtained by using this software or data. The NLM and the U.S.
 *  Government disclaim all warranties, express or implied, including
 *  warranties of performance, merchantability or fitness for any particular
 *  purpose.
 *
 *  Please cite the author in any work or product based on this material.
 *
 * ===========================================================================
 *
 */

/// @file VariantPlacement_.hpp
/// Data storage class.
///
/// This file was generated by application DATATOOL
/// using the following specifications:
/// 'variation.asn'.
///
/// ATTENTION:
///   Don't edit or commit this file into CVS as this file will
///   be overridden (by DATATOOL) without warning!

#ifndef OBJECTS_VARIATION_VARIANTPLACEMENT_BASE_HPP
#define OBJECTS_VARIATION_VARIANTPLACEMENT_BASE_HPP

// standard includes
#include <serial/serialbase.hpp>

// generated includes
#include <list>
#include <string>

BEGIN_NCBI_SCOPE

#ifndef BEGIN_objects_SCOPE
#  define BEGIN_objects_SCOPE BEGIN_SCOPE(objects)
#  define END_objects_SCOPE END_SCOPE(objects)
#endif
BEGIN_objects_SCOPE // namespace ncbi::objects::


// forward declarations
class CDbtag;
class CInt_fuzz;
class CObject_id;
class CSeq_literal;
class CSeq_loc;
class CUser_object;
class CVariationException;


// generated classes

/////////////////////////////////////////////////////////////////////////////
class NCBI_VARIATION_EXPORT CVariantPlacement_Base : public CSerialObject
{
    typedef CSerialObject Tparent;
public:
    // constructor
    CVariantPlacement_Base(void);
    // destructor
    virtual ~CVariantPlacement_Base(void);

    // type info
    DECLARE_INTERNAL_TYPE_INFO();

    enum EMol {
        eMol_unknown       = 0,
        eMol_genomic       = 1,  ///<"g." coordinates in HGVS
        eMol_cdna          = 2,  ///<"c." coordinates in HGVS
        eMol_rna           = 3,  ///<"n." coordinates in HGVS
        eMol_protein       = 4,  ///<"p." coordinates in HGVS
        eMol_mitochondrion = 5  ///<"mt." coordinates in HGVS
    };
    
    /// Access to EMol's attributes (values, names) as defined in spec
    static const NCBI_NS_NCBI::CEnumeratedTypeValues* ENUM_METHOD_NAME(EMol)(void);
    
    /// location flags
    enum EPlacement_method {
        ePlacement_method_projected = 1,
        ePlacement_method_asserted  = 2,
        ePlacement_method_aligned   = 3
    };
    
    /// Access to EPlacement_method's attributes (values, names) as defined in spec
    static const NCBI_NS_NCBI::CEnumeratedTypeValues* ENUM_METHOD_NAME(EPlacement_method)(void);
    
    // types
    typedef CSeq_loc TLoc;
    typedef int TMol;
    typedef int TPlacement_method;
    typedef int TStart_offset;
    typedef CInt_fuzz TStart_offset_fuzz;
    typedef int TStop_offset;
    typedef CInt_fuzz TStop_offset_fuzz;
    typedef int TFrame;
    typedef CSeq_literal TSeq;
    typedef CDbtag TAssembly;
    typedef string THgvs_name;
    typedef string TComment;
    typedef list< CRef< CVariationException > > TExceptions;
    typedef list< CRef< CDbtag > > TDbxrefs;
    typedef list< CRef< CUser_object > > TExt;
    typedef int TGene_location;
    typedef CObject_id TId;
    typedef CObject_id TParent_id;
    typedef list< int > TSo_terms;

    // member index
    enum class E_memberIndex {
        e__allMandatory = 0,
        e_loc,
        e_mol,
        e_placement_method,
        e_start_offset,
        e_start_offset_fuzz,
        e_stop_offset,
        e_stop_offset_fuzz,
        e_frame,
        e_seq,
        e_assembly,
        e_hgvs_name,
        e_comment,
        e_exceptions,
        e_dbxrefs,
        e_ext,
        e_gene_location,
        e_id,
        e_parent_id,
        e_so_terms
    };
    typedef Tparent::CMemberIndex<E_memberIndex, 20> TmemberIndex;

    // getters
    // setters

    /// actual concrete placement we are considering
    /// mandatory
    /// typedef CSeq_loc TLoc
    ///  Check whether the Loc data member has been assigned a value.
    bool IsSetLoc(void) const;
    /// Check whether it is safe or not to call GetLoc method.
    bool CanGetLoc(void) const;
    void ResetLoc(void);
    const TLoc& GetLoc(void) const;
    void SetLoc(TLoc& value);
    TLoc& SetLoc(void);

    /// mandatory
    /// typedef int TMol
    ///  Check whether the Mol data member has been assigned a value.
    bool IsSetMol(void) const;
    /// Check whether it is safe or not to call GetMol method.
    bool CanGetMol(void) const;
    void ResetMol(void);
    TMol GetMol(void) const;
    void SetMol(TMol value);
    TMol& SetMol(void);

    /// optional
    /// typedef int TPlacement_method
    ///  Check whether the Placement_method data member has been assigned a value.
    bool IsSetPlacement_method(void) const;
    /// Check whether it is safe or not to call GetPlacement_method method.
    bool CanGetPlacement_method(void) const;
    void ResetPlacement_method(void);
    TPlacement_method GetPlacement_method(void) const;
    void SetPlacement_method(TPlacement_method value);
    TPlacement_method& SetPlacement_method(void);

    /// location refinements, describing offsets into introns from product coordinates.
    /// Biological semantics: start-offset/stop-offset apply to bio-start/bio-stop respectively.
    /// positive = downstream; negative = upstream.
    /// optional
    /// typedef int TStart_offset
    ///  Check whether the Start_offset data member has been assigned a value.
    bool IsSetStart_offset(void) const;
    /// Check whether it is safe or not to call GetStart_offset method.
    bool CanGetStart_offset(void) const;
    void ResetStart_offset(void);
    TStart_offset GetStart_offset(void) const;
    void SetStart_offset(TStart_offset value);
    TStart_offset& SetStart_offset(void);

    /// optional
    /// typedef CInt_fuzz TStart_offset_fuzz
    ///  Check whether the Start_offset_fuzz data member has been assigned a value.
    bool IsSetStart_offset_fuzz(void) const;
    /// Check whether it is safe or not to call GetStart_offset_fuzz method.
    bool CanGetStart_offset_fuzz(void) const;
    void ResetStart_offset_fuzz(void);
    const TStart_offset_fuzz& GetStart_offset_fuzz(void) const;
    void SetStart_offset_fuzz(TStart_offset_fuzz& value);
    TStart_offset_fuzz& SetStart_offset_fuzz(void);

    /// optional
    /// typedef int TStop_offset
    ///  Check whether the Stop_offset data member has been assigned a value.
    bool IsSetStop_offset(void) const;
    /// Check whether it is safe or not to call GetStop_offset method.
    bool CanGetStop_offset(void) const;
    void ResetStop_offset(void);
    TStop_offset GetStop_offset(void) const;
    void SetStop_offset(TStop_offset value);
    TStop_offset& SetStop_offset(void);

    /// optional
    /// typedef CInt_fuzz TStop_offset_fuzz
    ///  Check whether the Stop_offset_fuzz data member has been assigned a value.
    bool IsSetStop_offset_fuzz(void) const;
    /// Check whether it is safe or not to call GetStop_offset_fuzz method.
    bool CanGetStop_offset_fuzz(void) const;
    void ResetStop_offset_fuzz(void);
    const TStop_offset_fuzz& GetStop_offset_fuzz(void) const;
    void SetStop_offset_fuzz(TStop_offset_fuzz& value);
    TStop_offset_fuzz& SetStop_offset_fuzz(void);

    /// 0-based position of bio-start relative to containing codon
    /// optional
    /// typedef int TFrame
    ///  Check whether the Frame data member has been assigned a value.
    bool IsSetFrame(void) const;
    /// Check whether it is safe or not to call GetFrame method.
    bool CanGetFrame(void) const;
    void ResetFrame(void);
    TFrame GetFrame(void) const;
    void SetFrame(TFrame value);
    TFrame& SetFrame(void);

    /// for situations in which a raw location isn't sufficient
    /// optional
    /// typedef CSeq_literal TSeq
    ///  Check whether the Seq data member has been assigned a value.
    bool IsSetSeq(void) const;
    /// Check whether it is safe or not to call GetSeq method.
    bool CanGetSeq(void) const;
    void ResetSeq(void);
    const TSeq& GetSeq(void) const;
    void SetSeq(TSeq& value);
    TSeq& SetSeq(void);

    /// reference to the assembly (GenColl ID) for this location
    /// optional
    /// typedef CDbtag TAssembly
    ///  Check whether the Assembly data member has been assigned a value.
    bool IsSetAssembly(void) const;
    /// Check whether it is safe or not to call GetAssembly method.
    bool CanGetAssembly(void) const;
    void ResetAssembly(void);
    const TAssembly& GetAssembly(void) const;
    void SetAssembly(TAssembly& value);
    TAssembly& SetAssembly(void);

    /// optional
    /// typedef string THgvs_name
    ///  Check whether the Hgvs_name data member has been assigned a value.
    bool IsSetHgvs_name(void) const;
    /// Check whether it is safe or not to call GetHgvs_name method.
    bool CanGetHgvs_name(void) const;
    void ResetHgvs_name(void);
    const THgvs_name& GetHgvs_name(void) const;
    void SetHgvs_name(const THgvs_name& value);
    void SetHgvs_name(THgvs_name&& value);
    THgvs_name& SetHgvs_name(void);

    /// the reference location for this variant
    /// optional
    /// typedef string TComment
    ///  Check whether the Comment data member has been assigned a value.
    bool IsSetComment(void) const;
    /// Check whether it is safe or not to call GetComment method.
    bool CanGetComment(void) const;
    void ResetComment(void);
    const TComment& GetComment(void) const;
    void SetComment(const TComment& value);
    void SetComment(TComment&& value);
    TComment& SetComment(void);

    /// optional
    /// typedef list< CRef< CVariationException > > TExceptions
    ///  Check whether the Exceptions data member has been assigned a value.
    bool IsSetExceptions(void) const;
    /// Check whether it is safe or not to call GetExceptions method.
    bool CanGetExceptions(void) const;
    void ResetExceptions(void);
    const TExceptions& GetExceptions(void) const;
    TExceptions& SetExceptions(void);

    ///e.g. rs#, that are placement-specific
    /// optional
    /// typedef list< CRef< CDbtag > > TDbxrefs
    ///  Check whether the Dbxrefs data member has been assigned a value.
    bool IsSetDbxrefs(void) const;
    /// Check whether it is safe or not to call GetDbxrefs method.
    bool CanGetDbxrefs(void) const;
    void ResetDbxrefs(void);
    const TDbxrefs& GetDbxrefs(void) const;
    TDbxrefs& SetDbxrefs(void);

    ///for process-specific placement tags/labels
    /// optional
    /// typedef list< CRef< CUser_object > > TExt
    ///  Check whether the Ext data member has been assigned a value.
    bool IsSetExt(void) const;
    /// Check whether it is safe or not to call GetExt method.
    bool CanGetExt(void) const;
    void ResetExt(void);
    const TExt& GetExt(void) const;
    TExt& SetExt(void);

    ///Same semantics as VariantProperties.gene-location, except placement-specific
    /// optional
    /// typedef int TGene_location
    ///  Check whether the Gene_location data member has been assigned a value.
    bool IsSetGene_location(void) const;
    /// Check whether it is safe or not to call GetGene_location method.
    bool CanGetGene_location(void) const;
    void ResetGene_location(void);
    TGene_location GetGene_location(void) const;
    void SetGene_location(TGene_location value);
    TGene_location& SetGene_location(void);

    /// optional
    /// typedef CObject_id TId
    ///  Check whether the Id data member has been assigned a value.
    bool IsSetId(void) const;
    /// Check whether it is safe or not to call GetId method.
    bool CanGetId(void) const;
    void ResetId(void);
    const TId& GetId(void) const;
    void SetId(TId& value);
    TId& SetId(void);

    ///id of the placement from which this one was derived
    /// optional
    /// typedef CObject_id TParent_id
    ///  Check whether the Parent_id data member has been assigned a value.
    bool IsSetParent_id(void) const;
    /// Check whether it is safe or not to call GetParent_id method.
    bool CanGetParent_id(void) const;
    void ResetParent_id(void);
    const TParent_id& GetParent_id(void) const;
    void SetParent_id(TParent_id& value);
    TParent_id& SetParent_id(void);

    ///Sequence Ontology terms for this placement
    /// optional
    /// typedef list< int > TSo_terms
    ///  Check whether the So_terms data member has been assigned a value.
    bool IsSetSo_terms(void) const;
    /// Check whether it is safe or not to call GetSo_terms method.
    bool CanGetSo_terms(void) const;
    void ResetSo_terms(void);
    const TSo_terms& GetSo_terms(void) const;
    TSo_terms& SetSo_terms(void);

    /// Reset the whole object
    virtual void Reset(void);


private:
    // Prohibit copy constructor and assignment operator
    CVariantPlacement_Base(const CVariantPlacement_Base&);
    CVariantPlacement_Base& operator=(const CVariantPlacement_Base&);

    // data
    Uint4 m_set_State[2];
    CRef< TLoc > m_Loc;
    int m_Mol;
    int m_Placement_method;
    int m_Start_offset;
    CRef< TStart_offset_fuzz > m_Start_offset_fuzz;
    int m_Stop_offset;
    CRef< TStop_offset_fuzz > m_Stop_offset_fuzz;
    int m_Frame;
    CRef< TSeq > m_Seq;
    CRef< TAssembly > m_Assembly;
    string m_Hgvs_name;
    string m_Comment;
    list< CRef< CVariationException > > m_Exceptions;
    list< CRef< CDbtag > > m_Dbxrefs;
    list< CRef< CUser_object > > m_Ext;
    int m_Gene_location;
    CRef< TId > m_Id;
    CRef< TParent_id > m_Parent_id;
    list< int > m_So_terms;
};






///////////////////////////////////////////////////////////
///////////////////// inline methods //////////////////////
///////////////////////////////////////////////////////////
inline
bool CVariantPlacement_Base::IsSetLoc(void) const
{
    return m_Loc.NotEmpty();
}

inline
bool CVariantPlacement_Base::CanGetLoc(void) const
{
    return true;
}

inline
const CVariantPlacement_Base::TLoc& CVariantPlacement_Base::GetLoc(void) const
{
    if ( !m_Loc ) {
        const_cast<CVariantPlacement_Base*>(this)->ResetLoc();
    }
    return (*m_Loc);
}

inline
CVariantPlacement_Base::TLoc& CVariantPlacement_Base::SetLoc(void)
{
    if ( !m_Loc ) {
        ResetLoc();
    }
    return (*m_Loc);
}

inline
bool CVariantPlacement_Base::IsSetMol(void) const
{
    return ((m_set_State[0] & 0xc) != 0);
}

inline
bool CVariantPlacement_Base::CanGetMol(void) const
{
    return IsSetMol();
}

inline
void CVariantPlacement_Base::ResetMol(void)
{
    m_Mol = (EMol)(0);
    m_set_State[0] &= ~0xc;
}

inline
CVariantPlacement_Base::TMol CVariantPlacement_Base::GetMol(void) const
{
    if (!CanGetMol()) {
        ThrowUnassigned(1);
    }
    return m_Mol;
}

inline
void CVariantPlacement_Base::SetMol(CVariantPlacement_Base::TMol value)
{
    m_Mol = value;
    m_set_State[0] |= 0xc;
}

inline
CVariantPlacement_Base::TMol& CVariantPlacement_Base::SetMol(void)
{
#ifdef _DEBUG
    if (!IsSetMol()) {
        memset(&m_Mol,UnassignedByte(),sizeof(m_Mol));
    }
#endif
    m_set_State[0] |= 0x4;
    return m_Mol;
}

inline
bool CVariantPlacement_Base::IsSetPlacement_method(void) const
{
    return ((m_set_State[0] & 0x30) != 0);
}

inline
bool CVariantPlacement_Base::CanGetPlacement_method(void) const
{
    return IsSetPlacement_method();
}

inline
void CVariantPlacement_Base::ResetPlacement_method(void)
{
    m_Placement_method = (EPlacement_method)(0);
    m_set_State[0] &= ~0x30;
}

inline
CVariantPlacement_Base::TPlacement_method CVariantPlacement_Base::GetPlacement_method(void) const
{
    if (!CanGetPlacement_method()) {
        ThrowUnassigned(2);
    }
    return m_Placement_method;
}

inline
void CVariantPlacement_Base::SetPlacement_method(CVariantPlacement_Base::TPlacement_method value)
{
    m_Placement_method = value;
    m_set_State[0] |= 0x30;
}

inline
CVariantPlacement_Base::TPlacement_method& CVariantPlacement_Base::SetPlacement_method(void)
{
#ifdef _DEBUG
    if (!IsSetPlacement_method()) {
        memset(&m_Placement_method,UnassignedByte(),sizeof(m_Placement_method));
    }
#endif
    m_set_State[0] |= 0x10;
    return m_Placement_method;
}

inline
bool CVariantPlacement_Base::IsSetStart_offset(void) const
{
    return ((m_set_State[0] & 0xc0) != 0);
}

inline
bool CVariantPlacement_Base::CanGetStart_offset(void) const
{
    return IsSetStart_offset();
}

inline
void CVariantPlacement_Base::ResetStart_offset(void)
{
    m_Start_offset = 0;
    m_set_State[0] &= ~0xc0;
}

inline
CVariantPlacement_Base::TStart_offset CVariantPlacement_Base::GetStart_offset(void) const
{
    if (!CanGetStart_offset()) {
        ThrowUnassigned(3);
    }
    return m_Start_offset;
}

inline
void CVariantPlacement_Base::SetStart_offset(CVariantPlacement_Base::TStart_offset value)
{
    m_Start_offset = value;
    m_set_State[0] |= 0xc0;
}

inline
CVariantPlacement_Base::TStart_offset& CVariantPlacement_Base::SetStart_offset(void)
{
#ifdef _DEBUG
    if (!IsSetStart_offset()) {
        memset(&m_Start_offset,UnassignedByte(),sizeof(m_Start_offset));
    }
#endif
    m_set_State[0] |= 0x40;
    return m_Start_offset;
}

inline
bool CVariantPlacement_Base::IsSetStart_offset_fuzz(void) const
{
    return m_Start_offset_fuzz.NotEmpty();
}

inline
bool CVariantPlacement_Base::CanGetStart_offset_fuzz(void) const
{
    return IsSetStart_offset_fuzz();
}

inline
const CVariantPlacement_Base::TStart_offset_fuzz& CVariantPlacement_Base::GetStart_offset_fuzz(void) const
{
    if (!CanGetStart_offset_fuzz()) {
        ThrowUnassigned(4);
    }
    return (*m_Start_offset_fuzz);
}

inline
bool CVariantPlacement_Base::IsSetStop_offset(void) const
{
    return ((m_set_State[0] & 0xc00) != 0);
}

inline
bool CVariantPlacement_Base::CanGetStop_offset(void) const
{
    return IsSetStop_offset();
}

inline
void CVariantPlacement_Base::ResetStop_offset(void)
{
    m_Stop_offset = 0;
    m_set_State[0] &= ~0xc00;
}

inline
CVariantPlacement_Base::TStop_offset CVariantPlacement_Base::GetStop_offset(void) const
{
    if (!CanGetStop_offset()) {
        ThrowUnassigned(5);
    }
    return m_Stop_offset;
}

inline
void CVariantPlacement_Base::SetStop_offset(CVariantPlacement_Base::TStop_offset value)
{
    m_Stop_offset = value;
    m_set_State[0] |= 0xc00;
}

inline
CVariantPlacement_Base::TStop_offset& CVariantPlacement_Base::SetStop_offset(void)
{
#ifdef _DEBUG
    if (!IsSetStop_offset()) {
        memset(&m_Stop_offset,UnassignedByte(),sizeof(m_Stop_offset));
    }
#endif
    m_set_State[0] |= 0x400;
    return m_Stop_offset;
}

inline
bool CVariantPlacement_Base::IsSetStop_offset_fuzz(void) const
{
    return m_Stop_offset_fuzz.NotEmpty();
}

inline
bool CVariantPlacement_Base::CanGetStop_offset_fuzz(void) const
{
    return IsSetStop_offset_fuzz();
}

inline
const CVariantPlacement_Base::TStop_offset_fuzz& CVariantPlacement_Base::GetStop_offset_fuzz(void) const
{
    if (!CanGetStop_offset_fuzz()) {
        ThrowUnassigned(6);
    }
    return (*m_Stop_offset_fuzz);
}

inline
bool CVariantPlacement_Base::IsSetFrame(void) const
{
    return ((m_set_State[0] & 0xc000) != 0);
}

inline
bool CVariantPlacement_Base::CanGetFrame(void) const
{
    return IsSetFrame();
}

inline
void CVariantPlacement_Base::ResetFrame(void)
{
    m_Frame = 0;
    m_set_State[0] &= ~0xc000;
}

inline
CVariantPlacement_Base::TFrame CVariantPlacement_Base::GetFrame(void) const
{
    if (!CanGetFrame()) {
        ThrowUnassigned(7);
    }
    return m_Frame;
}

inline
void CVariantPlacement_Base::SetFrame(CVariantPlacement_Base::TFrame value)
{
    m_Frame = value;
    m_set_State[0] |= 0xc000;
}

inline
CVariantPlacement_Base::TFrame& CVariantPlacement_Base::SetFrame(void)
{
#ifdef _DEBUG
    if (!IsSetFrame()) {
        memset(&m_Frame,UnassignedByte(),sizeof(m_Frame));
    }
#endif
    m_set_State[0] |= 0x4000;
    return m_Frame;
}

inline
bool CVariantPlacement_Base::IsSetSeq(void) const
{
    return m_Seq.NotEmpty();
}

inline
bool CVariantPlacement_Base::CanGetSeq(void) const
{
    return IsSetSeq();
}

inline
const CVariantPlacement_Base::TSeq& CVariantPlacement_Base::GetSeq(void) const
{
    if (!CanGetSeq()) {
        ThrowUnassigned(8);
    }
    return (*m_Seq);
}

inline
bool CVariantPlacement_Base::IsSetAssembly(void) const
{
    return m_Assembly.NotEmpty();
}

inline
bool CVariantPlacement_Base::CanGetAssembly(void) const
{
    return IsSetAssembly();
}

inline
const CVariantPlacement_Base::TAssembly& CVariantPlacement_Base::GetAssembly(void) const
{
    if (!CanGetAssembly()) {
        ThrowUnassigned(9);
    }
    return (*m_Assembly);
}

inline
bool CVariantPlacement_Base::IsSetHgvs_name(void) const
{
    return ((m_set_State[0] & 0x300000) != 0);
}

inline
bool CVariantPlacement_Base::CanGetHgvs_name(void) const
{
    return IsSetHgvs_name();
}

inline
const CVariantPlacement_Base::THgvs_name& CVariantPlacement_Base::GetHgvs_name(void) const
{
    if (!CanGetHgvs_name()) {
        ThrowUnassigned(10);
    }
    return m_Hgvs_name;
}

inline
void CVariantPlacement_Base::SetHgvs_name(const CVariantPlacement_Base::THgvs_name& value)
{
    m_Hgvs_name = value;
    m_set_State[0] |= 0x300000;
}

inline
void CVariantPlacement_Base::SetHgvs_name(CVariantPlacement_Base::THgvs_name&& value)
{
    m_Hgvs_name = std::forward<CVariantPlacement_Base::THgvs_name>(value);
    m_set_State[0] |= 0x300000;
}

inline
CVariantPlacement_Base::THgvs_name& CVariantPlacement_Base::SetHgvs_name(void)
{
#ifdef _DEBUG
    if (!IsSetHgvs_name()) {
        m_Hgvs_name = UnassignedString();
    }
#endif
    m_set_State[0] |= 0x100000;
    return m_Hgvs_name;
}

inline
bool CVariantPlacement_Base::IsSetComment(void) const
{
    return ((m_set_State[0] & 0xc00000) != 0);
}

inline
bool CVariantPlacement_Base::CanGetComment(void) const
{
    return IsSetComment();
}

inline
const CVariantPlacement_Base::TComment& CVariantPlacement_Base::GetComment(void) const
{
    if (!CanGetComment()) {
        ThrowUnassigned(11);
    }
    return m_Comment;
}

inline
void CVariantPlacement_Base::SetComment(const CVariantPlacement_Base::TComment& value)
{
    m_Comment = value;
    m_set_State[0] |= 0xc00000;
}

inline
void CVariantPlacement_Base::SetComment(CVariantPlacement_Base::TComment&& value)
{
    m_Comment = std::forward<CVariantPlacement_Base::TComment>(value);
    m_set_State[0] |= 0xc00000;
}

inline
CVariantPlacement_Base::TComment& CVariantPlacement_Base::SetComment(void)
{
#ifdef _DEBUG
    if (!IsSetComment()) {
        m_Comment = UnassignedString();
    }
#endif
    m_set_State[0] |= 0x400000;
    return m_Comment;
}

inline
bool CVariantPlacement_Base::IsSetExceptions(void) const
{
    return ((m_set_State[0] & 0x3000000) != 0);
}

inline
bool CVariantPlacement_Base::CanGetExceptions(void) const
{
    return true;
}

inline
const CVariantPlacement_Base::TExceptions& CVariantPlacement_Base::GetExceptions(void) const
{
    return m_Exceptions;
}

inline
CVariantPlacement_Base::TExceptions& CVariantPlacement_Base::SetExceptions(void)
{
    m_set_State[0] |= 0x1000000;
    return m_Exceptions;
}

inline
bool CVariantPlacement_Base::IsSetDbxrefs(void) const
{
    return ((m_set_State[0] & 0xc000000) != 0);
}

inline
bool CVariantPlacement_Base::CanGetDbxrefs(void) const
{
    return true;
}

inline
const CVariantPlacement_Base::TDbxrefs& CVariantPlacement_Base::GetDbxrefs(void) const
{
    return m_Dbxrefs;
}

inline
CVariantPlacement_Base::TDbxrefs& CVariantPlacement_Base::SetDbxrefs(void)
{
    m_set_State[0] |= 0x4000000;
    return m_Dbxrefs;
}

inline
bool CVariantPlacement_Base::IsSetExt(void) const
{
    return ((m_set_State[0] & 0x30000000) != 0);
}

inline
bool CVariantPlacement_Base::CanGetExt(void) const
{
    return true;
}

inline
const CVariantPlacement_Base::TExt& CVariantPlacement_Base::GetExt(void) const
{
    return m_Ext;
}

inline
CVariantPlacement_Base::TExt& CVariantPlacement_Base::SetExt(void)
{
    m_set_State[0] |= 0x10000000;
    return m_Ext;
}

inline
bool CVariantPlacement_Base::IsSetGene_location(void) const
{
    return ((m_set_State[0] & 0xc0000000) != 0);
}

inline
bool CVariantPlacement_Base::CanGetGene_location(void) const
{
    return IsSetGene_location();
}

inline
void CVariantPlacement_Base::ResetGene_location(void)
{
    m_Gene_location = 0;
    m_set_State[0] &= ~0xc0000000;
}

inline
CVariantPlacement_Base::TGene_location CVariantPlacement_Base::GetGene_location(void) const
{
    if (!CanGetGene_location()) {
        ThrowUnassigned(15);
    }
    return m_Gene_location;
}

inline
void CVariantPlacement_Base::SetGene_location(CVariantPlacement_Base::TGene_location value)
{
    m_Gene_location = value;
    m_set_State[0] |= 0xc0000000;
}

inline
CVariantPlacement_Base::TGene_location& CVariantPlacement_Base::SetGene_location(void)
{
#ifdef _DEBUG
    if (!IsSetGene_location()) {
        memset(&m_Gene_location,UnassignedByte(),sizeof(m_Gene_location));
    }
#endif
    m_set_State[0] |= 0x40000000;
    return m_Gene_location;
}

inline
bool CVariantPlacement_Base::IsSetId(void) const
{
    return m_Id.NotEmpty();
}

inline
bool CVariantPlacement_Base::CanGetId(void) const
{
    return IsSetId();
}

inline
const CVariantPlacement_Base::TId& CVariantPlacement_Base::GetId(void) const
{
    if (!CanGetId()) {
        ThrowUnassigned(16);
    }
    return (*m_Id);
}

inline
bool CVariantPlacement_Base::IsSetParent_id(void) const
{
    return m_Parent_id.NotEmpty();
}

inline
bool CVariantPlacement_Base::CanGetParent_id(void) const
{
    return IsSetParent_id();
}

inline
const CVariantPlacement_Base::TParent_id& CVariantPlacement_Base::GetParent_id(void) const
{
    if (!CanGetParent_id()) {
        ThrowUnassigned(17);
    }
    return (*m_Parent_id);
}

inline
bool CVariantPlacement_Base::IsSetSo_terms(void) const
{
    return ((m_set_State[1] & 0x30) != 0);
}

inline
bool CVariantPlacement_Base::CanGetSo_terms(void) const
{
    return true;
}

inline
const CVariantPlacement_Base::TSo_terms& CVariantPlacement_Base::GetSo_terms(void) const
{
    return m_So_terms;
}

inline
CVariantPlacement_Base::TSo_terms& CVariantPlacement_Base::SetSo_terms(void)
{
    m_set_State[1] |= 0x10;
    return m_So_terms;
}

///////////////////////////////////////////////////////////
////////////////// end of inline methods //////////////////
///////////////////////////////////////////////////////////





END_objects_SCOPE // namespace ncbi::objects::

END_NCBI_SCOPE


#endif // OBJECTS_VARIATION_VARIANTPLACEMENT_BASE_HPP
