/* $Id$
 * ===========================================================================
 *
 *                            PUBLIC DOMAIN NOTICE
 *               National Center for Biotechnology Information
 *
 *  This software/database is a "United States Government Work" under the
 *  terms of the United States Copyright Act.  It was written as part of
 *  the author's official duties as a United States Government employee and
 *  thus cannot be copyrighted.  This software/database is freely available
 *  to the public for use. The National Library of Medicine and the U.S.
 *  Government have not placed any restriction on its use or reproduction.
 *
 *  Although all reasonable efforts have been taken to ensure the accuracy
 *  and reliability of the software and data, the NLM and the U.S.
 *  Government do not and cannot warrant the performance or results that
 *  may be obtained by using this software or data. The NLM and the U.S.
 *  Government disclaim all warranties, express or implied, including
 *  warranties of performance, merchantability or fitness for any particular
 *  purpose.
 *
 *  Please cite the author in any work or product based on this material.
 *
 * ===========================================================================
 *
 */

/// @file BVector_data_.hpp
/// Data storage class.
///
/// This file was generated by application DATATOOL
/// using the following specifications:
/// 'seqtable.asn'.
///
/// ATTENTION:
///   Don't edit or commit this file into CVS as this file will
///   be overridden (by DATATOOL) without warning!

#ifndef OBJECTS_SEQTABLE_BVECTOR_DATA_BASE_HPP
#define OBJECTS_SEQTABLE_BVECTOR_DATA_BASE_HPP

// standard includes
#include <serial/serialbase.hpp>

// generated includes
#include <vector>

BEGIN_NCBI_SCOPE

#ifndef BEGIN_objects_SCOPE
#  define BEGIN_objects_SCOPE BEGIN_SCOPE(objects)
#  define END_objects_SCOPE END_SCOPE(objects)
#endif
BEGIN_objects_SCOPE // namespace ncbi::objects::


// generated classes

/////////////////////////////////////////////////////////////////////////////
/// Class for serializing bm::bvector<>
/// see include/util/bitset/bm.h
/// Since bvector<> serialization doesn't keep size we have to add it explicitly
class NCBI_SEQ_EXPORT CBVector_data_Base : public CSerialObject
{
    typedef CSerialObject Tparent;
public:
    // constructor
    CBVector_data_Base(void);
    // destructor
    virtual ~CBVector_data_Base(void);

    // type info
    DECLARE_INTERNAL_TYPE_INFO();

    // types
    typedef unsigned TSize;
    typedef vector< char > TData;

    // member index
    enum class E_memberIndex {
        e__allMandatory = 0,
        e_size,
        e_data
    };
    typedef Tparent::CMemberIndex<E_memberIndex, 3> TmemberIndex;

    // getters
    // setters

    /// mandatory
    /// typedef unsigned TSize
    ///  Check whether the Size data member has been assigned a value.
    bool IsSetSize(void) const;
    /// Check whether it is safe or not to call GetSize method.
    bool CanGetSize(void) const;
    void ResetSize(void);
    TSize GetSize(void) const;
    void SetSize(TSize value);
    TSize& SetSize(void);

    /// mandatory
    /// typedef vector< char > TData
    ///  Check whether the Data data member has been assigned a value.
    bool IsSetData(void) const;
    /// Check whether it is safe or not to call GetData method.
    bool CanGetData(void) const;
    void ResetData(void);
    const TData& GetData(void) const;
    TData& SetData(void);

    /// Reset the whole object
    virtual void Reset(void);


private:
    // Prohibit copy constructor and assignment operator
    CBVector_data_Base(const CBVector_data_Base&);
    CBVector_data_Base& operator=(const CBVector_data_Base&);

    // data
    Uint4 m_set_State[1];
    unsigned m_Size;
    vector< char > m_Data;
};






///////////////////////////////////////////////////////////
///////////////////// inline methods //////////////////////
///////////////////////////////////////////////////////////
inline
bool CBVector_data_Base::IsSetSize(void) const
{
    return ((m_set_State[0] & 0x3) != 0);
}

inline
bool CBVector_data_Base::CanGetSize(void) const
{
    return IsSetSize();
}

inline
void CBVector_data_Base::ResetSize(void)
{
    m_Size = 0;
    m_set_State[0] &= ~0x3;
}

inline
CBVector_data_Base::TSize CBVector_data_Base::GetSize(void) const
{
    if (!CanGetSize()) {
        ThrowUnassigned(0);
    }
    return m_Size;
}

inline
void CBVector_data_Base::SetSize(CBVector_data_Base::TSize value)
{
    m_Size = value;
    m_set_State[0] |= 0x3;
}

inline
CBVector_data_Base::TSize& CBVector_data_Base::SetSize(void)
{
#ifdef _DEBUG
    if (!IsSetSize()) {
        memset(&m_Size,UnassignedByte(),sizeof(m_Size));
    }
#endif
    m_set_State[0] |= 0x1;
    return m_Size;
}

inline
bool CBVector_data_Base::IsSetData(void) const
{
    return ((m_set_State[0] & 0xc) != 0);
}

inline
bool CBVector_data_Base::CanGetData(void) const
{
    return IsSetData();
}

inline
const CBVector_data_Base::TData& CBVector_data_Base::GetData(void) const
{
    if (!CanGetData()) {
        ThrowUnassigned(1);
    }
    return m_Data;
}

inline
CBVector_data_Base::TData& CBVector_data_Base::SetData(void)
{
    m_set_State[0] |= 0x4;
    return m_Data;
}

///////////////////////////////////////////////////////////
////////////////// end of inline methods //////////////////
///////////////////////////////////////////////////////////





END_objects_SCOPE // namespace ncbi::objects::

END_NCBI_SCOPE


#endif // OBJECTS_SEQTABLE_BVECTOR_DATA_BASE_HPP
