/* $Id$
 * ===========================================================================
 *
 *                            PUBLIC DOMAIN NOTICE
 *               National Center for Biotechnology Information
 *
 *  This software/database is a "United States Government Work" under the
 *  terms of the United States Copyright Act.  It was written as part of
 *  the author's official duties as a United States Government employee and
 *  thus cannot be copyrighted.  This software/database is freely available
 *  to the public for use. The National Library of Medicine and the U.S.
 *  Government have not placed any restriction on its use or reproduction.
 *
 *  Although all reasonable efforts have been taken to ensure the accuracy
 *  and reliability of the software and data, the NLM and the U.S.
 *  Government do not and cannot warrant the performance or results that
 *  may be obtained by using this software or data. The NLM and the U.S.
 *  Government disclaim all warranties, express or implied, including
 *  warranties of performance, merchantability or fitness for any particular
 *  purpose.
 *
 *  Please cite the author in any work or product based on this material.
 *
 * ===========================================================================
 *
 */

/// @file Packed_seqpnt_.hpp
/// Data storage class.
///
/// This file was generated by application DATATOOL
/// using the following specifications:
/// 'seqloc.asn'.
///
/// ATTENTION:
///   Don't edit or commit this file into CVS as this file will
///   be overridden (by DATATOOL) without warning!

#ifndef OBJECTS_SEQLOC_PACKED_SEQPNT_BASE_HPP
#define OBJECTS_SEQLOC_PACKED_SEQPNT_BASE_HPP

// standard includes
#include <serial/serialbase.hpp>

// generated includes
#include <vector>
#include <objects/seqloc/Na_strand.hpp>

BEGIN_NCBI_SCOPE

#ifndef BEGIN_objects_SCOPE
#  define BEGIN_objects_SCOPE BEGIN_SCOPE(objects)
#  define END_objects_SCOPE END_SCOPE(objects)
#endif
BEGIN_objects_SCOPE // namespace ncbi::objects::


// forward declarations
class CInt_fuzz;
class CSeq_id;


// generated classes

/////////////////////////////////////////////////////////////////////////////
class NCBI_SEQLOC_EXPORT CPacked_seqpnt_Base : public CSerialObject
{
    typedef CSerialObject Tparent;
public:
    // constructor
    CPacked_seqpnt_Base(void);
    // destructor
    virtual ~CPacked_seqpnt_Base(void);

    // type info
    DECLARE_INTERNAL_TYPE_INFO();

    // types
    typedef ENa_strand TStrand;
    typedef CSeq_id TId;
    typedef CInt_fuzz TFuzz;
    typedef vector< TSeqPos > TPoints;

    // member index
    enum class E_memberIndex {
        e__allMandatory = 0,
        e_strand,
        e_id,
        e_fuzz,
        e_points
    };
    typedef Tparent::CMemberIndex<E_memberIndex, 5> TmemberIndex;

    // getters
    // setters

    /// optional
    /// typedef ENa_strand TStrand
    ///  Check whether the Strand data member has been assigned a value.
    bool IsSetStrand(void) const;
    /// Check whether it is safe or not to call GetStrand method.
    bool CanGetStrand(void) const;
    void ResetStrand(void);
    TStrand GetStrand(void) const;
    void SetStrand(TStrand value);
    TStrand& SetStrand(void);

    /// mandatory
    /// typedef CSeq_id TId
    ///  Check whether the Id data member has been assigned a value.
    bool IsSetId(void) const;
    /// Check whether it is safe or not to call GetId method.
    bool CanGetId(void) const;
    void ResetId(void);
    const TId& GetId(void) const;
    void SetId(TId& value);
    TId& SetId(void);

    /// optional
    /// typedef CInt_fuzz TFuzz
    ///  Check whether the Fuzz data member has been assigned a value.
    bool IsSetFuzz(void) const;
    /// Check whether it is safe or not to call GetFuzz method.
    bool CanGetFuzz(void) const;
    void ResetFuzz(void);
    const TFuzz& GetFuzz(void) const;
    void SetFuzz(TFuzz& value);
    TFuzz& SetFuzz(void);

    /// mandatory
    /// typedef vector< TSeqPos > TPoints
    ///  Check whether the Points data member has been assigned a value.
    bool IsSetPoints(void) const;
    /// Check whether it is safe or not to call GetPoints method.
    bool CanGetPoints(void) const;
    void ResetPoints(void);
    const TPoints& GetPoints(void) const;
    TPoints& SetPoints(void);

    /// Reset the whole object
    virtual void Reset(void);


private:
    // Prohibit copy constructor and assignment operator
    CPacked_seqpnt_Base(const CPacked_seqpnt_Base&);
    CPacked_seqpnt_Base& operator=(const CPacked_seqpnt_Base&);

    // data
    Uint4 m_set_State[1];
    ENa_strand m_Strand;
    CRef< TId > m_Id;
    CRef< TFuzz > m_Fuzz;
    vector< TSeqPos > m_Points;
};






///////////////////////////////////////////////////////////
///////////////////// inline methods //////////////////////
///////////////////////////////////////////////////////////
inline
bool CPacked_seqpnt_Base::IsSetStrand(void) const
{
    return ((m_set_State[0] & 0x3) != 0);
}

inline
bool CPacked_seqpnt_Base::CanGetStrand(void) const
{
    return IsSetStrand();
}

inline
void CPacked_seqpnt_Base::ResetStrand(void)
{
    m_Strand = (ncbi::objects::ENa_strand)(0);
    m_set_State[0] &= ~0x3;
}

inline
CPacked_seqpnt_Base::TStrand CPacked_seqpnt_Base::GetStrand(void) const
{
    if (!CanGetStrand()) {
        ThrowUnassigned(0);
    }
    return m_Strand;
}

inline
void CPacked_seqpnt_Base::SetStrand(CPacked_seqpnt_Base::TStrand value)
{
    m_Strand = value;
    m_set_State[0] |= 0x3;
}

inline
CPacked_seqpnt_Base::TStrand& CPacked_seqpnt_Base::SetStrand(void)
{
#ifdef _DEBUG
    if (!IsSetStrand()) {
        memset(&m_Strand,UnassignedByte(),sizeof(m_Strand));
    }
#endif
    m_set_State[0] |= 0x1;
    return m_Strand;
}

inline
bool CPacked_seqpnt_Base::IsSetId(void) const
{
    return m_Id.NotEmpty();
}

inline
bool CPacked_seqpnt_Base::CanGetId(void) const
{
    return true;
}

inline
const CPacked_seqpnt_Base::TId& CPacked_seqpnt_Base::GetId(void) const
{
    if ( !m_Id ) {
        const_cast<CPacked_seqpnt_Base*>(this)->ResetId();
    }
    return (*m_Id);
}

inline
CPacked_seqpnt_Base::TId& CPacked_seqpnt_Base::SetId(void)
{
    if ( !m_Id ) {
        ResetId();
    }
    return (*m_Id);
}

inline
bool CPacked_seqpnt_Base::IsSetFuzz(void) const
{
    return m_Fuzz.NotEmpty();
}

inline
bool CPacked_seqpnt_Base::CanGetFuzz(void) const
{
    return IsSetFuzz();
}

inline
const CPacked_seqpnt_Base::TFuzz& CPacked_seqpnt_Base::GetFuzz(void) const
{
    if (!CanGetFuzz()) {
        ThrowUnassigned(2);
    }
    return (*m_Fuzz);
}

inline
bool CPacked_seqpnt_Base::IsSetPoints(void) const
{
    return ((m_set_State[0] & 0xc0) != 0);
}

inline
bool CPacked_seqpnt_Base::CanGetPoints(void) const
{
    return true;
}

inline
const CPacked_seqpnt_Base::TPoints& CPacked_seqpnt_Base::GetPoints(void) const
{
    return m_Points;
}

inline
CPacked_seqpnt_Base::TPoints& CPacked_seqpnt_Base::SetPoints(void)
{
    m_set_State[0] |= 0x40;
    return m_Points;
}

///////////////////////////////////////////////////////////
////////////////// end of inline methods //////////////////
///////////////////////////////////////////////////////////





END_objects_SCOPE // namespace ncbi::objects::

END_NCBI_SCOPE


#endif // OBJECTS_SEQLOC_PACKED_SEQPNT_BASE_HPP
