/* $Id$
 * ===========================================================================
 *
 *                            PUBLIC DOMAIN NOTICE
 *               National Center for Biotechnology Information
 *
 *  This software/database is a "United States Government Work" under the
 *  terms of the United States Copyright Act.  It was written as part of
 *  the author's official duties as a United States Government employee and
 *  thus cannot be copyrighted.  This software/database is freely available
 *  to the public for use. The National Library of Medicine and the U.S.
 *  Government have not placed any restriction on its use or reproduction.
 *
 *  Although all reasonable efforts have been taken to ensure the accuracy
 *  and reliability of the software and data, the NLM and the U.S.
 *  Government do not and cannot warrant the performance or results that
 *  may be obtained by using this software or data. The NLM and the U.S.
 *  Government disclaim all warranties, express or implied, including
 *  warranties of performance, merchantability or fitness for any particular
 *  purpose.
 *
 *  Please cite the author in any work or product based on this material.
 *
 * ===========================================================================
 *
 */

/// @file Variation_ref_.hpp
/// Data storage class.
///
/// This file was generated by application DATATOOL
/// using the following specifications:
/// 'seqfeat.asn'.
///
/// ATTENTION:
///   Don't edit or commit this file into CVS as this file will
///   be overridden (by DATATOOL) without warning!

#ifndef OBJECTS_SEQFEAT_VARIATION_REF_BASE_HPP
#define OBJECTS_SEQFEAT_VARIATION_REF_BASE_HPP

// standard includes
#include <serial/serialbase.hpp>

// generated includes
#include <list>
#include <string>

BEGIN_NCBI_SCOPE

#ifndef BEGIN_objects_SCOPE
#  define BEGIN_objects_SCOPE BEGIN_SCOPE(objects)
#  define END_objects_SCOPE END_SCOPE(objects)
#endif
BEGIN_objects_SCOPE // namespace ncbi::objects::


// forward declarations
class CDbtag;
class CExt_loc;
class CObject_id;
class CPhenotype;
class CPopulation_data;
class CPub;
class CSeq_loc;
class CSubSource;
class CUser_object;
class CVariantProperties;
class CVariation_inst;
class CVariation_ref;


// generated classes

/////////////////////////////////////////////////////////////////////////////
class NCBI_SEQFEAT_EXPORT CVariation_ref_Base : public CSerialObject
{
    typedef CSerialObject Tparent;
public:
    // constructor
    CVariation_ref_Base(void);
    // destructor
    virtual ~CVariation_ref_Base(void);

    // type info
    DECLARE_INTERNAL_TYPE_INFO();

    enum EMethod_E {
        eMethod_E_unknown            =   0,
        eMethod_E_bac_acgh           =   1,
        eMethod_E_computational      =   2,
        eMethod_E_curated            =   3,
        eMethod_E_digital_array      =   4,
        eMethod_E_expression_array   =   5,
        eMethod_E_fish               =   6,
        eMethod_E_flanking_sequence  =   7,
        eMethod_E_maph               =   8,
        eMethod_E_mcd_analysis       =   9,
        eMethod_E_mlpa               =  10,
        eMethod_E_oea_assembly       =  11,
        eMethod_E_oligo_acgh         =  12,
        eMethod_E_paired_end         =  13,
        eMethod_E_pcr                =  14,
        eMethod_E_qpcr               =  15,
        eMethod_E_read_depth         =  16,
        eMethod_E_roma               =  17,
        eMethod_E_rt_pcr             =  18,
        eMethod_E_sage               =  19,
        eMethod_E_sequence_alignment =  20,
        eMethod_E_sequencing         =  21,
        eMethod_E_snp_array          =  22,
        eMethod_E_snp_genoytyping    =  23,
        eMethod_E_southern           =  24,
        eMethod_E_western            =  25,
        eMethod_E_optical_mapping    =  26,
        eMethod_E_other              = 255
    };
    
    /// Access to EMethod_E's attributes (values, names) as defined in spec
    static const NCBI_NS_NCBI::CEnumeratedTypeValues* ENUM_METHOD_NAME(EMethod_E)(void);
    
    /// origin of this allele, if known
    /// note that these are powers-of-two, and represent bits; thus, we can
    /// represent more than one state simultaneously through a bitwise OR
    /// DEPRECATED: new field = VariantProperties.allele-origin
    enum EAllele_origin {
        eAllele_origin_unknown             =          0,
        eAllele_origin_germline            =          1,
        eAllele_origin_somatic             =          2,
        eAllele_origin_inherited           =          4,
        eAllele_origin_paternal            =          8,
        eAllele_origin_maternal            =         16,
        eAllele_origin_de_novo             =         32,
        eAllele_origin_biparental          =         64,
        eAllele_origin_uniparental         =        128,
        eAllele_origin_not_tested          =        256,
        eAllele_origin_tested_inconclusive =        512,
        eAllele_origin_other               = 1073741824  ///< stopper - 2^31
    };
    
    /// Access to EAllele_origin's attributes (values, names) as defined in spec
    static const NCBI_NS_NCBI::CEnumeratedTypeValues* ENUM_METHOD_NAME(EAllele_origin)(void);
    
    /// observed allele state, if known
    /// DEPRECATED: new field = VariantProperties.allele-state
    enum EAllele_state {
        eAllele_state_unknown      =   0,
        eAllele_state_homozygous   =   1,
        eAllele_state_heterozygous =   2,
        eAllele_state_hemizygous   =   3,
        eAllele_state_nullizygous  =   4,
        eAllele_state_other        = 255
    };
    
    /// Access to EAllele_state's attributes (values, names) as defined in spec
    static const NCBI_NS_NCBI::CEnumeratedTypeValues* ENUM_METHOD_NAME(EAllele_state)(void);
    
    /////////////////////////////////////////////////////////////////////////////
    class NCBI_SEQFEAT_EXPORT C_Data : public CSerialObject
    {
        typedef CSerialObject Tparent;
    public:
        // constructor
        C_Data(void);
        // destructor
        ~C_Data(void);
    
        // type info
        DECLARE_INTERNAL_TYPE_INFO();
    
        /////////////////////////////////////////////////////////////////////////////
        /// Set of related Variations.
        /// Location of the set equals to the union of member locations
        class NCBI_SEQFEAT_EXPORT C_Set : public CSerialObject
        {
            typedef CSerialObject Tparent;
        public:
            // constructor
            C_Set(void);
            // destructor
            ~C_Set(void);
        
            // type info
            DECLARE_INTERNAL_TYPE_INFO();
        
            enum EData_set_type {
                eData_set_type_unknown    =   0,
                eData_set_type_compound   =   1,  ///< complex change at the same location on the  same molecule
                eData_set_type_products   =   2,  ///< different products arising from the same  variation in a precursor, e.g. r.[13g>a,  13_88del]
                eData_set_type_haplotype  =   3,  ///< changes on the same allele, e.g  r.[13g>a;15u>c]
                eData_set_type_genotype   =   4,  ///< changes on different alleles in the same  genotype, e.g. g.[476C>T]+[476C>T]
                eData_set_type_mosaic     =   5,  ///< different genotypes in the same individual
                eData_set_type_individual =   6,  ///< same organism; allele relationship unknown,  e.g. g.[476C>T(+)183G>C]
                eData_set_type_population =   7,  ///< population
                eData_set_type_alleles    =   8,  ///< set represents a set of observed alleles
                eData_set_type_package    =   9,  ///< set represents a package of observations at  a given location, generally containing  asserted + reference
                eData_set_type_other      = 255
            };
            
            /// Access to EData_set_type's attributes (values, names) as defined in spec
            static const NCBI_NS_NCBI::CEnumeratedTypeValues* ENUM_METHOD_NAME(EData_set_type)(void);
            
            // types
            typedef int TType;
            typedef list< CRef< CVariation_ref > > TVariations;
            typedef string TName;
        
            // member index
            enum class E_memberIndex {
                e__allMandatory = 0,
                e_type,
                e_variations,
                e_name
            };
            typedef Tparent::CMemberIndex<E_memberIndex, 4> TmemberIndex;
        
            // getters
            // setters
        
            /// mandatory
            /// typedef int TType
            ///  Check whether the Type data member has been assigned a value.
            bool IsSetType(void) const;
            /// Check whether it is safe or not to call GetType method.
            bool CanGetType(void) const;
            void ResetType(void);
            TType GetType(void) const;
            void SetType(TType value);
            TType& SetType(void);
        
            /// mandatory
            /// typedef list< CRef< CVariation_ref > > TVariations
            ///  Check whether the Variations data member has been assigned a value.
            bool IsSetVariations(void) const;
            /// Check whether it is safe or not to call GetVariations method.
            bool CanGetVariations(void) const;
            void ResetVariations(void);
            const TVariations& GetVariations(void) const;
            TVariations& SetVariations(void);
        
            /// optional
            /// typedef string TName
            ///  Check whether the Name data member has been assigned a value.
            bool IsSetName(void) const;
            /// Check whether it is safe or not to call GetName method.
            bool CanGetName(void) const;
            void ResetName(void);
            const TName& GetName(void) const;
            void SetName(const TName& value);
            void SetName(TName&& value);
            TName& SetName(void);
        
            /// Reset the whole object
            void Reset(void);
        
        
        private:
            // Prohibit copy constructor and assignment operator
            C_Set(const C_Set&);
            C_Set& operator=(const C_Set&);
        
            // data
            Uint4 m_set_State[1];
            int m_Type;
            list< CRef< CVariation_ref > > m_Variations;
            string m_Name;
        };
    
        /// Choice variants.
        enum E_Choice {
            e_not_set = 0,         ///< No variant selected
            e_Unknown,
            e_Note,                ///<free-form
            e_Uniparental_disomy,
            e_Instance,            ///< actual sequence-edit at feat.location
            e_Set,
            e_Complex              ///< variant is a complex and undescribed change at the location  This type of variant is known to occur in dbVar submissions
        };
        /// Maximum+1 value of the choice variant enumerator.
        enum E_ChoiceStopper {
            e_MaxChoice = 7 ///< == e_Complex+1
        };
    
        /// Reset the whole object
        void Reset(void);
    
        /// Reset the selection (set it to e_not_set).
        void ResetSelection(void);
    
        /// Which variant is currently selected.
        E_Choice Which(void) const;
    
        /// Verify selection, throw exception if it differs from the expected.
        void CheckSelected(E_Choice index) const;
    
        /// Throw 'InvalidSelection' exception.
        NCBI_NORETURN void ThrowInvalidSelection(E_Choice index) const;
    
        /// Retrieve selection name (for diagnostic purposes).
        static string SelectionName(E_Choice index);
    
        /// Select the requested variant if needed.
        void Select(E_Choice index, EResetVariant reset = eDoResetVariant);
        /// Select the requested variant if needed,
        /// allocating CObject variants from memory pool.
        void Select(E_Choice index,
                    EResetVariant reset,
                    CObjectMemoryPool* pool);
    
        // types
        typedef string TNote;
        typedef CVariation_inst TInstance;
        typedef C_Set TSet;
    
        // getters
        // setters
    
    
        bool IsUnknown(void) const;
        void SetUnknown(void);
    
        // typedef string TNote
        bool IsNote(void) const;
        const TNote& GetNote(void) const;
        TNote& SetNote(void);
        void SetNote(const TNote& value);
    
    
        bool IsUniparental_disomy(void) const;
        void SetUniparental_disomy(void);
    
        // typedef CVariation_inst TInstance
        bool IsInstance(void) const;
        const TInstance& GetInstance(void) const;
        TInstance& SetInstance(void);
        void SetInstance(TInstance& value);
    
        // typedef C_Set TSet
        bool IsSet(void) const;
        const TSet& GetSet(void) const;
        TSet& SetSet(void);
        void SetSet(TSet& value);
    
    
        bool IsComplex(void) const;
        void SetComplex(void);
    
    
    private:
        // copy constructor and assignment operator
        C_Data(const C_Data& );
        C_Data& operator=(const C_Data& );
        // choice state
        E_Choice m_choice;
        // helper methods
        void DoSelect(E_Choice index, CObjectMemoryPool* pool = 0);
    
        static const char* const sm_SelectionNames[];
        // data
        union {
            NCBI_NS_NCBI::CUnionBuffer<NCBI_NS_STD::string> m_string;
            NCBI_NS_NCBI::CSerialObject *m_object;
        };
    };
    /////////////////////////////////////////////////////////////////////////////
    class NCBI_SEQFEAT_EXPORT C_E_Consequence : public CSerialObject
    {
        typedef CSerialObject Tparent;
    public:
        // constructor
        C_E_Consequence(void);
        // destructor
        ~C_E_Consequence(void);
    
        // type info
        DECLARE_INTERNAL_TYPE_INFO();
    
        /////////////////////////////////////////////////////////////////////////////
        /// see http://www.hgvs.org/mutnomen/recs-prot.html
        class NCBI_SEQFEAT_EXPORT C_Frameshift : public CSerialObject
        {
            typedef CSerialObject Tparent;
        public:
            // constructor
            C_Frameshift(void);
            // destructor
            ~C_Frameshift(void);
        
            // type info
            DECLARE_INTERNAL_TYPE_INFO();
        
            // types
            typedef int TPhase;
            typedef int TX_length;
        
            // member index
            enum class E_memberIndex {
                e__allMandatory = 0,
                e_phase,
                e_x_length
            };
            typedef Tparent::CMemberIndex<E_memberIndex, 3> TmemberIndex;
        
            // getters
            // setters
        
            /// optional
            /// typedef int TPhase
            ///  Check whether the Phase data member has been assigned a value.
            bool IsSetPhase(void) const;
            /// Check whether it is safe or not to call GetPhase method.
            bool CanGetPhase(void) const;
            void ResetPhase(void);
            TPhase GetPhase(void) const;
            void SetPhase(TPhase value);
            TPhase& SetPhase(void);
        
            /// optional
            /// typedef int TX_length
            ///  Check whether the X_length data member has been assigned a value.
            bool IsSetX_length(void) const;
            /// Check whether it is safe or not to call GetX_length method.
            bool CanGetX_length(void) const;
            void ResetX_length(void);
            TX_length GetX_length(void) const;
            void SetX_length(TX_length value);
            TX_length& SetX_length(void);
        
            /// Reset the whole object
            void Reset(void);
        
        
        private:
            // Prohibit copy constructor and assignment operator
            C_Frameshift(const C_Frameshift&);
            C_Frameshift& operator=(const C_Frameshift&);
        
            // data
            Uint4 m_set_State[1];
            int m_Phase;
            int m_X_length;
        };
        /////////////////////////////////////////////////////////////////////////////
        class NCBI_SEQFEAT_EXPORT C_Loss_of_heterozygosity : public CSerialObject
        {
            typedef CSerialObject Tparent;
        public:
            // constructor
            C_Loss_of_heterozygosity(void);
            // destructor
            ~C_Loss_of_heterozygosity(void);
        
            // type info
            DECLARE_INTERNAL_TYPE_INFO();
        
            // types
            typedef string TReference;
            typedef string TTest;
        
            // member index
            enum class E_memberIndex {
                e__allMandatory = 0,
                e_reference,
                e_test
            };
            typedef Tparent::CMemberIndex<E_memberIndex, 3> TmemberIndex;
        
            // getters
            // setters
        
            /// In germline comparison, it will be reference genome assembly
            /// (default) or reference/normal population. In somatic mutation,
            /// it will be a name of the normal tissue.
            /// optional
            /// typedef string TReference
            ///  Check whether the Reference data member has been assigned a value.
            bool IsSetReference(void) const;
            /// Check whether it is safe or not to call GetReference method.
            bool CanGetReference(void) const;
            void ResetReference(void);
            const TReference& GetReference(void) const;
            void SetReference(const TReference& value);
            void SetReference(TReference&& value);
            TReference& SetReference(void);
        
            /// Name of the testing subject type or the testing tissue.
            /// optional
            /// typedef string TTest
            ///  Check whether the Test data member has been assigned a value.
            bool IsSetTest(void) const;
            /// Check whether it is safe or not to call GetTest method.
            bool CanGetTest(void) const;
            void ResetTest(void);
            const TTest& GetTest(void) const;
            void SetTest(const TTest& value);
            void SetTest(TTest&& value);
            TTest& SetTest(void);
        
            /// Reset the whole object
            void Reset(void);
        
        
        private:
            // Prohibit copy constructor and assignment operator
            C_Loss_of_heterozygosity(const C_Loss_of_heterozygosity&);
            C_Loss_of_heterozygosity& operator=(const C_Loss_of_heterozygosity&);
        
            // data
            Uint4 m_set_State[1];
            string m_Reference;
            string m_Test;
        };
    
        /// Choice variants.
        enum E_Choice {
            e_not_set = 0,             ///< No variant selected
            e_Unknown,
            e_Splicing,                ///<some effect on splicing
            e_Note,                    ///<freeform
            e_Variation,               ///< Describe resulting variation in the product, e.g. missense,  nonsense, silent, neutral, etc in a protein, that arises from  THIS variation.
            e_Frameshift,
            e_Loss_of_heterozygosity
        };
        /// Maximum+1 value of the choice variant enumerator.
        enum E_ChoiceStopper {
            e_MaxChoice = 7 ///< == e_Loss_of_heterozygosity+1
        };
    
        /// Reset the whole object
        void Reset(void);
    
        /// Reset the selection (set it to e_not_set).
        void ResetSelection(void);
    
        /// Which variant is currently selected.
        E_Choice Which(void) const;
    
        /// Verify selection, throw exception if it differs from the expected.
        void CheckSelected(E_Choice index) const;
    
        /// Throw 'InvalidSelection' exception.
        NCBI_NORETURN void ThrowInvalidSelection(E_Choice index) const;
    
        /// Retrieve selection name (for diagnostic purposes).
        static string SelectionName(E_Choice index);
    
        /// Select the requested variant if needed.
        void Select(E_Choice index, EResetVariant reset = eDoResetVariant);
        /// Select the requested variant if needed,
        /// allocating CObject variants from memory pool.
        void Select(E_Choice index,
                    EResetVariant reset,
                    CObjectMemoryPool* pool);
    
        // types
        typedef string TNote;
        typedef CVariation_ref TVariation;
        typedef C_Frameshift TFrameshift;
        typedef C_Loss_of_heterozygosity TLoss_of_heterozygosity;
    
        // getters
        // setters
    
    
        bool IsUnknown(void) const;
        void SetUnknown(void);
    
    
        bool IsSplicing(void) const;
        void SetSplicing(void);
    
        // typedef string TNote
        bool IsNote(void) const;
        const TNote& GetNote(void) const;
        TNote& SetNote(void);
        void SetNote(const TNote& value);
    
        // typedef CVariation_ref TVariation
        bool IsVariation(void) const;
        const TVariation& GetVariation(void) const;
        TVariation& SetVariation(void);
        void SetVariation(TVariation& value);
    
        // typedef C_Frameshift TFrameshift
        bool IsFrameshift(void) const;
        const TFrameshift& GetFrameshift(void) const;
        TFrameshift& SetFrameshift(void);
        void SetFrameshift(TFrameshift& value);
    
        // typedef C_Loss_of_heterozygosity TLoss_of_heterozygosity
        bool IsLoss_of_heterozygosity(void) const;
        const TLoss_of_heterozygosity& GetLoss_of_heterozygosity(void) const;
        TLoss_of_heterozygosity& SetLoss_of_heterozygosity(void);
        void SetLoss_of_heterozygosity(TLoss_of_heterozygosity& value);
    
    
    private:
        // copy constructor and assignment operator
        C_E_Consequence(const C_E_Consequence& );
        C_E_Consequence& operator=(const C_E_Consequence& );
        // choice state
        E_Choice m_choice;
        // helper methods
        void DoSelect(E_Choice index, CObjectMemoryPool* pool = 0);
    
        static const char* const sm_SelectionNames[];
        // data
        union {
            NCBI_NS_NCBI::CUnionBuffer<NCBI_NS_STD::string> m_string;
            NCBI_NS_NCBI::CSerialObject *m_object;
        };
    };
    /////////////////////////////////////////////////////////////////////////////
    class NCBI_SEQFEAT_EXPORT C_E_Somatic_origin : public CSerialObject
    {
        typedef CSerialObject Tparent;
    public:
        // constructor
        C_E_Somatic_origin(void);
        // destructor
        ~C_E_Somatic_origin(void);
    
        // type info
        DECLARE_INTERNAL_TYPE_INFO();
    
        /////////////////////////////////////////////////////////////////////////////
        /// condition related to this origin's type
        class NCBI_SEQFEAT_EXPORT C_Condition : public CSerialObject
        {
            typedef CSerialObject Tparent;
        public:
            // constructor
            C_Condition(void);
            // destructor
            ~C_Condition(void);
        
            // type info
            DECLARE_INTERNAL_TYPE_INFO();
        
            // types
            typedef string TDescription;
            typedef list< CRef< CDbtag > > TObject_id;
        
            // member index
            enum class E_memberIndex {
                e__allMandatory = 0,
                e_description,
                e_object_id
            };
            typedef Tparent::CMemberIndex<E_memberIndex, 3> TmemberIndex;
        
            // getters
            // setters
        
            /// optional
            /// typedef string TDescription
            ///  Check whether the Description data member has been assigned a value.
            bool IsSetDescription(void) const;
            /// Check whether it is safe or not to call GetDescription method.
            bool CanGetDescription(void) const;
            void ResetDescription(void);
            const TDescription& GetDescription(void) const;
            void SetDescription(const TDescription& value);
            void SetDescription(TDescription&& value);
            TDescription& SetDescription(void);
        
            /// reference to BioTerm / other descriptive database
            /// optional
            /// typedef list< CRef< CDbtag > > TObject_id
            ///  Check whether the Object_id data member has been assigned a value.
            bool IsSetObject_id(void) const;
            /// Check whether it is safe or not to call GetObject_id method.
            bool CanGetObject_id(void) const;
            void ResetObject_id(void);
            const TObject_id& GetObject_id(void) const;
            TObject_id& SetObject_id(void);
        
            /// Reset the whole object
            void Reset(void);
        
        
        private:
            // Prohibit copy constructor and assignment operator
            C_Condition(const C_Condition&);
            C_Condition& operator=(const C_Condition&);
        
            // data
            Uint4 m_set_State[1];
            string m_Description;
            list< CRef< CDbtag > > m_Object_id;
        };
        // types
        typedef CSubSource TSource;
        typedef C_Condition TCondition;
    
        // member index
        enum class E_memberIndex {
            e__allMandatory = 0,
            e_source,
            e_condition
        };
        typedef Tparent::CMemberIndex<E_memberIndex, 3> TmemberIndex;
    
        // getters
        // setters
    
        /// description of the somatic origin itself
        /// optional
        /// typedef CSubSource TSource
        ///  Check whether the Source data member has been assigned a value.
        bool IsSetSource(void) const;
        /// Check whether it is safe or not to call GetSource method.
        bool CanGetSource(void) const;
        void ResetSource(void);
        const TSource& GetSource(void) const;
        void SetSource(TSource& value);
        TSource& SetSource(void);
    
        /// optional
        /// typedef C_Condition TCondition
        ///  Check whether the Condition data member has been assigned a value.
        bool IsSetCondition(void) const;
        /// Check whether it is safe or not to call GetCondition method.
        bool CanGetCondition(void) const;
        void ResetCondition(void);
        const TCondition& GetCondition(void) const;
        void SetCondition(TCondition& value);
        TCondition& SetCondition(void);
    
        /// Reset the whole object
        void Reset(void);
    
    
    private:
        // Prohibit copy constructor and assignment operator
        C_E_Somatic_origin(const C_E_Somatic_origin&);
        C_E_Somatic_origin& operator=(const C_E_Somatic_origin&);
    
        // data
        Uint4 m_set_State[1];
        CRef< TSource > m_Source;
        CRef< TCondition > m_Condition;
    };
    // types
    typedef CDbtag TId;
    typedef CDbtag TParent_id;
    typedef CObject_id TSample_id;
    typedef list< CRef< CDbtag > > TOther_ids;
    typedef string TName;
    typedef list< string > TSynonyms;
    typedef string TDescription;
    typedef list< CRef< CPhenotype > > TPhenotype;
    typedef list< int > TMethod;
    typedef list< CRef< CPopulation_data > > TPopulation_data;
    typedef CVariantProperties TVariant_prop;
    typedef bool TValidated;
    typedef list< CRef< CDbtag > > TClinical_test;
    typedef int TAllele_origin;
    typedef int TAllele_state;
    typedef double TAllele_frequency;
    typedef bool TIs_ancestral_allele;
    typedef CPub TPub;
    typedef C_Data TData;
    typedef C_E_Consequence C_E;
    typedef list< CRef< C_E_Consequence > > TConsequence;
    typedef CSeq_loc TLocation;
    typedef list< CRef< CExt_loc > > TExt_locs;
    typedef CUser_object TExt;
    typedef list< CRef< C_E_Somatic_origin > > TSomatic_origin;

    // member index
    enum class E_memberIndex {
        e__allMandatory = 0,
        e_id,
        e_parent_id,
        e_sample_id,
        e_other_ids,
        e_name,
        e_synonyms,
        e_description,
        e_phenotype,
        e_method,
        e_population_data,
        e_variant_prop,
        e_validated,
        e_clinical_test,
        e_allele_origin,
        e_allele_state,
        e_allele_frequency,
        e_is_ancestral_allele,
        e_pub,
        e_data,
        e_consequence,
        e_location,
        e_ext_locs,
        e_ext,
        e_somatic_origin
    };
    typedef Tparent::CMemberIndex<E_memberIndex, 25> TmemberIndex;

    // getters
    // setters

    /// ids (i.e., SNP rsid / ssid, dbVar nsv/nssv)
    /// expected values include 'dbSNP|rs12334', 'dbSNP|ss12345', 'dbVar|nsv1'
    ///
    /// we relate three kinds of IDs here:
    ///  - our current object's id
    ///  - the id of this object's parent, if it exists
    ///  - the sample ID that this item originates from
    /// optional
    /// typedef CDbtag TId
    ///  Check whether the Id data member has been assigned a value.
    bool IsSetId(void) const;
    /// Check whether it is safe or not to call GetId method.
    bool CanGetId(void) const;
    void ResetId(void);
    const TId& GetId(void) const;
    void SetId(TId& value);
    TId& SetId(void);

    /// optional
    /// typedef CDbtag TParent_id
    ///  Check whether the Parent_id data member has been assigned a value.
    bool IsSetParent_id(void) const;
    /// Check whether it is safe or not to call GetParent_id method.
    bool CanGetParent_id(void) const;
    void ResetParent_id(void);
    const TParent_id& GetParent_id(void) const;
    void SetParent_id(TParent_id& value);
    TParent_id& SetParent_id(void);

    /// optional
    /// typedef CObject_id TSample_id
    ///  Check whether the Sample_id data member has been assigned a value.
    bool IsSetSample_id(void) const;
    /// Check whether it is safe or not to call GetSample_id method.
    bool CanGetSample_id(void) const;
    void ResetSample_id(void);
    const TSample_id& GetSample_id(void) const;
    void SetSample_id(TSample_id& value);
    TSample_id& SetSample_id(void);

    /// optional
    /// typedef list< CRef< CDbtag > > TOther_ids
    ///  Check whether the Other_ids data member has been assigned a value.
    bool IsSetOther_ids(void) const;
    /// Check whether it is safe or not to call GetOther_ids method.
    bool CanGetOther_ids(void) const;
    void ResetOther_ids(void);
    const TOther_ids& GetOther_ids(void) const;
    TOther_ids& SetOther_ids(void);

    /// names and synonyms
    /// some variants have well-known canonical names and possible accepted
    /// synonyms
    /// optional
    /// typedef string TName
    ///  Check whether the Name data member has been assigned a value.
    bool IsSetName(void) const;
    /// Check whether it is safe or not to call GetName method.
    bool CanGetName(void) const;
    void ResetName(void);
    const TName& GetName(void) const;
    void SetName(const TName& value);
    void SetName(TName&& value);
    TName& SetName(void);

    /// optional
    /// typedef list< string > TSynonyms
    ///  Check whether the Synonyms data member has been assigned a value.
    bool IsSetSynonyms(void) const;
    /// Check whether it is safe or not to call GetSynonyms method.
    bool CanGetSynonyms(void) const;
    void ResetSynonyms(void);
    const TSynonyms& GetSynonyms(void) const;
    TSynonyms& SetSynonyms(void);

    /// tag for comment and descriptions
    /// optional
    /// typedef string TDescription
    ///  Check whether the Description data member has been assigned a value.
    bool IsSetDescription(void) const;
    /// Check whether it is safe or not to call GetDescription method.
    bool CanGetDescription(void) const;
    void ResetDescription(void);
    const TDescription& GetDescription(void) const;
    void SetDescription(const TDescription& value);
    void SetDescription(TDescription&& value);
    TDescription& SetDescription(void);

    /// phenotype
    /// optional
    /// typedef list< CRef< CPhenotype > > TPhenotype
    ///  Check whether the Phenotype data member has been assigned a value.
    bool IsSetPhenotype(void) const;
    /// Check whether it is safe or not to call GetPhenotype method.
    bool CanGetPhenotype(void) const;
    void ResetPhenotype(void);
    const TPhenotype& GetPhenotype(void) const;
    TPhenotype& SetPhenotype(void);

    /// optional
    /// typedef list< int > TMethod
    ///  Check whether the Method data member has been assigned a value.
    bool IsSetMethod(void) const;
    /// Check whether it is safe or not to call GetMethod method.
    bool CanGetMethod(void) const;
    void ResetMethod(void);
    const TMethod& GetMethod(void) const;
    TMethod& SetMethod(void);

    /// Note about SNP representation and pretinent fields: allele-frequency,
    /// population, quality-codes:
    /// The case of multiple alleles for a SNP would be described by
    /// parent-feature of type Variation-set.diff-alleles, where the child
    /// features of type Variation-inst, all at the same location, would
    /// describe individual alleles.
    /// population data
    /// DEPRECATED - do not use
    /// optional
    /// typedef list< CRef< CPopulation_data > > TPopulation_data
    ///  Check whether the Population_data data member has been assigned a value.
    bool IsSetPopulation_data(void) const;
    /// Check whether it is safe or not to call GetPopulation_data method.
    bool CanGetPopulation_data(void) const;
    void ResetPopulation_data(void);
    const TPopulation_data& GetPopulation_data(void) const;
    TPopulation_data& SetPopulation_data(void);

    /// variant properties bit fields
    /// optional
    /// typedef CVariantProperties TVariant_prop
    ///  Check whether the Variant_prop data member has been assigned a value.
    bool IsSetVariant_prop(void) const;
    /// Check whether it is safe or not to call GetVariant_prop method.
    bool CanGetVariant_prop(void) const;
    void ResetVariant_prop(void);
    const TVariant_prop& GetVariant_prop(void) const;
    void SetVariant_prop(TVariant_prop& value);
    TVariant_prop& SetVariant_prop(void);

    /// has this variant been validated?
    /// DEPRECATED: new field = VariantProperties.other-validation
    /// optional
    /// typedef bool TValidated
    ///  Check whether the Validated data member has been assigned a value.
    bool IsSetValidated(void) const;
    /// Check whether it is safe or not to call GetValidated method.
    bool CanGetValidated(void) const;
    void ResetValidated(void);
    TValidated GetValidated(void) const;
    void SetValidated(TValidated value);
    TValidated& SetValidated(void);

    /// link-outs to GeneTests database
    /// DEPRECATED - do not use
    /// optional
    /// typedef list< CRef< CDbtag > > TClinical_test
    ///  Check whether the Clinical_test data member has been assigned a value.
    bool IsSetClinical_test(void) const;
    /// Check whether it is safe or not to call GetClinical_test method.
    bool CanGetClinical_test(void) const;
    void ResetClinical_test(void);
    const TClinical_test& GetClinical_test(void) const;
    TClinical_test& SetClinical_test(void);

    /// optional
    /// typedef int TAllele_origin
    ///  Check whether the Allele_origin data member has been assigned a value.
    bool IsSetAllele_origin(void) const;
    /// Check whether it is safe or not to call GetAllele_origin method.
    bool CanGetAllele_origin(void) const;
    void ResetAllele_origin(void);
    TAllele_origin GetAllele_origin(void) const;
    void SetAllele_origin(TAllele_origin value);
    TAllele_origin& SetAllele_origin(void);

    /// optional
    /// typedef int TAllele_state
    ///  Check whether the Allele_state data member has been assigned a value.
    bool IsSetAllele_state(void) const;
    /// Check whether it is safe or not to call GetAllele_state method.
    bool CanGetAllele_state(void) const;
    void ResetAllele_state(void);
    TAllele_state GetAllele_state(void) const;
    void SetAllele_state(TAllele_state value);
    TAllele_state& SetAllele_state(void);

    /// NOTE:
    /// 'allele-frequency' here refers to the minor allele frequency of the
    /// default population
    /// DEPRECATED: new field = VariantProperties.allele-frequency
    /// optional
    /// typedef double TAllele_frequency
    ///  Check whether the Allele_frequency data member has been assigned a value.
    bool IsSetAllele_frequency(void) const;
    /// Check whether it is safe or not to call GetAllele_frequency method.
    bool CanGetAllele_frequency(void) const;
    void ResetAllele_frequency(void);
    TAllele_frequency GetAllele_frequency(void) const;
    void SetAllele_frequency(TAllele_frequency value);
    TAllele_frequency& SetAllele_frequency(void);

    /// is this variant the ancestral allele?
    /// DEPRECATED: new field = VariantProperties.is-ancestral-allele
    /// optional
    /// typedef bool TIs_ancestral_allele
    ///  Check whether the Is_ancestral_allele data member has been assigned a value.
    bool IsSetIs_ancestral_allele(void) const;
    /// Check whether it is safe or not to call GetIs_ancestral_allele method.
    bool CanGetIs_ancestral_allele(void) const;
    void ResetIs_ancestral_allele(void);
    TIs_ancestral_allele GetIs_ancestral_allele(void) const;
    void SetIs_ancestral_allele(TIs_ancestral_allele value);
    TIs_ancestral_allele& SetIs_ancestral_allele(void);

    /// publication support.
    /// Note: made this pub instead of pub-equiv, since
    /// Pub can be pub-equiv and pub-equiv is a set of pubs, but it looks like
    /// Pub is more often used as top-level container
    /// DEPRECATED - do not use; use Seq-feat.dbxref instead
    /// optional
    /// typedef CPub TPub
    ///  Check whether the Pub data member has been assigned a value.
    bool IsSetPub(void) const;
    /// Check whether it is safe or not to call GetPub method.
    bool CanGetPub(void) const;
    void ResetPub(void);
    const TPub& GetPub(void) const;
    void SetPub(TPub& value);
    TPub& SetPub(void);

    /// mandatory
    /// typedef C_Data TData
    ///  Check whether the Data data member has been assigned a value.
    bool IsSetData(void) const;
    /// Check whether it is safe or not to call GetData method.
    bool CanGetData(void) const;
    void ResetData(void);
    const TData& GetData(void) const;
    void SetData(TData& value);
    TData& SetData(void);

    /// optional
    /// typedef list< CRef< C_E_Consequence > > TConsequence
    ///  Check whether the Consequence data member has been assigned a value.
    bool IsSetConsequence(void) const;
    /// Check whether it is safe or not to call GetConsequence method.
    bool CanGetConsequence(void) const;
    void ResetConsequence(void);
    const TConsequence& GetConsequence(void) const;
    TConsequence& SetConsequence(void);

    /// Observed location, if different from the parent set or feature.location.
    /// DEPRECATED - do not use
    /// optional
    /// typedef CSeq_loc TLocation
    ///  Check whether the Location data member has been assigned a value.
    bool IsSetLocation(void) const;
    /// Check whether it is safe or not to call GetLocation method.
    bool CanGetLocation(void) const;
    void ResetLocation(void);
    const TLocation& GetLocation(void) const;
    void SetLocation(TLocation& value);
    TLocation& SetLocation(void);

    /// reference other locs, e.g. mapped source
    /// DEPRECATED - do not use
    /// optional
    /// typedef list< CRef< CExt_loc > > TExt_locs
    ///  Check whether the Ext_locs data member has been assigned a value.
    bool IsSetExt_locs(void) const;
    /// Check whether it is safe or not to call GetExt_locs method.
    bool CanGetExt_locs(void) const;
    void ResetExt_locs(void);
    const TExt_locs& GetExt_locs(void) const;
    TExt_locs& SetExt_locs(void);

    /// DEPRECATED - do not use; use Seq-feat.exts instead
    /// optional
    /// typedef CUser_object TExt
    ///  Check whether the Ext data member has been assigned a value.
    bool IsSetExt(void) const;
    /// Check whether it is safe or not to call GetExt method.
    bool CanGetExt(void) const;
    void ResetExt(void);
    const TExt& GetExt(void) const;
    void SetExt(TExt& value);
    TExt& SetExt(void);

    /// optional
    /// typedef list< CRef< C_E_Somatic_origin > > TSomatic_origin
    ///  Check whether the Somatic_origin data member has been assigned a value.
    bool IsSetSomatic_origin(void) const;
    /// Check whether it is safe or not to call GetSomatic_origin method.
    bool CanGetSomatic_origin(void) const;
    void ResetSomatic_origin(void);
    const TSomatic_origin& GetSomatic_origin(void) const;
    TSomatic_origin& SetSomatic_origin(void);

    /// Reset the whole object
    virtual void Reset(void);


private:
    // Prohibit copy constructor and assignment operator
    CVariation_ref_Base(const CVariation_ref_Base&);
    CVariation_ref_Base& operator=(const CVariation_ref_Base&);

    // data
    Uint4 m_set_State[2];
    CRef< TId > m_Id;
    CRef< TParent_id > m_Parent_id;
    CRef< TSample_id > m_Sample_id;
    list< CRef< CDbtag > > m_Other_ids;
    string m_Name;
    list< string > m_Synonyms;
    string m_Description;
    list< CRef< CPhenotype > > m_Phenotype;
    list< int > m_Method;
    list< CRef< CPopulation_data > > m_Population_data;
    CRef< TVariant_prop > m_Variant_prop;
    bool m_Validated;
    list< CRef< CDbtag > > m_Clinical_test;
    int m_Allele_origin;
    int m_Allele_state;
    double m_Allele_frequency;
    bool m_Is_ancestral_allele;
    CRef< TPub > m_Pub;
    CRef< TData > m_Data;
    list< CRef< C_E_Consequence > > m_Consequence;
    CRef< TLocation > m_Location;
    list< CRef< CExt_loc > > m_Ext_locs;
    CRef< TExt > m_Ext;
    list< CRef< C_E_Somatic_origin > > m_Somatic_origin;
};






///////////////////////////////////////////////////////////
///////////////////// inline methods //////////////////////
///////////////////////////////////////////////////////////
inline
bool CVariation_ref_Base::C_Data::C_Set::IsSetType(void) const
{
    return ((m_set_State[0] & 0x3) != 0);
}

inline
bool CVariation_ref_Base::C_Data::C_Set::CanGetType(void) const
{
    return IsSetType();
}

inline
void CVariation_ref_Base::C_Data::C_Set::ResetType(void)
{
    m_Type = (EData_set_type)(0);
    m_set_State[0] &= ~0x3;
}

inline
CVariation_ref_Base::C_Data::C_Set::TType CVariation_ref_Base::C_Data::C_Set::GetType(void) const
{
    if (!CanGetType()) {
        ThrowUnassigned(0);
    }
    return m_Type;
}

inline
void CVariation_ref_Base::C_Data::C_Set::SetType(CVariation_ref_Base::C_Data::C_Set::TType value)
{
    m_Type = value;
    m_set_State[0] |= 0x3;
}

inline
CVariation_ref_Base::C_Data::C_Set::TType& CVariation_ref_Base::C_Data::C_Set::SetType(void)
{
#ifdef _DEBUG
    if (!IsSetType()) {
        memset(&m_Type,UnassignedByte(),sizeof(m_Type));
    }
#endif
    m_set_State[0] |= 0x1;
    return m_Type;
}

inline
bool CVariation_ref_Base::C_Data::C_Set::IsSetVariations(void) const
{
    return ((m_set_State[0] & 0xc) != 0);
}

inline
bool CVariation_ref_Base::C_Data::C_Set::CanGetVariations(void) const
{
    return true;
}

inline
const CVariation_ref_Base::C_Data::C_Set::TVariations& CVariation_ref_Base::C_Data::C_Set::GetVariations(void) const
{
    return m_Variations;
}

inline
CVariation_ref_Base::C_Data::C_Set::TVariations& CVariation_ref_Base::C_Data::C_Set::SetVariations(void)
{
    m_set_State[0] |= 0x4;
    return m_Variations;
}

inline
bool CVariation_ref_Base::C_Data::C_Set::IsSetName(void) const
{
    return ((m_set_State[0] & 0x30) != 0);
}

inline
bool CVariation_ref_Base::C_Data::C_Set::CanGetName(void) const
{
    return IsSetName();
}

inline
const CVariation_ref_Base::C_Data::C_Set::TName& CVariation_ref_Base::C_Data::C_Set::GetName(void) const
{
    if (!CanGetName()) {
        ThrowUnassigned(2);
    }
    return m_Name;
}

inline
void CVariation_ref_Base::C_Data::C_Set::SetName(const CVariation_ref_Base::C_Data::C_Set::TName& value)
{
    m_Name = value;
    m_set_State[0] |= 0x30;
}

inline
void CVariation_ref_Base::C_Data::C_Set::SetName(CVariation_ref_Base::C_Data::C_Set::TName&& value)
{
    m_Name = std::forward<CVariation_ref_Base::C_Data::C_Set::TName>(value);
    m_set_State[0] |= 0x30;
}

inline
CVariation_ref_Base::C_Data::C_Set::TName& CVariation_ref_Base::C_Data::C_Set::SetName(void)
{
#ifdef _DEBUG
    if (!IsSetName()) {
        m_Name = UnassignedString();
    }
#endif
    m_set_State[0] |= 0x10;
    return m_Name;
}

inline
CVariation_ref_Base::C_Data::E_Choice CVariation_ref_Base::C_Data::Which(void) const
{
    return m_choice;
}

inline
void CVariation_ref_Base::C_Data::CheckSelected(E_Choice index) const
{
    if ( m_choice != index )
        ThrowInvalidSelection(index);
}

inline
void CVariation_ref_Base::C_Data::Select(E_Choice index, NCBI_NS_NCBI::EResetVariant reset, NCBI_NS_NCBI::CObjectMemoryPool* pool)
{
    if ( reset == NCBI_NS_NCBI::eDoResetVariant || m_choice != index ) {
        if ( m_choice != e_not_set )
            ResetSelection();
        DoSelect(index, pool);
    }
}

inline
void CVariation_ref_Base::C_Data::Select(E_Choice index, NCBI_NS_NCBI::EResetVariant reset)
{
    Select(index, reset, 0);
}

inline
bool CVariation_ref_Base::C_Data::IsUnknown(void) const
{
    return m_choice == e_Unknown;
}

inline
void CVariation_ref_Base::C_Data::SetUnknown(void)
{
    Select(e_Unknown, NCBI_NS_NCBI::eDoNotResetVariant);
}

inline
bool CVariation_ref_Base::C_Data::IsNote(void) const
{
    return m_choice == e_Note;
}

inline
const CVariation_ref_Base::C_Data::TNote& CVariation_ref_Base::C_Data::GetNote(void) const
{
    CheckSelected(e_Note);
    return *m_string;
}

inline
CVariation_ref_Base::C_Data::TNote& CVariation_ref_Base::C_Data::SetNote(void)
{
    Select(e_Note, NCBI_NS_NCBI::eDoNotResetVariant);
    return *m_string;
}

inline
bool CVariation_ref_Base::C_Data::IsUniparental_disomy(void) const
{
    return m_choice == e_Uniparental_disomy;
}

inline
void CVariation_ref_Base::C_Data::SetUniparental_disomy(void)
{
    Select(e_Uniparental_disomy, NCBI_NS_NCBI::eDoNotResetVariant);
}

inline
bool CVariation_ref_Base::C_Data::IsInstance(void) const
{
    return m_choice == e_Instance;
}

inline
bool CVariation_ref_Base::C_Data::IsSet(void) const
{
    return m_choice == e_Set;
}

inline
bool CVariation_ref_Base::C_Data::IsComplex(void) const
{
    return m_choice == e_Complex;
}

inline
void CVariation_ref_Base::C_Data::SetComplex(void)
{
    Select(e_Complex, NCBI_NS_NCBI::eDoNotResetVariant);
}

inline
bool CVariation_ref_Base::C_E_Consequence::C_Frameshift::IsSetPhase(void) const
{
    return ((m_set_State[0] & 0x3) != 0);
}

inline
bool CVariation_ref_Base::C_E_Consequence::C_Frameshift::CanGetPhase(void) const
{
    return IsSetPhase();
}

inline
void CVariation_ref_Base::C_E_Consequence::C_Frameshift::ResetPhase(void)
{
    m_Phase = 0;
    m_set_State[0] &= ~0x3;
}

inline
CVariation_ref_Base::C_E_Consequence::C_Frameshift::TPhase CVariation_ref_Base::C_E_Consequence::C_Frameshift::GetPhase(void) const
{
    if (!CanGetPhase()) {
        ThrowUnassigned(0);
    }
    return m_Phase;
}

inline
void CVariation_ref_Base::C_E_Consequence::C_Frameshift::SetPhase(CVariation_ref_Base::C_E_Consequence::C_Frameshift::TPhase value)
{
    m_Phase = value;
    m_set_State[0] |= 0x3;
}

inline
CVariation_ref_Base::C_E_Consequence::C_Frameshift::TPhase& CVariation_ref_Base::C_E_Consequence::C_Frameshift::SetPhase(void)
{
#ifdef _DEBUG
    if (!IsSetPhase()) {
        memset(&m_Phase,UnassignedByte(),sizeof(m_Phase));
    }
#endif
    m_set_State[0] |= 0x1;
    return m_Phase;
}

inline
bool CVariation_ref_Base::C_E_Consequence::C_Frameshift::IsSetX_length(void) const
{
    return ((m_set_State[0] & 0xc) != 0);
}

inline
bool CVariation_ref_Base::C_E_Consequence::C_Frameshift::CanGetX_length(void) const
{
    return IsSetX_length();
}

inline
void CVariation_ref_Base::C_E_Consequence::C_Frameshift::ResetX_length(void)
{
    m_X_length = 0;
    m_set_State[0] &= ~0xc;
}

inline
CVariation_ref_Base::C_E_Consequence::C_Frameshift::TX_length CVariation_ref_Base::C_E_Consequence::C_Frameshift::GetX_length(void) const
{
    if (!CanGetX_length()) {
        ThrowUnassigned(1);
    }
    return m_X_length;
}

inline
void CVariation_ref_Base::C_E_Consequence::C_Frameshift::SetX_length(CVariation_ref_Base::C_E_Consequence::C_Frameshift::TX_length value)
{
    m_X_length = value;
    m_set_State[0] |= 0xc;
}

inline
CVariation_ref_Base::C_E_Consequence::C_Frameshift::TX_length& CVariation_ref_Base::C_E_Consequence::C_Frameshift::SetX_length(void)
{
#ifdef _DEBUG
    if (!IsSetX_length()) {
        memset(&m_X_length,UnassignedByte(),sizeof(m_X_length));
    }
#endif
    m_set_State[0] |= 0x4;
    return m_X_length;
}

inline
bool CVariation_ref_Base::C_E_Consequence::C_Loss_of_heterozygosity::IsSetReference(void) const
{
    return ((m_set_State[0] & 0x3) != 0);
}

inline
bool CVariation_ref_Base::C_E_Consequence::C_Loss_of_heterozygosity::CanGetReference(void) const
{
    return IsSetReference();
}

inline
const CVariation_ref_Base::C_E_Consequence::C_Loss_of_heterozygosity::TReference& CVariation_ref_Base::C_E_Consequence::C_Loss_of_heterozygosity::GetReference(void) const
{
    if (!CanGetReference()) {
        ThrowUnassigned(0);
    }
    return m_Reference;
}

inline
void CVariation_ref_Base::C_E_Consequence::C_Loss_of_heterozygosity::SetReference(const CVariation_ref_Base::C_E_Consequence::C_Loss_of_heterozygosity::TReference& value)
{
    m_Reference = value;
    m_set_State[0] |= 0x3;
}

inline
void CVariation_ref_Base::C_E_Consequence::C_Loss_of_heterozygosity::SetReference(CVariation_ref_Base::C_E_Consequence::C_Loss_of_heterozygosity::TReference&& value)
{
    m_Reference = std::forward<CVariation_ref_Base::C_E_Consequence::C_Loss_of_heterozygosity::TReference>(value);
    m_set_State[0] |= 0x3;
}

inline
CVariation_ref_Base::C_E_Consequence::C_Loss_of_heterozygosity::TReference& CVariation_ref_Base::C_E_Consequence::C_Loss_of_heterozygosity::SetReference(void)
{
#ifdef _DEBUG
    if (!IsSetReference()) {
        m_Reference = UnassignedString();
    }
#endif
    m_set_State[0] |= 0x1;
    return m_Reference;
}

inline
bool CVariation_ref_Base::C_E_Consequence::C_Loss_of_heterozygosity::IsSetTest(void) const
{
    return ((m_set_State[0] & 0xc) != 0);
}

inline
bool CVariation_ref_Base::C_E_Consequence::C_Loss_of_heterozygosity::CanGetTest(void) const
{
    return IsSetTest();
}

inline
const CVariation_ref_Base::C_E_Consequence::C_Loss_of_heterozygosity::TTest& CVariation_ref_Base::C_E_Consequence::C_Loss_of_heterozygosity::GetTest(void) const
{
    if (!CanGetTest()) {
        ThrowUnassigned(1);
    }
    return m_Test;
}

inline
void CVariation_ref_Base::C_E_Consequence::C_Loss_of_heterozygosity::SetTest(const CVariation_ref_Base::C_E_Consequence::C_Loss_of_heterozygosity::TTest& value)
{
    m_Test = value;
    m_set_State[0] |= 0xc;
}

inline
void CVariation_ref_Base::C_E_Consequence::C_Loss_of_heterozygosity::SetTest(CVariation_ref_Base::C_E_Consequence::C_Loss_of_heterozygosity::TTest&& value)
{
    m_Test = std::forward<CVariation_ref_Base::C_E_Consequence::C_Loss_of_heterozygosity::TTest>(value);
    m_set_State[0] |= 0xc;
}

inline
CVariation_ref_Base::C_E_Consequence::C_Loss_of_heterozygosity::TTest& CVariation_ref_Base::C_E_Consequence::C_Loss_of_heterozygosity::SetTest(void)
{
#ifdef _DEBUG
    if (!IsSetTest()) {
        m_Test = UnassignedString();
    }
#endif
    m_set_State[0] |= 0x4;
    return m_Test;
}

inline
CVariation_ref_Base::C_E_Consequence::E_Choice CVariation_ref_Base::C_E_Consequence::Which(void) const
{
    return m_choice;
}

inline
void CVariation_ref_Base::C_E_Consequence::CheckSelected(E_Choice index) const
{
    if ( m_choice != index )
        ThrowInvalidSelection(index);
}

inline
void CVariation_ref_Base::C_E_Consequence::Select(E_Choice index, NCBI_NS_NCBI::EResetVariant reset, NCBI_NS_NCBI::CObjectMemoryPool* pool)
{
    if ( reset == NCBI_NS_NCBI::eDoResetVariant || m_choice != index ) {
        if ( m_choice != e_not_set )
            ResetSelection();
        DoSelect(index, pool);
    }
}

inline
void CVariation_ref_Base::C_E_Consequence::Select(E_Choice index, NCBI_NS_NCBI::EResetVariant reset)
{
    Select(index, reset, 0);
}

inline
bool CVariation_ref_Base::C_E_Consequence::IsUnknown(void) const
{
    return m_choice == e_Unknown;
}

inline
void CVariation_ref_Base::C_E_Consequence::SetUnknown(void)
{
    Select(e_Unknown, NCBI_NS_NCBI::eDoNotResetVariant);
}

inline
bool CVariation_ref_Base::C_E_Consequence::IsSplicing(void) const
{
    return m_choice == e_Splicing;
}

inline
void CVariation_ref_Base::C_E_Consequence::SetSplicing(void)
{
    Select(e_Splicing, NCBI_NS_NCBI::eDoNotResetVariant);
}

inline
bool CVariation_ref_Base::C_E_Consequence::IsNote(void) const
{
    return m_choice == e_Note;
}

inline
const CVariation_ref_Base::C_E_Consequence::TNote& CVariation_ref_Base::C_E_Consequence::GetNote(void) const
{
    CheckSelected(e_Note);
    return *m_string;
}

inline
CVariation_ref_Base::C_E_Consequence::TNote& CVariation_ref_Base::C_E_Consequence::SetNote(void)
{
    Select(e_Note, NCBI_NS_NCBI::eDoNotResetVariant);
    return *m_string;
}

inline
bool CVariation_ref_Base::C_E_Consequence::IsVariation(void) const
{
    return m_choice == e_Variation;
}

inline
bool CVariation_ref_Base::C_E_Consequence::IsFrameshift(void) const
{
    return m_choice == e_Frameshift;
}

inline
bool CVariation_ref_Base::C_E_Consequence::IsLoss_of_heterozygosity(void) const
{
    return m_choice == e_Loss_of_heterozygosity;
}

inline
bool CVariation_ref_Base::C_E_Somatic_origin::C_Condition::IsSetDescription(void) const
{
    return ((m_set_State[0] & 0x3) != 0);
}

inline
bool CVariation_ref_Base::C_E_Somatic_origin::C_Condition::CanGetDescription(void) const
{
    return IsSetDescription();
}

inline
const CVariation_ref_Base::C_E_Somatic_origin::C_Condition::TDescription& CVariation_ref_Base::C_E_Somatic_origin::C_Condition::GetDescription(void) const
{
    if (!CanGetDescription()) {
        ThrowUnassigned(0);
    }
    return m_Description;
}

inline
void CVariation_ref_Base::C_E_Somatic_origin::C_Condition::SetDescription(const CVariation_ref_Base::C_E_Somatic_origin::C_Condition::TDescription& value)
{
    m_Description = value;
    m_set_State[0] |= 0x3;
}

inline
void CVariation_ref_Base::C_E_Somatic_origin::C_Condition::SetDescription(CVariation_ref_Base::C_E_Somatic_origin::C_Condition::TDescription&& value)
{
    m_Description = std::forward<CVariation_ref_Base::C_E_Somatic_origin::C_Condition::TDescription>(value);
    m_set_State[0] |= 0x3;
}

inline
CVariation_ref_Base::C_E_Somatic_origin::C_Condition::TDescription& CVariation_ref_Base::C_E_Somatic_origin::C_Condition::SetDescription(void)
{
#ifdef _DEBUG
    if (!IsSetDescription()) {
        m_Description = UnassignedString();
    }
#endif
    m_set_State[0] |= 0x1;
    return m_Description;
}

inline
bool CVariation_ref_Base::C_E_Somatic_origin::C_Condition::IsSetObject_id(void) const
{
    return ((m_set_State[0] & 0xc) != 0);
}

inline
bool CVariation_ref_Base::C_E_Somatic_origin::C_Condition::CanGetObject_id(void) const
{
    return true;
}

inline
const CVariation_ref_Base::C_E_Somatic_origin::C_Condition::TObject_id& CVariation_ref_Base::C_E_Somatic_origin::C_Condition::GetObject_id(void) const
{
    return m_Object_id;
}

inline
CVariation_ref_Base::C_E_Somatic_origin::C_Condition::TObject_id& CVariation_ref_Base::C_E_Somatic_origin::C_Condition::SetObject_id(void)
{
    m_set_State[0] |= 0x4;
    return m_Object_id;
}

inline
bool CVariation_ref_Base::C_E_Somatic_origin::IsSetSource(void) const
{
    return m_Source.NotEmpty();
}

inline
bool CVariation_ref_Base::C_E_Somatic_origin::CanGetSource(void) const
{
    return IsSetSource();
}

inline
const CVariation_ref_Base::C_E_Somatic_origin::TSource& CVariation_ref_Base::C_E_Somatic_origin::GetSource(void) const
{
    if (!CanGetSource()) {
        ThrowUnassigned(0);
    }
    return (*m_Source);
}

inline
bool CVariation_ref_Base::C_E_Somatic_origin::IsSetCondition(void) const
{
    return m_Condition.NotEmpty();
}

inline
bool CVariation_ref_Base::C_E_Somatic_origin::CanGetCondition(void) const
{
    return IsSetCondition();
}

inline
const CVariation_ref_Base::C_E_Somatic_origin::TCondition& CVariation_ref_Base::C_E_Somatic_origin::GetCondition(void) const
{
    if (!CanGetCondition()) {
        ThrowUnassigned(1);
    }
    return (*m_Condition);
}

inline
bool CVariation_ref_Base::IsSetId(void) const
{
    return m_Id.NotEmpty();
}

inline
bool CVariation_ref_Base::CanGetId(void) const
{
    return IsSetId();
}

inline
const CVariation_ref_Base::TId& CVariation_ref_Base::GetId(void) const
{
    if (!CanGetId()) {
        ThrowUnassigned(0);
    }
    return (*m_Id);
}

inline
bool CVariation_ref_Base::IsSetParent_id(void) const
{
    return m_Parent_id.NotEmpty();
}

inline
bool CVariation_ref_Base::CanGetParent_id(void) const
{
    return IsSetParent_id();
}

inline
const CVariation_ref_Base::TParent_id& CVariation_ref_Base::GetParent_id(void) const
{
    if (!CanGetParent_id()) {
        ThrowUnassigned(1);
    }
    return (*m_Parent_id);
}

inline
bool CVariation_ref_Base::IsSetSample_id(void) const
{
    return m_Sample_id.NotEmpty();
}

inline
bool CVariation_ref_Base::CanGetSample_id(void) const
{
    return IsSetSample_id();
}

inline
const CVariation_ref_Base::TSample_id& CVariation_ref_Base::GetSample_id(void) const
{
    if (!CanGetSample_id()) {
        ThrowUnassigned(2);
    }
    return (*m_Sample_id);
}

inline
bool CVariation_ref_Base::IsSetOther_ids(void) const
{
    return ((m_set_State[0] & 0xc0) != 0);
}

inline
bool CVariation_ref_Base::CanGetOther_ids(void) const
{
    return true;
}

inline
const CVariation_ref_Base::TOther_ids& CVariation_ref_Base::GetOther_ids(void) const
{
    return m_Other_ids;
}

inline
CVariation_ref_Base::TOther_ids& CVariation_ref_Base::SetOther_ids(void)
{
    m_set_State[0] |= 0x40;
    return m_Other_ids;
}

inline
bool CVariation_ref_Base::IsSetName(void) const
{
    return ((m_set_State[0] & 0x300) != 0);
}

inline
bool CVariation_ref_Base::CanGetName(void) const
{
    return IsSetName();
}

inline
const CVariation_ref_Base::TName& CVariation_ref_Base::GetName(void) const
{
    if (!CanGetName()) {
        ThrowUnassigned(4);
    }
    return m_Name;
}

inline
void CVariation_ref_Base::SetName(const CVariation_ref_Base::TName& value)
{
    m_Name = value;
    m_set_State[0] |= 0x300;
}

inline
void CVariation_ref_Base::SetName(CVariation_ref_Base::TName&& value)
{
    m_Name = std::forward<CVariation_ref_Base::TName>(value);
    m_set_State[0] |= 0x300;
}

inline
CVariation_ref_Base::TName& CVariation_ref_Base::SetName(void)
{
#ifdef _DEBUG
    if (!IsSetName()) {
        m_Name = UnassignedString();
    }
#endif
    m_set_State[0] |= 0x100;
    return m_Name;
}

inline
bool CVariation_ref_Base::IsSetSynonyms(void) const
{
    return ((m_set_State[0] & 0xc00) != 0);
}

inline
bool CVariation_ref_Base::CanGetSynonyms(void) const
{
    return true;
}

inline
const CVariation_ref_Base::TSynonyms& CVariation_ref_Base::GetSynonyms(void) const
{
    return m_Synonyms;
}

inline
CVariation_ref_Base::TSynonyms& CVariation_ref_Base::SetSynonyms(void)
{
    m_set_State[0] |= 0x400;
    return m_Synonyms;
}

inline
bool CVariation_ref_Base::IsSetDescription(void) const
{
    return ((m_set_State[0] & 0x3000) != 0);
}

inline
bool CVariation_ref_Base::CanGetDescription(void) const
{
    return IsSetDescription();
}

inline
const CVariation_ref_Base::TDescription& CVariation_ref_Base::GetDescription(void) const
{
    if (!CanGetDescription()) {
        ThrowUnassigned(6);
    }
    return m_Description;
}

inline
void CVariation_ref_Base::SetDescription(const CVariation_ref_Base::TDescription& value)
{
    m_Description = value;
    m_set_State[0] |= 0x3000;
}

inline
void CVariation_ref_Base::SetDescription(CVariation_ref_Base::TDescription&& value)
{
    m_Description = std::forward<CVariation_ref_Base::TDescription>(value);
    m_set_State[0] |= 0x3000;
}

inline
CVariation_ref_Base::TDescription& CVariation_ref_Base::SetDescription(void)
{
#ifdef _DEBUG
    if (!IsSetDescription()) {
        m_Description = UnassignedString();
    }
#endif
    m_set_State[0] |= 0x1000;
    return m_Description;
}

inline
bool CVariation_ref_Base::IsSetPhenotype(void) const
{
    return ((m_set_State[0] & 0xc000) != 0);
}

inline
bool CVariation_ref_Base::CanGetPhenotype(void) const
{
    return true;
}

inline
const CVariation_ref_Base::TPhenotype& CVariation_ref_Base::GetPhenotype(void) const
{
    return m_Phenotype;
}

inline
CVariation_ref_Base::TPhenotype& CVariation_ref_Base::SetPhenotype(void)
{
    m_set_State[0] |= 0x4000;
    return m_Phenotype;
}

inline
bool CVariation_ref_Base::IsSetMethod(void) const
{
    return ((m_set_State[0] & 0x30000) != 0);
}

inline
bool CVariation_ref_Base::CanGetMethod(void) const
{
    return true;
}

inline
const CVariation_ref_Base::TMethod& CVariation_ref_Base::GetMethod(void) const
{
    return m_Method;
}

inline
CVariation_ref_Base::TMethod& CVariation_ref_Base::SetMethod(void)
{
    m_set_State[0] |= 0x10000;
    return m_Method;
}

inline
bool CVariation_ref_Base::IsSetPopulation_data(void) const
{
    return ((m_set_State[0] & 0xc0000) != 0);
}

inline
bool CVariation_ref_Base::CanGetPopulation_data(void) const
{
    return true;
}

inline
const CVariation_ref_Base::TPopulation_data& CVariation_ref_Base::GetPopulation_data(void) const
{
    return m_Population_data;
}

inline
CVariation_ref_Base::TPopulation_data& CVariation_ref_Base::SetPopulation_data(void)
{
    m_set_State[0] |= 0x40000;
    return m_Population_data;
}

inline
bool CVariation_ref_Base::IsSetVariant_prop(void) const
{
    return m_Variant_prop.NotEmpty();
}

inline
bool CVariation_ref_Base::CanGetVariant_prop(void) const
{
    return IsSetVariant_prop();
}

inline
const CVariation_ref_Base::TVariant_prop& CVariation_ref_Base::GetVariant_prop(void) const
{
    if (!CanGetVariant_prop()) {
        ThrowUnassigned(10);
    }
    return (*m_Variant_prop);
}

inline
bool CVariation_ref_Base::IsSetValidated(void) const
{
    return ((m_set_State[0] & 0xc00000) != 0);
}

inline
bool CVariation_ref_Base::CanGetValidated(void) const
{
    return IsSetValidated();
}

inline
void CVariation_ref_Base::ResetValidated(void)
{
    m_Validated = 0;
    m_set_State[0] &= ~0xc00000;
}

inline
CVariation_ref_Base::TValidated CVariation_ref_Base::GetValidated(void) const
{
    if (!CanGetValidated()) {
        ThrowUnassigned(11);
    }
    return m_Validated;
}

inline
void CVariation_ref_Base::SetValidated(CVariation_ref_Base::TValidated value)
{
    m_Validated = value;
    m_set_State[0] |= 0xc00000;
}

inline
CVariation_ref_Base::TValidated& CVariation_ref_Base::SetValidated(void)
{
#ifdef _DEBUG
    if (!IsSetValidated()) {
        memset(&m_Validated,UnassignedByte(),sizeof(m_Validated));
    }
#endif
    m_set_State[0] |= 0x400000;
    return m_Validated;
}

inline
bool CVariation_ref_Base::IsSetClinical_test(void) const
{
    return ((m_set_State[0] & 0x3000000) != 0);
}

inline
bool CVariation_ref_Base::CanGetClinical_test(void) const
{
    return true;
}

inline
const CVariation_ref_Base::TClinical_test& CVariation_ref_Base::GetClinical_test(void) const
{
    return m_Clinical_test;
}

inline
CVariation_ref_Base::TClinical_test& CVariation_ref_Base::SetClinical_test(void)
{
    m_set_State[0] |= 0x1000000;
    return m_Clinical_test;
}

inline
bool CVariation_ref_Base::IsSetAllele_origin(void) const
{
    return ((m_set_State[0] & 0xc000000) != 0);
}

inline
bool CVariation_ref_Base::CanGetAllele_origin(void) const
{
    return IsSetAllele_origin();
}

inline
void CVariation_ref_Base::ResetAllele_origin(void)
{
    m_Allele_origin = (EAllele_origin)(0);
    m_set_State[0] &= ~0xc000000;
}

inline
CVariation_ref_Base::TAllele_origin CVariation_ref_Base::GetAllele_origin(void) const
{
    if (!CanGetAllele_origin()) {
        ThrowUnassigned(13);
    }
    return m_Allele_origin;
}

inline
void CVariation_ref_Base::SetAllele_origin(CVariation_ref_Base::TAllele_origin value)
{
    m_Allele_origin = value;
    m_set_State[0] |= 0xc000000;
}

inline
CVariation_ref_Base::TAllele_origin& CVariation_ref_Base::SetAllele_origin(void)
{
#ifdef _DEBUG
    if (!IsSetAllele_origin()) {
        memset(&m_Allele_origin,UnassignedByte(),sizeof(m_Allele_origin));
    }
#endif
    m_set_State[0] |= 0x4000000;
    return m_Allele_origin;
}

inline
bool CVariation_ref_Base::IsSetAllele_state(void) const
{
    return ((m_set_State[0] & 0x30000000) != 0);
}

inline
bool CVariation_ref_Base::CanGetAllele_state(void) const
{
    return IsSetAllele_state();
}

inline
void CVariation_ref_Base::ResetAllele_state(void)
{
    m_Allele_state = (EAllele_state)(0);
    m_set_State[0] &= ~0x30000000;
}

inline
CVariation_ref_Base::TAllele_state CVariation_ref_Base::GetAllele_state(void) const
{
    if (!CanGetAllele_state()) {
        ThrowUnassigned(14);
    }
    return m_Allele_state;
}

inline
void CVariation_ref_Base::SetAllele_state(CVariation_ref_Base::TAllele_state value)
{
    m_Allele_state = value;
    m_set_State[0] |= 0x30000000;
}

inline
CVariation_ref_Base::TAllele_state& CVariation_ref_Base::SetAllele_state(void)
{
#ifdef _DEBUG
    if (!IsSetAllele_state()) {
        memset(&m_Allele_state,UnassignedByte(),sizeof(m_Allele_state));
    }
#endif
    m_set_State[0] |= 0x10000000;
    return m_Allele_state;
}

inline
bool CVariation_ref_Base::IsSetAllele_frequency(void) const
{
    return ((m_set_State[0] & 0xc0000000) != 0);
}

inline
bool CVariation_ref_Base::CanGetAllele_frequency(void) const
{
    return IsSetAllele_frequency();
}

inline
void CVariation_ref_Base::ResetAllele_frequency(void)
{
    m_Allele_frequency = 0;
    m_set_State[0] &= ~0xc0000000;
}

inline
CVariation_ref_Base::TAllele_frequency CVariation_ref_Base::GetAllele_frequency(void) const
{
    if (!CanGetAllele_frequency()) {
        ThrowUnassigned(15);
    }
    return m_Allele_frequency;
}

inline
void CVariation_ref_Base::SetAllele_frequency(CVariation_ref_Base::TAllele_frequency value)
{
    m_Allele_frequency = value;
    m_set_State[0] |= 0xc0000000;
}

inline
CVariation_ref_Base::TAllele_frequency& CVariation_ref_Base::SetAllele_frequency(void)
{
#ifdef _DEBUG
    if (!IsSetAllele_frequency()) {
        memset(&m_Allele_frequency,UnassignedByte(),sizeof(m_Allele_frequency));
    }
#endif
    m_set_State[0] |= 0x40000000;
    return m_Allele_frequency;
}

inline
bool CVariation_ref_Base::IsSetIs_ancestral_allele(void) const
{
    return ((m_set_State[1] & 0x3) != 0);
}

inline
bool CVariation_ref_Base::CanGetIs_ancestral_allele(void) const
{
    return IsSetIs_ancestral_allele();
}

inline
void CVariation_ref_Base::ResetIs_ancestral_allele(void)
{
    m_Is_ancestral_allele = 0;
    m_set_State[1] &= ~0x3;
}

inline
CVariation_ref_Base::TIs_ancestral_allele CVariation_ref_Base::GetIs_ancestral_allele(void) const
{
    if (!CanGetIs_ancestral_allele()) {
        ThrowUnassigned(16);
    }
    return m_Is_ancestral_allele;
}

inline
void CVariation_ref_Base::SetIs_ancestral_allele(CVariation_ref_Base::TIs_ancestral_allele value)
{
    m_Is_ancestral_allele = value;
    m_set_State[1] |= 0x3;
}

inline
CVariation_ref_Base::TIs_ancestral_allele& CVariation_ref_Base::SetIs_ancestral_allele(void)
{
#ifdef _DEBUG
    if (!IsSetIs_ancestral_allele()) {
        memset(&m_Is_ancestral_allele,UnassignedByte(),sizeof(m_Is_ancestral_allele));
    }
#endif
    m_set_State[1] |= 0x1;
    return m_Is_ancestral_allele;
}

inline
bool CVariation_ref_Base::IsSetPub(void) const
{
    return m_Pub.NotEmpty();
}

inline
bool CVariation_ref_Base::CanGetPub(void) const
{
    return IsSetPub();
}

inline
const CVariation_ref_Base::TPub& CVariation_ref_Base::GetPub(void) const
{
    if (!CanGetPub()) {
        ThrowUnassigned(17);
    }
    return (*m_Pub);
}

inline
bool CVariation_ref_Base::IsSetData(void) const
{
    return m_Data.NotEmpty();
}

inline
bool CVariation_ref_Base::CanGetData(void) const
{
    return true;
}

inline
const CVariation_ref_Base::TData& CVariation_ref_Base::GetData(void) const
{
    if ( !m_Data ) {
        const_cast<CVariation_ref_Base*>(this)->ResetData();
    }
    return (*m_Data);
}

inline
CVariation_ref_Base::TData& CVariation_ref_Base::SetData(void)
{
    if ( !m_Data ) {
        ResetData();
    }
    return (*m_Data);
}

inline
bool CVariation_ref_Base::IsSetConsequence(void) const
{
    return ((m_set_State[1] & 0xc0) != 0);
}

inline
bool CVariation_ref_Base::CanGetConsequence(void) const
{
    return true;
}

inline
const CVariation_ref_Base::TConsequence& CVariation_ref_Base::GetConsequence(void) const
{
    return m_Consequence;
}

inline
CVariation_ref_Base::TConsequence& CVariation_ref_Base::SetConsequence(void)
{
    m_set_State[1] |= 0x40;
    return m_Consequence;
}

inline
bool CVariation_ref_Base::IsSetLocation(void) const
{
    return m_Location.NotEmpty();
}

inline
bool CVariation_ref_Base::CanGetLocation(void) const
{
    return IsSetLocation();
}

inline
const CVariation_ref_Base::TLocation& CVariation_ref_Base::GetLocation(void) const
{
    if (!CanGetLocation()) {
        ThrowUnassigned(20);
    }
    return (*m_Location);
}

inline
bool CVariation_ref_Base::IsSetExt_locs(void) const
{
    return ((m_set_State[1] & 0xc00) != 0);
}

inline
bool CVariation_ref_Base::CanGetExt_locs(void) const
{
    return true;
}

inline
const CVariation_ref_Base::TExt_locs& CVariation_ref_Base::GetExt_locs(void) const
{
    return m_Ext_locs;
}

inline
CVariation_ref_Base::TExt_locs& CVariation_ref_Base::SetExt_locs(void)
{
    m_set_State[1] |= 0x400;
    return m_Ext_locs;
}

inline
bool CVariation_ref_Base::IsSetExt(void) const
{
    return m_Ext.NotEmpty();
}

inline
bool CVariation_ref_Base::CanGetExt(void) const
{
    return IsSetExt();
}

inline
const CVariation_ref_Base::TExt& CVariation_ref_Base::GetExt(void) const
{
    if (!CanGetExt()) {
        ThrowUnassigned(22);
    }
    return (*m_Ext);
}

inline
bool CVariation_ref_Base::IsSetSomatic_origin(void) const
{
    return ((m_set_State[1] & 0xc000) != 0);
}

inline
bool CVariation_ref_Base::CanGetSomatic_origin(void) const
{
    return true;
}

inline
const CVariation_ref_Base::TSomatic_origin& CVariation_ref_Base::GetSomatic_origin(void) const
{
    return m_Somatic_origin;
}

inline
CVariation_ref_Base::TSomatic_origin& CVariation_ref_Base::SetSomatic_origin(void)
{
    m_set_State[1] |= 0x4000;
    return m_Somatic_origin;
}

///////////////////////////////////////////////////////////
////////////////// end of inline methods //////////////////
///////////////////////////////////////////////////////////





END_objects_SCOPE // namespace ncbi::objects::

END_NCBI_SCOPE


#endif // OBJECTS_SEQFEAT_VARIATION_REF_BASE_HPP
