/* $Id$
 * ===========================================================================
 *
 *                            PUBLIC DOMAIN NOTICE
 *               National Center for Biotechnology Information
 *
 *  This software/database is a "United States Government Work" under the
 *  terms of the United States Copyright Act.  It was written as part of
 *  the author's official duties as a United States Government employee and
 *  thus cannot be copyrighted.  This software/database is freely available
 *  to the public for use. The National Library of Medicine and the U.S.
 *  Government have not placed any restriction on its use or reproduction.
 *
 *  Although all reasonable efforts have been taken to ensure the accuracy
 *  and reliability of the software and data, the NLM and the U.S.
 *  Government do not and cannot warrant the performance or results that
 *  may be obtained by using this software or data. The NLM and the U.S.
 *  Government disclaim all warranties, express or implied, including
 *  warranties of performance, merchantability or fitness for any particular
 *  purpose.
 *
 *  Please cite the author in any work or product based on this material.
 *
 * ===========================================================================
 *
 */

/// @file Imp_feat_.hpp
/// Data storage class.
///
/// This file was generated by application DATATOOL
/// using the following specifications:
/// 'seqfeat.asn'.
///
/// ATTENTION:
///   Don't edit or commit this file into CVS as this file will
///   be overridden (by DATATOOL) without warning!

#ifndef OBJECTS_SEQFEAT_IMP_FEAT_BASE_HPP
#define OBJECTS_SEQFEAT_IMP_FEAT_BASE_HPP

// standard includes
#include <serial/serialbase.hpp>

// generated includes
#include <string>

BEGIN_NCBI_SCOPE

#ifndef BEGIN_objects_SCOPE
#  define BEGIN_objects_SCOPE BEGIN_SCOPE(objects)
#  define END_objects_SCOPE END_SCOPE(objects)
#endif
BEGIN_objects_SCOPE // namespace ncbi::objects::


// generated classes

/////////////////////////////////////////////////////////////////////////////
///*** Import ***********************************************
///*
///*  Features imported from other databases
///*
class NCBI_SEQFEAT_EXPORT CImp_feat_Base : public CSerialObject
{
    typedef CSerialObject Tparent;
public:
    // constructor
    CImp_feat_Base(void);
    // destructor
    virtual ~CImp_feat_Base(void);

    // type info
    DECLARE_INTERNAL_TYPE_INFO();

    // types
    typedef string TKey;
    typedef string TLoc;
    typedef string TDescr;

    // member index
    enum class E_memberIndex {
        e__allMandatory = 0,
        e_key,
        e_loc,
        e_descr
    };
    typedef Tparent::CMemberIndex<E_memberIndex, 4> TmemberIndex;

    // getters
    // setters

    /// mandatory
    /// typedef string TKey
    ///  Check whether the Key data member has been assigned a value.
    bool IsSetKey(void) const;
    /// Check whether it is safe or not to call GetKey method.
    bool CanGetKey(void) const;
    void ResetKey(void);
    const TKey& GetKey(void) const;
    void SetKey(const TKey& value);
    void SetKey(TKey&& value);
    TKey& SetKey(void);

    /// original location string
    /// optional
    /// typedef string TLoc
    ///  Check whether the Loc data member has been assigned a value.
    bool IsSetLoc(void) const;
    /// Check whether it is safe or not to call GetLoc method.
    bool CanGetLoc(void) const;
    void ResetLoc(void);
    const TLoc& GetLoc(void) const;
    void SetLoc(const TLoc& value);
    void SetLoc(TLoc&& value);
    TLoc& SetLoc(void);

    /// text description
    /// optional
    /// typedef string TDescr
    ///  Check whether the Descr data member has been assigned a value.
    bool IsSetDescr(void) const;
    /// Check whether it is safe or not to call GetDescr method.
    bool CanGetDescr(void) const;
    void ResetDescr(void);
    const TDescr& GetDescr(void) const;
    void SetDescr(const TDescr& value);
    void SetDescr(TDescr&& value);
    TDescr& SetDescr(void);

    /// Reset the whole object
    virtual void Reset(void);


private:
    // Prohibit copy constructor and assignment operator
    CImp_feat_Base(const CImp_feat_Base&);
    CImp_feat_Base& operator=(const CImp_feat_Base&);

    // data
    Uint4 m_set_State[1];
    string m_Key;
    string m_Loc;
    string m_Descr;
};






///////////////////////////////////////////////////////////
///////////////////// inline methods //////////////////////
///////////////////////////////////////////////////////////
inline
bool CImp_feat_Base::IsSetKey(void) const
{
    return ((m_set_State[0] & 0x3) != 0);
}

inline
bool CImp_feat_Base::CanGetKey(void) const
{
    return IsSetKey();
}

inline
const CImp_feat_Base::TKey& CImp_feat_Base::GetKey(void) const
{
    if (!CanGetKey()) {
        ThrowUnassigned(0);
    }
    return m_Key;
}

inline
void CImp_feat_Base::SetKey(const CImp_feat_Base::TKey& value)
{
    m_Key = value;
    m_set_State[0] |= 0x3;
}

inline
void CImp_feat_Base::SetKey(CImp_feat_Base::TKey&& value)
{
    m_Key = std::forward<CImp_feat_Base::TKey>(value);
    m_set_State[0] |= 0x3;
}

inline
CImp_feat_Base::TKey& CImp_feat_Base::SetKey(void)
{
#ifdef _DEBUG
    if (!IsSetKey()) {
        m_Key = UnassignedString();
    }
#endif
    m_set_State[0] |= 0x1;
    return m_Key;
}

inline
bool CImp_feat_Base::IsSetLoc(void) const
{
    return ((m_set_State[0] & 0xc) != 0);
}

inline
bool CImp_feat_Base::CanGetLoc(void) const
{
    return IsSetLoc();
}

inline
const CImp_feat_Base::TLoc& CImp_feat_Base::GetLoc(void) const
{
    if (!CanGetLoc()) {
        ThrowUnassigned(1);
    }
    return m_Loc;
}

inline
void CImp_feat_Base::SetLoc(const CImp_feat_Base::TLoc& value)
{
    m_Loc = value;
    m_set_State[0] |= 0xc;
}

inline
void CImp_feat_Base::SetLoc(CImp_feat_Base::TLoc&& value)
{
    m_Loc = std::forward<CImp_feat_Base::TLoc>(value);
    m_set_State[0] |= 0xc;
}

inline
CImp_feat_Base::TLoc& CImp_feat_Base::SetLoc(void)
{
#ifdef _DEBUG
    if (!IsSetLoc()) {
        m_Loc = UnassignedString();
    }
#endif
    m_set_State[0] |= 0x4;
    return m_Loc;
}

inline
bool CImp_feat_Base::IsSetDescr(void) const
{
    return ((m_set_State[0] & 0x30) != 0);
}

inline
bool CImp_feat_Base::CanGetDescr(void) const
{
    return IsSetDescr();
}

inline
const CImp_feat_Base::TDescr& CImp_feat_Base::GetDescr(void) const
{
    if (!CanGetDescr()) {
        ThrowUnassigned(2);
    }
    return m_Descr;
}

inline
void CImp_feat_Base::SetDescr(const CImp_feat_Base::TDescr& value)
{
    m_Descr = value;
    m_set_State[0] |= 0x30;
}

inline
void CImp_feat_Base::SetDescr(CImp_feat_Base::TDescr&& value)
{
    m_Descr = std::forward<CImp_feat_Base::TDescr>(value);
    m_set_State[0] |= 0x30;
}

inline
CImp_feat_Base::TDescr& CImp_feat_Base::SetDescr(void)
{
#ifdef _DEBUG
    if (!IsSetDescr()) {
        m_Descr = UnassignedString();
    }
#endif
    m_set_State[0] |= 0x10;
    return m_Descr;
}

///////////////////////////////////////////////////////////
////////////////// end of inline methods //////////////////
///////////////////////////////////////////////////////////





END_objects_SCOPE // namespace ncbi::objects::

END_NCBI_SCOPE


#endif // OBJECTS_SEQFEAT_IMP_FEAT_BASE_HPP
