/* $Id$
 * ===========================================================================
 *
 *                            PUBLIC DOMAIN NOTICE
 *               National Center for Biotechnology Information
 *
 *  This software/database is a "United States Government Work" under the
 *  terms of the United States Copyright Act.  It was written as part of
 *  the author's official duties as a United States Government employee and
 *  thus cannot be copyrighted.  This software/database is freely available
 *  to the public for use. The National Library of Medicine and the U.S.
 *  Government have not placed any restriction on its use or reproduction.
 *
 *  Although all reasonable efforts have been taken to ensure the accuracy
 *  and reliability of the software and data, the NLM and the U.S.
 *  Government do not and cannot warrant the performance or results that
 *  may be obtained by using this software or data. The NLM and the U.S.
 *  Government disclaim all warranties, express or implied, including
 *  warranties of performance, merchantability or fitness for any particular
 *  purpose.
 *
 *  Please cite the author in any work or product based on this material.
 *
 * ===========================================================================
 *
 */

/// @file Cdregion_.hpp
/// Data storage class.
///
/// This file was generated by application DATATOOL
/// using the following specifications:
/// 'seqfeat.asn'.
///
/// ATTENTION:
///   Don't edit or commit this file into CVS as this file will
///   be overridden (by DATATOOL) without warning!

#ifndef OBJECTS_SEQFEAT_CDREGION_BASE_HPP
#define OBJECTS_SEQFEAT_CDREGION_BASE_HPP

// standard includes
#include <serial/serialbase.hpp>

// generated includes
#include <list>

BEGIN_NCBI_SCOPE

#ifndef BEGIN_objects_SCOPE
#  define BEGIN_objects_SCOPE BEGIN_SCOPE(objects)
#  define END_objects_SCOPE END_SCOPE(objects)
#endif
BEGIN_objects_SCOPE // namespace ncbi::objects::


// forward declarations
class CCode_break;
class CGenetic_code;


// generated classes

/////////////////////////////////////////////////////////////////////////////
///*** CdRegion ***********************************************
///*
///*  Instructions to translate from a nucleic acid to a peptide
///*    conflict means it's supposed to translate but doesn't
///*
class NCBI_SEQFEAT_EXPORT CCdregion_Base : public CSerialObject
{
    typedef CSerialObject Tparent;
public:
    // constructor
    CCdregion_Base(void);
    // destructor
    virtual ~CCdregion_Base(void);

    // type info
    DECLARE_INTERNAL_TYPE_INFO();

    enum EFrame {
        eFrame_not_set = 0,  ///< not set, code uses one
        eFrame_one     = 1,
        eFrame_two     = 2,
        eFrame_three   = 3  ///< reading frame
    };
    
    /// Access to EFrame's attributes (values, names) as defined in spec
    static const NCBI_NS_NCBI::CEnumeratedTypeValues* ENUM_METHOD_NAME(EFrame)(void);
    
    // types
    typedef bool TOrf;
    typedef EFrame TFrame;
    typedef bool TConflict;
    typedef TSeqPos TGaps;
    typedef TSeqPos TMismatch;
    typedef CGenetic_code TCode;
    typedef list< CRef< CCode_break > > TCode_break;
    typedef TSeqPos TStops;

    // member index
    enum class E_memberIndex {
        e__allMandatory = 0,
        e_orf,
        e_frame,
        e_conflict,
        e_gaps,
        e_mismatch,
        e_code,
        e_code_break,
        e_stops
    };
    typedef Tparent::CMemberIndex<E_memberIndex, 9> TmemberIndex;

    // getters
    // setters

    /// just an ORF ?
    /// optional
    /// typedef bool TOrf
    ///  Check whether the Orf data member has been assigned a value.
    bool IsSetOrf(void) const;
    /// Check whether it is safe or not to call GetOrf method.
    bool CanGetOrf(void) const;
    void ResetOrf(void);
    TOrf GetOrf(void) const;
    void SetOrf(TOrf value);
    TOrf& SetOrf(void);

    /// optional with default eFrame_not_set
    /// typedef EFrame TFrame
    ///  Check whether the Frame data member has been assigned a value.
    bool IsSetFrame(void) const;
    /// Check whether it is safe or not to call GetFrame method.
    bool CanGetFrame(void) const;
    void ResetFrame(void);
    void SetDefaultFrame(void);
    TFrame GetFrame(void) const;
    void SetFrame(TFrame value);
    TFrame& SetFrame(void);

    /// conflict
    /// optional
    /// typedef bool TConflict
    ///  Check whether the Conflict data member has been assigned a value.
    bool IsSetConflict(void) const;
    /// Check whether it is safe or not to call GetConflict method.
    bool CanGetConflict(void) const;
    void ResetConflict(void);
    TConflict GetConflict(void) const;
    void SetConflict(TConflict value);
    TConflict& SetConflict(void);

    /// number of gaps on conflict/except
    /// optional
    /// typedef TSeqPos TGaps
    ///  Check whether the Gaps data member has been assigned a value.
    bool IsSetGaps(void) const;
    /// Check whether it is safe or not to call GetGaps method.
    bool CanGetGaps(void) const;
    void ResetGaps(void);
    TGaps GetGaps(void) const;
    void SetGaps(TGaps value);
    TGaps& SetGaps(void);

    /// number of mismatches on above
    /// optional
    /// typedef TSeqPos TMismatch
    ///  Check whether the Mismatch data member has been assigned a value.
    bool IsSetMismatch(void) const;
    /// Check whether it is safe or not to call GetMismatch method.
    bool CanGetMismatch(void) const;
    void ResetMismatch(void);
    TMismatch GetMismatch(void) const;
    void SetMismatch(TMismatch value);
    TMismatch& SetMismatch(void);

    /// genetic code used
    /// optional
    /// typedef CGenetic_code TCode
    ///  Check whether the Code data member has been assigned a value.
    bool IsSetCode(void) const;
    /// Check whether it is safe or not to call GetCode method.
    bool CanGetCode(void) const;
    void ResetCode(void);
    const TCode& GetCode(void) const;
    void SetCode(TCode& value);
    TCode& SetCode(void);

    /// individual exceptions
    /// optional
    /// typedef list< CRef< CCode_break > > TCode_break
    ///  Check whether the Code_break data member has been assigned a value.
    bool IsSetCode_break(void) const;
    /// Check whether it is safe or not to call GetCode_break method.
    bool CanGetCode_break(void) const;
    void ResetCode_break(void);
    const TCode_break& GetCode_break(void) const;
    TCode_break& SetCode_break(void);

    /// number of stop codons on above
    /// optional
    /// typedef TSeqPos TStops
    ///  Check whether the Stops data member has been assigned a value.
    bool IsSetStops(void) const;
    /// Check whether it is safe or not to call GetStops method.
    bool CanGetStops(void) const;
    void ResetStops(void);
    TStops GetStops(void) const;
    void SetStops(TStops value);
    TStops& SetStops(void);

    /// Reset the whole object
    virtual void Reset(void);


private:
    // Prohibit copy constructor and assignment operator
    CCdregion_Base(const CCdregion_Base&);
    CCdregion_Base& operator=(const CCdregion_Base&);

    // data
    Uint4 m_set_State[1];
    bool m_Orf;
    EFrame m_Frame;
    bool m_Conflict;
    TSeqPos m_Gaps;
    TSeqPos m_Mismatch;
    CRef< TCode > m_Code;
    list< CRef< CCode_break > > m_Code_break;
    TSeqPos m_Stops;
};






///////////////////////////////////////////////////////////
///////////////////// inline methods //////////////////////
///////////////////////////////////////////////////////////
inline
bool CCdregion_Base::IsSetOrf(void) const
{
    return ((m_set_State[0] & 0x3) != 0);
}

inline
bool CCdregion_Base::CanGetOrf(void) const
{
    return IsSetOrf();
}

inline
void CCdregion_Base::ResetOrf(void)
{
    m_Orf = 0;
    m_set_State[0] &= ~0x3;
}

inline
CCdregion_Base::TOrf CCdregion_Base::GetOrf(void) const
{
    if (!CanGetOrf()) {
        ThrowUnassigned(0);
    }
    return m_Orf;
}

inline
void CCdregion_Base::SetOrf(CCdregion_Base::TOrf value)
{
    m_Orf = value;
    m_set_State[0] |= 0x3;
}

inline
CCdregion_Base::TOrf& CCdregion_Base::SetOrf(void)
{
#ifdef _DEBUG
    if (!IsSetOrf()) {
        memset(&m_Orf,UnassignedByte(),sizeof(m_Orf));
    }
#endif
    m_set_State[0] |= 0x1;
    return m_Orf;
}

inline
bool CCdregion_Base::IsSetFrame(void) const
{
    return ((m_set_State[0] & 0xc) != 0);
}

inline
bool CCdregion_Base::CanGetFrame(void) const
{
    return true;
}

inline
void CCdregion_Base::ResetFrame(void)
{
    m_Frame = eFrame_not_set;
    m_set_State[0] &= ~0xc;
}

inline
void CCdregion_Base::SetDefaultFrame(void)
{
    ResetFrame();
}

inline
CCdregion_Base::TFrame CCdregion_Base::GetFrame(void) const
{
    return m_Frame;
}

inline
void CCdregion_Base::SetFrame(CCdregion_Base::TFrame value)
{
    m_Frame = value;
    m_set_State[0] |= 0xc;
}

inline
CCdregion_Base::TFrame& CCdregion_Base::SetFrame(void)
{
#ifdef _DEBUG
    if (!IsSetFrame()) {
        memset(&m_Frame,UnassignedByte(),sizeof(m_Frame));
    }
#endif
    m_set_State[0] |= 0x4;
    return m_Frame;
}

inline
bool CCdregion_Base::IsSetConflict(void) const
{
    return ((m_set_State[0] & 0x30) != 0);
}

inline
bool CCdregion_Base::CanGetConflict(void) const
{
    return IsSetConflict();
}

inline
void CCdregion_Base::ResetConflict(void)
{
    m_Conflict = 0;
    m_set_State[0] &= ~0x30;
}

inline
CCdregion_Base::TConflict CCdregion_Base::GetConflict(void) const
{
    if (!CanGetConflict()) {
        ThrowUnassigned(2);
    }
    return m_Conflict;
}

inline
void CCdregion_Base::SetConflict(CCdregion_Base::TConflict value)
{
    m_Conflict = value;
    m_set_State[0] |= 0x30;
}

inline
CCdregion_Base::TConflict& CCdregion_Base::SetConflict(void)
{
#ifdef _DEBUG
    if (!IsSetConflict()) {
        memset(&m_Conflict,UnassignedByte(),sizeof(m_Conflict));
    }
#endif
    m_set_State[0] |= 0x10;
    return m_Conflict;
}

inline
bool CCdregion_Base::IsSetGaps(void) const
{
    return ((m_set_State[0] & 0xc0) != 0);
}

inline
bool CCdregion_Base::CanGetGaps(void) const
{
    return IsSetGaps();
}

inline
void CCdregion_Base::ResetGaps(void)
{
    m_Gaps = 0;
    m_set_State[0] &= ~0xc0;
}

inline
CCdregion_Base::TGaps CCdregion_Base::GetGaps(void) const
{
    if (!CanGetGaps()) {
        ThrowUnassigned(3);
    }
    return m_Gaps;
}

inline
void CCdregion_Base::SetGaps(CCdregion_Base::TGaps value)
{
    m_Gaps = value;
    m_set_State[0] |= 0xc0;
}

inline
CCdregion_Base::TGaps& CCdregion_Base::SetGaps(void)
{
#ifdef _DEBUG
    if (!IsSetGaps()) {
        memset(&m_Gaps,UnassignedByte(),sizeof(m_Gaps));
    }
#endif
    m_set_State[0] |= 0x40;
    return m_Gaps;
}

inline
bool CCdregion_Base::IsSetMismatch(void) const
{
    return ((m_set_State[0] & 0x300) != 0);
}

inline
bool CCdregion_Base::CanGetMismatch(void) const
{
    return IsSetMismatch();
}

inline
void CCdregion_Base::ResetMismatch(void)
{
    m_Mismatch = 0;
    m_set_State[0] &= ~0x300;
}

inline
CCdregion_Base::TMismatch CCdregion_Base::GetMismatch(void) const
{
    if (!CanGetMismatch()) {
        ThrowUnassigned(4);
    }
    return m_Mismatch;
}

inline
void CCdregion_Base::SetMismatch(CCdregion_Base::TMismatch value)
{
    m_Mismatch = value;
    m_set_State[0] |= 0x300;
}

inline
CCdregion_Base::TMismatch& CCdregion_Base::SetMismatch(void)
{
#ifdef _DEBUG
    if (!IsSetMismatch()) {
        memset(&m_Mismatch,UnassignedByte(),sizeof(m_Mismatch));
    }
#endif
    m_set_State[0] |= 0x100;
    return m_Mismatch;
}

inline
bool CCdregion_Base::IsSetCode(void) const
{
    return m_Code.NotEmpty();
}

inline
bool CCdregion_Base::CanGetCode(void) const
{
    return IsSetCode();
}

inline
const CCdregion_Base::TCode& CCdregion_Base::GetCode(void) const
{
    if (!CanGetCode()) {
        ThrowUnassigned(5);
    }
    return (*m_Code);
}

inline
bool CCdregion_Base::IsSetCode_break(void) const
{
    return ((m_set_State[0] & 0x3000) != 0);
}

inline
bool CCdregion_Base::CanGetCode_break(void) const
{
    return true;
}

inline
const CCdregion_Base::TCode_break& CCdregion_Base::GetCode_break(void) const
{
    return m_Code_break;
}

inline
CCdregion_Base::TCode_break& CCdregion_Base::SetCode_break(void)
{
    m_set_State[0] |= 0x1000;
    return m_Code_break;
}

inline
bool CCdregion_Base::IsSetStops(void) const
{
    return ((m_set_State[0] & 0xc000) != 0);
}

inline
bool CCdregion_Base::CanGetStops(void) const
{
    return IsSetStops();
}

inline
void CCdregion_Base::ResetStops(void)
{
    m_Stops = 0;
    m_set_State[0] &= ~0xc000;
}

inline
CCdregion_Base::TStops CCdregion_Base::GetStops(void) const
{
    if (!CanGetStops()) {
        ThrowUnassigned(7);
    }
    return m_Stops;
}

inline
void CCdregion_Base::SetStops(CCdregion_Base::TStops value)
{
    m_Stops = value;
    m_set_State[0] |= 0xc000;
}

inline
CCdregion_Base::TStops& CCdregion_Base::SetStops(void)
{
#ifdef _DEBUG
    if (!IsSetStops()) {
        memset(&m_Stops,UnassignedByte(),sizeof(m_Stops));
    }
#endif
    m_set_State[0] |= 0x4000;
    return m_Stops;
}

///////////////////////////////////////////////////////////
////////////////// end of inline methods //////////////////
///////////////////////////////////////////////////////////





END_objects_SCOPE // namespace ncbi::objects::

END_NCBI_SCOPE


#endif // OBJECTS_SEQFEAT_CDREGION_BASE_HPP
