/* $Id$
 * ===========================================================================
 *
 *                            PUBLIC DOMAIN NOTICE
 *               National Center for Biotechnology Information
 *
 *  This software/database is a "United States Government Work" under the
 *  terms of the United States Copyright Act.  It was written as part of
 *  the author's official duties as a United States Government employee and
 *  thus cannot be copyrighted.  This software/database is freely available
 *  to the public for use. The National Library of Medicine and the U.S.
 *  Government have not placed any restriction on its use or reproduction.
 *
 *  Although all reasonable efforts have been taken to ensure the accuracy
 *  and reliability of the software and data, the NLM and the U.S.
 *  Government do not and cannot warrant the performance or results that
 *  may be obtained by using this software or data. The NLM and the U.S.
 *  Government disclaim all warranties, express or implied, including
 *  warranties of performance, merchantability or fitness for any particular
 *  purpose.
 *
 *  Please cite the author in any work or product based on this material.
 *
 * ===========================================================================
 *
 */

/// @file Seq_code_table_.hpp
/// Data storage class.
///
/// This file was generated by application DATATOOL
/// using the following specifications:
/// 'seqcode.asn'.
///
/// ATTENTION:
///   Don't edit or commit this file into CVS as this file will
///   be overridden (by DATATOOL) without warning!

#ifndef OBJECTS_SEQCODE_SEQ_CODE_TABLE_BASE_HPP
#define OBJECTS_SEQCODE_SEQ_CODE_TABLE_BASE_HPP

// standard includes
#include <serial/serialbase.hpp>

// generated includes
#include <list>
#include <string>
#include <objects/seqcode/Seq_code_type.hpp>

BEGIN_NCBI_SCOPE

#ifndef BEGIN_objects_SCOPE
#  define BEGIN_objects_SCOPE BEGIN_SCOPE(objects)
#  define END_objects_SCOPE END_SCOPE(objects)
#endif
BEGIN_objects_SCOPE // namespace ncbi::objects::


// generated classes

/////////////////////////////////////////////////////////////////////////////
/// for names of coded values
class NCBI_SEQCODE_EXPORT CSeq_code_table_Base : public CSerialObject
{
    typedef CSerialObject Tparent;
public:
    // constructor
    CSeq_code_table_Base(void);
    // destructor
    virtual ~CSeq_code_table_Base(void);

    // type info
    DECLARE_INTERNAL_TYPE_INFO();

    /////////////////////////////////////////////////////////////////////////////
    class NCBI_SEQCODE_EXPORT C_E_Table : public CSerialObject
    {
        typedef CSerialObject Tparent;
    public:
        // constructor
        C_E_Table(void);
        // destructor
        ~C_E_Table(void);
    
        // type info
        DECLARE_INTERNAL_TYPE_INFO();
    
        // types
        typedef string TSymbol;
        typedef string TName;
    
        // member index
        enum class E_memberIndex {
            e__allMandatory = 0,
            e_symbol,
            e_name
        };
        typedef Tparent::CMemberIndex<E_memberIndex, 3> TmemberIndex;
    
        // getters
        // setters
    
        /// the printed symbol or letter
        /// mandatory
        /// typedef string TSymbol
        ///  Check whether the Symbol data member has been assigned a value.
        bool IsSetSymbol(void) const;
        /// Check whether it is safe or not to call GetSymbol method.
        bool CanGetSymbol(void) const;
        void ResetSymbol(void);
        const TSymbol& GetSymbol(void) const;
        void SetSymbol(const TSymbol& value);
        void SetSymbol(TSymbol&& value);
        TSymbol& SetSymbol(void);
    
        /// mandatory
        /// typedef string TName
        ///  Check whether the Name data member has been assigned a value.
        bool IsSetName(void) const;
        /// Check whether it is safe or not to call GetName method.
        bool CanGetName(void) const;
        void ResetName(void);
        const TName& GetName(void) const;
        void SetName(const TName& value);
        void SetName(TName&& value);
        TName& SetName(void);
    
        /// Reset the whole object
        void Reset(void);
    
    
    private:
        // Prohibit copy constructor and assignment operator
        C_E_Table(const C_E_Table&);
        C_E_Table& operator=(const C_E_Table&);
    
        // data
        Uint4 m_set_State[1];
        string m_Symbol;
        string m_Name;
    };
    // types
    typedef ESeq_code_type TCode;
    typedef int TNum;
    typedef bool TOne_letter;
    typedef int TStart_at;
    typedef C_E_Table C_E;
    typedef list< CRef< C_E_Table > > TTable;
    typedef list< int > TComps;

    // member index
    enum class E_memberIndex {
        e__allMandatory = 0,
        e_code,
        e_num,
        e_one_letter,
        e_start_at,
        e_table,
        e_comps
    };
    typedef Tparent::CMemberIndex<E_memberIndex, 7> TmemberIndex;

    // getters
    // setters

    /// name of code
    /// mandatory
    /// typedef ESeq_code_type TCode
    ///  Check whether the Code data member has been assigned a value.
    bool IsSetCode(void) const;
    /// Check whether it is safe or not to call GetCode method.
    bool CanGetCode(void) const;
    void ResetCode(void);
    TCode GetCode(void) const;
    void SetCode(TCode value);
    TCode& SetCode(void);

    /// number of rows in table
    /// mandatory
    /// typedef int TNum
    ///  Check whether the Num data member has been assigned a value.
    bool IsSetNum(void) const;
    /// Check whether it is safe or not to call GetNum method.
    bool CanGetNum(void) const;
    void ResetNum(void);
    TNum GetNum(void) const;
    void SetNum(TNum value);
    TNum& SetNum(void);

    /// symbol is ALWAYS 1 letter?
    /// mandatory
    /// typedef bool TOne_letter
    ///  Check whether the One_letter data member has been assigned a value.
    bool IsSetOne_letter(void) const;
    /// Check whether it is safe or not to call GetOne_letter method.
    bool CanGetOne_letter(void) const;
    void ResetOne_letter(void);
    TOne_letter GetOne_letter(void) const;
    void SetOne_letter(TOne_letter value);
    TOne_letter& SetOne_letter(void);

    /// index offset of first element
    /// optional with default 0
    /// typedef int TStart_at
    ///  Check whether the Start_at data member has been assigned a value.
    bool IsSetStart_at(void) const;
    /// Check whether it is safe or not to call GetStart_at method.
    bool CanGetStart_at(void) const;
    void ResetStart_at(void);
    void SetDefaultStart_at(void);
    TStart_at GetStart_at(void) const;
    void SetStart_at(TStart_at value);
    TStart_at& SetStart_at(void);

    /// an explanatory name or string
    /// mandatory
    /// typedef list< CRef< C_E_Table > > TTable
    ///  Check whether the Table data member has been assigned a value.
    bool IsSetTable(void) const;
    /// Check whether it is safe or not to call GetTable method.
    bool CanGetTable(void) const;
    void ResetTable(void);
    const TTable& GetTable(void) const;
    TTable& SetTable(void);

    /// pointers to complement nuc acid
    /// optional
    /// typedef list< int > TComps
    ///  Check whether the Comps data member has been assigned a value.
    bool IsSetComps(void) const;
    /// Check whether it is safe or not to call GetComps method.
    bool CanGetComps(void) const;
    void ResetComps(void);
    const TComps& GetComps(void) const;
    TComps& SetComps(void);

    /// Reset the whole object
    virtual void Reset(void);


private:
    // Prohibit copy constructor and assignment operator
    CSeq_code_table_Base(const CSeq_code_table_Base&);
    CSeq_code_table_Base& operator=(const CSeq_code_table_Base&);

    // data
    Uint4 m_set_State[1];
    ESeq_code_type m_Code;
    int m_Num;
    bool m_One_letter;
    int m_Start_at;
    list< CRef< C_E_Table > > m_Table;
    list< int > m_Comps;
};






///////////////////////////////////////////////////////////
///////////////////// inline methods //////////////////////
///////////////////////////////////////////////////////////
inline
bool CSeq_code_table_Base::C_E_Table::IsSetSymbol(void) const
{
    return ((m_set_State[0] & 0x3) != 0);
}

inline
bool CSeq_code_table_Base::C_E_Table::CanGetSymbol(void) const
{
    return IsSetSymbol();
}

inline
const CSeq_code_table_Base::C_E_Table::TSymbol& CSeq_code_table_Base::C_E_Table::GetSymbol(void) const
{
    if (!CanGetSymbol()) {
        ThrowUnassigned(0);
    }
    return m_Symbol;
}

inline
void CSeq_code_table_Base::C_E_Table::SetSymbol(const CSeq_code_table_Base::C_E_Table::TSymbol& value)
{
    m_Symbol = value;
    m_set_State[0] |= 0x3;
}

inline
void CSeq_code_table_Base::C_E_Table::SetSymbol(CSeq_code_table_Base::C_E_Table::TSymbol&& value)
{
    m_Symbol = std::forward<CSeq_code_table_Base::C_E_Table::TSymbol>(value);
    m_set_State[0] |= 0x3;
}

inline
CSeq_code_table_Base::C_E_Table::TSymbol& CSeq_code_table_Base::C_E_Table::SetSymbol(void)
{
#ifdef _DEBUG
    if (!IsSetSymbol()) {
        m_Symbol = UnassignedString();
    }
#endif
    m_set_State[0] |= 0x1;
    return m_Symbol;
}

inline
bool CSeq_code_table_Base::C_E_Table::IsSetName(void) const
{
    return ((m_set_State[0] & 0xc) != 0);
}

inline
bool CSeq_code_table_Base::C_E_Table::CanGetName(void) const
{
    return IsSetName();
}

inline
const CSeq_code_table_Base::C_E_Table::TName& CSeq_code_table_Base::C_E_Table::GetName(void) const
{
    if (!CanGetName()) {
        ThrowUnassigned(1);
    }
    return m_Name;
}

inline
void CSeq_code_table_Base::C_E_Table::SetName(const CSeq_code_table_Base::C_E_Table::TName& value)
{
    m_Name = value;
    m_set_State[0] |= 0xc;
}

inline
void CSeq_code_table_Base::C_E_Table::SetName(CSeq_code_table_Base::C_E_Table::TName&& value)
{
    m_Name = std::forward<CSeq_code_table_Base::C_E_Table::TName>(value);
    m_set_State[0] |= 0xc;
}

inline
CSeq_code_table_Base::C_E_Table::TName& CSeq_code_table_Base::C_E_Table::SetName(void)
{
#ifdef _DEBUG
    if (!IsSetName()) {
        m_Name = UnassignedString();
    }
#endif
    m_set_State[0] |= 0x4;
    return m_Name;
}

inline
bool CSeq_code_table_Base::IsSetCode(void) const
{
    return ((m_set_State[0] & 0x3) != 0);
}

inline
bool CSeq_code_table_Base::CanGetCode(void) const
{
    return IsSetCode();
}

inline
void CSeq_code_table_Base::ResetCode(void)
{
    m_Code = (ncbi::objects::ESeq_code_type)(0);
    m_set_State[0] &= ~0x3;
}

inline
CSeq_code_table_Base::TCode CSeq_code_table_Base::GetCode(void) const
{
    if (!CanGetCode()) {
        ThrowUnassigned(0);
    }
    return m_Code;
}

inline
void CSeq_code_table_Base::SetCode(CSeq_code_table_Base::TCode value)
{
    m_Code = value;
    m_set_State[0] |= 0x3;
}

inline
CSeq_code_table_Base::TCode& CSeq_code_table_Base::SetCode(void)
{
#ifdef _DEBUG
    if (!IsSetCode()) {
        memset(&m_Code,UnassignedByte(),sizeof(m_Code));
    }
#endif
    m_set_State[0] |= 0x1;
    return m_Code;
}

inline
bool CSeq_code_table_Base::IsSetNum(void) const
{
    return ((m_set_State[0] & 0xc) != 0);
}

inline
bool CSeq_code_table_Base::CanGetNum(void) const
{
    return IsSetNum();
}

inline
void CSeq_code_table_Base::ResetNum(void)
{
    m_Num = 0;
    m_set_State[0] &= ~0xc;
}

inline
CSeq_code_table_Base::TNum CSeq_code_table_Base::GetNum(void) const
{
    if (!CanGetNum()) {
        ThrowUnassigned(1);
    }
    return m_Num;
}

inline
void CSeq_code_table_Base::SetNum(CSeq_code_table_Base::TNum value)
{
    m_Num = value;
    m_set_State[0] |= 0xc;
}

inline
CSeq_code_table_Base::TNum& CSeq_code_table_Base::SetNum(void)
{
#ifdef _DEBUG
    if (!IsSetNum()) {
        memset(&m_Num,UnassignedByte(),sizeof(m_Num));
    }
#endif
    m_set_State[0] |= 0x4;
    return m_Num;
}

inline
bool CSeq_code_table_Base::IsSetOne_letter(void) const
{
    return ((m_set_State[0] & 0x30) != 0);
}

inline
bool CSeq_code_table_Base::CanGetOne_letter(void) const
{
    return IsSetOne_letter();
}

inline
void CSeq_code_table_Base::ResetOne_letter(void)
{
    m_One_letter = 0;
    m_set_State[0] &= ~0x30;
}

inline
CSeq_code_table_Base::TOne_letter CSeq_code_table_Base::GetOne_letter(void) const
{
    if (!CanGetOne_letter()) {
        ThrowUnassigned(2);
    }
    return m_One_letter;
}

inline
void CSeq_code_table_Base::SetOne_letter(CSeq_code_table_Base::TOne_letter value)
{
    m_One_letter = value;
    m_set_State[0] |= 0x30;
}

inline
CSeq_code_table_Base::TOne_letter& CSeq_code_table_Base::SetOne_letter(void)
{
#ifdef _DEBUG
    if (!IsSetOne_letter()) {
        memset(&m_One_letter,UnassignedByte(),sizeof(m_One_letter));
    }
#endif
    m_set_State[0] |= 0x10;
    return m_One_letter;
}

inline
bool CSeq_code_table_Base::IsSetStart_at(void) const
{
    return ((m_set_State[0] & 0xc0) != 0);
}

inline
bool CSeq_code_table_Base::CanGetStart_at(void) const
{
    return true;
}

inline
void CSeq_code_table_Base::ResetStart_at(void)
{
    m_Start_at = 0;
    m_set_State[0] &= ~0xc0;
}

inline
void CSeq_code_table_Base::SetDefaultStart_at(void)
{
    ResetStart_at();
}

inline
CSeq_code_table_Base::TStart_at CSeq_code_table_Base::GetStart_at(void) const
{
    return m_Start_at;
}

inline
void CSeq_code_table_Base::SetStart_at(CSeq_code_table_Base::TStart_at value)
{
    m_Start_at = value;
    m_set_State[0] |= 0xc0;
}

inline
CSeq_code_table_Base::TStart_at& CSeq_code_table_Base::SetStart_at(void)
{
#ifdef _DEBUG
    if (!IsSetStart_at()) {
        memset(&m_Start_at,UnassignedByte(),sizeof(m_Start_at));
    }
#endif
    m_set_State[0] |= 0x40;
    return m_Start_at;
}

inline
bool CSeq_code_table_Base::IsSetTable(void) const
{
    return ((m_set_State[0] & 0x300) != 0);
}

inline
bool CSeq_code_table_Base::CanGetTable(void) const
{
    return true;
}

inline
const CSeq_code_table_Base::TTable& CSeq_code_table_Base::GetTable(void) const
{
    return m_Table;
}

inline
CSeq_code_table_Base::TTable& CSeq_code_table_Base::SetTable(void)
{
    m_set_State[0] |= 0x100;
    return m_Table;
}

inline
bool CSeq_code_table_Base::IsSetComps(void) const
{
    return ((m_set_State[0] & 0xc00) != 0);
}

inline
bool CSeq_code_table_Base::CanGetComps(void) const
{
    return true;
}

inline
const CSeq_code_table_Base::TComps& CSeq_code_table_Base::GetComps(void) const
{
    return m_Comps;
}

inline
CSeq_code_table_Base::TComps& CSeq_code_table_Base::SetComps(void)
{
    m_set_State[0] |= 0x400;
    return m_Comps;
}

///////////////////////////////////////////////////////////
////////////////// end of inline methods //////////////////
///////////////////////////////////////////////////////////





END_objects_SCOPE // namespace ncbi::objects::

END_NCBI_SCOPE


#endif // OBJECTS_SEQCODE_SEQ_CODE_TABLE_BASE_HPP
