/* $Id$
 * ===========================================================================
 *
 *                            PUBLIC DOMAIN NOTICE
 *               National Center for Biotechnology Information
 *
 *  This software/database is a "United States Government Work" under the
 *  terms of the United States Copyright Act.  It was written as part of
 *  the author's official duties as a United States Government employee and
 *  thus cannot be copyrighted.  This software/database is freely available
 *  to the public for use. The National Library of Medicine and the U.S.
 *  Government have not placed any restriction on its use or reproduction.
 *
 *  Although all reasonable efforts have been taken to ensure the accuracy
 *  and reliability of the software and data, the NLM and the U.S.
 *  Government do not and cannot warrant the performance or results that
 *  may be obtained by using this software or data. The NLM and the U.S.
 *  Government disclaim all warranties, express or implied, including
 *  warranties of performance, merchantability or fitness for any particular
 *  purpose.
 *
 *  Please cite the author in any work or product based on this material.
 *
 * ===========================================================================
 *
 */

/// @file Seq_hist_.hpp
/// Data storage class.
///
/// This file was generated by application DATATOOL
/// using the following specifications:
/// 'seq.asn'.
///
/// ATTENTION:
///   Don't edit or commit this file into CVS as this file will
///   be overridden (by DATATOOL) without warning!

#ifndef OBJECTS_SEQ_SEQ_HIST_BASE_HPP
#define OBJECTS_SEQ_SEQ_HIST_BASE_HPP

// standard includes
#include <serial/serialbase.hpp>

// generated includes
#include <list>

BEGIN_NCBI_SCOPE

#ifndef BEGIN_objects_SCOPE
#  define BEGIN_objects_SCOPE BEGIN_SCOPE(objects)
#  define END_objects_SCOPE END_SCOPE(objects)
#endif
BEGIN_objects_SCOPE // namespace ncbi::objects::


// forward declarations
class CDate;
class CSeq_align;
class CSeq_hist_rec;


// generated classes

/////////////////////////////////////////////////////////////////////////////
///*** Sequence History Record ***********************************
///** assembly = records how seq was assembled from others
///** replaces = records sequences made obsolete by this one
///** replaced-by = this seq is made obsolete by another(s)
class NCBI_SEQ_EXPORT CSeq_hist_Base : public CSerialObject
{
    typedef CSerialObject Tparent;
public:
    // constructor
    CSeq_hist_Base(void);
    // destructor
    virtual ~CSeq_hist_Base(void);

    // type info
    DECLARE_INTERNAL_TYPE_INFO();

    /////////////////////////////////////////////////////////////////////////////
    class NCBI_SEQ_EXPORT C_Deleted : public CSerialObject
    {
        typedef CSerialObject Tparent;
    public:
        // constructor
        C_Deleted(void);
        // destructor
        ~C_Deleted(void);
    
        // type info
        DECLARE_INTERNAL_TYPE_INFO();
    
    
        /// Choice variants.
        enum E_Choice {
            e_not_set = 0,  ///< No variant selected
            e_Bool,
            e_Date
        };
        /// Maximum+1 value of the choice variant enumerator.
        enum E_ChoiceStopper {
            e_MaxChoice = 3 ///< == e_Date+1
        };
    
        /// Reset the whole object
        void Reset(void);
    
        /// Reset the selection (set it to e_not_set).
        void ResetSelection(void);
    
        /// Which variant is currently selected.
        E_Choice Which(void) const;
    
        /// Verify selection, throw exception if it differs from the expected.
        void CheckSelected(E_Choice index) const;
    
        /// Throw 'InvalidSelection' exception.
        NCBI_NORETURN void ThrowInvalidSelection(E_Choice index) const;
    
        /// Retrieve selection name (for diagnostic purposes).
        static string SelectionName(E_Choice index);
    
        /// Select the requested variant if needed.
        void Select(E_Choice index, EResetVariant reset = eDoResetVariant);
        /// Select the requested variant if needed,
        /// allocating CObject variants from memory pool.
        void Select(E_Choice index,
                    EResetVariant reset,
                    CObjectMemoryPool* pool);
    
        // types
        typedef bool TBool;
        typedef CDate TDate;
    
        // getters
        // setters
    
        // typedef bool TBool
        bool IsBool(void) const;
        TBool GetBool(void) const;
        TBool& SetBool(void);
        void SetBool(TBool value);
    
        // typedef CDate TDate
        bool IsDate(void) const;
        const TDate& GetDate(void) const;
        TDate& SetDate(void);
        void SetDate(TDate& value);
    
    
    private:
        // copy constructor and assignment operator
        C_Deleted(const C_Deleted& );
        C_Deleted& operator=(const C_Deleted& );
        // choice state
        E_Choice m_choice;
        // helper methods
        void DoSelect(E_Choice index, CObjectMemoryPool* pool = 0);
    
        static const char* const sm_SelectionNames[];
        // data
        union {
            TBool m_Bool;
            NCBI_NS_NCBI::CSerialObject *m_object;
        };
    };
    // types
    typedef list< CRef< CSeq_align > > TAssembly;
    typedef CSeq_hist_rec TReplaces;
    typedef CSeq_hist_rec TReplaced_by;
    typedef C_Deleted TDeleted;

    // member index
    enum class E_memberIndex {
        e__allMandatory = 0,
        e_assembly,
        e_replaces,
        e_replaced_by,
        e_deleted
    };
    typedef Tparent::CMemberIndex<E_memberIndex, 5> TmemberIndex;

    // getters
    // setters

    /// how was this assembled?
    /// optional
    /// typedef list< CRef< CSeq_align > > TAssembly
    ///  Check whether the Assembly data member has been assigned a value.
    bool IsSetAssembly(void) const;
    /// Check whether it is safe or not to call GetAssembly method.
    bool CanGetAssembly(void) const;
    void ResetAssembly(void);
    const TAssembly& GetAssembly(void) const;
    TAssembly& SetAssembly(void);

    /// seq makes these seqs obsolete
    /// optional
    /// typedef CSeq_hist_rec TReplaces
    ///  Check whether the Replaces data member has been assigned a value.
    bool IsSetReplaces(void) const;
    /// Check whether it is safe or not to call GetReplaces method.
    bool CanGetReplaces(void) const;
    void ResetReplaces(void);
    const TReplaces& GetReplaces(void) const;
    void SetReplaces(TReplaces& value);
    TReplaces& SetReplaces(void);

    /// these seqs make this one obsolete
    /// optional
    /// typedef CSeq_hist_rec TReplaced_by
    ///  Check whether the Replaced_by data member has been assigned a value.
    bool IsSetReplaced_by(void) const;
    /// Check whether it is safe or not to call GetReplaced_by method.
    bool CanGetReplaced_by(void) const;
    void ResetReplaced_by(void);
    const TReplaced_by& GetReplaced_by(void) const;
    void SetReplaced_by(TReplaced_by& value);
    TReplaced_by& SetReplaced_by(void);

    /// optional
    /// typedef C_Deleted TDeleted
    ///  Check whether the Deleted data member has been assigned a value.
    bool IsSetDeleted(void) const;
    /// Check whether it is safe or not to call GetDeleted method.
    bool CanGetDeleted(void) const;
    void ResetDeleted(void);
    const TDeleted& GetDeleted(void) const;
    void SetDeleted(TDeleted& value);
    TDeleted& SetDeleted(void);

    /// Reset the whole object
    virtual void Reset(void);


private:
    // Prohibit copy constructor and assignment operator
    CSeq_hist_Base(const CSeq_hist_Base&);
    CSeq_hist_Base& operator=(const CSeq_hist_Base&);

    // data
    Uint4 m_set_State[1];
    list< CRef< CSeq_align > > m_Assembly;
    CRef< TReplaces > m_Replaces;
    CRef< TReplaced_by > m_Replaced_by;
    CRef< TDeleted > m_Deleted;
};






///////////////////////////////////////////////////////////
///////////////////// inline methods //////////////////////
///////////////////////////////////////////////////////////
inline
CSeq_hist_Base::C_Deleted::E_Choice CSeq_hist_Base::C_Deleted::Which(void) const
{
    return m_choice;
}

inline
void CSeq_hist_Base::C_Deleted::CheckSelected(E_Choice index) const
{
    if ( m_choice != index )
        ThrowInvalidSelection(index);
}

inline
void CSeq_hist_Base::C_Deleted::Select(E_Choice index, NCBI_NS_NCBI::EResetVariant reset, NCBI_NS_NCBI::CObjectMemoryPool* pool)
{
    if ( reset == NCBI_NS_NCBI::eDoResetVariant || m_choice != index ) {
        if ( m_choice != e_not_set )
            ResetSelection();
        DoSelect(index, pool);
    }
}

inline
void CSeq_hist_Base::C_Deleted::Select(E_Choice index, NCBI_NS_NCBI::EResetVariant reset)
{
    Select(index, reset, 0);
}

inline
bool CSeq_hist_Base::C_Deleted::IsBool(void) const
{
    return m_choice == e_Bool;
}

inline
CSeq_hist_Base::C_Deleted::TBool CSeq_hist_Base::C_Deleted::GetBool(void) const
{
    CheckSelected(e_Bool);
    return m_Bool;
}

inline
CSeq_hist_Base::C_Deleted::TBool& CSeq_hist_Base::C_Deleted::SetBool(void)
{
    Select(e_Bool, NCBI_NS_NCBI::eDoNotResetVariant);
    return m_Bool;
}

inline
void CSeq_hist_Base::C_Deleted::SetBool(CSeq_hist_Base::C_Deleted::TBool value)
{
    Select(e_Bool, NCBI_NS_NCBI::eDoNotResetVariant);
    m_Bool = value;
}

inline
bool CSeq_hist_Base::C_Deleted::IsDate(void) const
{
    return m_choice == e_Date;
}

inline
bool CSeq_hist_Base::IsSetAssembly(void) const
{
    return ((m_set_State[0] & 0x3) != 0);
}

inline
bool CSeq_hist_Base::CanGetAssembly(void) const
{
    return true;
}

inline
const CSeq_hist_Base::TAssembly& CSeq_hist_Base::GetAssembly(void) const
{
    return m_Assembly;
}

inline
CSeq_hist_Base::TAssembly& CSeq_hist_Base::SetAssembly(void)
{
    m_set_State[0] |= 0x1;
    return m_Assembly;
}

inline
bool CSeq_hist_Base::IsSetReplaces(void) const
{
    return m_Replaces.NotEmpty();
}

inline
bool CSeq_hist_Base::CanGetReplaces(void) const
{
    return IsSetReplaces();
}

inline
const CSeq_hist_Base::TReplaces& CSeq_hist_Base::GetReplaces(void) const
{
    if (!CanGetReplaces()) {
        ThrowUnassigned(1);
    }
    return (*m_Replaces);
}

inline
bool CSeq_hist_Base::IsSetReplaced_by(void) const
{
    return m_Replaced_by.NotEmpty();
}

inline
bool CSeq_hist_Base::CanGetReplaced_by(void) const
{
    return IsSetReplaced_by();
}

inline
const CSeq_hist_Base::TReplaced_by& CSeq_hist_Base::GetReplaced_by(void) const
{
    if (!CanGetReplaced_by()) {
        ThrowUnassigned(2);
    }
    return (*m_Replaced_by);
}

inline
bool CSeq_hist_Base::IsSetDeleted(void) const
{
    return m_Deleted.NotEmpty();
}

inline
bool CSeq_hist_Base::CanGetDeleted(void) const
{
    return IsSetDeleted();
}

inline
const CSeq_hist_Base::TDeleted& CSeq_hist_Base::GetDeleted(void) const
{
    if (!CanGetDeleted()) {
        ThrowUnassigned(3);
    }
    return (*m_Deleted);
}

///////////////////////////////////////////////////////////
////////////////// end of inline methods //////////////////
///////////////////////////////////////////////////////////





END_objects_SCOPE // namespace ncbi::objects::

END_NCBI_SCOPE


#endif // OBJECTS_SEQ_SEQ_HIST_BASE_HPP
