/* $Id$
 * ===========================================================================
 *
 *                            PUBLIC DOMAIN NOTICE
 *               National Center for Biotechnology Information
 *
 *  This software/database is a "United States Government Work" under the
 *  terms of the United States Copyright Act.  It was written as part of
 *  the author's official duties as a United States Government employee and
 *  thus cannot be copyrighted.  This software/database is freely available
 *  to the public for use. The National Library of Medicine and the U.S.
 *  Government have not placed any restriction on its use or reproduction.
 *
 *  Although all reasonable efforts have been taken to ensure the accuracy
 *  and reliability of the software and data, the NLM and the U.S.
 *  Government do not and cannot warrant the performance or results that
 *  may be obtained by using this software or data. The NLM and the U.S.
 *  Government disclaim all warranties, express or implied, including
 *  warranties of performance, merchantability or fitness for any particular
 *  purpose.
 *
 *  Please cite the author in any work or product based on this material.
 *
 * ===========================================================================
 *
 */

/// @file Pubdesc_.hpp
/// Data storage class.
///
/// This file was generated by application DATATOOL
/// using the following specifications:
/// 'seq.asn'.
///
/// ATTENTION:
///   Don't edit or commit this file into CVS as this file will
///   be overridden (by DATATOOL) without warning!

#ifndef OBJECTS_SEQ_PUBDESC_BASE_HPP
#define OBJECTS_SEQ_PUBDESC_BASE_HPP

// standard includes
#include <serial/serialbase.hpp>

// generated includes
#include <string>

BEGIN_NCBI_SCOPE

#ifndef BEGIN_objects_SCOPE
#  define BEGIN_objects_SCOPE BEGIN_SCOPE(objects)
#  define END_objects_SCOPE END_SCOPE(objects)
#endif
BEGIN_objects_SCOPE // namespace ncbi::objects::


// forward declarations
class CNumbering;
class CPub_equiv;


// generated classes

/////////////////////////////////////////////////////////////////////////////
/// how sequence presented in pub
class NCBI_SEQ_EXPORT CPubdesc_Base : public CSerialObject
{
    typedef CSerialObject Tparent;
public:
    // constructor
    CPubdesc_Base(void);
    // destructor
    virtual ~CPubdesc_Base(void);

    // type info
    DECLARE_INTERNAL_TYPE_INFO();

    /// type of reference in a GenBank record
    enum EReftype {
        eReftype_seq       = 0,  ///< refers to sequence
        eReftype_sites     = 1,  ///< refers to unspecified features
        eReftype_feats     = 2,  ///< refers to specified features
        eReftype_no_target = 3  ///< nothing specified (EMBL)
    };
    
    /// Access to EReftype's attributes (values, names) as defined in spec
    static const NCBI_NS_NCBI::CEnumeratedTypeValues* ENUM_METHOD_NAME(EReftype)(void);
    
    // types
    typedef CPub_equiv TPub;
    typedef string TName;
    typedef string TFig;
    typedef CNumbering TNum;
    typedef bool TNumexc;
    typedef bool TPoly_a;
    typedef string TMaploc;
    typedef string TSeq_raw;
    typedef int TAlign_group;
    typedef string TComment;
    typedef int TReftype;

    // member index
    enum class E_memberIndex {
        e__allMandatory = 0,
        e_pub,
        e_name,
        e_fig,
        e_num,
        e_numexc,
        e_poly_a,
        e_maploc,
        e_seq_raw,
        e_align_group,
        e_comment,
        e_reftype
    };
    typedef Tparent::CMemberIndex<E_memberIndex, 12> TmemberIndex;

    // getters
    // setters

    /// the citation(s)
    /// mandatory
    /// typedef CPub_equiv TPub
    ///  Check whether the Pub data member has been assigned a value.
    bool IsSetPub(void) const;
    /// Check whether it is safe or not to call GetPub method.
    bool CanGetPub(void) const;
    void ResetPub(void);
    const TPub& GetPub(void) const;
    void SetPub(TPub& value);
    TPub& SetPub(void);

    /// name used in paper
    /// optional
    /// typedef string TName
    ///  Check whether the Name data member has been assigned a value.
    bool IsSetName(void) const;
    /// Check whether it is safe or not to call GetName method.
    bool CanGetName(void) const;
    void ResetName(void);
    const TName& GetName(void) const;
    void SetName(const TName& value);
    void SetName(TName&& value);
    TName& SetName(void);

    /// figure in paper
    /// optional
    /// typedef string TFig
    ///  Check whether the Fig data member has been assigned a value.
    bool IsSetFig(void) const;
    /// Check whether it is safe or not to call GetFig method.
    bool CanGetFig(void) const;
    void ResetFig(void);
    const TFig& GetFig(void) const;
    void SetFig(const TFig& value);
    void SetFig(TFig&& value);
    TFig& SetFig(void);

    /// numbering from paper
    /// optional
    /// typedef CNumbering TNum
    ///  Check whether the Num data member has been assigned a value.
    bool IsSetNum(void) const;
    /// Check whether it is safe or not to call GetNum method.
    bool CanGetNum(void) const;
    void ResetNum(void);
    const TNum& GetNum(void) const;
    void SetNum(TNum& value);
    TNum& SetNum(void);

    /// numbering problem with paper
    /// optional
    /// typedef bool TNumexc
    ///  Check whether the Numexc data member has been assigned a value.
    bool IsSetNumexc(void) const;
    /// Check whether it is safe or not to call GetNumexc method.
    bool CanGetNumexc(void) const;
    void ResetNumexc(void);
    TNumexc GetNumexc(void) const;
    void SetNumexc(TNumexc value);
    TNumexc& SetNumexc(void);

    /// poly A tail indicated in figure?
    /// optional
    /// typedef bool TPoly_a
    ///  Check whether the Poly_a data member has been assigned a value.
    bool IsSetPoly_a(void) const;
    /// Check whether it is safe or not to call GetPoly_a method.
    bool CanGetPoly_a(void) const;
    void ResetPoly_a(void);
    TPoly_a GetPoly_a(void) const;
    void SetPoly_a(TPoly_a value);
    TPoly_a& SetPoly_a(void);

    /// map location reported in paper
    /// optional
    /// typedef string TMaploc
    ///  Check whether the Maploc data member has been assigned a value.
    bool IsSetMaploc(void) const;
    /// Check whether it is safe or not to call GetMaploc method.
    bool CanGetMaploc(void) const;
    void ResetMaploc(void);
    const TMaploc& GetMaploc(void) const;
    void SetMaploc(const TMaploc& value);
    void SetMaploc(TMaploc&& value);
    TMaploc& SetMaploc(void);

    /// original sequence from paper
    /// optional
    /// typedef string TSeq_raw
    ///  Check whether the Seq_raw data member has been assigned a value.
    bool IsSetSeq_raw(void) const;
    /// Check whether it is safe or not to call GetSeq_raw method.
    bool CanGetSeq_raw(void) const;
    void ResetSeq_raw(void);
    const TSeq_raw& GetSeq_raw(void) const;
    void SetSeq_raw(const TSeq_raw& value);
    void SetSeq_raw(TSeq_raw&& value);
    TSeq_raw& SetSeq_raw(void);

    /// this seq aligned with others in paper
    /// optional
    /// typedef int TAlign_group
    ///  Check whether the Align_group data member has been assigned a value.
    bool IsSetAlign_group(void) const;
    /// Check whether it is safe or not to call GetAlign_group method.
    bool CanGetAlign_group(void) const;
    void ResetAlign_group(void);
    TAlign_group GetAlign_group(void) const;
    void SetAlign_group(TAlign_group value);
    TAlign_group& SetAlign_group(void);

    /// any comment on this pub in context
    /// optional
    /// typedef string TComment
    ///  Check whether the Comment data member has been assigned a value.
    bool IsSetComment(void) const;
    /// Check whether it is safe or not to call GetComment method.
    bool CanGetComment(void) const;
    void ResetComment(void);
    const TComment& GetComment(void) const;
    void SetComment(const TComment& value);
    void SetComment(TComment&& value);
    TComment& SetComment(void);

    /// optional with default eReftype_seq
    /// typedef int TReftype
    ///  Check whether the Reftype data member has been assigned a value.
    bool IsSetReftype(void) const;
    /// Check whether it is safe or not to call GetReftype method.
    bool CanGetReftype(void) const;
    void ResetReftype(void);
    void SetDefaultReftype(void);
    TReftype GetReftype(void) const;
    void SetReftype(TReftype value);
    TReftype& SetReftype(void);

    /// Reset the whole object
    virtual void Reset(void);


private:
    // Prohibit copy constructor and assignment operator
    CPubdesc_Base(const CPubdesc_Base&);
    CPubdesc_Base& operator=(const CPubdesc_Base&);

    // data
    Uint4 m_set_State[1];
    CRef< TPub > m_Pub;
    string m_Name;
    string m_Fig;
    CRef< TNum > m_Num;
    bool m_Numexc;
    bool m_Poly_a;
    string m_Maploc;
    string m_Seq_raw;
    int m_Align_group;
    string m_Comment;
    int m_Reftype;
};






///////////////////////////////////////////////////////////
///////////////////// inline methods //////////////////////
///////////////////////////////////////////////////////////
inline
bool CPubdesc_Base::IsSetPub(void) const
{
    return m_Pub.NotEmpty();
}

inline
bool CPubdesc_Base::CanGetPub(void) const
{
    return true;
}

inline
const CPubdesc_Base::TPub& CPubdesc_Base::GetPub(void) const
{
    if ( !m_Pub ) {
        const_cast<CPubdesc_Base*>(this)->ResetPub();
    }
    return (*m_Pub);
}

inline
CPubdesc_Base::TPub& CPubdesc_Base::SetPub(void)
{
    if ( !m_Pub ) {
        ResetPub();
    }
    return (*m_Pub);
}

inline
bool CPubdesc_Base::IsSetName(void) const
{
    return ((m_set_State[0] & 0xc) != 0);
}

inline
bool CPubdesc_Base::CanGetName(void) const
{
    return IsSetName();
}

inline
const CPubdesc_Base::TName& CPubdesc_Base::GetName(void) const
{
    if (!CanGetName()) {
        ThrowUnassigned(1);
    }
    return m_Name;
}

inline
void CPubdesc_Base::SetName(const CPubdesc_Base::TName& value)
{
    m_Name = value;
    m_set_State[0] |= 0xc;
}

inline
void CPubdesc_Base::SetName(CPubdesc_Base::TName&& value)
{
    m_Name = std::forward<CPubdesc_Base::TName>(value);
    m_set_State[0] |= 0xc;
}

inline
CPubdesc_Base::TName& CPubdesc_Base::SetName(void)
{
#ifdef _DEBUG
    if (!IsSetName()) {
        m_Name = UnassignedString();
    }
#endif
    m_set_State[0] |= 0x4;
    return m_Name;
}

inline
bool CPubdesc_Base::IsSetFig(void) const
{
    return ((m_set_State[0] & 0x30) != 0);
}

inline
bool CPubdesc_Base::CanGetFig(void) const
{
    return IsSetFig();
}

inline
const CPubdesc_Base::TFig& CPubdesc_Base::GetFig(void) const
{
    if (!CanGetFig()) {
        ThrowUnassigned(2);
    }
    return m_Fig;
}

inline
void CPubdesc_Base::SetFig(const CPubdesc_Base::TFig& value)
{
    m_Fig = value;
    m_set_State[0] |= 0x30;
}

inline
void CPubdesc_Base::SetFig(CPubdesc_Base::TFig&& value)
{
    m_Fig = std::forward<CPubdesc_Base::TFig>(value);
    m_set_State[0] |= 0x30;
}

inline
CPubdesc_Base::TFig& CPubdesc_Base::SetFig(void)
{
#ifdef _DEBUG
    if (!IsSetFig()) {
        m_Fig = UnassignedString();
    }
#endif
    m_set_State[0] |= 0x10;
    return m_Fig;
}

inline
bool CPubdesc_Base::IsSetNum(void) const
{
    return m_Num.NotEmpty();
}

inline
bool CPubdesc_Base::CanGetNum(void) const
{
    return IsSetNum();
}

inline
const CPubdesc_Base::TNum& CPubdesc_Base::GetNum(void) const
{
    if (!CanGetNum()) {
        ThrowUnassigned(3);
    }
    return (*m_Num);
}

inline
bool CPubdesc_Base::IsSetNumexc(void) const
{
    return ((m_set_State[0] & 0x300) != 0);
}

inline
bool CPubdesc_Base::CanGetNumexc(void) const
{
    return IsSetNumexc();
}

inline
void CPubdesc_Base::ResetNumexc(void)
{
    m_Numexc = 0;
    m_set_State[0] &= ~0x300;
}

inline
CPubdesc_Base::TNumexc CPubdesc_Base::GetNumexc(void) const
{
    if (!CanGetNumexc()) {
        ThrowUnassigned(4);
    }
    return m_Numexc;
}

inline
void CPubdesc_Base::SetNumexc(CPubdesc_Base::TNumexc value)
{
    m_Numexc = value;
    m_set_State[0] |= 0x300;
}

inline
CPubdesc_Base::TNumexc& CPubdesc_Base::SetNumexc(void)
{
#ifdef _DEBUG
    if (!IsSetNumexc()) {
        memset(&m_Numexc,UnassignedByte(),sizeof(m_Numexc));
    }
#endif
    m_set_State[0] |= 0x100;
    return m_Numexc;
}

inline
bool CPubdesc_Base::IsSetPoly_a(void) const
{
    return ((m_set_State[0] & 0xc00) != 0);
}

inline
bool CPubdesc_Base::CanGetPoly_a(void) const
{
    return IsSetPoly_a();
}

inline
void CPubdesc_Base::ResetPoly_a(void)
{
    m_Poly_a = 0;
    m_set_State[0] &= ~0xc00;
}

inline
CPubdesc_Base::TPoly_a CPubdesc_Base::GetPoly_a(void) const
{
    if (!CanGetPoly_a()) {
        ThrowUnassigned(5);
    }
    return m_Poly_a;
}

inline
void CPubdesc_Base::SetPoly_a(CPubdesc_Base::TPoly_a value)
{
    m_Poly_a = value;
    m_set_State[0] |= 0xc00;
}

inline
CPubdesc_Base::TPoly_a& CPubdesc_Base::SetPoly_a(void)
{
#ifdef _DEBUG
    if (!IsSetPoly_a()) {
        memset(&m_Poly_a,UnassignedByte(),sizeof(m_Poly_a));
    }
#endif
    m_set_State[0] |= 0x400;
    return m_Poly_a;
}

inline
bool CPubdesc_Base::IsSetMaploc(void) const
{
    return ((m_set_State[0] & 0x3000) != 0);
}

inline
bool CPubdesc_Base::CanGetMaploc(void) const
{
    return IsSetMaploc();
}

inline
const CPubdesc_Base::TMaploc& CPubdesc_Base::GetMaploc(void) const
{
    if (!CanGetMaploc()) {
        ThrowUnassigned(6);
    }
    return m_Maploc;
}

inline
void CPubdesc_Base::SetMaploc(const CPubdesc_Base::TMaploc& value)
{
    m_Maploc = value;
    m_set_State[0] |= 0x3000;
}

inline
void CPubdesc_Base::SetMaploc(CPubdesc_Base::TMaploc&& value)
{
    m_Maploc = std::forward<CPubdesc_Base::TMaploc>(value);
    m_set_State[0] |= 0x3000;
}

inline
CPubdesc_Base::TMaploc& CPubdesc_Base::SetMaploc(void)
{
#ifdef _DEBUG
    if (!IsSetMaploc()) {
        m_Maploc = UnassignedString();
    }
#endif
    m_set_State[0] |= 0x1000;
    return m_Maploc;
}

inline
bool CPubdesc_Base::IsSetSeq_raw(void) const
{
    return ((m_set_State[0] & 0xc000) != 0);
}

inline
bool CPubdesc_Base::CanGetSeq_raw(void) const
{
    return IsSetSeq_raw();
}

inline
const CPubdesc_Base::TSeq_raw& CPubdesc_Base::GetSeq_raw(void) const
{
    if (!CanGetSeq_raw()) {
        ThrowUnassigned(7);
    }
    return m_Seq_raw;
}

inline
void CPubdesc_Base::SetSeq_raw(const CPubdesc_Base::TSeq_raw& value)
{
    m_Seq_raw = value;
    m_set_State[0] |= 0xc000;
}

inline
void CPubdesc_Base::SetSeq_raw(CPubdesc_Base::TSeq_raw&& value)
{
    m_Seq_raw = std::forward<CPubdesc_Base::TSeq_raw>(value);
    m_set_State[0] |= 0xc000;
}

inline
CPubdesc_Base::TSeq_raw& CPubdesc_Base::SetSeq_raw(void)
{
#ifdef _DEBUG
    if (!IsSetSeq_raw()) {
        m_Seq_raw = UnassignedString();
    }
#endif
    m_set_State[0] |= 0x4000;
    return m_Seq_raw;
}

inline
bool CPubdesc_Base::IsSetAlign_group(void) const
{
    return ((m_set_State[0] & 0x30000) != 0);
}

inline
bool CPubdesc_Base::CanGetAlign_group(void) const
{
    return IsSetAlign_group();
}

inline
void CPubdesc_Base::ResetAlign_group(void)
{
    m_Align_group = 0;
    m_set_State[0] &= ~0x30000;
}

inline
CPubdesc_Base::TAlign_group CPubdesc_Base::GetAlign_group(void) const
{
    if (!CanGetAlign_group()) {
        ThrowUnassigned(8);
    }
    return m_Align_group;
}

inline
void CPubdesc_Base::SetAlign_group(CPubdesc_Base::TAlign_group value)
{
    m_Align_group = value;
    m_set_State[0] |= 0x30000;
}

inline
CPubdesc_Base::TAlign_group& CPubdesc_Base::SetAlign_group(void)
{
#ifdef _DEBUG
    if (!IsSetAlign_group()) {
        memset(&m_Align_group,UnassignedByte(),sizeof(m_Align_group));
    }
#endif
    m_set_State[0] |= 0x10000;
    return m_Align_group;
}

inline
bool CPubdesc_Base::IsSetComment(void) const
{
    return ((m_set_State[0] & 0xc0000) != 0);
}

inline
bool CPubdesc_Base::CanGetComment(void) const
{
    return IsSetComment();
}

inline
const CPubdesc_Base::TComment& CPubdesc_Base::GetComment(void) const
{
    if (!CanGetComment()) {
        ThrowUnassigned(9);
    }
    return m_Comment;
}

inline
void CPubdesc_Base::SetComment(const CPubdesc_Base::TComment& value)
{
    m_Comment = value;
    m_set_State[0] |= 0xc0000;
}

inline
void CPubdesc_Base::SetComment(CPubdesc_Base::TComment&& value)
{
    m_Comment = std::forward<CPubdesc_Base::TComment>(value);
    m_set_State[0] |= 0xc0000;
}

inline
CPubdesc_Base::TComment& CPubdesc_Base::SetComment(void)
{
#ifdef _DEBUG
    if (!IsSetComment()) {
        m_Comment = UnassignedString();
    }
#endif
    m_set_State[0] |= 0x40000;
    return m_Comment;
}

inline
bool CPubdesc_Base::IsSetReftype(void) const
{
    return ((m_set_State[0] & 0x300000) != 0);
}

inline
bool CPubdesc_Base::CanGetReftype(void) const
{
    return true;
}

inline
void CPubdesc_Base::ResetReftype(void)
{
    m_Reftype = eReftype_seq;
    m_set_State[0] &= ~0x300000;
}

inline
void CPubdesc_Base::SetDefaultReftype(void)
{
    ResetReftype();
}

inline
CPubdesc_Base::TReftype CPubdesc_Base::GetReftype(void) const
{
    return m_Reftype;
}

inline
void CPubdesc_Base::SetReftype(CPubdesc_Base::TReftype value)
{
    m_Reftype = value;
    m_set_State[0] |= 0x300000;
}

inline
CPubdesc_Base::TReftype& CPubdesc_Base::SetReftype(void)
{
#ifdef _DEBUG
    if (!IsSetReftype()) {
        memset(&m_Reftype,UnassignedByte(),sizeof(m_Reftype));
    }
#endif
    m_set_State[0] |= 0x100000;
    return m_Reftype;
}

///////////////////////////////////////////////////////////
////////////////// end of inline methods //////////////////
///////////////////////////////////////////////////////////





END_objects_SCOPE // namespace ncbi::objects::

END_NCBI_SCOPE


#endif // OBJECTS_SEQ_PUBDESC_BASE_HPP
