/* $Id$
 * ===========================================================================
 *
 *                            PUBLIC DOMAIN NOTICE
 *               National Center for Biotechnology Information
 *
 *  This software/database is a "United States Government Work" under the
 *  terms of the United States Copyright Act.  It was written as part of
 *  the author's official duties as a United States Government employee and
 *  thus cannot be copyrighted.  This software/database is freely available
 *  to the public for use. The National Library of Medicine and the U.S.
 *  Government have not placed any restriction on its use or reproduction.
 *
 *  Although all reasonable efforts have been taken to ensure the accuracy
 *  and reliability of the software and data, the NLM and the U.S.
 *  Government do not and cannot warrant the performance or results that
 *  may be obtained by using this software or data. The NLM and the U.S.
 *  Government disclaim all warranties, express or implied, including
 *  warranties of performance, merchantability or fitness for any particular
 *  purpose.
 *
 *  Please cite the author in any work or product based on this material.
 *
 * ===========================================================================
 *
 */

/// @file PC_StereoTShape_.hpp
/// Data storage class.
///
/// This file was generated by application DATATOOL
/// using the following specifications:
/// 'pcsubstance.asn'.
///
/// ATTENTION:
///   Don't edit or commit this file into CVS as this file will
///   be overridden (by DATATOOL) without warning!

#ifndef OBJECTS_PCSUBSTANCE_PC_STEREOTSHAPE_BASE_HPP
#define OBJECTS_PCSUBSTANCE_PC_STEREOTSHAPE_BASE_HPP

// standard includes
#include <serial/serialbase.hpp>
BEGIN_NCBI_SCOPE

#ifndef BEGIN_objects_SCOPE
#  define BEGIN_objects_SCOPE BEGIN_SCOPE(objects)
#  define END_objects_SCOPE END_SCOPE(objects)
#endif
BEGIN_objects_SCOPE // namespace ncbi::objects::


// generated classes

/////////////////////////////////////////////////////////////////////////////
/// T-Shaped (TS-3) StereoCenters
///   [Using IUPAC Stereogenic Center recommendations and terminology]
///   [Note: "-1" can be used for the Atom Identifier to represent a lone-pair or implicit hydrogen]
class NCBI_PCSUBSTANCE_EXPORT CPC_StereoTShape_Base : public CSerialObject
{
    typedef CSerialObject Tparent;
public:
    // constructor
    CPC_StereoTShape_Base(void);
    // destructor
    virtual ~CPC_StereoTShape_Base(void);

    // type info
    DECLARE_INTERNAL_TYPE_INFO();

    // types
    typedef int TCenter;
    typedef int TTop;
    typedef int TBottom;
    typedef int TAbove;

    // member index
    enum class E_memberIndex {
        e__allMandatory = 0,
        e_center,
        e_top,
        e_bottom,
        e_above
    };
    typedef Tparent::CMemberIndex<E_memberIndex, 5> TmemberIndex;

    // getters
    // setters

    /// Atom ID of Atom Center
    ///   Note: Atom ID's must be greater than "0"
    /// mandatory
    /// typedef int TCenter
    ///  Check whether the Center data member has been assigned a value.
    bool IsSetCenter(void) const;
    /// Check whether it is safe or not to call GetCenter method.
    bool CanGetCenter(void) const;
    void ResetCenter(void);
    TCenter GetCenter(void) const;
    void SetCenter(TCenter value);
    TCenter& SetCenter(void);

    /// Atom ID of Atom In-Plane and at the Top
    ///   Note: Atom ID's must be greater than "0"
    /// mandatory
    /// typedef int TTop
    ///  Check whether the Top data member has been assigned a value.
    bool IsSetTop(void) const;
    /// Check whether it is safe or not to call GetTop method.
    bool CanGetTop(void) const;
    void ResetTop(void);
    TTop GetTop(void) const;
    void SetTop(TTop value);
    TTop& SetTop(void);

    /// Atom ID of Atom In-Plane and at the Bottom
    ///   Note: Atom ID's must be greater than "0"
    /// mandatory
    /// typedef int TBottom
    ///  Check whether the Bottom data member has been assigned a value.
    bool IsSetBottom(void) const;
    /// Check whether it is safe or not to call GetBottom method.
    bool CanGetBottom(void) const;
    void ResetBottom(void);
    TBottom GetBottom(void) const;
    void SetBottom(TBottom value);
    TBottom& SetBottom(void);

    /// Atom ID of Atom Above the Plane
    ///   Note: Atom ID's must be greater than "0"
    /// mandatory
    /// typedef int TAbove
    ///  Check whether the Above data member has been assigned a value.
    bool IsSetAbove(void) const;
    /// Check whether it is safe or not to call GetAbove method.
    bool CanGetAbove(void) const;
    void ResetAbove(void);
    TAbove GetAbove(void) const;
    void SetAbove(TAbove value);
    TAbove& SetAbove(void);

    /// Reset the whole object
    virtual void Reset(void);


private:
    // Prohibit copy constructor and assignment operator
    CPC_StereoTShape_Base(const CPC_StereoTShape_Base&);
    CPC_StereoTShape_Base& operator=(const CPC_StereoTShape_Base&);

    // data
    Uint4 m_set_State[1];
    int m_Center;
    int m_Top;
    int m_Bottom;
    int m_Above;
};






///////////////////////////////////////////////////////////
///////////////////// inline methods //////////////////////
///////////////////////////////////////////////////////////
inline
bool CPC_StereoTShape_Base::IsSetCenter(void) const
{
    return ((m_set_State[0] & 0x3) != 0);
}

inline
bool CPC_StereoTShape_Base::CanGetCenter(void) const
{
    return IsSetCenter();
}

inline
void CPC_StereoTShape_Base::ResetCenter(void)
{
    m_Center = 0;
    m_set_State[0] &= ~0x3;
}

inline
CPC_StereoTShape_Base::TCenter CPC_StereoTShape_Base::GetCenter(void) const
{
    if (!CanGetCenter()) {
        ThrowUnassigned(0);
    }
    return m_Center;
}

inline
void CPC_StereoTShape_Base::SetCenter(CPC_StereoTShape_Base::TCenter value)
{
    m_Center = value;
    m_set_State[0] |= 0x3;
}

inline
CPC_StereoTShape_Base::TCenter& CPC_StereoTShape_Base::SetCenter(void)
{
#ifdef _DEBUG
    if (!IsSetCenter()) {
        memset(&m_Center,UnassignedByte(),sizeof(m_Center));
    }
#endif
    m_set_State[0] |= 0x1;
    return m_Center;
}

inline
bool CPC_StereoTShape_Base::IsSetTop(void) const
{
    return ((m_set_State[0] & 0xc) != 0);
}

inline
bool CPC_StereoTShape_Base::CanGetTop(void) const
{
    return IsSetTop();
}

inline
void CPC_StereoTShape_Base::ResetTop(void)
{
    m_Top = 0;
    m_set_State[0] &= ~0xc;
}

inline
CPC_StereoTShape_Base::TTop CPC_StereoTShape_Base::GetTop(void) const
{
    if (!CanGetTop()) {
        ThrowUnassigned(1);
    }
    return m_Top;
}

inline
void CPC_StereoTShape_Base::SetTop(CPC_StereoTShape_Base::TTop value)
{
    m_Top = value;
    m_set_State[0] |= 0xc;
}

inline
CPC_StereoTShape_Base::TTop& CPC_StereoTShape_Base::SetTop(void)
{
#ifdef _DEBUG
    if (!IsSetTop()) {
        memset(&m_Top,UnassignedByte(),sizeof(m_Top));
    }
#endif
    m_set_State[0] |= 0x4;
    return m_Top;
}

inline
bool CPC_StereoTShape_Base::IsSetBottom(void) const
{
    return ((m_set_State[0] & 0x30) != 0);
}

inline
bool CPC_StereoTShape_Base::CanGetBottom(void) const
{
    return IsSetBottom();
}

inline
void CPC_StereoTShape_Base::ResetBottom(void)
{
    m_Bottom = 0;
    m_set_State[0] &= ~0x30;
}

inline
CPC_StereoTShape_Base::TBottom CPC_StereoTShape_Base::GetBottom(void) const
{
    if (!CanGetBottom()) {
        ThrowUnassigned(2);
    }
    return m_Bottom;
}

inline
void CPC_StereoTShape_Base::SetBottom(CPC_StereoTShape_Base::TBottom value)
{
    m_Bottom = value;
    m_set_State[0] |= 0x30;
}

inline
CPC_StereoTShape_Base::TBottom& CPC_StereoTShape_Base::SetBottom(void)
{
#ifdef _DEBUG
    if (!IsSetBottom()) {
        memset(&m_Bottom,UnassignedByte(),sizeof(m_Bottom));
    }
#endif
    m_set_State[0] |= 0x10;
    return m_Bottom;
}

inline
bool CPC_StereoTShape_Base::IsSetAbove(void) const
{
    return ((m_set_State[0] & 0xc0) != 0);
}

inline
bool CPC_StereoTShape_Base::CanGetAbove(void) const
{
    return IsSetAbove();
}

inline
void CPC_StereoTShape_Base::ResetAbove(void)
{
    m_Above = 0;
    m_set_State[0] &= ~0xc0;
}

inline
CPC_StereoTShape_Base::TAbove CPC_StereoTShape_Base::GetAbove(void) const
{
    if (!CanGetAbove()) {
        ThrowUnassigned(3);
    }
    return m_Above;
}

inline
void CPC_StereoTShape_Base::SetAbove(CPC_StereoTShape_Base::TAbove value)
{
    m_Above = value;
    m_set_State[0] |= 0xc0;
}

inline
CPC_StereoTShape_Base::TAbove& CPC_StereoTShape_Base::SetAbove(void)
{
#ifdef _DEBUG
    if (!IsSetAbove()) {
        memset(&m_Above,UnassignedByte(),sizeof(m_Above));
    }
#endif
    m_set_State[0] |= 0x40;
    return m_Above;
}

///////////////////////////////////////////////////////////
////////////////// end of inline methods //////////////////
///////////////////////////////////////////////////////////





END_objects_SCOPE // namespace ncbi::objects::

END_NCBI_SCOPE


#endif // OBJECTS_PCSUBSTANCE_PC_STEREOTSHAPE_BASE_HPP
