/* $Id$
 * ===========================================================================
 *
 *                            PUBLIC DOMAIN NOTICE
 *               National Center for Biotechnology Information
 *
 *  This software/database is a "United States Government Work" under the
 *  terms of the United States Copyright Act.  It was written as part of
 *  the author's official duties as a United States Government employee and
 *  thus cannot be copyrighted.  This software/database is freely available
 *  to the public for use. The National Library of Medicine and the U.S.
 *  Government have not placed any restriction on its use or reproduction.
 *
 *  Although all reasonable efforts have been taken to ensure the accuracy
 *  and reliability of the software and data, the NLM and the U.S.
 *  Government do not and cannot warrant the performance or results that
 *  may be obtained by using this software or data. The NLM and the U.S.
 *  Government disclaim all warranties, express or implied, including
 *  warranties of performance, merchantability or fitness for any particular
 *  purpose.
 *
 *  Please cite the author in any work or product based on this material.
 *
 * ===========================================================================
 *
 */

/// @file MSMassSet_.hpp
/// Data storage class.
///
/// This file was generated by application DATATOOL
/// using the following specifications:
/// 'omssa.asn'.
///
/// ATTENTION:
///   Don't edit or commit this file into CVS as this file will
///   be overridden (by DATATOOL) without warning!

#ifndef OBJECTS_OMSSA_MSMASSSET_BASE_HPP
#define OBJECTS_OMSSA_MSMASSSET_BASE_HPP

// standard includes
#include <serial/serialbase.hpp>
BEGIN_NCBI_SCOPE

#ifndef BEGIN_objects_SCOPE
#  define BEGIN_objects_SCOPE BEGIN_SCOPE(objects)
#  define END_objects_SCOPE END_SCOPE(objects)
#endif
BEGIN_objects_SCOPE // namespace ncbi::objects::


// generated classes

/////////////////////////////////////////////////////////////////////////////
/// mass container
class NCBI_OMSSA_EXPORT CMSMassSet_Base : public CSerialObject
{
    typedef CSerialObject Tparent;
public:
    // constructor
    CMSMassSet_Base(void);
    // destructor
    virtual ~CMSMassSet_Base(void);

    // type info
    DECLARE_INTERNAL_TYPE_INFO();

    // types
    typedef double TMonomass;
    typedef double TAveragemass;
    typedef double TN15mass;

    // member index
    enum class E_memberIndex {
        e__allMandatory = 0,
        e_monomass,
        e_averagemass,
        e_n15mass
    };
    typedef Tparent::CMemberIndex<E_memberIndex, 4> TmemberIndex;

    // getters
    // setters

    /// mandatory
    /// typedef double TMonomass
    ///  Check whether the Monomass data member has been assigned a value.
    bool IsSetMonomass(void) const;
    /// Check whether it is safe or not to call GetMonomass method.
    bool CanGetMonomass(void) const;
    void ResetMonomass(void);
    TMonomass GetMonomass(void) const;
    void SetMonomass(TMonomass value);
    TMonomass& SetMonomass(void);

    /// mandatory
    /// typedef double TAveragemass
    ///  Check whether the Averagemass data member has been assigned a value.
    bool IsSetAveragemass(void) const;
    /// Check whether it is safe or not to call GetAveragemass method.
    bool CanGetAveragemass(void) const;
    void ResetAveragemass(void);
    TAveragemass GetAveragemass(void) const;
    void SetAveragemass(TAveragemass value);
    TAveragemass& SetAveragemass(void);

    /// mandatory
    /// typedef double TN15mass
    ///  Check whether the N15mass data member has been assigned a value.
    bool IsSetN15mass(void) const;
    /// Check whether it is safe or not to call GetN15mass method.
    bool CanGetN15mass(void) const;
    void ResetN15mass(void);
    TN15mass GetN15mass(void) const;
    void SetN15mass(TN15mass value);
    TN15mass& SetN15mass(void);

    /// Reset the whole object
    virtual void Reset(void);


private:
    // Prohibit copy constructor and assignment operator
    CMSMassSet_Base(const CMSMassSet_Base&);
    CMSMassSet_Base& operator=(const CMSMassSet_Base&);

    // data
    Uint4 m_set_State[1];
    double m_Monomass;
    double m_Averagemass;
    double m_N15mass;
};






///////////////////////////////////////////////////////////
///////////////////// inline methods //////////////////////
///////////////////////////////////////////////////////////
inline
bool CMSMassSet_Base::IsSetMonomass(void) const
{
    return ((m_set_State[0] & 0x3) != 0);
}

inline
bool CMSMassSet_Base::CanGetMonomass(void) const
{
    return IsSetMonomass();
}

inline
void CMSMassSet_Base::ResetMonomass(void)
{
    m_Monomass = 0;
    m_set_State[0] &= ~0x3;
}

inline
CMSMassSet_Base::TMonomass CMSMassSet_Base::GetMonomass(void) const
{
    if (!CanGetMonomass()) {
        ThrowUnassigned(0);
    }
    return m_Monomass;
}

inline
void CMSMassSet_Base::SetMonomass(CMSMassSet_Base::TMonomass value)
{
    m_Monomass = value;
    m_set_State[0] |= 0x3;
}

inline
CMSMassSet_Base::TMonomass& CMSMassSet_Base::SetMonomass(void)
{
#ifdef _DEBUG
    if (!IsSetMonomass()) {
        memset(&m_Monomass,UnassignedByte(),sizeof(m_Monomass));
    }
#endif
    m_set_State[0] |= 0x1;
    return m_Monomass;
}

inline
bool CMSMassSet_Base::IsSetAveragemass(void) const
{
    return ((m_set_State[0] & 0xc) != 0);
}

inline
bool CMSMassSet_Base::CanGetAveragemass(void) const
{
    return IsSetAveragemass();
}

inline
void CMSMassSet_Base::ResetAveragemass(void)
{
    m_Averagemass = 0;
    m_set_State[0] &= ~0xc;
}

inline
CMSMassSet_Base::TAveragemass CMSMassSet_Base::GetAveragemass(void) const
{
    if (!CanGetAveragemass()) {
        ThrowUnassigned(1);
    }
    return m_Averagemass;
}

inline
void CMSMassSet_Base::SetAveragemass(CMSMassSet_Base::TAveragemass value)
{
    m_Averagemass = value;
    m_set_State[0] |= 0xc;
}

inline
CMSMassSet_Base::TAveragemass& CMSMassSet_Base::SetAveragemass(void)
{
#ifdef _DEBUG
    if (!IsSetAveragemass()) {
        memset(&m_Averagemass,UnassignedByte(),sizeof(m_Averagemass));
    }
#endif
    m_set_State[0] |= 0x4;
    return m_Averagemass;
}

inline
bool CMSMassSet_Base::IsSetN15mass(void) const
{
    return ((m_set_State[0] & 0x30) != 0);
}

inline
bool CMSMassSet_Base::CanGetN15mass(void) const
{
    return IsSetN15mass();
}

inline
void CMSMassSet_Base::ResetN15mass(void)
{
    m_N15mass = 0;
    m_set_State[0] &= ~0x30;
}

inline
CMSMassSet_Base::TN15mass CMSMassSet_Base::GetN15mass(void) const
{
    if (!CanGetN15mass()) {
        ThrowUnassigned(2);
    }
    return m_N15mass;
}

inline
void CMSMassSet_Base::SetN15mass(CMSMassSet_Base::TN15mass value)
{
    m_N15mass = value;
    m_set_State[0] |= 0x30;
}

inline
CMSMassSet_Base::TN15mass& CMSMassSet_Base::SetN15mass(void)
{
#ifdef _DEBUG
    if (!IsSetN15mass()) {
        memset(&m_N15mass,UnassignedByte(),sizeof(m_N15mass));
    }
#endif
    m_set_State[0] |= 0x10;
    return m_N15mass;
}

///////////////////////////////////////////////////////////
////////////////// end of inline methods //////////////////
///////////////////////////////////////////////////////////





END_objects_SCOPE // namespace ncbi::objects::

END_NCBI_SCOPE


#endif // OBJECTS_OMSSA_MSMASSSET_BASE_HPP
