/* $Id$
 * ===========================================================================
 *
 *                            PUBLIC DOMAIN NOTICE
 *               National Center for Biotechnology Information
 *
 *  This software/database is a "United States Government Work" under the
 *  terms of the United States Copyright Act.  It was written as part of
 *  the author's official duties as a United States Government employee and
 *  thus cannot be copyrighted.  This software/database is freely available
 *  to the public for use. The National Library of Medicine and the U.S.
 *  Government have not placed any restriction on its use or reproduction.
 *
 *  Although all reasonable efforts have been taken to ensure the accuracy
 *  and reliability of the software and data, the NLM and the U.S.
 *  Government do not and cannot warrant the performance or results that
 *  may be obtained by using this software or data. The NLM and the U.S.
 *  Government disclaim all warranties, express or implied, including
 *  warranties of performance, merchantability or fitness for any particular
 *  purpose.
 *
 *  Please cite the author in any work or product based on this material.
 *
 * ===========================================================================
 *
 */

/// @file Model_coordinate_set_.hpp
/// Data storage class.
///
/// This file was generated by application DATATOOL
/// using the following specifications:
/// 'mmdb2.asn'.
///
/// ATTENTION:
///   Don't edit or commit this file into CVS as this file will
///   be overridden (by DATATOOL) without warning!

#ifndef OBJECTS_MMDB2_MODEL_COORDINATE_SET_BASE_HPP
#define OBJECTS_MMDB2_MODEL_COORDINATE_SET_BASE_HPP

// standard includes
#include <serial/serialbase.hpp>

// generated includes
#include <list>
#include <objects/mmdb2/Model_coordinate_set_id.hpp>

BEGIN_NCBI_SCOPE

#ifndef BEGIN_objects_SCOPE
#  define BEGIN_objects_SCOPE BEGIN_SCOPE(objects)
#  define END_objects_SCOPE END_SCOPE(objects)
#endif
BEGIN_objects_SCOPE // namespace ncbi::objects::


// forward declarations
class CChem_graph_alignment;
class CCoordinates;
class CModel_descr;


// generated classes

/////////////////////////////////////////////////////////////////////////////
/// Atomic coordinates may be assigned literally or by reference to another
/// biostruc.  The reference coordinate type is used to represent homology-
/// derived model structures.  PDB-derived structures have literal coordinates.
/// Referenced coordinates identify another biostruc, any transformation to be 
/// applied to coordinates from that biostruc, and a mapping of the chemical
/// graph of the present biostruc onto that of the referenced biostruc.  They
/// give an "alignment" of atoms in the current biostruc with those in another,
/// from which the coordinates of matched atoms may be retrieved.  For non-
/// atomic models "alignment" may also be represented by molecule and residue
/// equivalence lists.  Referenced coordinates are a data item inteded for 
/// representation of homology models, with an explicit pointer to their source
/// information. They do not occur in PDB-derived models.
class NCBI_MMDB2_EXPORT CModel_coordinate_set_Base : public CSerialObject
{
    typedef CSerialObject Tparent;
public:
    // constructor
    CModel_coordinate_set_Base(void);
    // destructor
    virtual ~CModel_coordinate_set_Base(void);

    // type info
    DECLARE_INTERNAL_TYPE_INFO();

    /////////////////////////////////////////////////////////////////////////////
    class NCBI_MMDB2_EXPORT C_Coordinates : public CSerialObject
    {
        typedef CSerialObject Tparent;
    public:
        // constructor
        C_Coordinates(void);
        // destructor
        ~C_Coordinates(void);
    
        // type info
        DECLARE_INTERNAL_TYPE_INFO();
    
    
        /// Choice variants.
        enum E_Choice {
            e_not_set = 0,  ///< No variant selected
            e_Literal,
            e_Reference
        };
        /// Maximum+1 value of the choice variant enumerator.
        enum E_ChoiceStopper {
            e_MaxChoice = 3 ///< == e_Reference+1
        };
    
        /// Reset the whole object
        void Reset(void);
    
        /// Reset the selection (set it to e_not_set).
        void ResetSelection(void);
    
        /// Which variant is currently selected.
        E_Choice Which(void) const;
    
        /// Verify selection, throw exception if it differs from the expected.
        void CheckSelected(E_Choice index) const;
    
        /// Throw 'InvalidSelection' exception.
        NCBI_NORETURN void ThrowInvalidSelection(E_Choice index) const;
    
        /// Retrieve selection name (for diagnostic purposes).
        static string SelectionName(E_Choice index);
    
        /// Select the requested variant if needed.
        void Select(E_Choice index, EResetVariant reset = eDoResetVariant);
        /// Select the requested variant if needed,
        /// allocating CObject variants from memory pool.
        void Select(E_Choice index,
                    EResetVariant reset,
                    CObjectMemoryPool* pool);
    
        // types
        typedef CCoordinates TLiteral;
        typedef CChem_graph_alignment TReference;
    
        // getters
        // setters
    
        // typedef CCoordinates TLiteral
        bool IsLiteral(void) const;
        const TLiteral& GetLiteral(void) const;
        TLiteral& SetLiteral(void);
        void SetLiteral(TLiteral& value);
    
        // typedef CChem_graph_alignment TReference
        bool IsReference(void) const;
        const TReference& GetReference(void) const;
        TReference& SetReference(void);
        void SetReference(TReference& value);
    
    
    private:
        // copy constructor and assignment operator
        C_Coordinates(const C_Coordinates& );
        C_Coordinates& operator=(const C_Coordinates& );
        // choice state
        E_Choice m_choice;
        // helper methods
        void DoSelect(E_Choice index, CObjectMemoryPool* pool = 0);
    
        static const char* const sm_SelectionNames[];
        // data
        NCBI_NS_NCBI::CSerialObject *m_object;
    };
    // types
    typedef CModel_coordinate_set_id TId;
    typedef list< CRef< CModel_descr > > TDescr;
    typedef C_Coordinates TCoordinates;

    // member index
    enum class E_memberIndex {
        e__allMandatory = 0,
        e_id,
        e_descr,
        e_coordinates
    };
    typedef Tparent::CMemberIndex<E_memberIndex, 4> TmemberIndex;

    // getters
    // setters

    /// optional
    /// typedef CModel_coordinate_set_id TId
    ///  Check whether the Id data member has been assigned a value.
    bool IsSetId(void) const;
    /// Check whether it is safe or not to call GetId method.
    bool CanGetId(void) const;
    void ResetId(void);
    const TId& GetId(void) const;
    void SetId(const TId& value);
    TId& SetId(void);

    /// optional
    /// typedef list< CRef< CModel_descr > > TDescr
    ///  Check whether the Descr data member has been assigned a value.
    bool IsSetDescr(void) const;
    /// Check whether it is safe or not to call GetDescr method.
    bool CanGetDescr(void) const;
    void ResetDescr(void);
    const TDescr& GetDescr(void) const;
    TDescr& SetDescr(void);

    /// mandatory
    /// typedef C_Coordinates TCoordinates
    ///  Check whether the Coordinates data member has been assigned a value.
    bool IsSetCoordinates(void) const;
    /// Check whether it is safe or not to call GetCoordinates method.
    bool CanGetCoordinates(void) const;
    void ResetCoordinates(void);
    const TCoordinates& GetCoordinates(void) const;
    void SetCoordinates(TCoordinates& value);
    TCoordinates& SetCoordinates(void);

    /// Reset the whole object
    virtual void Reset(void);


private:
    // Prohibit copy constructor and assignment operator
    CModel_coordinate_set_Base(const CModel_coordinate_set_Base&);
    CModel_coordinate_set_Base& operator=(const CModel_coordinate_set_Base&);

    // data
    Uint4 m_set_State[1];
    CModel_coordinate_set_id m_Id;
    list< CRef< CModel_descr > > m_Descr;
    CRef< TCoordinates > m_Coordinates;
};






///////////////////////////////////////////////////////////
///////////////////// inline methods //////////////////////
///////////////////////////////////////////////////////////
inline
CModel_coordinate_set_Base::C_Coordinates::E_Choice CModel_coordinate_set_Base::C_Coordinates::Which(void) const
{
    return m_choice;
}

inline
void CModel_coordinate_set_Base::C_Coordinates::CheckSelected(E_Choice index) const
{
    if ( m_choice != index )
        ThrowInvalidSelection(index);
}

inline
void CModel_coordinate_set_Base::C_Coordinates::Select(E_Choice index, NCBI_NS_NCBI::EResetVariant reset, NCBI_NS_NCBI::CObjectMemoryPool* pool)
{
    if ( reset == NCBI_NS_NCBI::eDoResetVariant || m_choice != index ) {
        if ( m_choice != e_not_set )
            ResetSelection();
        DoSelect(index, pool);
    }
}

inline
void CModel_coordinate_set_Base::C_Coordinates::Select(E_Choice index, NCBI_NS_NCBI::EResetVariant reset)
{
    Select(index, reset, 0);
}

inline
bool CModel_coordinate_set_Base::C_Coordinates::IsLiteral(void) const
{
    return m_choice == e_Literal;
}

inline
bool CModel_coordinate_set_Base::C_Coordinates::IsReference(void) const
{
    return m_choice == e_Reference;
}

inline
bool CModel_coordinate_set_Base::IsSetId(void) const
{
    return ((m_set_State[0] & 0x3) != 0);
}

inline
bool CModel_coordinate_set_Base::CanGetId(void) const
{
    return IsSetId();
}

inline
void CModel_coordinate_set_Base::ResetId(void)
{
    m_Id = CModel_coordinate_set_id(0);
    m_set_State[0] &= ~0x3;
}

inline
const CModel_coordinate_set_Base::TId& CModel_coordinate_set_Base::GetId(void) const
{
    if (!CanGetId()) {
        ThrowUnassigned(0);
    }
    return m_Id;
}

inline
void CModel_coordinate_set_Base::SetId(const CModel_coordinate_set_Base::TId& value)
{
    m_Id = value;
    m_set_State[0] |= 0x3;
}

inline
CModel_coordinate_set_Base::TId& CModel_coordinate_set_Base::SetId(void)
{
    m_set_State[0] |= 0x1;
    return m_Id;
}

inline
bool CModel_coordinate_set_Base::IsSetDescr(void) const
{
    return ((m_set_State[0] & 0xc) != 0);
}

inline
bool CModel_coordinate_set_Base::CanGetDescr(void) const
{
    return true;
}

inline
const CModel_coordinate_set_Base::TDescr& CModel_coordinate_set_Base::GetDescr(void) const
{
    return m_Descr;
}

inline
CModel_coordinate_set_Base::TDescr& CModel_coordinate_set_Base::SetDescr(void)
{
    m_set_State[0] |= 0x4;
    return m_Descr;
}

inline
bool CModel_coordinate_set_Base::IsSetCoordinates(void) const
{
    return m_Coordinates.NotEmpty();
}

inline
bool CModel_coordinate_set_Base::CanGetCoordinates(void) const
{
    return true;
}

inline
const CModel_coordinate_set_Base::TCoordinates& CModel_coordinate_set_Base::GetCoordinates(void) const
{
    if ( !m_Coordinates ) {
        const_cast<CModel_coordinate_set_Base*>(this)->ResetCoordinates();
    }
    return (*m_Coordinates);
}

inline
CModel_coordinate_set_Base::TCoordinates& CModel_coordinate_set_Base::SetCoordinates(void)
{
    if ( !m_Coordinates ) {
        ResetCoordinates();
    }
    return (*m_Coordinates);
}

///////////////////////////////////////////////////////////
////////////////// end of inline methods //////////////////
///////////////////////////////////////////////////////////





END_objects_SCOPE // namespace ncbi::objects::

END_NCBI_SCOPE


#endif // OBJECTS_MMDB2_MODEL_COORDINATE_SET_BASE_HPP
