/* $Id$
 * ===========================================================================
 *
 *                            PUBLIC DOMAIN NOTICE
 *               National Center for Biotechnology Information
 *
 *  This software/database is a "United States Government Work" under the
 *  terms of the United States Copyright Act.  It was written as part of
 *  the author's official duties as a United States Government employee and
 *  thus cannot be copyrighted.  This software/database is freely available
 *  to the public for use. The National Library of Medicine and the U.S.
 *  Government have not placed any restriction on its use or reproduction.
 *
 *  Although all reasonable efforts have been taken to ensure the accuracy
 *  and reliability of the software and data, the NLM and the U.S.
 *  Government do not and cannot warrant the performance or results that
 *  may be obtained by using this software or data. The NLM and the U.S.
 *  Government disclaim all warranties, express or implied, including
 *  warranties of performance, merchantability or fitness for any particular
 *  purpose.
 *
 *  Please cite the author in any work or product based on this material.
 *
 * ===========================================================================
 *
 */

/// @file DocRef_.hpp
/// Data storage class.
///
/// This file was generated by application DATATOOL
/// using the following specifications:
/// 'medline.asn'.
///
/// ATTENTION:
///   Don't edit or commit this file into CVS as this file will
///   be overridden (by DATATOOL) without warning!

#ifndef OBJECTS_MEDLINE_DOCREF_BASE_HPP
#define OBJECTS_MEDLINE_DOCREF_BASE_HPP

// standard includes
#include <serial/serialbase.hpp>
BEGIN_NCBI_SCOPE

#ifndef BEGIN_objects_SCOPE
#  define BEGIN_objects_SCOPE BEGIN_SCOPE(objects)
#  define END_objects_SCOPE END_SCOPE(objects)
#endif
BEGIN_objects_SCOPE // namespace ncbi::objects::


// generated classes

/////////////////////////////////////////////////////////////////////////////
/// reference to a document
class NCBI_MEDLINE_EXPORT CDocRef_Base : public CSerialObject
{
    typedef CSerialObject Tparent;
public:
    // constructor
    CDocRef_Base(void);
    // destructor
    virtual ~CDocRef_Base(void);

    // type info
    DECLARE_INTERNAL_TYPE_INFO();

    enum EType {
        eType_medline = 1,
        eType_pubmed  = 2,
        eType_ncbigi  = 3
    };
    
    /// Access to EType's attributes (values, names) as defined in spec
    static const NCBI_NS_NCBI::CEnumeratedTypeValues* ENUM_METHOD_NAME(EType)(void);
    
    // types
    typedef int TType;
    typedef NCBI_NS_NCBI::TEntrezId TUid;

    // member index
    enum class E_memberIndex {
        e__allMandatory = 0,
        e_type,
        e_uid
    };
    typedef Tparent::CMemberIndex<E_memberIndex, 3> TmemberIndex;

    // getters
    // setters

    /// mandatory
    /// typedef int TType
    ///  Check whether the Type data member has been assigned a value.
    bool IsSetType(void) const;
    /// Check whether it is safe or not to call GetType method.
    bool CanGetType(void) const;
    void ResetType(void);
    TType GetType(void) const;
    void SetType(TType value);
    TType& SetType(void);

    /// mandatory
    /// typedef NCBI_NS_NCBI::TEntrezId TUid
    ///  Check whether the Uid data member has been assigned a value.
    bool IsSetUid(void) const;
    /// Check whether it is safe or not to call GetUid method.
    bool CanGetUid(void) const;
    void ResetUid(void);
    TUid GetUid(void) const;
    void SetUid(TUid value);
    TUid& SetUid(void);

    /// Reset the whole object
    virtual void Reset(void);


private:
    // Prohibit copy constructor and assignment operator
    CDocRef_Base(const CDocRef_Base&);
    CDocRef_Base& operator=(const CDocRef_Base&);

    // data
    Uint4 m_set_State[1];
    int m_Type;
    ncbi::TIntId m_Uid;
};






///////////////////////////////////////////////////////////
///////////////////// inline methods //////////////////////
///////////////////////////////////////////////////////////
inline
bool CDocRef_Base::IsSetType(void) const
{
    return ((m_set_State[0] & 0x3) != 0);
}

inline
bool CDocRef_Base::CanGetType(void) const
{
    return IsSetType();
}

inline
void CDocRef_Base::ResetType(void)
{
    m_Type = (EType)(0);
    m_set_State[0] &= ~0x3;
}

inline
CDocRef_Base::TType CDocRef_Base::GetType(void) const
{
    if (!CanGetType()) {
        ThrowUnassigned(0);
    }
    return m_Type;
}

inline
void CDocRef_Base::SetType(CDocRef_Base::TType value)
{
    m_Type = value;
    m_set_State[0] |= 0x3;
}

inline
CDocRef_Base::TType& CDocRef_Base::SetType(void)
{
#ifdef _DEBUG
    if (!IsSetType()) {
        memset(&m_Type,UnassignedByte(),sizeof(m_Type));
    }
#endif
    m_set_State[0] |= 0x1;
    return m_Type;
}

inline
bool CDocRef_Base::IsSetUid(void) const
{
    return ((m_set_State[0] & 0xc) != 0);
}

inline
bool CDocRef_Base::CanGetUid(void) const
{
    return IsSetUid();
}

inline
void CDocRef_Base::ResetUid(void)
{
    m_Uid = 0;
    m_set_State[0] &= ~0xc;
}

inline
CDocRef_Base::TUid CDocRef_Base::GetUid(void) const
{
    if (!CanGetUid()) {
        ThrowUnassigned(1);
    }
    return reinterpret_cast<const TUid&>(m_Uid);
}

inline
void CDocRef_Base::SetUid(CDocRef_Base::TUid value)
{
    reinterpret_cast<TUid&>(m_Uid) = value;
    m_set_State[0] |= 0xc;
}

inline
CDocRef_Base::TUid& CDocRef_Base::SetUid(void)
{
#ifdef _DEBUG
    if (!IsSetUid()) {
        memset(&m_Uid,UnassignedByte(),sizeof(m_Uid));
    }
#endif
    m_set_State[0] |= 0x4;
    return reinterpret_cast<TUid&>(m_Uid);
}

///////////////////////////////////////////////////////////
////////////////// end of inline methods //////////////////
///////////////////////////////////////////////////////////





END_objects_SCOPE // namespace ncbi::objects::

END_NCBI_SCOPE


#endif // OBJECTS_MEDLINE_DOCREF_BASE_HPP
