/* $Id$
 * ===========================================================================
 *
 *                            PUBLIC DOMAIN NOTICE
 *               National Center for Biotechnology Information
 *
 *  This software/database is a "United States Government Work" under the
 *  terms of the United States Copyright Act.  It was written as part of
 *  the author's official duties as a United States Government employee and
 *  thus cannot be copyrighted.  This software/database is freely available
 *  to the public for use. The National Library of Medicine and the U.S.
 *  Government have not placed any restriction on its use or reproduction.
 *
 *  Although all reasonable efforts have been taken to ensure the accuracy
 *  and reliability of the software and data, the NLM and the U.S.
 *  Government do not and cannot warrant the performance or results that
 *  may be obtained by using this software or data. The NLM and the U.S.
 *  Government disclaim all warranties, express or implied, including
 *  warranties of performance, merchantability or fitness for any particular
 *  purpose.
 *
 *  Please cite the author in any work or product based on this material.
 *
 * ===========================================================================
 *
 */

/// @file Word_substitution_.hpp
/// Data storage class.
///
/// This file was generated by application DATATOOL
/// using the following specifications:
/// 'macro.asn'.
///
/// ATTENTION:
///   Don't edit or commit this file into CVS as this file will
///   be overridden (by DATATOOL) without warning!

#ifndef OBJECTS_MACRO_WORD_SUBSTITUTION_BASE_HPP
#define OBJECTS_MACRO_WORD_SUBSTITUTION_BASE_HPP

// standard includes
#include <serial/serialbase.hpp>

// generated includes
#include <list>
#include <string>

BEGIN_NCBI_SCOPE

#ifndef BEGIN_objects_SCOPE
#  define BEGIN_objects_SCOPE BEGIN_SCOPE(objects)
#  define END_objects_SCOPE END_SCOPE(objects)
#endif
BEGIN_objects_SCOPE // namespace ncbi::objects::


// generated classes

/////////////////////////////////////////////////////////////////////////////
class CWord_substitution_Base : public CSerialObject
{
    typedef CSerialObject Tparent;
public:
    // constructor
    CWord_substitution_Base(void);
    // destructor
    virtual ~CWord_substitution_Base(void);

    // type info
    DECLARE_INTERNAL_TYPE_INFO();

    // types
    typedef string TWord;
    typedef list< string > TSynonyms;
    typedef bool TCase_sensitive;
    typedef bool TWhole_word;

    // member index
    enum class E_memberIndex {
        e__allMandatory = 0,
        e_word,
        e_synonyms,
        e_case_sensitive,
        e_whole_word
    };
    typedef Tparent::CMemberIndex<E_memberIndex, 5> TmemberIndex;

    // getters
    // setters

    /// optional
    /// typedef string TWord
    ///  Check whether the Word data member has been assigned a value.
    bool IsSetWord(void) const;
    /// Check whether it is safe or not to call GetWord method.
    bool CanGetWord(void) const;
    void ResetWord(void);
    const TWord& GetWord(void) const;
    void SetWord(const TWord& value);
    void SetWord(TWord&& value);
    TWord& SetWord(void);

    /// optional
    /// typedef list< string > TSynonyms
    ///  Check whether the Synonyms data member has been assigned a value.
    bool IsSetSynonyms(void) const;
    /// Check whether it is safe or not to call GetSynonyms method.
    bool CanGetSynonyms(void) const;
    void ResetSynonyms(void);
    const TSynonyms& GetSynonyms(void) const;
    TSynonyms& SetSynonyms(void);

    /// optional with default false
    /// typedef bool TCase_sensitive
    ///  Check whether the Case_sensitive data member has been assigned a value.
    bool IsSetCase_sensitive(void) const;
    /// Check whether it is safe or not to call GetCase_sensitive method.
    bool CanGetCase_sensitive(void) const;
    void ResetCase_sensitive(void);
    void SetDefaultCase_sensitive(void);
    TCase_sensitive GetCase_sensitive(void) const;
    void SetCase_sensitive(TCase_sensitive value);
    TCase_sensitive& SetCase_sensitive(void);

    /// optional with default false
    /// typedef bool TWhole_word
    ///  Check whether the Whole_word data member has been assigned a value.
    bool IsSetWhole_word(void) const;
    /// Check whether it is safe or not to call GetWhole_word method.
    bool CanGetWhole_word(void) const;
    void ResetWhole_word(void);
    void SetDefaultWhole_word(void);
    TWhole_word GetWhole_word(void) const;
    void SetWhole_word(TWhole_word value);
    TWhole_word& SetWhole_word(void);

    /// Reset the whole object
    virtual void Reset(void);


private:
    // Prohibit copy constructor and assignment operator
    CWord_substitution_Base(const CWord_substitution_Base&);
    CWord_substitution_Base& operator=(const CWord_substitution_Base&);

    // data
    Uint4 m_set_State[1];
    string m_Word;
    list< string > m_Synonyms;
    bool m_Case_sensitive;
    bool m_Whole_word;
};






///////////////////////////////////////////////////////////
///////////////////// inline methods //////////////////////
///////////////////////////////////////////////////////////
inline
bool CWord_substitution_Base::IsSetWord(void) const
{
    return ((m_set_State[0] & 0x3) != 0);
}

inline
bool CWord_substitution_Base::CanGetWord(void) const
{
    return IsSetWord();
}

inline
const CWord_substitution_Base::TWord& CWord_substitution_Base::GetWord(void) const
{
    if (!CanGetWord()) {
        ThrowUnassigned(0);
    }
    return m_Word;
}

inline
void CWord_substitution_Base::SetWord(const CWord_substitution_Base::TWord& value)
{
    m_Word = value;
    m_set_State[0] |= 0x3;
}

inline
void CWord_substitution_Base::SetWord(CWord_substitution_Base::TWord&& value)
{
    m_Word = std::forward<CWord_substitution_Base::TWord>(value);
    m_set_State[0] |= 0x3;
}

inline
CWord_substitution_Base::TWord& CWord_substitution_Base::SetWord(void)
{
#ifdef _DEBUG
    if (!IsSetWord()) {
        m_Word = UnassignedString();
    }
#endif
    m_set_State[0] |= 0x1;
    return m_Word;
}

inline
bool CWord_substitution_Base::IsSetSynonyms(void) const
{
    return ((m_set_State[0] & 0xc) != 0);
}

inline
bool CWord_substitution_Base::CanGetSynonyms(void) const
{
    return true;
}

inline
const CWord_substitution_Base::TSynonyms& CWord_substitution_Base::GetSynonyms(void) const
{
    return m_Synonyms;
}

inline
CWord_substitution_Base::TSynonyms& CWord_substitution_Base::SetSynonyms(void)
{
    m_set_State[0] |= 0x4;
    return m_Synonyms;
}

inline
bool CWord_substitution_Base::IsSetCase_sensitive(void) const
{
    return ((m_set_State[0] & 0x30) != 0);
}

inline
bool CWord_substitution_Base::CanGetCase_sensitive(void) const
{
    return true;
}

inline
void CWord_substitution_Base::ResetCase_sensitive(void)
{
    m_Case_sensitive = false;
    m_set_State[0] &= ~0x30;
}

inline
void CWord_substitution_Base::SetDefaultCase_sensitive(void)
{
    ResetCase_sensitive();
}

inline
CWord_substitution_Base::TCase_sensitive CWord_substitution_Base::GetCase_sensitive(void) const
{
    return m_Case_sensitive;
}

inline
void CWord_substitution_Base::SetCase_sensitive(CWord_substitution_Base::TCase_sensitive value)
{
    m_Case_sensitive = value;
    m_set_State[0] |= 0x30;
}

inline
CWord_substitution_Base::TCase_sensitive& CWord_substitution_Base::SetCase_sensitive(void)
{
#ifdef _DEBUG
    if (!IsSetCase_sensitive()) {
        memset(&m_Case_sensitive,UnassignedByte(),sizeof(m_Case_sensitive));
    }
#endif
    m_set_State[0] |= 0x10;
    return m_Case_sensitive;
}

inline
bool CWord_substitution_Base::IsSetWhole_word(void) const
{
    return ((m_set_State[0] & 0xc0) != 0);
}

inline
bool CWord_substitution_Base::CanGetWhole_word(void) const
{
    return true;
}

inline
void CWord_substitution_Base::ResetWhole_word(void)
{
    m_Whole_word = false;
    m_set_State[0] &= ~0xc0;
}

inline
void CWord_substitution_Base::SetDefaultWhole_word(void)
{
    ResetWhole_word();
}

inline
CWord_substitution_Base::TWhole_word CWord_substitution_Base::GetWhole_word(void) const
{
    return m_Whole_word;
}

inline
void CWord_substitution_Base::SetWhole_word(CWord_substitution_Base::TWhole_word value)
{
    m_Whole_word = value;
    m_set_State[0] |= 0xc0;
}

inline
CWord_substitution_Base::TWhole_word& CWord_substitution_Base::SetWhole_word(void)
{
#ifdef _DEBUG
    if (!IsSetWhole_word()) {
        memset(&m_Whole_word,UnassignedByte(),sizeof(m_Whole_word));
    }
#endif
    m_set_State[0] |= 0x40;
    return m_Whole_word;
}

///////////////////////////////////////////////////////////
////////////////// end of inline methods //////////////////
///////////////////////////////////////////////////////////





END_objects_SCOPE // namespace ncbi::objects::

END_NCBI_SCOPE


#endif // OBJECTS_MACRO_WORD_SUBSTITUTION_BASE_HPP
