/* $Id$
 * ===========================================================================
 *
 *                            PUBLIC DOMAIN NOTICE
 *               National Center for Biotechnology Information
 *
 *  This software/database is a "United States Government Work" under the
 *  terms of the United States Copyright Act.  It was written as part of
 *  the author's official duties as a United States Government employee and
 *  thus cannot be copyrighted.  This software/database is freely available
 *  to the public for use. The National Library of Medicine and the U.S.
 *  Government have not placed any restriction on its use or reproduction.
 *
 *  Although all reasonable efforts have been taken to ensure the accuracy
 *  and reliability of the software and data, the NLM and the U.S.
 *  Government do not and cannot warrant the performance or results that
 *  may be obtained by using this software or data. The NLM and the U.S.
 *  Government disclaim all warranties, express or implied, including
 *  warranties of performance, merchantability or fitness for any particular
 *  purpose.
 *
 *  Please cite the author in any work or product based on this material.
 *
 * ===========================================================================
 *
 */

/// @file Table_match_type_.hpp
/// Data storage class.
///
/// This file was generated by application DATATOOL
/// using the following specifications:
/// 'macro.asn'.
///
/// ATTENTION:
///   Don't edit or commit this file into CVS as this file will
///   be overridden (by DATATOOL) without warning!

#ifndef OBJECTS_MACRO_TABLE_MATCH_TYPE_BASE_HPP
#define OBJECTS_MACRO_TABLE_MATCH_TYPE_BASE_HPP

// standard includes
#include <serial/serialbase.hpp>
BEGIN_NCBI_SCOPE

#ifndef BEGIN_objects_SCOPE
#  define BEGIN_objects_SCOPE BEGIN_SCOPE(objects)
#  define END_objects_SCOPE END_SCOPE(objects)
#endif
BEGIN_objects_SCOPE // namespace ncbi::objects::


// forward declarations
class CSource_qual_choice;


// generated classes

/////////////////////////////////////////////////////////////////////////////
class CTable_match_type_Base : public CSerialObject
{
    typedef CSerialObject Tparent;
public:
    // constructor
    CTable_match_type_Base(void);
    // destructor
    virtual ~CTable_match_type_Base(void);

    // type info
    DECLARE_INTERNAL_TYPE_INFO();


    /// Choice variants.
    enum E_Choice {
        e_not_set = 0,     ///< No variant selected
        e_Feature_id,
        e_Gene_locus_tag,
        e_Protein_id,
        e_Dbxref,
        e_Nuc_id,
        e_Src_qual,
        e_Protein_name,
        e_Bioproject,
        e_Any
    };
    /// Maximum+1 value of the choice variant enumerator.
    enum E_ChoiceStopper {
        e_MaxChoice = 10 ///< == e_Any+1
    };

    /// Reset the whole object
    virtual void Reset(void);

    /// Reset the selection (set it to e_not_set).
    virtual void ResetSelection(void);

    /// Which variant is currently selected.
    E_Choice Which(void) const;

    /// Verify selection, throw exception if it differs from the expected.
    void CheckSelected(E_Choice index) const;

    /// Throw 'InvalidSelection' exception.
    NCBI_NORETURN void ThrowInvalidSelection(E_Choice index) const;

    /// Retrieve selection name (for diagnostic purposes).
    static string SelectionName(E_Choice index);

    /// Select the requested variant if needed.
    void Select(E_Choice index, EResetVariant reset = eDoResetVariant);
    /// Select the requested variant if needed,
    /// allocating CObject variants from memory pool.
    void Select(E_Choice index,
                EResetVariant reset,
                CObjectMemoryPool* pool);

    // types
    typedef CSource_qual_choice TSrc_qual;

    // getters
    // setters


    bool IsFeature_id(void) const;
    void SetFeature_id(void);


    bool IsGene_locus_tag(void) const;
    void SetGene_locus_tag(void);


    bool IsProtein_id(void) const;
    void SetProtein_id(void);


    bool IsDbxref(void) const;
    void SetDbxref(void);


    bool IsNuc_id(void) const;
    void SetNuc_id(void);

    // typedef CSource_qual_choice TSrc_qual
    bool IsSrc_qual(void) const;
    const TSrc_qual& GetSrc_qual(void) const;
    TSrc_qual& SetSrc_qual(void);
    void SetSrc_qual(TSrc_qual& value);


    bool IsProtein_name(void) const;
    void SetProtein_name(void);


    bool IsBioproject(void) const;
    void SetBioproject(void);


    bool IsAny(void) const;
    void SetAny(void);


private:
    // copy constructor and assignment operator
    CTable_match_type_Base(const CTable_match_type_Base& );
    CTable_match_type_Base& operator=(const CTable_match_type_Base& );
    // choice state
    E_Choice m_choice;
    // helper methods
    void DoSelect(E_Choice index, CObjectMemoryPool* pool = 0);

    static const char* const sm_SelectionNames[];
    // data
    union {
        NCBI_NS_NCBI::CSerialObject *m_object;
    };
};






///////////////////////////////////////////////////////////
///////////////////// inline methods //////////////////////
///////////////////////////////////////////////////////////
inline
CTable_match_type_Base::E_Choice CTable_match_type_Base::Which(void) const
{
    return m_choice;
}

inline
void CTable_match_type_Base::CheckSelected(E_Choice index) const
{
    if ( m_choice != index )
        ThrowInvalidSelection(index);
}

inline
void CTable_match_type_Base::Select(E_Choice index, NCBI_NS_NCBI::EResetVariant reset, NCBI_NS_NCBI::CObjectMemoryPool* pool)
{
    if ( reset == NCBI_NS_NCBI::eDoResetVariant || m_choice != index ) {
        if ( m_choice != e_not_set )
            ResetSelection();
        DoSelect(index, pool);
    }
}

inline
void CTable_match_type_Base::Select(E_Choice index, NCBI_NS_NCBI::EResetVariant reset)
{
    Select(index, reset, 0);
}

inline
bool CTable_match_type_Base::IsFeature_id(void) const
{
    return m_choice == e_Feature_id;
}

inline
void CTable_match_type_Base::SetFeature_id(void)
{
    Select(e_Feature_id, NCBI_NS_NCBI::eDoNotResetVariant);
}

inline
bool CTable_match_type_Base::IsGene_locus_tag(void) const
{
    return m_choice == e_Gene_locus_tag;
}

inline
void CTable_match_type_Base::SetGene_locus_tag(void)
{
    Select(e_Gene_locus_tag, NCBI_NS_NCBI::eDoNotResetVariant);
}

inline
bool CTable_match_type_Base::IsProtein_id(void) const
{
    return m_choice == e_Protein_id;
}

inline
void CTable_match_type_Base::SetProtein_id(void)
{
    Select(e_Protein_id, NCBI_NS_NCBI::eDoNotResetVariant);
}

inline
bool CTable_match_type_Base::IsDbxref(void) const
{
    return m_choice == e_Dbxref;
}

inline
void CTable_match_type_Base::SetDbxref(void)
{
    Select(e_Dbxref, NCBI_NS_NCBI::eDoNotResetVariant);
}

inline
bool CTable_match_type_Base::IsNuc_id(void) const
{
    return m_choice == e_Nuc_id;
}

inline
void CTable_match_type_Base::SetNuc_id(void)
{
    Select(e_Nuc_id, NCBI_NS_NCBI::eDoNotResetVariant);
}

inline
bool CTable_match_type_Base::IsSrc_qual(void) const
{
    return m_choice == e_Src_qual;
}

inline
bool CTable_match_type_Base::IsProtein_name(void) const
{
    return m_choice == e_Protein_name;
}

inline
void CTable_match_type_Base::SetProtein_name(void)
{
    Select(e_Protein_name, NCBI_NS_NCBI::eDoNotResetVariant);
}

inline
bool CTable_match_type_Base::IsBioproject(void) const
{
    return m_choice == e_Bioproject;
}

inline
void CTable_match_type_Base::SetBioproject(void)
{
    Select(e_Bioproject, NCBI_NS_NCBI::eDoNotResetVariant);
}

inline
bool CTable_match_type_Base::IsAny(void) const
{
    return m_choice == e_Any;
}

inline
void CTable_match_type_Base::SetAny(void)
{
    Select(e_Any, NCBI_NS_NCBI::eDoNotResetVariant);
}

///////////////////////////////////////////////////////////
////////////////// end of inline methods //////////////////
///////////////////////////////////////////////////////////





END_objects_SCOPE // namespace ncbi::objects::

END_NCBI_SCOPE


#endif // OBJECTS_MACRO_TABLE_MATCH_TYPE_BASE_HPP
