/* $Id$
 * ===========================================================================
 *
 *                            PUBLIC DOMAIN NOTICE
 *               National Center for Biotechnology Information
 *
 *  This software/database is a "United States Government Work" under the
 *  terms of the United States Copyright Act.  It was written as part of
 *  the author's official duties as a United States Government employee and
 *  thus cannot be copyrighted.  This software/database is freely available
 *  to the public for use. The National Library of Medicine and the U.S.
 *  Government have not placed any restriction on its use or reproduction.
 *
 *  Although all reasonable efforts have been taken to ensure the accuracy
 *  and reliability of the software and data, the NLM and the U.S.
 *  Government do not and cannot warrant the performance or results that
 *  may be obtained by using this software or data. The NLM and the U.S.
 *  Government disclaim all warranties, express or implied, including
 *  warranties of performance, merchantability or fitness for any particular
 *  purpose.
 *
 *  Please cite the author in any work or product based on this material.
 *
 * ===========================================================================
 *
 */

/// @file Remov_duplic_featur_action_.hpp
/// Data storage class.
///
/// This file was generated by application DATATOOL
/// using the following specifications:
/// 'macro.asn'.
///
/// ATTENTION:
///   Don't edit or commit this file into CVS as this file will
///   be overridden (by DATATOOL) without warning!

#ifndef OBJECTS_MACRO_REMOV_DUPLIC_FEATUR_ACTION_BASE_HPP
#define OBJECTS_MACRO_REMOV_DUPLIC_FEATUR_ACTION_BASE_HPP

// standard includes
#include <serial/serialbase.hpp>

// generated includes
#include <objects/macro/Macro_feature_type.hpp>

BEGIN_NCBI_SCOPE

#ifndef BEGIN_objects_SCOPE
#  define BEGIN_objects_SCOPE BEGIN_SCOPE(objects)
#  define END_objects_SCOPE END_SCOPE(objects)
#endif
BEGIN_objects_SCOPE // namespace ncbi::objects::


// forward declarations
class CConstraint_choice_set;


// generated classes

/////////////////////////////////////////////////////////////////////////////
class CRemove_duplicate_feature_action_Base : public CSerialObject
{
    typedef CSerialObject Tparent;
public:
    // constructor
    CRemove_duplicate_feature_action_Base(void);
    // destructor
    virtual ~CRemove_duplicate_feature_action_Base(void);

    // type info
    DECLARE_INTERNAL_TYPE_INFO();

    // types
    typedef EMacro_feature_type TType;
    typedef bool TIgnore_partials;
    typedef bool TCase_sensitive;
    typedef bool TRemove_proteins;
    typedef CConstraint_choice_set TRd_constraint;

    // member index
    enum class E_memberIndex {
        e__allMandatory = 0,
        e_type,
        e_ignore_partials,
        e_case_sensitive,
        e_remove_proteins,
        e_rd_constraint
    };
    typedef Tparent::CMemberIndex<E_memberIndex, 6> TmemberIndex;

    // getters
    // setters

    /// mandatory
    /// typedef EMacro_feature_type TType
    ///  Check whether the Type data member has been assigned a value.
    bool IsSetType(void) const;
    /// Check whether it is safe or not to call GetType method.
    bool CanGetType(void) const;
    void ResetType(void);
    TType GetType(void) const;
    void SetType(TType value);
    TType& SetType(void);

    /// mandatory
    /// typedef bool TIgnore_partials
    ///  Check whether the Ignore_partials data member has been assigned a value.
    bool IsSetIgnore_partials(void) const;
    /// Check whether it is safe or not to call GetIgnore_partials method.
    bool CanGetIgnore_partials(void) const;
    void ResetIgnore_partials(void);
    TIgnore_partials GetIgnore_partials(void) const;
    void SetIgnore_partials(TIgnore_partials value);
    TIgnore_partials& SetIgnore_partials(void);

    /// mandatory
    /// typedef bool TCase_sensitive
    ///  Check whether the Case_sensitive data member has been assigned a value.
    bool IsSetCase_sensitive(void) const;
    /// Check whether it is safe or not to call GetCase_sensitive method.
    bool CanGetCase_sensitive(void) const;
    void ResetCase_sensitive(void);
    TCase_sensitive GetCase_sensitive(void) const;
    void SetCase_sensitive(TCase_sensitive value);
    TCase_sensitive& SetCase_sensitive(void);

    /// mandatory
    /// typedef bool TRemove_proteins
    ///  Check whether the Remove_proteins data member has been assigned a value.
    bool IsSetRemove_proteins(void) const;
    /// Check whether it is safe or not to call GetRemove_proteins method.
    bool CanGetRemove_proteins(void) const;
    void ResetRemove_proteins(void);
    TRemove_proteins GetRemove_proteins(void) const;
    void SetRemove_proteins(TRemove_proteins value);
    TRemove_proteins& SetRemove_proteins(void);

    /// optional
    /// typedef CConstraint_choice_set TRd_constraint
    ///  Check whether the Rd_constraint data member has been assigned a value.
    bool IsSetRd_constraint(void) const;
    /// Check whether it is safe or not to call GetRd_constraint method.
    bool CanGetRd_constraint(void) const;
    void ResetRd_constraint(void);
    const TRd_constraint& GetRd_constraint(void) const;
    void SetRd_constraint(TRd_constraint& value);
    TRd_constraint& SetRd_constraint(void);

    /// Reset the whole object
    virtual void Reset(void);


private:
    // Prohibit copy constructor and assignment operator
    CRemove_duplicate_feature_action_Base(const CRemove_duplicate_feature_action_Base&);
    CRemove_duplicate_feature_action_Base& operator=(const CRemove_duplicate_feature_action_Base&);

    // data
    Uint4 m_set_State[1];
    EMacro_feature_type m_Type;
    bool m_Ignore_partials;
    bool m_Case_sensitive;
    bool m_Remove_proteins;
    CRef< TRd_constraint > m_Rd_constraint;
};






///////////////////////////////////////////////////////////
///////////////////// inline methods //////////////////////
///////////////////////////////////////////////////////////
inline
bool CRemove_duplicate_feature_action_Base::IsSetType(void) const
{
    return ((m_set_State[0] & 0x3) != 0);
}

inline
bool CRemove_duplicate_feature_action_Base::CanGetType(void) const
{
    return IsSetType();
}

inline
void CRemove_duplicate_feature_action_Base::ResetType(void)
{
    m_Type = (ncbi::objects::EMacro_feature_type)(0);
    m_set_State[0] &= ~0x3;
}

inline
CRemove_duplicate_feature_action_Base::TType CRemove_duplicate_feature_action_Base::GetType(void) const
{
    if (!CanGetType()) {
        ThrowUnassigned(0);
    }
    return m_Type;
}

inline
void CRemove_duplicate_feature_action_Base::SetType(CRemove_duplicate_feature_action_Base::TType value)
{
    m_Type = value;
    m_set_State[0] |= 0x3;
}

inline
CRemove_duplicate_feature_action_Base::TType& CRemove_duplicate_feature_action_Base::SetType(void)
{
#ifdef _DEBUG
    if (!IsSetType()) {
        memset(&m_Type,UnassignedByte(),sizeof(m_Type));
    }
#endif
    m_set_State[0] |= 0x1;
    return m_Type;
}

inline
bool CRemove_duplicate_feature_action_Base::IsSetIgnore_partials(void) const
{
    return ((m_set_State[0] & 0xc) != 0);
}

inline
bool CRemove_duplicate_feature_action_Base::CanGetIgnore_partials(void) const
{
    return IsSetIgnore_partials();
}

inline
void CRemove_duplicate_feature_action_Base::ResetIgnore_partials(void)
{
    m_Ignore_partials = 0;
    m_set_State[0] &= ~0xc;
}

inline
CRemove_duplicate_feature_action_Base::TIgnore_partials CRemove_duplicate_feature_action_Base::GetIgnore_partials(void) const
{
    if (!CanGetIgnore_partials()) {
        ThrowUnassigned(1);
    }
    return m_Ignore_partials;
}

inline
void CRemove_duplicate_feature_action_Base::SetIgnore_partials(CRemove_duplicate_feature_action_Base::TIgnore_partials value)
{
    m_Ignore_partials = value;
    m_set_State[0] |= 0xc;
}

inline
CRemove_duplicate_feature_action_Base::TIgnore_partials& CRemove_duplicate_feature_action_Base::SetIgnore_partials(void)
{
#ifdef _DEBUG
    if (!IsSetIgnore_partials()) {
        memset(&m_Ignore_partials,UnassignedByte(),sizeof(m_Ignore_partials));
    }
#endif
    m_set_State[0] |= 0x4;
    return m_Ignore_partials;
}

inline
bool CRemove_duplicate_feature_action_Base::IsSetCase_sensitive(void) const
{
    return ((m_set_State[0] & 0x30) != 0);
}

inline
bool CRemove_duplicate_feature_action_Base::CanGetCase_sensitive(void) const
{
    return IsSetCase_sensitive();
}

inline
void CRemove_duplicate_feature_action_Base::ResetCase_sensitive(void)
{
    m_Case_sensitive = 0;
    m_set_State[0] &= ~0x30;
}

inline
CRemove_duplicate_feature_action_Base::TCase_sensitive CRemove_duplicate_feature_action_Base::GetCase_sensitive(void) const
{
    if (!CanGetCase_sensitive()) {
        ThrowUnassigned(2);
    }
    return m_Case_sensitive;
}

inline
void CRemove_duplicate_feature_action_Base::SetCase_sensitive(CRemove_duplicate_feature_action_Base::TCase_sensitive value)
{
    m_Case_sensitive = value;
    m_set_State[0] |= 0x30;
}

inline
CRemove_duplicate_feature_action_Base::TCase_sensitive& CRemove_duplicate_feature_action_Base::SetCase_sensitive(void)
{
#ifdef _DEBUG
    if (!IsSetCase_sensitive()) {
        memset(&m_Case_sensitive,UnassignedByte(),sizeof(m_Case_sensitive));
    }
#endif
    m_set_State[0] |= 0x10;
    return m_Case_sensitive;
}

inline
bool CRemove_duplicate_feature_action_Base::IsSetRemove_proteins(void) const
{
    return ((m_set_State[0] & 0xc0) != 0);
}

inline
bool CRemove_duplicate_feature_action_Base::CanGetRemove_proteins(void) const
{
    return IsSetRemove_proteins();
}

inline
void CRemove_duplicate_feature_action_Base::ResetRemove_proteins(void)
{
    m_Remove_proteins = 0;
    m_set_State[0] &= ~0xc0;
}

inline
CRemove_duplicate_feature_action_Base::TRemove_proteins CRemove_duplicate_feature_action_Base::GetRemove_proteins(void) const
{
    if (!CanGetRemove_proteins()) {
        ThrowUnassigned(3);
    }
    return m_Remove_proteins;
}

inline
void CRemove_duplicate_feature_action_Base::SetRemove_proteins(CRemove_duplicate_feature_action_Base::TRemove_proteins value)
{
    m_Remove_proteins = value;
    m_set_State[0] |= 0xc0;
}

inline
CRemove_duplicate_feature_action_Base::TRemove_proteins& CRemove_duplicate_feature_action_Base::SetRemove_proteins(void)
{
#ifdef _DEBUG
    if (!IsSetRemove_proteins()) {
        memset(&m_Remove_proteins,UnassignedByte(),sizeof(m_Remove_proteins));
    }
#endif
    m_set_State[0] |= 0x40;
    return m_Remove_proteins;
}

inline
bool CRemove_duplicate_feature_action_Base::IsSetRd_constraint(void) const
{
    return m_Rd_constraint.NotEmpty();
}

inline
bool CRemove_duplicate_feature_action_Base::CanGetRd_constraint(void) const
{
    return IsSetRd_constraint();
}

inline
const CRemove_duplicate_feature_action_Base::TRd_constraint& CRemove_duplicate_feature_action_Base::GetRd_constraint(void) const
{
    if (!CanGetRd_constraint()) {
        ThrowUnassigned(4);
    }
    return (*m_Rd_constraint);
}

///////////////////////////////////////////////////////////
////////////////// end of inline methods //////////////////
///////////////////////////////////////////////////////////





END_objects_SCOPE // namespace ncbi::objects::

END_NCBI_SCOPE


#endif // OBJECTS_MACRO_REMOV_DUPLIC_FEATUR_ACTION_BASE_HPP
