/* $Id$
 * ===========================================================================
 *
 *                            PUBLIC DOMAIN NOTICE
 *               National Center for Biotechnology Information
 *
 *  This software/database is a "United States Government Work" under the
 *  terms of the United States Copyright Act.  It was written as part of
 *  the author's official duties as a United States Government employee and
 *  thus cannot be copyrighted.  This software/database is freely available
 *  to the public for use. The National Library of Medicine and the U.S.
 *  Government have not placed any restriction on its use or reproduction.
 *
 *  Although all reasonable efforts have been taken to ensure the accuracy
 *  and reliability of the software and data, the NLM and the U.S.
 *  Government do not and cannot warrant the performance or results that
 *  may be obtained by using this software or data. The NLM and the U.S.
 *  Government disclaim all warranties, express or implied, including
 *  warranties of performance, merchantability or fitness for any particular
 *  purpose.
 *
 *  Please cite the author in any work or product based on this material.
 *
 * ===========================================================================
 *
 */

/// @file Apply_table_action_.hpp
/// Data storage class.
///
/// This file was generated by application DATATOOL
/// using the following specifications:
/// 'macro.asn'.
///
/// ATTENTION:
///   Don't edit or commit this file into CVS as this file will
///   be overridden (by DATATOOL) without warning!

#ifndef OBJECTS_MACRO_APPLY_TABLE_ACTION_BASE_HPP
#define OBJECTS_MACRO_APPLY_TABLE_ACTION_BASE_HPP

// standard includes
#include <serial/serialbase.hpp>

// generated includes
#include <string>

BEGIN_NCBI_SCOPE

#ifndef BEGIN_objects_SCOPE
#  define BEGIN_objects_SCOPE BEGIN_SCOPE(objects)
#  define END_objects_SCOPE END_SCOPE(objects)
#endif
BEGIN_objects_SCOPE // namespace ncbi::objects::


// forward declarations
class CApply_table_extra_data;
class CTable_match;


// generated classes

/////////////////////////////////////////////////////////////////////////////
class CApply_table_action_Base : public CSerialObject
{
    typedef CSerialObject Tparent;
public:
    // constructor
    CApply_table_action_Base(void);
    // destructor
    virtual ~CApply_table_action_Base(void);

    // type info
    DECLARE_INTERNAL_TYPE_INFO();

    // types
    typedef string TFilename;
    typedef CTable_match TMatch_type;
    typedef CApply_table_extra_data TIn_memory_table;
    typedef bool TAlso_change_mrna;
    typedef bool TSkip_blanks;

    // member index
    enum class E_memberIndex {
        e__allMandatory = 0,
        e_filename,
        e_match_type,
        e_in_memory_table,
        e_also_change_mrna,
        e_skip_blanks
    };
    typedef Tparent::CMemberIndex<E_memberIndex, 6> TmemberIndex;

    // getters
    // setters

    /// mandatory
    /// typedef string TFilename
    ///  Check whether the Filename data member has been assigned a value.
    bool IsSetFilename(void) const;
    /// Check whether it is safe or not to call GetFilename method.
    bool CanGetFilename(void) const;
    void ResetFilename(void);
    const TFilename& GetFilename(void) const;
    void SetFilename(const TFilename& value);
    void SetFilename(TFilename&& value);
    TFilename& SetFilename(void);

    /// mandatory
    /// typedef CTable_match TMatch_type
    ///  Check whether the Match_type data member has been assigned a value.
    bool IsSetMatch_type(void) const;
    /// Check whether it is safe or not to call GetMatch_type method.
    bool CanGetMatch_type(void) const;
    void ResetMatch_type(void);
    const TMatch_type& GetMatch_type(void) const;
    void SetMatch_type(TMatch_type& value);
    TMatch_type& SetMatch_type(void);

    /// optional
    /// typedef CApply_table_extra_data TIn_memory_table
    ///  Check whether the In_memory_table data member has been assigned a value.
    bool IsSetIn_memory_table(void) const;
    /// Check whether it is safe or not to call GetIn_memory_table method.
    bool CanGetIn_memory_table(void) const;
    void ResetIn_memory_table(void);
    const TIn_memory_table& GetIn_memory_table(void) const;
    void SetIn_memory_table(TIn_memory_table& value);
    TIn_memory_table& SetIn_memory_table(void);

    /// optional with default false
    /// typedef bool TAlso_change_mrna
    ///  Check whether the Also_change_mrna data member has been assigned a value.
    bool IsSetAlso_change_mrna(void) const;
    /// Check whether it is safe or not to call GetAlso_change_mrna method.
    bool CanGetAlso_change_mrna(void) const;
    void ResetAlso_change_mrna(void);
    void SetDefaultAlso_change_mrna(void);
    TAlso_change_mrna GetAlso_change_mrna(void) const;
    void SetAlso_change_mrna(TAlso_change_mrna value);
    TAlso_change_mrna& SetAlso_change_mrna(void);

    /// optional with default true
    /// typedef bool TSkip_blanks
    ///  Check whether the Skip_blanks data member has been assigned a value.
    bool IsSetSkip_blanks(void) const;
    /// Check whether it is safe or not to call GetSkip_blanks method.
    bool CanGetSkip_blanks(void) const;
    void ResetSkip_blanks(void);
    void SetDefaultSkip_blanks(void);
    TSkip_blanks GetSkip_blanks(void) const;
    void SetSkip_blanks(TSkip_blanks value);
    TSkip_blanks& SetSkip_blanks(void);

    /// Reset the whole object
    virtual void Reset(void);


private:
    // Prohibit copy constructor and assignment operator
    CApply_table_action_Base(const CApply_table_action_Base&);
    CApply_table_action_Base& operator=(const CApply_table_action_Base&);

    // data
    Uint4 m_set_State[1];
    string m_Filename;
    CRef< TMatch_type > m_Match_type;
    CRef< TIn_memory_table > m_In_memory_table;
    bool m_Also_change_mrna;
    bool m_Skip_blanks;
};






///////////////////////////////////////////////////////////
///////////////////// inline methods //////////////////////
///////////////////////////////////////////////////////////
inline
bool CApply_table_action_Base::IsSetFilename(void) const
{
    return ((m_set_State[0] & 0x3) != 0);
}

inline
bool CApply_table_action_Base::CanGetFilename(void) const
{
    return IsSetFilename();
}

inline
const CApply_table_action_Base::TFilename& CApply_table_action_Base::GetFilename(void) const
{
    if (!CanGetFilename()) {
        ThrowUnassigned(0);
    }
    return m_Filename;
}

inline
void CApply_table_action_Base::SetFilename(const CApply_table_action_Base::TFilename& value)
{
    m_Filename = value;
    m_set_State[0] |= 0x3;
}

inline
void CApply_table_action_Base::SetFilename(CApply_table_action_Base::TFilename&& value)
{
    m_Filename = std::forward<CApply_table_action_Base::TFilename>(value);
    m_set_State[0] |= 0x3;
}

inline
CApply_table_action_Base::TFilename& CApply_table_action_Base::SetFilename(void)
{
#ifdef _DEBUG
    if (!IsSetFilename()) {
        m_Filename = UnassignedString();
    }
#endif
    m_set_State[0] |= 0x1;
    return m_Filename;
}

inline
bool CApply_table_action_Base::IsSetMatch_type(void) const
{
    return m_Match_type.NotEmpty();
}

inline
bool CApply_table_action_Base::CanGetMatch_type(void) const
{
    return true;
}

inline
const CApply_table_action_Base::TMatch_type& CApply_table_action_Base::GetMatch_type(void) const
{
    if ( !m_Match_type ) {
        const_cast<CApply_table_action_Base*>(this)->ResetMatch_type();
    }
    return (*m_Match_type);
}

inline
CApply_table_action_Base::TMatch_type& CApply_table_action_Base::SetMatch_type(void)
{
    if ( !m_Match_type ) {
        ResetMatch_type();
    }
    return (*m_Match_type);
}

inline
bool CApply_table_action_Base::IsSetIn_memory_table(void) const
{
    return m_In_memory_table.NotEmpty();
}

inline
bool CApply_table_action_Base::CanGetIn_memory_table(void) const
{
    return IsSetIn_memory_table();
}

inline
const CApply_table_action_Base::TIn_memory_table& CApply_table_action_Base::GetIn_memory_table(void) const
{
    if (!CanGetIn_memory_table()) {
        ThrowUnassigned(2);
    }
    return (*m_In_memory_table);
}

inline
bool CApply_table_action_Base::IsSetAlso_change_mrna(void) const
{
    return ((m_set_State[0] & 0xc0) != 0);
}

inline
bool CApply_table_action_Base::CanGetAlso_change_mrna(void) const
{
    return true;
}

inline
void CApply_table_action_Base::ResetAlso_change_mrna(void)
{
    m_Also_change_mrna = false;
    m_set_State[0] &= ~0xc0;
}

inline
void CApply_table_action_Base::SetDefaultAlso_change_mrna(void)
{
    ResetAlso_change_mrna();
}

inline
CApply_table_action_Base::TAlso_change_mrna CApply_table_action_Base::GetAlso_change_mrna(void) const
{
    return m_Also_change_mrna;
}

inline
void CApply_table_action_Base::SetAlso_change_mrna(CApply_table_action_Base::TAlso_change_mrna value)
{
    m_Also_change_mrna = value;
    m_set_State[0] |= 0xc0;
}

inline
CApply_table_action_Base::TAlso_change_mrna& CApply_table_action_Base::SetAlso_change_mrna(void)
{
#ifdef _DEBUG
    if (!IsSetAlso_change_mrna()) {
        memset(&m_Also_change_mrna,UnassignedByte(),sizeof(m_Also_change_mrna));
    }
#endif
    m_set_State[0] |= 0x40;
    return m_Also_change_mrna;
}

inline
bool CApply_table_action_Base::IsSetSkip_blanks(void) const
{
    return ((m_set_State[0] & 0x300) != 0);
}

inline
bool CApply_table_action_Base::CanGetSkip_blanks(void) const
{
    return true;
}

inline
void CApply_table_action_Base::ResetSkip_blanks(void)
{
    m_Skip_blanks = true;
    m_set_State[0] &= ~0x300;
}

inline
void CApply_table_action_Base::SetDefaultSkip_blanks(void)
{
    ResetSkip_blanks();
}

inline
CApply_table_action_Base::TSkip_blanks CApply_table_action_Base::GetSkip_blanks(void) const
{
    return m_Skip_blanks;
}

inline
void CApply_table_action_Base::SetSkip_blanks(CApply_table_action_Base::TSkip_blanks value)
{
    m_Skip_blanks = value;
    m_set_State[0] |= 0x300;
}

inline
CApply_table_action_Base::TSkip_blanks& CApply_table_action_Base::SetSkip_blanks(void)
{
#ifdef _DEBUG
    if (!IsSetSkip_blanks()) {
        memset(&m_Skip_blanks,UnassignedByte(),sizeof(m_Skip_blanks));
    }
#endif
    m_set_State[0] |= 0x100;
    return m_Skip_blanks;
}

///////////////////////////////////////////////////////////
////////////////// end of inline methods //////////////////
///////////////////////////////////////////////////////////





END_objects_SCOPE // namespace ncbi::objects::

END_NCBI_SCOPE


#endif // OBJECTS_MACRO_APPLY_TABLE_ACTION_BASE_HPP
