/* $Id$
 * ===========================================================================
 *
 *                            PUBLIC DOMAIN NOTICE
 *               National Center for Biotechnology Information
 *
 *  This software/database is a "United States Government Work" under the
 *  terms of the United States Copyright Act.  It was written as part of
 *  the author's official duties as a United States Government employee and
 *  thus cannot be copyrighted.  This software/database is freely available
 *  to the public for use. The National Library of Medicine and the U.S.
 *  Government have not placed any restriction on its use or reproduction.
 *
 *  Although all reasonable efforts have been taken to ensure the accuracy
 *  and reliability of the software and data, the NLM and the U.S.
 *  Government do not and cannot warrant the performance or results that
 *  may be obtained by using this software or data. The NLM and the U.S.
 *  Government disclaim all warranties, express or implied, including
 *  warranties of performance, merchantability or fitness for any particular
 *  purpose.
 *
 *  Please cite the author in any work or product based on this material.
 *
 * ===========================================================================
 *
 */

/// @file Action_choice_.hpp
/// Data storage class.
///
/// This file was generated by application DATATOOL
/// using the following specifications:
/// 'macro.asn'.
///
/// ATTENTION:
///   Don't edit or commit this file into CVS as this file will
///   be overridden (by DATATOOL) without warning!

#ifndef OBJECTS_MACRO_ACTION_CHOICE_BASE_HPP
#define OBJECTS_MACRO_ACTION_CHOICE_BASE_HPP

// standard includes
#include <serial/serialbase.hpp>
BEGIN_NCBI_SCOPE

#ifndef BEGIN_objects_SCOPE
#  define BEGIN_objects_SCOPE BEGIN_SCOPE(objects)
#  define END_objects_SCOPE END_SCOPE(objects)
#endif
BEGIN_objects_SCOPE // namespace ncbi::objects::


// forward declarations
class CAECRParse_action;
class CApply_action;
class CConvert_action;
class CCopy_action;
class CEdit_action;
class CRemove_action;
class CRemove_outside_action;
class CSwap_action;


// generated classes

/////////////////////////////////////////////////////////////////////////////
class CAction_choice_Base : public CSerialObject
{
    typedef CSerialObject Tparent;
public:
    // constructor
    CAction_choice_Base(void);
    // destructor
    virtual ~CAction_choice_Base(void);

    // type info
    DECLARE_INTERNAL_TYPE_INFO();


    /// Choice variants.
    enum E_Choice {
        e_not_set = 0,     ///< No variant selected
        e_Apply,
        e_Edit,
        e_Convert,
        e_Copy,
        e_Swap,
        e_Remove,
        e_Parse,
        e_Remove_outside
    };
    /// Maximum+1 value of the choice variant enumerator.
    enum E_ChoiceStopper {
        e_MaxChoice = 9 ///< == e_Remove_outside+1
    };

    /// Reset the whole object
    virtual void Reset(void);

    /// Reset the selection (set it to e_not_set).
    virtual void ResetSelection(void);

    /// Which variant is currently selected.
    E_Choice Which(void) const;

    /// Verify selection, throw exception if it differs from the expected.
    void CheckSelected(E_Choice index) const;

    /// Throw 'InvalidSelection' exception.
    NCBI_NORETURN void ThrowInvalidSelection(E_Choice index) const;

    /// Retrieve selection name (for diagnostic purposes).
    static string SelectionName(E_Choice index);

    /// Select the requested variant if needed.
    void Select(E_Choice index, EResetVariant reset = eDoResetVariant);
    /// Select the requested variant if needed,
    /// allocating CObject variants from memory pool.
    void Select(E_Choice index,
                EResetVariant reset,
                CObjectMemoryPool* pool);

    // types
    typedef CApply_action TApply;
    typedef CEdit_action TEdit;
    typedef CConvert_action TConvert;
    typedef CCopy_action TCopy;
    typedef CSwap_action TSwap;
    typedef CRemove_action TRemove;
    typedef CAECRParse_action TParse;
    typedef CRemove_outside_action TRemove_outside;

    // getters
    // setters

    // typedef CApply_action TApply
    bool IsApply(void) const;
    const TApply& GetApply(void) const;
    TApply& SetApply(void);
    void SetApply(TApply& value);

    // typedef CEdit_action TEdit
    bool IsEdit(void) const;
    const TEdit& GetEdit(void) const;
    TEdit& SetEdit(void);
    void SetEdit(TEdit& value);

    // typedef CConvert_action TConvert
    bool IsConvert(void) const;
    const TConvert& GetConvert(void) const;
    TConvert& SetConvert(void);
    void SetConvert(TConvert& value);

    // typedef CCopy_action TCopy
    bool IsCopy(void) const;
    const TCopy& GetCopy(void) const;
    TCopy& SetCopy(void);
    void SetCopy(TCopy& value);

    // typedef CSwap_action TSwap
    bool IsSwap(void) const;
    const TSwap& GetSwap(void) const;
    TSwap& SetSwap(void);
    void SetSwap(TSwap& value);

    // typedef CRemove_action TRemove
    bool IsRemove(void) const;
    const TRemove& GetRemove(void) const;
    TRemove& SetRemove(void);
    void SetRemove(TRemove& value);

    // typedef CAECRParse_action TParse
    bool IsParse(void) const;
    const TParse& GetParse(void) const;
    TParse& SetParse(void);
    void SetParse(TParse& value);

    // typedef CRemove_outside_action TRemove_outside
    bool IsRemove_outside(void) const;
    const TRemove_outside& GetRemove_outside(void) const;
    TRemove_outside& SetRemove_outside(void);
    void SetRemove_outside(TRemove_outside& value);


private:
    // copy constructor and assignment operator
    CAction_choice_Base(const CAction_choice_Base& );
    CAction_choice_Base& operator=(const CAction_choice_Base& );
    // choice state
    E_Choice m_choice;
    // helper methods
    void DoSelect(E_Choice index, CObjectMemoryPool* pool = 0);

    static const char* const sm_SelectionNames[];
    // data
    NCBI_NS_NCBI::CSerialObject *m_object;
};






///////////////////////////////////////////////////////////
///////////////////// inline methods //////////////////////
///////////////////////////////////////////////////////////
inline
CAction_choice_Base::E_Choice CAction_choice_Base::Which(void) const
{
    return m_choice;
}

inline
void CAction_choice_Base::CheckSelected(E_Choice index) const
{
    if ( m_choice != index )
        ThrowInvalidSelection(index);
}

inline
void CAction_choice_Base::Select(E_Choice index, NCBI_NS_NCBI::EResetVariant reset, NCBI_NS_NCBI::CObjectMemoryPool* pool)
{
    if ( reset == NCBI_NS_NCBI::eDoResetVariant || m_choice != index ) {
        if ( m_choice != e_not_set )
            ResetSelection();
        DoSelect(index, pool);
    }
}

inline
void CAction_choice_Base::Select(E_Choice index, NCBI_NS_NCBI::EResetVariant reset)
{
    Select(index, reset, 0);
}

inline
bool CAction_choice_Base::IsApply(void) const
{
    return m_choice == e_Apply;
}

inline
bool CAction_choice_Base::IsEdit(void) const
{
    return m_choice == e_Edit;
}

inline
bool CAction_choice_Base::IsConvert(void) const
{
    return m_choice == e_Convert;
}

inline
bool CAction_choice_Base::IsCopy(void) const
{
    return m_choice == e_Copy;
}

inline
bool CAction_choice_Base::IsSwap(void) const
{
    return m_choice == e_Swap;
}

inline
bool CAction_choice_Base::IsRemove(void) const
{
    return m_choice == e_Remove;
}

inline
bool CAction_choice_Base::IsParse(void) const
{
    return m_choice == e_Parse;
}

inline
bool CAction_choice_Base::IsRemove_outside(void) const
{
    return m_choice == e_Remove_outside;
}

///////////////////////////////////////////////////////////
////////////////// end of inline methods //////////////////
///////////////////////////////////////////////////////////





END_objects_SCOPE // namespace ncbi::objects::

END_NCBI_SCOPE


#endif // OBJECTS_MACRO_ACTION_CHOICE_BASE_HPP
