/* $Id$
 * ===========================================================================
 *
 *                            PUBLIC DOMAIN NOTICE
 *               National Center for Biotechnology Information
 *
 *  This software/database is a "United States Government Work" under the
 *  terms of the United States Copyright Act.  It was written as part of
 *  the author's official duties as a United States Government employee and
 *  thus cannot be copyrighted.  This software/database is freely available
 *  to the public for use. The National Library of Medicine and the U.S.
 *  Government have not placed any restriction on its use or reproduction.
 *
 *  Although all reasonable efforts have been taken to ensure the accuracy
 *  and reliability of the software and data, the NLM and the U.S.
 *  Government do not and cannot warrant the performance or results that
 *  may be obtained by using this software or data. The NLM and the U.S.
 *  Government disclaim all warranties, express or implied, including
 *  warranties of performance, merchantability or fitness for any particular
 *  purpose.
 *
 *  Please cite the author in any work or product based on this material.
 *
 * ===========================================================================
 *
 */

/// @file ID2S_Request_Get_Chunks_.hpp
/// Data storage class.
///
/// This file was generated by application DATATOOL
/// using the following specifications:
/// 'id2.asn'.
///
/// ATTENTION:
///   Don't edit or commit this file into CVS as this file will
///   be overridden (by DATATOOL) without warning!

#ifndef OBJECTS_ID2_ID2S_REQUEST_GET_CHUNKS_BASE_HPP
#define OBJECTS_ID2_ID2S_REQUEST_GET_CHUNKS_BASE_HPP

// standard includes
#include <serial/serialbase.hpp>

// generated includes
#include <list>
#include <objects/seqsplit/ID2S_Chunk_Id.hpp>

BEGIN_NCBI_SCOPE

#ifndef BEGIN_objects_SCOPE
#  define BEGIN_objects_SCOPE BEGIN_SCOPE(objects)
#  define END_objects_SCOPE END_SCOPE(objects)
#endif
BEGIN_objects_SCOPE // namespace ncbi::objects::


// forward declarations
class CID2_Blob_Id;


// generated classes

/////////////////////////////////////////////////////////////////////////////
/// Request for specific chunks.
/// Server will reply with one or more ID2S-Reply-Get-Chunk.
class NCBI_ID2_EXPORT CID2S_Request_Get_Chunks_Base : public CSerialObject
{
    typedef CSerialObject Tparent;
public:
    // constructor
    CID2S_Request_Get_Chunks_Base(void);
    // destructor
    virtual ~CID2S_Request_Get_Chunks_Base(void);

    // type info
    DECLARE_INTERNAL_TYPE_INFO();

    // types
    typedef CID2_Blob_Id TBlob_id;
    typedef list< CID2S_Chunk_Id > TChunks;
    typedef int TSplit_version;

    // member index
    enum class E_memberIndex {
        e__allMandatory = 0,
        e_blob_id,
        e_chunks,
        e_split_version
    };
    typedef Tparent::CMemberIndex<E_memberIndex, 4> TmemberIndex;

    // getters
    // setters

    /// mandatory
    /// typedef CID2_Blob_Id TBlob_id
    ///  Check whether the Blob_id data member has been assigned a value.
    bool IsSetBlob_id(void) const;
    /// Check whether it is safe or not to call GetBlob_id method.
    bool CanGetBlob_id(void) const;
    void ResetBlob_id(void);
    const TBlob_id& GetBlob_id(void) const;
    void SetBlob_id(TBlob_id& value);
    TBlob_id& SetBlob_id(void);

    /// requests for specific chunks of splitted blob
    /// mandatory
    /// typedef list< CID2S_Chunk_Id > TChunks
    ///  Check whether the Chunks data member has been assigned a value.
    bool IsSetChunks(void) const;
    /// Check whether it is safe or not to call GetChunks method.
    bool CanGetChunks(void) const;
    void ResetChunks(void);
    const TChunks& GetChunks(void) const;
    TChunks& SetChunks(void);

    /// blob split version
    /// optional
    /// typedef int TSplit_version
    ///  Check whether the Split_version data member has been assigned a value.
    bool IsSetSplit_version(void) const;
    /// Check whether it is safe or not to call GetSplit_version method.
    bool CanGetSplit_version(void) const;
    void ResetSplit_version(void);
    TSplit_version GetSplit_version(void) const;
    void SetSplit_version(TSplit_version value);
    TSplit_version& SetSplit_version(void);

    /// Reset the whole object
    virtual void Reset(void);


private:
    // Prohibit copy constructor and assignment operator
    CID2S_Request_Get_Chunks_Base(const CID2S_Request_Get_Chunks_Base&);
    CID2S_Request_Get_Chunks_Base& operator=(const CID2S_Request_Get_Chunks_Base&);

    // data
    Uint4 m_set_State[1];
    CRef< TBlob_id > m_Blob_id;
    list< CID2S_Chunk_Id > m_Chunks;
    int m_Split_version;
};






///////////////////////////////////////////////////////////
///////////////////// inline methods //////////////////////
///////////////////////////////////////////////////////////
inline
bool CID2S_Request_Get_Chunks_Base::IsSetBlob_id(void) const
{
    return m_Blob_id.NotEmpty();
}

inline
bool CID2S_Request_Get_Chunks_Base::CanGetBlob_id(void) const
{
    return true;
}

inline
const CID2S_Request_Get_Chunks_Base::TBlob_id& CID2S_Request_Get_Chunks_Base::GetBlob_id(void) const
{
    if ( !m_Blob_id ) {
        const_cast<CID2S_Request_Get_Chunks_Base*>(this)->ResetBlob_id();
    }
    return (*m_Blob_id);
}

inline
CID2S_Request_Get_Chunks_Base::TBlob_id& CID2S_Request_Get_Chunks_Base::SetBlob_id(void)
{
    if ( !m_Blob_id ) {
        ResetBlob_id();
    }
    return (*m_Blob_id);
}

inline
bool CID2S_Request_Get_Chunks_Base::IsSetChunks(void) const
{
    return ((m_set_State[0] & 0xc) != 0);
}

inline
bool CID2S_Request_Get_Chunks_Base::CanGetChunks(void) const
{
    return true;
}

inline
const CID2S_Request_Get_Chunks_Base::TChunks& CID2S_Request_Get_Chunks_Base::GetChunks(void) const
{
    return m_Chunks;
}

inline
CID2S_Request_Get_Chunks_Base::TChunks& CID2S_Request_Get_Chunks_Base::SetChunks(void)
{
    m_set_State[0] |= 0x4;
    return m_Chunks;
}

inline
bool CID2S_Request_Get_Chunks_Base::IsSetSplit_version(void) const
{
    return ((m_set_State[0] & 0x30) != 0);
}

inline
bool CID2S_Request_Get_Chunks_Base::CanGetSplit_version(void) const
{
    return IsSetSplit_version();
}

inline
void CID2S_Request_Get_Chunks_Base::ResetSplit_version(void)
{
    m_Split_version = 0;
    m_set_State[0] &= ~0x30;
}

inline
CID2S_Request_Get_Chunks_Base::TSplit_version CID2S_Request_Get_Chunks_Base::GetSplit_version(void) const
{
    if (!CanGetSplit_version()) {
        ThrowUnassigned(2);
    }
    return m_Split_version;
}

inline
void CID2S_Request_Get_Chunks_Base::SetSplit_version(CID2S_Request_Get_Chunks_Base::TSplit_version value)
{
    m_Split_version = value;
    m_set_State[0] |= 0x30;
}

inline
CID2S_Request_Get_Chunks_Base::TSplit_version& CID2S_Request_Get_Chunks_Base::SetSplit_version(void)
{
#ifdef _DEBUG
    if (!IsSetSplit_version()) {
        memset(&m_Split_version,UnassignedByte(),sizeof(m_Split_version));
    }
#endif
    m_set_State[0] |= 0x10;
    return m_Split_version;
}

///////////////////////////////////////////////////////////
////////////////// end of inline methods //////////////////
///////////////////////////////////////////////////////////





END_objects_SCOPE // namespace ncbi::objects::

END_NCBI_SCOPE


#endif // OBJECTS_ID2_ID2S_REQUEST_GET_CHUNKS_BASE_HPP
